/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.ser;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.InputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.OutputShim;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.SerializerShim;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;

public class RequestMessageGryoSerializer
implements SerializerShim<RequestMessage> {
    public <O extends OutputShim> void write(KryoShim<?, O> kryo, O output, RequestMessage requestMessage) {
        kryo.writeObject(output, (Object)requestMessage.getRequestId());
        output.writeString(requestMessage.getProcessor());
        output.writeString(requestMessage.getOp());
        kryo.writeObject(output, requestMessage.getArgs());
    }

    public <I extends InputShim> RequestMessage read(KryoShim<I, ?> kryo, I input, Class<RequestMessage> aClass) {
        UUID id = (UUID)kryo.readObject(input, UUID.class);
        String processor = input.readString();
        String op = input.readString();
        RequestMessage.Builder builder = RequestMessage.build(op).overrideRequestId(id).processor(processor);
        Map args = (Map)kryo.readObject(input, HashMap.class);
        args.forEach(builder::addArg);
        return builder.create();
    }
}

