/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.step.map;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.GraphFilter;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.clustering.peerpressure.PeerPressureVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.lambda.HaltedTraversersCountTraversal;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.PeerPressure;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.VertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class PeerPressureVertexProgramStep
extends VertexProgramStep
implements TraversalParent,
Configuring {
    private Parameters parameters = new Parameters();
    private PureTraversal<Vertex, Edge> edgeTraversal;
    private String clusterProperty = "gremlin.peerPressureVertexProgram.cluster";
    private int times = 30;

    public PeerPressureVertexProgramStep(Traversal.Admin traversal) {
        super(traversal);
        this.configure(PeerPressure.edges, __.outE(new String[0]).asAdmin());
    }

    @Override
    public void configure(Object ... keyValues) {
        if (keyValues[0].equals(PeerPressure.edges)) {
            if (!(keyValues[1] instanceof Traversal)) {
                throw new IllegalArgumentException("PeerPressure.edges requires a Traversal as its argument");
            }
            this.edgeTraversal = new PureTraversal(((Traversal)keyValues[1]).asAdmin());
            this.integrateChild(this.edgeTraversal.get());
        } else if (keyValues[0].equals(PeerPressure.propertyName)) {
            if (!(keyValues[1] instanceof String)) {
                throw new IllegalArgumentException("PeerPressure.propertyName requires a String as its argument");
            }
            this.clusterProperty = (String)keyValues[1];
        } else if (keyValues[0].equals(PeerPressure.times)) {
            if (!(keyValues[1] instanceof Integer)) {
                throw new IllegalArgumentException("PeerPressure.times requires an Integer as its argument");
            }
            this.times = (Integer)keyValues[1];
        } else {
            this.parameters.set(this, keyValues);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.edgeTraversal.hashCode() ^ this.clusterProperty.hashCode() ^ this.times;
    }

    public List<Traversal.Admin<Vertex, Edge>> getLocalChildren() {
        return Collections.singletonList(this.edgeTraversal.get());
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.edgeTraversal.get(), this.clusterProperty, this.times, new GraphFilter(this.computer));
    }

    @Override
    public PeerPressureVertexProgram generateProgram(Graph graph, Memory memory) {
        Traversal.Admin<Vertex, Edge> detachedTraversal = this.edgeTraversal.getPure();
        detachedTraversal.setStrategies(TraversalStrategies.GlobalCache.getStrategies(graph.getClass()));
        PeerPressureVertexProgram.Builder builder = PeerPressureVertexProgram.build().property(this.clusterProperty).maxIterations(this.times).edges(detachedTraversal);
        if (this.previousTraversalVertexProgram()) {
            builder.initialVoteStrength(new HaltedTraversersCountTraversal());
        }
        return (PeerPressureVertexProgram)builder.create(graph);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return TraversalParent.super.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public PeerPressureVertexProgramStep clone() {
        PeerPressureVertexProgramStep clone = (PeerPressureVertexProgramStep)super.clone();
        clone.edgeTraversal = this.edgeTraversal.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.edgeTraversal.get());
    }
}

