/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.CardinalityValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ConstantTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class MergeVertexStep<S>
extends MergeStep<S, Vertex, Map> {
    private static final Set allowedTokens = new LinkedHashSet<T>(Arrays.asList(T.id, T.label));

    public static void validateMapInput(Map map, boolean ignoreTokens) {
        MergeStep.validate(map, ignoreTokens, allowedTokens, "mergeV");
    }

    public MergeVertexStep(Traversal.Admin traversal, boolean isStart) {
        super(traversal, isStart);
    }

    public MergeVertexStep(Traversal.Admin traversal, boolean isStart, Map merge) {
        super(traversal, isStart, merge);
    }

    public MergeVertexStep(Traversal.Admin traversal, boolean isStart, Traversal.Admin<S, Map> mergeTraversal) {
        super(traversal, isStart, mergeTraversal);
    }

    @Override
    public MergeVertexStep<S> clone() {
        return (MergeVertexStep)super.clone();
    }

    @Override
    protected Set getAllowedTokens() {
        return allowedTokens;
    }

    @Override
    protected Iterator<Vertex> flatMap(Traverser.Admin<S> traverser) {
        Graph graph = this.getGraph();
        Map mergeMap = this.materializeMap(traverser, this.mergeTraversal);
        MergeVertexStep.validateMapInput(mergeMap, false);
        Iterator<Vertex> vertices = this.searchVertices(mergeMap);
        if (this.onMatchTraversal != null) {
            if (this.onMatchTraversal instanceof ConstantTraversal) {
                Map matchMap = (Map)this.onMatchTraversal.next();
                MergeVertexStep.validateMapInput(matchMap, true);
            }
            vertices = IteratorUtils.peek(vertices, v -> {
                if (this.isStart) {
                    traverser.set(v);
                }
                Map onMatchMap = this.materializeMap(traverser, this.onMatchTraversal);
                MergeVertexStep.validateMapInput(onMatchMap, true);
                onMatchMap.forEach((key, value) -> {
                    Object val = value;
                    VertexProperty.Cardinality card = graph.features().vertex().getCardinality((String)key);
                    if (value instanceof CardinalityValueTraversal) {
                        CardinalityValueTraversal cardinalityValueTraversal = (CardinalityValueTraversal)value;
                        card = cardinalityValueTraversal.getCardinality();
                        val = cardinalityValueTraversal.getValue();
                    }
                    EventUtil.registerVertexPropertyChange(this.callbackRegistry, this.getTraversal(), v, key, val);
                    v.property(card, (String)key, val, new Object[0]);
                });
            });
        }
        if (vertices.hasNext()) {
            return vertices;
        }
        CloseableIterator.closeIterator(vertices);
        Map onCreateMap = this.onCreateMap(traverser, mergeMap);
        Object[] flatArgsWithoutExplicitCardinality = onCreateMap.entrySet().stream().filter(e -> !(e.getValue() instanceof CardinalityValueTraversal)).flatMap((? super T e) -> Stream.of(e.getKey(), e.getValue())).collect(Collectors.toList()).toArray();
        Vertex vertex = graph.addVertex(flatArgsWithoutExplicitCardinality);
        onCreateMap.entrySet().stream().filter(e -> e.getKey() instanceof String && e.getValue() instanceof CardinalityValueTraversal).forEach(e -> {
            CardinalityValueTraversal cardinalityValueTraversal = (CardinalityValueTraversal)e.getValue();
            vertex.property(cardinalityValueTraversal.getCardinality(), (String)e.getKey(), cardinalityValueTraversal.getValue(), new Object[0]);
        });
        EventUtil.registerVertexCreationWithGenericEventRegistry(this.callbackRegistry, this.getTraversal(), vertex);
        return IteratorUtils.of(vertex);
    }

    protected Map onCreateMap(Traverser.Admin<S> traverser, Map mergeMap) {
        if (this.onCreateTraversal == null) {
            return mergeMap;
        }
        Map onCreateMap = this.materializeMap(traverser, this.onCreateTraversal);
        if (onCreateMap == null || onCreateMap.size() == 0) {
            return mergeMap;
        }
        MergeVertexStep.validateMapInput(onCreateMap, false);
        if (mergeMap == null || mergeMap.size() == 0) {
            return onCreateMap;
        }
        this.validateNoOverrides(mergeMap, onCreateMap);
        HashMap combinedMap = new HashMap(onCreateMap.size() + mergeMap.size());
        combinedMap.putAll(onCreateMap);
        combinedMap.putAll(mergeMap);
        return combinedMap;
    }
}

