/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceElement;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;

public class ReferenceProperty<V>
implements Attachable<Property<V>>,
Serializable,
Property<V> {
    private ReferenceElement<?> element;
    private String key;
    private V value;

    private ReferenceProperty() {
    }

    @Override
    public Property<V> get() {
        return this;
    }

    public ReferenceProperty(Property<V> property) {
        this.element = null == property.element() ? null : ReferenceFactory.detach(property.element());
        this.key = property.key();
        this.value = property.value();
    }

    public ReferenceProperty(String key, V value) {
        this.element = null;
        this.key = key;
        this.value = value;
    }

    public int hashCode() {
        return ElementHelper.hashCode(this);
    }

    public String toString() {
        return StringFactory.propertyString(this);
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public V value() throws NoSuchElementException {
        return this.value;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public Element element() {
        return this.element;
    }

    @Override
    public void remove() {
        throw Property.Exceptions.propertyRemovalNotSupported();
    }
}

