/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class LocalDateTimeSerializer
extends SimpleTypeSerializer<LocalDateTime> {
    public LocalDateTimeSerializer() {
        super(DataType.LOCALDATETIME);
    }

    @Override
    protected LocalDateTime readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        return LocalDateTime.of(context.readValue(buffer, LocalDate.class, false), context.readValue(buffer, LocalTime.class, false));
    }

    @Override
    protected void writeValue(LocalDateTime value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value.toLocalDate(), buffer, false);
        context.writeValue(value.toLocalTime(), buffer, false);
    }
}

