/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.dsl.graph;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration.RemoteStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.UnionStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CallStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.InjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IoStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.RequirementsStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public class GraphTraversalSource
implements TraversalSource {
    protected transient RemoteConnection connection;
    protected final Graph graph;
    protected TraversalStrategies strategies;
    protected Bytecode bytecode = new Bytecode();

    public GraphTraversalSource(Graph graph, TraversalStrategies traversalStrategies) {
        this.graph = graph;
        this.strategies = traversalStrategies;
    }

    public GraphTraversalSource(Graph graph) {
        this(graph, TraversalStrategies.GlobalCache.getStrategies(graph.getClass()));
    }

    public GraphTraversalSource(RemoteConnection connection) {
        this(EmptyGraph.instance(), TraversalStrategies.GlobalCache.getStrategies(EmptyGraph.class).clone());
        this.connection = connection;
        this.strategies.addStrategies(new RemoteStrategy(connection));
    }

    @Override
    public Optional<Class<?>> getAnonymousTraversalClass() {
        return Optional.of(__.class);
    }

    @Override
    public TraversalStrategies getStrategies() {
        return this.strategies;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public Bytecode getBytecode() {
        return this.bytecode;
    }

    @Override
    public GraphTraversalSource clone() {
        try {
            GraphTraversalSource clone = (GraphTraversalSource)super.clone();
            clone.strategies = this.strategies.clone();
            clone.bytecode = this.bytecode.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public GraphTraversalSource with(String key) {
        return (GraphTraversalSource)TraversalSource.super.with(key);
    }

    @Override
    public GraphTraversalSource with(String key, Object value) {
        return (GraphTraversalSource)TraversalSource.super.with(key, value);
    }

    @Override
    public GraphTraversalSource withStrategies(TraversalStrategy ... traversalStrategies) {
        return (GraphTraversalSource)TraversalSource.super.withStrategies(traversalStrategies);
    }

    @Override
    public GraphTraversalSource withoutStrategies(Class<? extends TraversalStrategy> ... traversalStrategyClasses) {
        return (GraphTraversalSource)TraversalSource.super.withoutStrategies(traversalStrategyClasses);
    }

    @Override
    public GraphTraversalSource withComputer(Computer computer) {
        return (GraphTraversalSource)TraversalSource.super.withComputer(computer);
    }

    @Override
    public GraphTraversalSource withComputer(Class<? extends GraphComputer> graphComputerClass) {
        return (GraphTraversalSource)TraversalSource.super.withComputer(graphComputerClass);
    }

    @Override
    public GraphTraversalSource withComputer() {
        return (GraphTraversalSource)TraversalSource.super.withComputer();
    }

    @Override
    public <A> GraphTraversalSource withSideEffect(String key, Supplier<A> initialValue, BinaryOperator<A> reducer) {
        return (GraphTraversalSource)TraversalSource.super.withSideEffect(key, initialValue, reducer);
    }

    @Override
    public <A> GraphTraversalSource withSideEffect(String key, A initialValue, BinaryOperator<A> reducer) {
        return (GraphTraversalSource)TraversalSource.super.withSideEffect(key, initialValue, reducer);
    }

    @Override
    public <A> GraphTraversalSource withSideEffect(String key, A initialValue) {
        return (GraphTraversalSource)TraversalSource.super.withSideEffect(key, initialValue);
    }

    @Override
    public <A> GraphTraversalSource withSideEffect(String key, Supplier<A> initialValue) {
        return (GraphTraversalSource)TraversalSource.super.withSideEffect(key, initialValue);
    }

    @Override
    public <A> GraphTraversalSource withSack(Supplier<A> initialValue, UnaryOperator<A> splitOperator, BinaryOperator<A> mergeOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, splitOperator, mergeOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator, BinaryOperator<A> mergeOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, splitOperator, mergeOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(A initialValue) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue);
    }

    @Override
    public <A> GraphTraversalSource withSack(Supplier<A> initialValue) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue);
    }

    @Override
    public <A> GraphTraversalSource withSack(Supplier<A> initialValue, UnaryOperator<A> splitOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, splitOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(A initialValue, UnaryOperator<A> splitOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, splitOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(Supplier<A> initialValue, BinaryOperator<A> mergeOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, mergeOperator);
    }

    @Override
    public <A> GraphTraversalSource withSack(A initialValue, BinaryOperator<A> mergeOperator) {
        return (GraphTraversalSource)TraversalSource.super.withSack(initialValue, mergeOperator);
    }

    public GraphTraversalSource withBulk(boolean useBulk) {
        if (useBulk) {
            return this;
        }
        GraphTraversalSource clone = this.clone();
        RequirementsStrategy.addRequirements(clone.getStrategies(), TraverserRequirement.ONE_BULK);
        clone.bytecode.addSource("withBulk", useBulk);
        return clone;
    }

    public GraphTraversalSource withPath() {
        GraphTraversalSource clone = this.clone();
        RequirementsStrategy.addRequirements(clone.getStrategies(), TraverserRequirement.PATH);
        clone.bytecode.addSource("withPath", new Object[0]);
        return clone;
    }

    public GraphTraversal<Vertex, Vertex> addV(String vertexLabel) {
        if (null == vertexLabel) {
            throw new IllegalArgumentException("vertexLabel cannot be null");
        }
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("addV", vertexLabel);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new AddVertexStartStep(traversal, vertexLabel));
    }

    public GraphTraversal<Vertex, Vertex> addV(Traversal<?, String> vertexLabelTraversal) {
        if (null == vertexLabelTraversal) {
            throw new IllegalArgumentException("vertexLabelTraversal cannot be null");
        }
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("addV", vertexLabelTraversal);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new AddVertexStartStep(traversal, vertexLabelTraversal));
    }

    public GraphTraversal<Vertex, Vertex> addV() {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("addV", new Object[0]);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new AddVertexStartStep(traversal, (String)null));
    }

    public GraphTraversal<Edge, Edge> addE(String label) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("addE", label);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new AddEdgeStartStep(traversal, label));
    }

    public GraphTraversal<Edge, Edge> addE(Traversal<?, String> edgeLabelTraversal) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("addE", edgeLabelTraversal);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new AddEdgeStartStep(traversal, edgeLabelTraversal));
    }

    public GraphTraversal<Vertex, Vertex> mergeV(Map<Object, Object> searchCreate) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("mergeV", searchCreate);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new MergeVertexStep(traversal, true, searchCreate));
    }

    public <S> GraphTraversal<S, Vertex> mergeV(Traversal<?, Map<Object, Object>> searchCreate) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("mergeV", searchCreate);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        MergeVertexStep step = null == searchCreate ? new MergeVertexStep(traversal, true, (Map)null) : new MergeVertexStep(traversal, true, searchCreate.asAdmin());
        return traversal.addStep((Step)step);
    }

    public GraphTraversal<Edge, Edge> mergeE(Map<?, Object> searchCreate) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("mergeE", searchCreate);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new MergeEdgeStep(traversal, true, searchCreate));
    }

    public GraphTraversal<Edge, Edge> mergeE(Traversal<?, Map<Object, Object>> searchCreate) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("mergeE", searchCreate);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        MergeEdgeStep step = null == searchCreate ? new MergeEdgeStep(traversal, true, (Map)null) : new MergeEdgeStep(traversal, true, searchCreate.asAdmin());
        return traversal.addStep((Step)step);
    }

    public <S> GraphTraversal<S, S> inject(S ... starts) {
        Object[] objectArray;
        if (null == starts) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = starts;
        }
        Object[] s = objectArray;
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("inject", s);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep(new InjectStep<Object>((Traversal.Admin)traversal, (S[])s));
    }

    public GraphTraversal<Vertex, Vertex> V(Object ... vertexIds) {
        Object[] objectArray;
        if (null == vertexIds) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = vertexIds;
        }
        Object[] ids = objectArray;
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("V", ids);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new GraphStep(traversal, Vertex.class, true, ids));
    }

    public GraphTraversal<Edge, Edge> E(Object ... edgeIds) {
        Object[] objectArray;
        if (null == edgeIds) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = null;
        } else {
            objectArray = edgeIds;
        }
        Object[] ids = objectArray;
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("E", ids);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new GraphStep(traversal, Edge.class, true, ids));
    }

    public <S> GraphTraversal<S, S> call() {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("call", new Object[0]);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new CallStep(traversal, true));
    }

    public <S> GraphTraversal<S, S> call(String service) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("call", service);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new CallStep(traversal, true, service));
    }

    public <S> GraphTraversal<S, S> call(String service, Map params) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("call", service, params);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new CallStep(traversal, true, service, params));
    }

    public <S> GraphTraversal<S, S> call(String service, Traversal<S, Map> childTraversal) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("call", service, childTraversal);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        CallStep step = null == childTraversal ? new CallStep(traversal, true, service) : new CallStep(traversal, true, service, new LinkedHashMap(), childTraversal.asAdmin());
        return traversal.addStep((Step)step);
    }

    public <S> GraphTraversal<S, S> call(String service, Map params, Traversal<S, Map> childTraversal) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("call", service, params, childTraversal);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        CallStep step = null == childTraversal ? new CallStep(traversal, true, service, params) : new CallStep(traversal, true, service, params, childTraversal.asAdmin());
        return traversal.addStep((Step)step);
    }

    public <S> GraphTraversal<S, S> union(Traversal<?, S> ... unionTraversals) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("union", unionTraversals);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        UnionStep step = new UnionStep(traversal, true, (Traversal.Admin[])Arrays.copyOf(unionTraversals, unionTraversals.length, Traversal.Admin[].class));
        return traversal.addStep((Step)step);
    }

    public <S> GraphTraversal<S, S> io(String file) {
        GraphTraversalSource clone = this.clone();
        clone.bytecode.addStep("io", file);
        DefaultGraphTraversal traversal = new DefaultGraphTraversal(clone);
        return traversal.addStep((Step)new IoStep(traversal, file));
    }

    public Transaction tx() {
        if (null == this.connection) {
            return this.graph.tx();
        }
        Transaction tx = this.connection.tx();
        if (tx == Transaction.NO_OP && this.connection instanceof Transaction) {
            return (Transaction)((Object)this.connection);
        }
        return tx;
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public String toString() {
        return StringFactory.traversalSourceString(this);
    }

    public static final class Symbols {
        public static final String withBulk = "withBulk";
        public static final String withPath = "withPath";
        public static final String tx = "tx";

        private Symbols() {
        }
    }
}

