/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.SideEffectCapable;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupCountStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.HashMapSupplier;

public class GroupCountSideEffectStep<S, E>
extends SideEffectStep<S>
implements SideEffectCapable<Map<E, Long>, Map<E, Long>>,
TraversalParent,
ByModulating {
    private Traversal.Admin<S, E> keyTraversal = null;
    private String sideEffectKey;

    public GroupCountSideEffectStep(Traversal.Admin traversal, String sideEffectKey) {
        super(traversal);
        this.sideEffectKey = sideEffectKey;
        this.getTraversal().asAdmin().getSideEffects().registerIfAbsent(this.sideEffectKey, HashMapSupplier.instance(), GroupCountStep.GroupCountBiOperator.instance());
    }

    @Override
    protected void sideEffect(Traverser.Admin<S> traverser) {
        HashMap<E, Long> map = new HashMap<E, Long>(1);
        map.put(TraversalUtil.applyNullable(traverser, this.keyTraversal), traverser.bulk());
        this.getTraversal().getSideEffects().add(this.sideEffectKey, map);
    }

    @Override
    public String getSideEffectKey() {
        return this.sideEffectKey;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.sideEffectKey, this.keyTraversal);
    }

    @Override
    public void addLocalChild(Traversal.Admin<?, ?> groupTraversal) {
        this.keyTraversal = this.integrateChild(groupTraversal);
    }

    @Override
    public List<Traversal.Admin<S, E>> getLocalChildren() {
        return null == this.keyTraversal ? Collections.emptyList() : Collections.singletonList(this.keyTraversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.BULK, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public GroupCountSideEffectStep<S, E> clone() {
        GroupCountSideEffectStep clone = (GroupCountSideEffectStep)super.clone();
        if (null != this.keyTraversal) {
            clone.keyTraversal = this.keyTraversal.clone();
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.keyTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ this.sideEffectKey.hashCode();
        if (this.keyTraversal != null) {
            result ^= this.keyTraversal.hashCode();
        }
        return result;
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> keyTraversal) throws UnsupportedOperationException {
        this.keyTraversal = this.integrateChild(keyTraversal);
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        if (null != this.keyTraversal && this.keyTraversal.equals((Object)oldTraversal)) {
            this.keyTraversal = this.integrateChild(newTraversal);
        }
    }
}

