/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration.VertexProgramStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.RequirementsStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;

public final class RequirementsStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final Set<TraverserRequirement> requirements = EnumSet.noneOf(TraverserRequirement.class);

    private RequirementsStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (traversal.isRoot() && !this.requirements.isEmpty()) {
            traversal.addStep(new RequirementsStep(traversal, this.requirements));
        }
    }

    public static void addRequirements(TraversalStrategies traversalStrategies, TraverserRequirement ... requirements) {
        RequirementsStrategy strategy = traversalStrategies.getStrategy(RequirementsStrategy.class).orElse(null);
        if (null == strategy) {
            strategy = new RequirementsStrategy();
            traversalStrategies.addStrategies(strategy);
        } else {
            RequirementsStrategy cloneStrategy = new RequirementsStrategy();
            cloneStrategy.requirements.addAll(strategy.requirements);
            strategy = cloneStrategy;
            traversalStrategies.addStrategies(strategy);
        }
        Collections.addAll(strategy.requirements, requirements);
    }

    @Override
    public Set<Class<? extends TraversalStrategy.DecorationStrategy>> applyPost() {
        return Collections.singleton(VertexProgramStrategy.class);
    }
}

