/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <E> List<E> asList(E ... elements) {
        return new ArrayList<E>(Arrays.asList(elements));
    }

    public static <E> LinkedHashSet<E> asSet(E ... elements) {
        return CollectionUtil.asSet(Arrays.asList(elements));
    }

    public static <E> LinkedHashSet<E> asSet(Collection<E> elements) {
        return new LinkedHashSet<E>(elements);
    }

    public static <K, V> LinkedHashMap<K, V> asMap(Object ... elements) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < elements.length; i += 2) {
            Object k = elements[i];
            Object v = i + 1 < elements.length ? elements[i + 1] : null;
            map.put(k, v);
        }
        return map;
    }

    public static <K, V> ConcurrentHashMap<K, V> clone(ConcurrentHashMap<K, V> map) {
        ConcurrentHashMap<K, Object> result = new ConcurrentHashMap<K, Object>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Object clonedValue;
            if (entry.getValue() instanceof Set) {
                clonedValue = ConcurrentHashMap.newKeySet();
                ((Set)clonedValue).addAll((Set)entry.getValue());
            } else {
                clonedValue = entry.getValue() instanceof ArrayList ? ((ArrayList)entry.getValue()).clone() : entry.getValue();
            }
            result.put(entry.getKey(), clonedValue);
        }
        return result;
    }
}

