/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.FilteringBarrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.Grouping;
import org.apache.tinkerpop.gremlin.process.traversal.step.SideEffectCapable;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.SupplyingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.HashMapSupplier;

public final class GroupSideEffectStep<S, K, V>
extends SideEffectBarrierStep<S>
implements SideEffectCapable<Map<K, ?>, Map<K, V>>,
TraversalParent,
ByModulating,
Grouping<S, K, V> {
    private char state = (char)107;
    private Traversal.Admin<S, K> keyTraversal;
    private Traversal.Admin<S, V> valueTraversal;
    private Barrier barrierStep;
    private String sideEffectKey;

    public GroupSideEffectStep(Traversal.Admin traversal, String sideEffectKey) {
        super(traversal);
        this.sideEffectKey = sideEffectKey;
        this.valueTraversal = this.integrateChild(__.fold().asAdmin());
        this.barrierStep = this.determineBarrierStep(this.valueTraversal);
        this.getTraversal().getSideEffects().registerIfAbsent(this.sideEffectKey, HashMapSupplier.instance(), new GroupStep.GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
    }

    @Override
    public Traversal.Admin<S, K> getKeyTraversal() {
        return this.keyTraversal;
    }

    @Override
    public Traversal.Admin<S, V> getValueTraversal() {
        return this.valueTraversal;
    }

    private void setValueTraversal(Traversal.Admin valueTraversal) {
        this.valueTraversal = this.integrateChild(this.convertValueTraversal(valueTraversal));
        this.barrierStep = this.determineBarrierStep(this.valueTraversal);
        this.getTraversal().getSideEffects().register(this.sideEffectKey, null, new GroupStep.GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
    }

    @Override
    public void resetBarrierFromValueTraversal() {
        this.barrierStep = this.determineBarrierStep(this.valueTraversal);
        this.getTraversal().getSideEffects().registerIfAbsent(this.sideEffectKey, HashMapSupplier.instance(), new GroupStep.GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> kvTraversal) {
        if ('k' == this.state) {
            this.keyTraversal = this.integrateChild(kvTraversal);
            this.state = (char)118;
        } else if ('v' == this.state) {
            this.setValueTraversal(kvTraversal);
            this.state = (char)120;
        } else {
            throw new IllegalStateException("The key and value traversals for group()-step have already been set: " + this);
        }
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        if (null != this.keyTraversal && this.keyTraversal.equals(oldTraversal)) {
            this.keyTraversal = this.integrateChild(newTraversal);
        } else if (null != this.valueTraversal && this.valueTraversal.equals(oldTraversal)) {
            this.setValueTraversal(newTraversal);
        }
    }

    @Override
    protected void sideEffect(Traverser.Admin<S> traverser) {
        HashMap map = new HashMap(1);
        this.valueTraversal.reset();
        this.valueTraversal.addStart(traverser);
        TraversalUtil.produce(traverser, this.keyTraversal).ifProductive(p -> {
            if (null == this.barrierStep) {
                if (this.valueTraversal.hasNext()) {
                    map.put(p, this.valueTraversal.next());
                }
            } else if (this.barrierStep.hasNextBarrier()) {
                map.put(p, this.barrierStep.nextBarrier());
            } else if (this.barrierStep instanceof FilteringBarrier) {
                int barrierStepIndex = TraversalHelper.stepIndex((Step)((Object)this.barrierStep), this.valueTraversal) + 1;
                if (this.valueTraversal.getSteps().stream().skip(barrierStepIndex).anyMatch(step -> step instanceof SupplyingBarrierStep || step instanceof ReducingBarrierStep)) {
                    map.put(p, this.barrierStep.getEmptyBarrier());
                }
            }
        });
        if (!map.isEmpty()) {
            this.getTraversal().getSideEffects().add(this.sideEffectKey, map);
        }
    }

    @Override
    public String getSideEffectKey() {
        return this.sideEffectKey;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.sideEffectKey, this.keyTraversal, this.valueTraversal);
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        ArrayList children = new ArrayList(2);
        if (null != this.keyTraversal) {
            children.add(this.keyTraversal);
        }
        children.add(this.valueTraversal);
        return children;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.BULK, TraverserRequirement.SIDE_EFFECTS);
    }

    @Override
    public GroupSideEffectStep<S, K, V> clone() {
        GroupSideEffectStep clone = (GroupSideEffectStep)super.clone();
        if (null != this.keyTraversal) {
            clone.keyTraversal = this.keyTraversal.clone();
        }
        clone.valueTraversal = this.valueTraversal.clone();
        clone.barrierStep = this.determineBarrierStep(clone.valueTraversal);
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.keyTraversal);
        this.integrateChild(this.valueTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() ^ this.sideEffectKey.hashCode();
        if (this.keyTraversal != null) {
            result ^= this.keyTraversal.hashCode();
        }
        return result ^= this.valueTraversal.hashCode();
    }

    @Override
    public void reset() {
        super.reset();
        this.barrierStep = this.determineBarrierStep(this.valueTraversal);
    }

    @Override
    public Map<K, V> generateFinalResult(Map<K, ?> object) {
        return this.doFinalReduction(object, this.valueTraversal);
    }
}

