/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.BaseConvertDefinitions;
import org.apache.openejb.config.CompManagedBean;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.ManagedExecutor;
import org.apache.openejb.util.PropertyPlaceHolderHelper;

public class ConvertManagedExecutorServiceDefinitions
extends BaseConvertDefinitions {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        List<JndiConsumer> jndiConsumers = this.collectConsumers(appModule);
        KeyedCollection managedExecutors = new KeyedCollection();
        KeyedCollection managedExecutorsFromCompManagedBeans = new KeyedCollection();
        for (JndiConsumer consumer : jndiConsumers) {
            if (consumer == null) continue;
            if (consumer instanceof CompManagedBean) {
                managedExecutorsFromCompManagedBeans.addAll(consumer.getManagedExecutorMap().values());
                continue;
            }
            managedExecutors.addAll(consumer.getManagedExecutorMap().values());
        }
        Map managedExecutorsMap = managedExecutors.toMap();
        for (ManagedExecutor managedExecutor : managedExecutorsFromCompManagedBeans) {
            if (managedExecutorsMap.containsKey(managedExecutor.getName().getvalue())) continue;
            managedExecutors.add((Object)managedExecutor);
        }
        for (ManagedExecutor managedExecutor : managedExecutors) {
            appModule.getResources().add(this.toResource(managedExecutor));
        }
        return appModule;
    }

    private Resource toResource(ManagedExecutor managedExecutor) {
        String name = this.cleanUpName(managedExecutor.getName().getvalue());
        Resource def = new Resource(name, ManagedExecutorService.class.getName());
        def.setJndi(managedExecutor.getName().getvalue().replaceFirst("java:", ""));
        Properties p = def.getProperties();
        String contextName = managedExecutor.getContextService().getvalue();
        if ("java:comp/DefaultContextService".equals(contextName)) {
            contextName = "Default Context Service";
        }
        ConvertManagedExecutorServiceDefinitions.put(p, "Context", contextName);
        ConvertManagedExecutorServiceDefinitions.put(p, "HungTaskThreshold", managedExecutor.getHungTaskThreshold());
        ConvertManagedExecutorServiceDefinitions.put(p, "Max", managedExecutor.getMaxAsync());
        ConvertManagedExecutorServiceDefinitions.put(p, "JndiName", def.getJndi());
        return def;
    }

    private static void put(Properties properties, String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        properties.put(key, PropertyPlaceHolderHelper.value(String.valueOf(value)));
    }
}

