/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.DiscriminatorMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.InValueDiscriminatorStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.MetaDataException;

public class ValueMapDiscriminatorStrategy
extends InValueDiscriminatorStrategy {
    private static final long serialVersionUID = 1L;
    public static final String ALIAS = "value-map";
    private static final Localizer _loc = Localizer.forPackage(ValueMapDiscriminatorStrategy.class);
    private Map<String, Class<?>> _vals;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private final Lock _readLock = this.rwl.readLock();
    private final Lock _writeLock = this.rwl.writeLock();

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    protected int getJavaType() {
        Column col;
        Object val = this.disc.getValue();
        if (val != null && val != Discriminator.NULL) {
            return JavaTypes.getTypeCode(val.getClass());
        }
        DiscriminatorMappingInfo info = this.disc.getMappingInfo();
        List<Column> cols = info.getColumns();
        Column column = col = cols.isEmpty() ? null : cols.get(0);
        if (col != null) {
            if (col.getJavaType() != 8) {
                return col.getJavaType();
            }
            if (col.getType() != 1111) {
                return JavaTypes.getTypeCode(Schemas.getJavaType(col.getType(), col.getSize(), col.getDecimalDigits()));
            }
        }
        return 9;
    }

    @Override
    protected Object getDiscriminatorValue(ClassMapping cls) {
        Object val = cls.getDiscriminator().getValue();
        return val == Discriminator.NULL ? null : val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class getClass(Object val, JDBCStore store) throws ClassNotFoundException {
        Class<?> clz;
        if (this._vals == null) {
            this._writeLock.lock();
            try {
                if (this._vals == null) {
                    this._vals = ValueMapDiscriminatorStrategy.constructCache(this.disc);
                }
            }
            finally {
                this._writeLock.unlock();
            }
        }
        String className = val == null ? null : val.toString();
        this._readLock.lock();
        try {
            clz = this._vals.get(className);
            if (clz != null) {
                Class<?> clazz = clz;
                return clazz;
            }
        }
        finally {
            this._readLock.unlock();
        }
        this._writeLock.lock();
        try {
            clz = this._vals.get(className);
            if (clz != null) {
                Class<?> clazz = clz;
                return clazz;
            }
            this._vals = ValueMapDiscriminatorStrategy.constructCache(this.disc);
            clz = this._vals.get(className);
            if (clz != null) {
                Class<?> clazz = clz;
                return clazz;
            }
            throw new ClassNotFoundException(_loc.get("unknown-discrim-value", new Object[]{className, this.disc.getClassMapping().getDescribedType().getName(), new TreeSet<String>(this._vals.keySet())}).getMessage());
        }
        finally {
            this._writeLock.unlock();
        }
    }

    private static Map<String, Class<?>> constructCache(Discriminator disc) {
        ClassMapping cls = disc.getClassMapping();
        ClassMapping[] subs = cls.getJoinablePCSubclassMappings();
        HashMap map = new HashMap((int)((double)(subs.length + 1) * 1.33 + 1.0));
        ValueMapDiscriminatorStrategy.mapDiscriminatorValue(cls, map);
        for (ClassMapping sub : subs) {
            ValueMapDiscriminatorStrategy.mapDiscriminatorValue(sub, map);
        }
        return map;
    }

    private static void mapDiscriminatorValue(ClassMapping cls, Map<String, Class<?>> map) {
        Object val = cls.getDiscriminator().getValue();
        if (val == null) {
            return;
        }
        String str = val == Discriminator.NULL ? null : val.toString();
        Class<?> exist = map.get(str);
        if (exist != null) {
            throw new MetaDataException(_loc.get("dup-discrim-value", str, exist, cls));
        }
        map.put(str, cls.getDescribedType());
    }

    @Override
    public void map(boolean adapt) {
        Object val = this.disc.getMappingInfo().getValue(this.disc, adapt);
        if (val == null && !Modifier.isAbstract(this.disc.getClassMapping().getDescribedType().getModifiers())) {
            throw new MetaDataException(_loc.get("no-discrim-value", this.disc.getClassMapping()));
        }
        this.disc.setValue(val);
        super.map(adapt);
    }
}

