/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.server.httpd.WebBeansListenerHelper;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;

public class EndWebBeansListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener,
HttpSessionActivationListener {
    protected WebBeansContext webBeansContext;
    private final CdiAppContextsService contextsService;
    private final boolean cleanUpSession;

    public EndWebBeansListener(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        if (webBeansContext != null) {
            this.contextsService = (CdiAppContextsService)CdiAppContextsService.class.cast(webBeansContext.getService(ContextsService.class));
            this.cleanUpSession = Boolean.parseBoolean(webBeansContext.getOpenWebBeansConfiguration().getProperty("tomee.session.remove-cdi-beans-on-passivate", "false"));
        } else {
            this.contextsService = null;
            this.cleanUpSession = false;
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
    }

    public void requestInitialized(ServletRequestEvent event) {
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.contextsService == null) {
            return;
        }
        WebBeansListenerHelper.ensureRequestScope((ContextsService)this.contextsService, this);
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        if (this.webBeansContext == null) {
            return;
        }
        if (this.cleanUpSession) {
            event.getSession().removeAttribute("openWebBeansSessionContext");
        }
        WebBeansListenerHelper.destroyFakedRequest(this);
    }

    public void sessionDidActivate(HttpSessionEvent event) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        WebBeansListenerHelper.destroyFakedRequest(this);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.contextsService == null) {
            return;
        }
        WebBeansListenerHelper.ensureRequestScope((ContextsService)this.contextsService, this);
    }
}

