/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.apply;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.ruta.explain.apply.ApplyViewPage;
import org.apache.uima.ruta.explain.tree.IExplainTreeNode;
import org.apache.uima.ruta.type.ProfiledAnnotation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ApplyTreeLabelProvider
extends LabelProvider
implements ILabelProvider {
    private DecimalFormat dfTime = new DecimalFormat("###,###,##0.000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private DecimalFormat dfPercentage = new DecimalFormat("##0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    protected ApplyViewPage owner;
    ImageDescriptor blockApply;

    public ApplyTreeLabelProvider(ApplyViewPage owner) {
        this.owner = owner;
    }

    public Image getImage(Object element) {
        IExplainTreeNode debugNode;
        FeatureStructure fs;
        if (element instanceof IExplainTreeNode && (fs = (debugNode = (IExplainTreeNode)element).getFeatureStructure()) != null) {
            Object name = fs.getType().getName();
            if (((String)name).equals("org.apache.uima.ruta.type.DebugRuleApply") && debugNode.getChildren().size() >= 3) {
                name = (String)name + "Delegate";
            }
            return this.owner.getImage((String)name);
        }
        return null;
    }

    public String getText(Object element) {
        StringBuilder result = new StringBuilder();
        if (element instanceof IExplainTreeNode) {
            IExplainTreeNode debugNode = (IExplainTreeNode)element;
            TypeSystem ts = debugNode.getTypeSystem();
            Type ruleType = ts.getType("org.apache.uima.ruta.type.DebugRuleApply");
            FeatureStructure fs = debugNode.getFeatureStructure();
            if (fs != null && ts.subsumes(ruleType, fs.getType())) {
                Feature f1 = ruleType.getFeatureByBaseName("applied");
                int v1 = fs.getIntValue(f1);
                Feature f2 = ruleType.getFeatureByBaseName("tried");
                int v2 = fs.getIntValue(f2);
                result.append("[");
                result.append(v1);
                result.append("/");
                result.append(v2);
                result.append("] ");
                Feature f3 = ruleType.getFeatureByBaseName("element");
                Object v3 = fs.getStringValue(f3);
                v3 = ((String)v3).replaceAll("[\\n\\r]", "");
                if (((String)v3).length() > 150) {
                    v3 = ((String)v3).substring(0, 148) + "...";
                }
                result.append((String)v3);
                Feature f4 = ruleType.getFeatureByBaseName("time");
                long v4 = fs.getLongValue(f4);
                if (v4 > 0L) {
                    long parentTime;
                    FeatureStructure parent;
                    double took = (double)v4 / 1000.0;
                    String s = this.dfTime.format(took);
                    result.append(" [");
                    result.append(s);
                    result.append("s");
                    double percent = 100.0;
                    IExplainTreeNode parentNode = debugNode.getParent();
                    if (parentNode != null && (parent = parentNode.getFeatureStructure()) instanceof ProfiledAnnotation && (parentTime = ((ProfiledAnnotation)parent).getTime()) > 0L) {
                        percent = took / ((double)parentTime / 1000.0) * 100.0;
                    }
                    result.append("|");
                    result.append(this.dfPercentage.format(percent));
                    result.append("%");
                    result.append("]");
                }
            }
        }
        return result.toString();
    }

    public static String escape(String str) {
        String result = str.replaceAll("\\\\", "\\\\\\\\");
        return result;
    }
}

