/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.check;

import org.apache.uima.cas.Type;
import org.eclipse.jface.dialogs.IInputValidator;

public class ChangeFeatureValidator
implements IInputValidator {
    private Type range;

    public ChangeFeatureValidator(Type range) {
        this.range = range;
    }

    public String isValid(String input) {
        String rangeType = this.range.getShortName();
        if (input != null && !input.equalsIgnoreCase("")) {
            if (rangeType.equals("String")) {
                return null;
            }
            if (rangeType.equals("Integer")) {
                try {
                    Integer.parseInt(input);
                    return null;
                }
                catch (NumberFormatException e) {
                    return "Input must be an integer value!";
                }
            }
            if (rangeType.equals("Float")) {
                try {
                    Float.parseFloat(input);
                    return null;
                }
                catch (NumberFormatException e) {
                    return "Input must be a floating point value!";
                }
            }
            if (rangeType.equals("Double")) {
                try {
                    Double.parseDouble(input);
                    return null;
                }
                catch (NumberFormatException e) {
                    return "Input must be a double value!";
                }
            }
        }
        return null;
    }
}

