/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.util.ArrayList;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;
import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRuleItem;

public class AnnotationRule
extends TrabalRule {
    private TrabalRuleItem frontBoundaryItem;
    private TrabalRuleItem rearBoundaryItem;

    public AnnotationRule(TrabalLearner parentAlgorithm, TextRulerTarget target, TrabalAnnotation targetAnnotation) {
        super(parentAlgorithm, target);
        this.targetAnnotation = targetAnnotation;
        this.errorType = AnnotationErrorType.ANNOTATION;
        this.addConditionTypes();
    }

    public AnnotationRule(AnnotationRule copyFrom) {
        super((TrabalLearner)copyFrom.algorithm, copyFrom.target);
        this.targetAnnotation = copyFrom.targetAnnotation;
        this.errorType = AnnotationErrorType.ANNOTATION;
        this.frontBoundaryItem = copyFrom.frontBoundaryItem;
        this.rearBoundaryItem = copyFrom.rearBoundaryItem;
        this.conditions = new ArrayList();
        for (Condition c : copyFrom.conditions) {
            this.conditions.add(c.clone());
        }
        this.addConditionTypes();
    }

    private void addConditionTypes() {
        this.conditionTypes = new ArrayList();
        this.conditionTypes.add(ConditionType.STARTSWITH);
        this.conditionTypes.add(ConditionType.ENDSWITH);
        this.conditionTypes.add(ConditionType.CONTAINS);
        this.conditionTypes.add(ConditionType.PARTOF);
    }

    @Override
    public void compileRuleString() {
        String conditions;
        String before;
        boolean frontItemInBorders = this.frontBoundaryItem.getAnnotation().getBegin() == this.targetAnnotation.getBegin();
        boolean rearItemInBorders = this.rearBoundaryItem.getAnnotation().getEnd() == this.targetAnnotation.getEnd();
        String after = this.parseConditions(ConditionType.AFTER);
        if (after.length() > 0) {
            after = "{" + after + "}";
        }
        if ((before = this.parseConditions(ConditionType.BEFORE)).length() > 0) {
            before = "{" + before + "}";
        }
        if ((conditions = this.parseConditions(this.conditionTypes)).length() > 0) {
            conditions = conditions + ", ";
        }
        String nPartof = "-PARTOF(" + this.targetAnnotation.getType().getShortName() + ")";
        String mark = ((TrabalLearner)this.algorithm).getEnableFeatures() ? "-> CREATE(" + this.targetAnnotation.getType().getShortName() + this.parseFeatures() + ")" : "-> MARK(" + this.targetAnnotation.getType().getShortName() + ")";
        String action = "{" + conditions + nPartof + " " + mark + "}";
        this.ruleString = "";
        this.ruleString = frontItemInBorders ? this.ruleString + "(" + this.frontBoundaryItem + after + " " : this.ruleString + this.frontBoundaryItem + after + " (";
        this.ruleString = this.ruleString + "ANY*{-PARTOF(" + this.rearBoundaryItem + ")}";
        this.ruleString = rearItemInBorders ? this.ruleString + " " + this.rearBoundaryItem + before + ")" + action + ";" : this.ruleString + ")" + action + " " + this.rearBoundaryItem + before + ";";
        this.setNeedsCompile(false);
    }

    @Override
    public boolean contains(TrabalAnnotation target) {
        if (target != null) {
            if (this.targetAnnotation.getType().getShortName().equals(target.getType().getShortName())) {
                return true;
            }
            if (this.frontBoundaryItem.getName().equals(target.getType().getShortName())) {
                return true;
            }
            if (this.rearBoundaryItem.getName().equals(target.getType().getShortName())) {
                return true;
            }
            for (Condition each : this.getConditions()) {
                if (!each.getItem().getName().equals(target.getType().getShortName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSameBasicRule(TrabalRule rule) {
        if (rule.getAnnotation() != null) {
            return false;
        }
        if (rule.getTargetAnnotation() == null) {
            return false;
        }
        return rule.getTargetAnnotation().getType().getShortName().equals(this.targetAnnotation.getType().getShortName());
    }

    @Override
    public TrabalRuleItem getFrontBoundary() {
        return this.frontBoundaryItem;
    }

    public void setFrontBoundary(TrabalRuleItem item) {
        this.frontBoundaryItem = item;
    }

    @Override
    public TrabalRuleItem getRearBoundary() {
        return this.rearBoundaryItem;
    }

    public void setRearBoundary(TrabalRuleItem item) {
        this.rearBoundaryItem = item;
    }

    @Override
    public TrabalRule copy() {
        return new AnnotationRule(this);
    }
}

