/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.io.File;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.util.FileUtils;

public abstract class TextRulerRule {
    protected TextRulerBasicLearner algorithm;
    protected boolean needsCompile = true;
    protected String ruleString;
    protected TextRulerTarget target;
    protected TextRulerStatisticsCollector coveringStatistics;

    public TextRulerRule(TextRulerRule copyFrom) {
        this.algorithm = copyFrom.algorithm;
        this.needsCompile = copyFrom.needsCompile;
        this.ruleString = copyFrom.ruleString;
        this.target = new TextRulerTarget(copyFrom.target, this.algorithm);
        this.coveringStatistics = copyFrom.coveringStatistics != null ? copyFrom.coveringStatistics.copy() : null;
    }

    public TextRulerRule(TextRulerBasicLearner parentAlgorithm, TextRulerTarget target) {
        this.algorithm = parentAlgorithm;
        this.target = target;
    }

    public String getRuleString() {
        if (this.needsCompile) {
            this.compileRuleString();
        }
        return this.ruleString;
    }

    public TextRulerTarget getTarget() {
        return this.target;
    }

    public abstract void compileRuleString();

    public void setNeedsCompile(boolean flag) {
        this.needsCompile = flag;
    }

    public String getRulesFileContent() {
        return this.algorithm.getFileHeaderString(false) + this.getRuleString() + "\n";
    }

    public void saveToRulesFile(String filename) {
        File file = new File(filename);
        String str = this.getRulesFileContent();
        try {
            FileUtils.saveString2File((String)str, (File)file);
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
        }
    }

    public boolean equals(Object obj) {
        return this.getRuleString().equals(((TextRulerRule)obj).getRuleString());
    }

    public int hashCode() {
        return this.getRuleString().hashCode();
    }

    public void setCoveringStatistics(TextRulerStatisticsCollector c) {
        this.coveringStatistics = c.copy();
    }

    public TextRulerStatisticsCollector getCoveringStatistics() {
        return this.coveringStatistics;
    }

    public abstract TextRulerRule copy();

    public String toString() {
        return this.ruleString == null ? "<not compiled>" : this.ruleString;
    }
}

