/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.dde.internal.page;

import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.tools.images.internal.ImageLoader;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractHeaderPage
extends FormPage {
    public static final int STATUS_IS_VALID = 0;
    public static final int STATUS_IS_INVALID = -1;
    public static final int STATUS_FILE_NOT_SPECIFIED = 1;
    public static final int STATUS_FILE_NOT_EXIST = 2;

    public AbstractHeaderPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public AbstractHeaderPage(String id, String title) {
        super(id, title);
    }

    public void setFormPageTitle(ScrolledForm sform, String title) {
        sform.setText(title);
    }

    public static void createExpandOrCollapseAllMenu(FormToolkit toolkit, Section section, Composite toolbarComposite, final TreeViewer treeViewer, boolean expand) {
        String iconKey;
        String toolTipText;
        if (expand) {
            toolTipText = "Expand All";
            iconKey = "icons/full/elcl16/expandall.gif";
        } else {
            toolTipText = "Collapse All";
            iconKey = "icons/full/elcl16/collapseall.gif";
        }
        ImageHyperlink info = new ImageHyperlink(toolbarComposite, 0);
        toolkit.adapt((Control)info, true, true);
        Image image = ImageLoader.getInstance().getImage(iconKey);
        info.setImage(image);
        info.setToolTipText(toolTipText);
        if (expand) {
            info.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    treeViewer.expandAll();
                }
            });
        } else {
            info.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    treeViewer.collapseAll();
                }
            });
        }
    }

    protected static void createToolBarActions(IManagedForm managedForm, final SashForm sashForm, boolean selectHorizontal) {
        final ScrolledForm form = managedForm.getForm();
        Action haction = new Action("hor", 8){

            public void run() {
                sashForm.setOrientation(256);
                form.reflow(true);
            }
        };
        haction.setChecked(selectHorizontal);
        haction.setToolTipText("Horizontal Orientation");
        haction.setImageDescriptor(TAEConfiguratorPlugin.getImageDescriptor((String)"th_horizontal.gif"));
        haction.setDisabledImageDescriptor(TAEConfiguratorPlugin.getImageDescriptor((String)"th_horizontal.gif"));
        Action vaction = new Action("ver", 8){

            public void run() {
                sashForm.setOrientation(512);
                form.reflow(true);
            }
        };
        vaction.setChecked(!selectHorizontal);
        vaction.setToolTipText("Vertical Orientation");
        vaction.setImageDescriptor(TAEConfiguratorPlugin.getImageDescriptor((String)"th_vertical.gif"));
        vaction.setDisabledImageDescriptor(TAEConfiguratorPlugin.getImageDescriptor((String)"th_vertical.gif"));
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
        form.updateToolBar();
    }
}

