/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.AggregateTransformer;

abstract class XalanExecutor {
    private static final String PACKAGE = "org.apache.tools.ant.taskdefs.optional.junit.";
    protected AggregateTransformer caller;

    XalanExecutor() {
    }

    private void setCaller(AggregateTransformer caller) {
        this.caller = caller;
    }

    protected final OutputStream getOutputStream() throws IOException {
        if ("frames".equals(this.caller.format)) {
            return new ByteArrayOutputStream();
        }
        return new BufferedOutputStream(new FileOutputStream(new File(this.caller.toDir, "junit-noframes.html")));
    }

    abstract void execute() throws Exception;

    static XalanExecutor newInstance(AggregateTransformer caller) throws BuildException {
        XalanExecutor executor = null;
        try {
            Class<?> clazz = Class.forName("org.apache.tools.ant.taskdefs.optional.junit.Xalan2Executor");
            executor = (XalanExecutor)clazz.newInstance();
        }
        catch (Exception xsltcApacheMissing) {
            caller.task.log(xsltcApacheMissing.toString());
            throw new BuildException("Could not find xstlc nor xalan2 in the classpath. Check http://xml.apache.org/xalan-j");
        }
        String classNameImpl = executor.getImplementation();
        String version = executor.getProcVersion(classNameImpl);
        caller.task.log("Using " + version, 3);
        executor.setCaller(caller);
        return executor;
    }

    protected abstract String getImplementation();

    protected abstract String getProcVersion(String var1) throws BuildException;

    protected final String getXSLTCVersion(String procVersionClassName) throws ClassNotFoundException {
        Class<?> procVersion = Class.forName(procVersionClassName);
        Package pkg = procVersion.getPackage();
        return pkg.getName() + " " + pkg.getImplementationTitle() + " " + pkg.getImplementationVersion();
    }

    protected final String getXalanVersion(String procVersionClassName) throws ClassNotFoundException {
        Class<?> procVersion = Class.forName(procVersionClassName);
        String pkg = procVersion.getPackage().getName();
        try {
            Field f = procVersion.getField("S_VERSION");
            return pkg + " " + f.get(null).toString();
        }
        catch (Exception e) {
            return pkg + " ?.?";
        }
    }
}

