#!BPY
"""
Name: 'Stairs Creator'
Blender: 248
Group: 'Add'
Tooltip: 'Draw Platformed stairs'
"""
versja = "1.4.3"
__version__ = " ver. 1.4.3 RC1"
__descript__="Architectural script for creating stairs."
__author__	= "Krzystof Nowacki (GUCIAS)"
__license__ = "GPL"
__url__	= "http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Add/Stairs_Creator"
__bpydoc__ ="""The script creates platformed stairs...

StairsCreator for blender
by GUCIAS - Krzystof Nowacki
gucias@o2.pl 2008
http://www.gucias.republika.pl/katalog/katalogen.html


Version %s
Copyright %s
License %s
See the homepage for documentation.
url: %s

THANKS for:
www.blender.pl
(skoti) - for "first step" in python
(szczuro) - for "first step" in python, tips, help in python problems, etc  :)


IDEAs:
- stairs as parametric object = stored/editable parameters
- 3d-view interactive stairs geometry manipulation
- full professional StairCreator for architects :)

TODO:
- correct normals in second flight
- diffrent types of stairs
- types of railings

History
v.1.4.3 RC1 - 2008.12.9 by gucias
- upgrade/more functions for stairs
- correct normals and faces in flights
- fix bugs
v.1.4.2 - 2008.12.2 by gucias
- dynamic UI :)
- fix bugs
v.1.4.1 - 2008.12.2 by gucias
- fix bugs
v.1.4 	- 2008.12.2 by gicias & szczuro
- Add materials for elements of stairs
- diffrend types of stairs
v.1.3.3 - 2008.12.1 by gucias
- Tread options
v.1.3.2 - 2008.11.30 by gucias
- new function for connecting stairs with floor or ceiling
v1.3.1 - 2008.11.29 by migius
- convert to tabs
- clearing import procedures
v1.3.0 - 2008.11.28 by gucias  (with szczuro help:)
- new menu
- new function for creating stairs
- new graphic icons
- movable menu (with mouse middlebutton)
v.1.2.0 - 2008.11.27 by gucias (with szczuro help:)
- add graphic icons
- updating procedures
- etc..:)
v.1.1.0 - 2008.11.25 by gucias
- updating procedures
- new menu
.....
.....
v1.0.0 - 2008.11.19 by gucias
- initial version
- draw first stair :)

v.0......long time ago 2008.11.....
gucias ask skoti&szczuro what's python and how use it for make stairs :) :)

______________________________________________________________
"""


# --------------------------------------------------------------------------
# Script copyright (C) 2008 by Krzystof Nowacki (GUCIAS)
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA	02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****

import Blender
#from Blender import *
import bpy
import os, math
from Blender import NMesh
#from Blender.BGL import *
#from Blender.Draw import *
from Blender import BGL, Image, Draw, Window, Material

import math
#from math import *

szX = Draw.Create(0.32)		# szerokosc stopnia
wysY = Draw.Create(0.15)		# wysokosc stopnia
ilosc = Draw.Create(20)	 # ilosc stopni
szS = Draw.Create(1.20)	 # szerokosc biegu
dspS = Draw.Create(1.50)		# dlugosc spocznika
spS = Draw.Create(0.60)	 # sz. m biegami
ild = Draw.Create(10)	 # ilosc stopni do spocznika
wkD = Draw.Create(4.0)		# wysokosc kondygnacji
szD = Draw.Create(3.0)		# dlugosc biegu do spocznika
wyso = Draw.Create(4.0)
sztdx = Draw.Create(0.03)	# nosek nastopnicy
sztdy = Draw.Create(0.05)	# grubosc nastopnicy
szSS1 = Draw.Create(0.13)		#grubosc laczenia schodow typ 3

dbx1 = Draw.Create(0.05)	# gruosc deski bocznej
dby1 = Draw.Create(0.27)	# wysokosc deski bocznej
ydb = Draw.Create(0.07)		# podwyzszenie deski
# dby2 = Draw.Create(0.15)	# szerokosc deski bocznej

toggle=1
toggle1=0

toggle2=1
toggle3=0

guiHeightOffset = -20
guiWidgetHeight = 15
guiDrawOffset = 0
lastMousePosX = 0
lastMousePosY = 0
middlePressed = False
currentSelection = None

typ = Draw.Create(4)		# typ schodow
typsta = 4

EVENT_NOEVENT = 1
EVENT_DRAW		= 2
EVENT_EXIT		= 3
EVENT_DRAW2	 = 4
EVENT_SPRAWDZ = 5
EVENT_1		 = 6
EVENT_2		 = 7
EVENT_3		= 8
EVENT_4		= 9
EVENT_5		= 10

ymenu = 140
xmenu = 0
scx=0

imagname = "add_stairs_creator.png"

if Blender.sys.exists(os.path.join(Blender.Get("scriptsdir"),'add', imagname)):
	myimage = Image.Load(os.path.join(Blender.Get("scriptsdir"), 'add', imagname)) #---obrazek w tle
	
else:
	Draw.PupMenu("Script error. Picture not found in /.blender/scripts. Please read instructions.")
	print "----------------------ERROR------------------------------------------"
	print ""
	print ("Picture file not found. Read instruction how to install this script.")
	print ""
	print "----------------------ERROR------------------------------------------"
	Draw.Exit()


print "Welcome to StairsCreator " + __version__
# Draw.PupMenu("Yes|No")
celinfo = ""


def menu():
	global szX,wysY,ilosc,szS, dspS, spS, NSize, ild, wkD, myimage, szD, u, wyso, wiesc, celinfo, toggle,toggle1,sztdx,sztdy,typsta, scx,typ,dbx1,dby1,szSS1,ydb
	global EVENT_NOEVENT,EVENT_DRAW,EVENT_EXIT,EVENT_DRAW1,EVENT_SPRAWDZ

	u = (2*wysY.val)+szX.val

	# Tytul
	# BGL.glClearColor(1,1,1,1)
	BGL.glClear(BGL.GL_COLOR_BUFFER_BIT)
	BGL.glColor3f(0,0,0)
	# glClear(GL_COLOR_BUFFER_BIT)
	BGL.glRasterPos2d(xmenu+8, ymenu+475)
	Draw.Text("StairsCreator "+__version__+" by ")
	BGL.glRasterPos2d(xmenu+8, ymenu+455)
	Draw.Text(__descript__)
	BGL.glRasterPos2d(xmenu+8, ymenu+435)
	Draw.Text("Stairs parameters")
	BGL.glRasterPos2d(xmenu+8, ymenu+320)
	Draw.Text("Steps parameters [m]")
	BGL.glRasterPos2d(xmenu+8, ymenu+175)
	Draw.Text("Landing dimension [m]")
	BGL.glRasterPos2d(xmenu+8, ymenu+40)
	Draw.Text("Type of stairs:")
	BGL.glRasterPos2d(xmenu+8, ymenu+100)
	Draw.Text("Connection type:")
	Draw.Button("gucias",EVENT_DRAW2 ,xmenu+ 170, ymenu+470, 40, 18)

	# BGL.glColor3f(1,1,1)
	Draw.Toggle("", EVENT_1, 195+xmenu, 90+ymenu, 15, 15, toggle,"Landing and ceiling as next step in flight")
	Draw.Toggle("", EVENT_2, 195+xmenu, 60+ymenu, 15, 15, toggle1,"Landing and ceiling as step in flight")

	Draw.Toggle("", EVENT_3, 125+xmenu, 90+ymenu, 15, 15, toggle2,"First step on floor")
	Draw.Toggle("", EVENT_4, 125+xmenu, 60+ymenu, 15, 15, toggle3,"First step with ceiling")
	BGL.glRasterPos2d(xmenu+10, ymenu+50)
	Draw.Text (celinfo)

	# ------rysuj obrazki w menu
	BGL.glEnable( BGL.GL_BLEND )
	# Only needed for alpha blending images with background.
	BGL.glBlendFunc(BGL.GL_SRC_ALPHA, BGL.GL_ONE_MINUS_SRC_ALPHA)

	Draw.Image(myimage, xmenu+15, ymenu-142)
	BGL.glDisable( BGL.GL_BLEND )
	#-------------------------------------



	# GUI
	szS	 = Draw.Number("STAIRWAY WIDTH (W): ", 10, xmenu+10, ymenu+300, 200, 15, szS.val, 0.60, 10, "Stairway width");
	szX	 = Draw.Number("STEP DEPTH (s): ", 10,xmenu+ 10, ymenu+275, 200, 15, szX.val, 0.01, 0.5, "Step depth (s)");
	wysY	= Draw.Number("STEP HEIGHT (h): ", 10, xmenu+10,ymenu+ 250, 200, 15, wysY.val, 0.01, 0.5, "Step height (h)");
	if typ.val> 1: sztdx	= Draw.Number("TREAD NOSING (dx): ", 10, xmenu+10,ymenu+ 200, 200, 15, sztdx.val, 0.00, 0.1, "Tread nosing (dx)");
	if typ.val> 1: sztdy	= Draw.Number("TREAD THICKNESS (dy): ", 10, xmenu+10,ymenu+ 225, 200, 15, sztdy.val, 0.01, wysY.val, "tread thickness (dy)");
	dspS	= Draw.Number("LANDING DEPTH (D): ", 10, xmenu+10, ymenu+155, 200, 15, dspS.val, 0.5, 5, "Landing depth");
	if ild.val<ilosc.val: spS	 = Draw.Number("GAP b/FLIGHT (d): ", 10,xmenu+ 10,ymenu+ 130, 200, 15, spS.val, 0.001, 5, "Opening between flight of stairs");
	#wkD	= Draw.Number("STORY HEIGHT (H): ", 10,xmenu+ 10,ymenu+ 235, 170, 15, wkD.val, 1, 5, "Story height - use with automatic calculate dimensions");
	#szD	= Draw.Number("FLIGHT LENGHT (X): ", 10,xmenu+ 10, ymenu+180, 200, 15, szD.val, 0.60, 10, "Flight lenght to landing");
	if typ.val== 4:	dbx1	 = Draw.Number("STRINGER THICKNESS: ", 10, xmenu+10, ymenu-20, 200, 15, dbx1.val, 0.00, spS.val-0.00001, "Stringer thickness:  0=no stringer");
	if typ.val== 4:	dby1	 = Draw.Number("STRINGER HEIGHT: ", 10, xmenu+10, ymenu-45, 200, 15, dby1.val, 0.00, 0.5, "Stringer high:  0=no stringer");
	if typ.val== 3:	szSS1	 = Draw.Number("STREAM WIDTH", 10, xmenu+10, ymenu-95, 200, 15, szSS1.val, 0.01, szS.val, "Stairway stream width:  max = stairs type 2 :)");
	if typ.val== 4: ydb	 = Draw.Number("STRINGER ELEVATION", 10, xmenu+10, ymenu-70, 200, 15, ydb.val, -dby1.val, dby1.val, "Stinger elevation");

	ilosc = Draw.Slider("STEPS (N): ", EVENT_NOEVENT,xmenu+ 10, ymenu+380, 200, 18,
										ilosc.val, 2, 40, 1, "Total number of steps");
	ild = Draw.Slider("...to LANDING:", EVENT_NOEVENT,xmenu+ 10, ymenu+355, 200, 18,
										ild.val, 2, ilosc.val, 1, "Number of steps on the first flight of stairs:	n = N - one flight");

	typ = Draw.Slider(" ", EVENT_NOEVENT,xmenu+ 10, ymenu+10, 55, 18,
										typ.val, 1, 4, 1, "Stairs type");

	Draw.Button("Draw stairs",EVENT_DRAW ,xmenu+ 10, ymenu-130, 80, 18, "Draw stairs")
	Draw.Button("Cancel",EVENT_EXIT ,xmenu+ 130, ymenu-130, 80, 18)
#	Draw.Button("DESKA",EVENT_5 ,xmenu+ 230, ymenu-40, 80, 18)
	Draw.Button("Automatic calculate ",EVENT_SPRAWDZ ,xmenu+ 10,ymenu+ 405, 200, 20,
	"Click here if you want automatic calculate number (N) and optimal steps (h,s) dimensions : (2h+s >< 60-65 cm) if story height (H)= Constans")




def event(evt, val):
	# the function to handle input events
	global lastMousePosX, lastMousePosY, guiDrawOffset, middlePressed, currentSelection, ymenu, xmenu, toggle

	mouseX, mouseY = Window.GetMouseCoords()

	if middlePressed:
		if Window.GetMouseButtons() & Window.MButs['M']: # still pressed = dragging
			mouseDeltaY = lastMousePosY - mouseY
			mouseDeltaX = lastMousePosX - mouseX
			guiDrawOffset -= mouseDeltaY
			lastMousePosX = mouseX
			lastMousePosY = mouseY
			ymenu = ymenu-mouseDeltaY
			xmenu = xmenu-mouseDeltaX
			if xmenu < 1: xmenu=1
			Draw.Draw()
		else: # not pressed any more
			middlePressed = False
	elif not middlePressed and Window.GetMouseButtons() & Window.MButs['M']: # not yet pressed, start dragging
		lastMousePosX = mouseX
		lastMousePosY = mouseY
		middlePressed = True


	if (evt == Draw.QKEY and not val):
		Draw.Exit()


def bevent(evt):
	global EVENT_NOEVENT,EVENT_DRAW,EVENT_EXIT,EVENT_DRAW2,EVENT_SPRAWDZ,EVENT_5
	global EVENT_1,EVENT_2, toggle, toggle1, celinfo, toggle2, toggle3,typsta
	if (evt == EVENT_EXIT):
		Draw.Exit()
	elif (evt== EVENT_DRAW):
		Schody ()
		if dbx1.val>0 and dby1.val>0: Deska ()
	elif (evt== EVENT_DRAW2):
		Inform ()
	elif (evt== EVENT_1):
		toggle = 1 - toggle
		if toggle == 1:
			toggle1 = 0
		if toggle == 0:
			toggle1 = 1
		Draw.Redraw(EVENT_1)
	elif (evt== EVENT_2):
		 toggle1 = 1 - toggle1
		 if toggle1 == 0:
			toggle = 1
		 if toggle1 == 1:
			toggle = 0
		 Draw.Redraw(EVENT_2)
	elif (evt== EVENT_3):
		 toggle2 = 1 - toggle2
		 if toggle2 == 0:
			toggle3 = 1
		 if toggle2 == 1:
			toggle3 = 0
		 Draw.Redraw(EVENT_3)
	elif (evt== EVENT_4):
		 toggle3 = 1 - toggle3
		 if toggle3 == 0:
			toggle2 = 1
		 if toggle3 == 1:
			toggle2 = 0
		 Draw.Redraw(EVENT_4)
	elif (evt== EVENT_5):

		 Draw.Redraw(EVENT_5)

	elif (evt== EVENT_SPRAWDZ):
	# jesli nie wykona sie taki popup ...
		result = Draw.PupBlock('Story height (H) [m] = const.', [\
		('STORY HEIGHT (H): ', wyso, 0.45, 6, 'Total story height (m)'),])
		if not result: return
		Sprawdz()
	Blender.Redraw()

#------------------------------------------------------
Draw.Register(menu, event, bevent)


#------------------------------------------------------
def Inform ():
	Draw.PupMenu('Welcome to my homepage :)')
	url = 'http://www.gucias.republika.pl/katalog/katalogen.html'
	try:
		import webbrowser
		webbrowser.open(url)
	except:
		print '...could not open a browser window.'



#------------Automatycznie przeliczam schody H kondygnacji = constans-----------------------------------------
def Sprawdz ():
	global toggle
	wkD = wyso		# wysokosc kondygnacji

	u = (2*wysY.val)+szX.val
	s=0.00
	c=0.00
	i=0
	g=0.0
	sz=0.00

	if u <> 0:
		print "LIST of OPTIMAL STAIRS PARAMETERS---for ", str(wkD.val),"(m) STORY HIGHT"
		for i in range(1000):
			c=c+0.01
			g=g+1
			s=wkD.val/g

			sz=sz+0.01
			if s > 0.149 and s < 0.20:

				print "Step hight (h): ",s,"	Total number of steps ", g,"	", c
				wysY.val=s
				ilosc.val=g
				szX.val= 0.60 - (2*wysY.val)
				print "Step width (s): ",szX.val
				print "--------------------------------------------"

	ild.val=int(ilosc.val/2)
	wiesc = "STAIRS ARE OK."

	#Draw.PupMenu('Wys Y: '+str(wysY.val) +'	ilosc: '+str(ilosc.val) )
	Draw.PupMenu('Stairs are recalculated. Still you can change steps number of first flight (n) or press -[Draw stairs]-')



#---------------------------------------------------------------------------------------------------

# ---------------------------------------- SCHODY PROSTE I DWUBIEGOWE (STAIRS 1 OR 2 FLATS) --------------------------
def Schody ():

	global toggle2, Material, mati, scx

	typsta=typ.val
	scx=0
	szty = 0
	sztx = sztdx.val
	if typsta >1: szty = sztdy.val

	dsp=dspS.val
	s=szS.val
	w=wysY.val
	d=szX.val-sztx
	sp = spS.val

	sxc=0
	if typsta ==3: scx=(szS.val-szSS1.val)/2

	il = ilosc.val
	if spS > 0 :
		il=ild.val
		il2=ilosc.val-il

	editmode = Window.EditMode()		# are we in edit mode?	If so ...
	if editmode: Window.EditMode(0) # leave edit mode before getting the mesh
	# define vertices and faces for a pyramid

	#pierwszy schodek
	#cztery pierwsze wierzcholki
	if toggle2 ==1: coords=[ [-s/2+scx,0,0],[s/2-scx,0,0], [-s/2+scx,0,w-szty], [s/2-scx,0,w-szty] ]
	if toggle2 ==0: coords=[ [-s/2+scx,0,0-w],[s/2-scx,0,0-w], [-s/2+scx,0,w-szty], [s/2-scx,0,w-szty] ]
	#dodajemy nastepne 4
	coords.extend([[-s/2+scx,d,0],[s/2-scx,d,0], [-s/2+scx,d,w-szty], [s/2-scx,d,w-szty]])
	# zamykamy 5 face'ami
	faces= [[0,1,3,2], [1,0,4,5], [6,4,0,2], [3,1,5,7], [7,6,2,3]]
	#srodkowe schodki w petli
	if toggle ==0: il=il
	if toggle ==1: il=il-1
	for i in xrange(il):
		if i!=0:
			coords.extend([[-s/2+scx,(i)*d,(i+1)*w-szty], [s/2-scx,(i)*d,(i+1)*w-szty]])
			coords.extend([[-s/2+scx,(i+1)*d,(i)*w],[s/2-scx,(i+1)*d,(i)*w], [-s/2+scx,(i+1)*d,(i+1)*w-szty], [s/2-scx,(i+1)*d,(i+1)*w-szty]])
			v=i*6
			faces.extend([[v,v+1,v+3,v+2], [v+6,v+4,v,v+2], [v+3,v+1,v+5,v+7], [v+7,v+6,v+2,v+3]])
			faces.extend([[v-2,v,v+4],[v+1,v-1,v+5],[v-1,v-2,v+4,v+5]])


	#domkniecie ostatiego
	#faces.extend([[v+4,v+6,v+7,v+5]])
	if toggle==0:faces.extend([[v+4,v+6,v+7,v+5]])
	elif toggle==1:
		m=0
		n=0
		i=il
		coords.extend([[-s/2+scx,(i+1)*d-2*szty,(i)*w-szty],[s/2-scx,(i+1)*d-2*szty,(i)*w-szty], [-s/2+scx,(i+1)*d-2*szty,(i)*w-szty], [s/2-scx,(i+1)*d-2*szty,(i)*w-szty]])
		v=i*6
		faces.extend([[v-2,v,v+4],[v+1,v-1,v+5],[v-1,v-2,v+4,v+5]])

	if typsta==1 or typsta==2 or typsta==3:
		me = bpy.data.meshes.new('Schody')					# create a new mesh

 		try:
			mati = Material.Get("Stairs")
		except:
			mati = Material.New('Stairs')
			mati.setRGBCol(0.9,0.9,0.9)

		me.materials = [mati]

		me.verts.extend(coords)					# add vertices to mesh
		me.faces.extend(faces)					 # add faces to the mesh (also adds edges)

		scn = bpy.data.scenes.active		 # link object to current scene
		ob = scn.objects.new(me, 'Schody')




#------------------------------------------------------------------------------------





# ------------SPOCZNIK (LANDING)--------------------------------------

 #pierwszy schodek

	n=d*il
	if toggle==1:
		#n=d*il-d
		m=w*il

	scx=0
	if typsta ==3:
		scx=(szS.val-szSS1.val)/2
		dsp=s-2*scx

	if toggle==0: m=w*il-w
	sp=0

	if spS > 0 and il2>1:
		#dsp=dspS.val
		sp=s+spS.val

	if toggle ==0:
	#cztery pierwsze wierzcholki
		coords=[ [-s/2-sp+scx,n+0,0+m],[s/2-scx,n+0,0+m], [-s/2-sp+scx,n+0,w+m-szty], [s/2-scx,n+0,w+m-szty] ]
	#dodajemy nastepne 4
		coords.extend([[-s/2-sp+scx,n+dsp,0+m],[s/2-scx,n+dsp,0+m], [-s/2-sp+scx,n+dsp,w+m-szty], [s/2-scx,n+dsp,w+m-szty]])
	# zamykamy 5 face'ami
		faces= [[0,1,3,2], [1,0,4,5], [6,4,0,2], [3,1,5,7], [7,6,2,3]]
		faces.extend([[4,6,7,5]])

	if toggle ==1:
		if typsta ==3:
			scx=scx=(szS.val-szSS1.val)/2
			dsp=szX.val
		coords=[ [-s/2-sp+scx,n+0,0+m-szty],[s/2-scx,n+0,0+m-szty], [-s/2-sp+scx,n+0,w+m-szty], [s/2-scx,n+0,w+m-szty] ]
		coords.extend([[-s/2-sp+scx,n+dsp,0+m-szty],[s/2-scx,n+dsp,0+m-szty], [-s/2-sp+scx,n+dsp,w+m-szty], [s/2-scx,n+dsp,w+m-szty]])

		faces= [[0,1,3,2], [1,0,4,5], [6,4,0,2], [3,1,5,7], [7,6,2,3]]
		faces.extend([[4,6,7,5]])

	if typsta < 4:
		me = bpy.data.meshes.new('Spocznik')					# create a new mesh

  		try:
			mati = Material.Get("Stairs")
		except:
			mati = Material.New('Stairs')
			mati.setRGBCol(0.9,0.9,0.9)

		me.materials = [mati]

		me.verts.extend(coords)					# add vertices to mesh
		me.faces.extend(faces)					 # add faces to the mesh (also adds edges)

		scn = bpy.data.scenes.active		 # link object to current scene
		ob = scn.objects.new(me, 'Spocznik')

#--------SPOCZNIK-NASTOPNICA-----------------------------------------------------
	dsp=dspS.val
	if toggle ==0 and sztdy.val>0:
		dsp=dspS.val
		coords=[ [-s/2-sp,n+0,0+m+w-szty],[s/2,n+0,0+m+w-szty], [-s/2-sp,n+0,w+m], [s/2,n+0,w+m] ]
	#dodajemy nastepne 4
		coords.extend([[-s/2-sp,n+dsp,0+m+w-szty],[s/2,n+dsp,0+m+w-szty], [-s/2-sp,n+dsp,w+m], [s/2,n+dsp,w+m]])
	# zamykamy 5 face'ami
		faces= [[0,1,3,2], [1,0,4,5], [6,4,0,2], [3,1,5,7], [7,6,2,3]]
		faces.extend([[4,6,7,5]])

	if toggle ==1 and sztdy.val>0:
	#cztery pierwsze wierzcholki
		coords=[ [-s/2-sp,n+0-sztx,0+m+w-szty],[s/2,n+0-sztx,0+m+w-szty], [-s/2-sp,n+0-sztx,w+m], [s/2,n+0-sztx,w+m] ]
	#dodajemy nastepne 4
		coords.extend([[-s/2-sp,n+dsp,0+m+w-szty],[s/2,n+dsp,0+m+w-szty], [-s/2-sp,n+dsp,w+m], [s/2,n+dsp,w+m]])
	# zamykamy 5 face'ami
		faces= [[0,1,3,2], [1,0,4,5], [6,4,0,2], [3,1,5,7], [7,6,2,3]]
		faces.extend([[4,6,7,5]])

	if szty>0 and typsta >1:
		me = bpy.data.meshes.new('Spocznik nastopnica')					# create a new mesh

		try:
			mati = Material.Get("Trips")
		except:
			mati = Material.New('Trips')
			mati.setRGBCol(0.6,0.5,0.4)

		me.materials = [mati]

		me.verts.extend(coords)					# add vertices to mesh
		me.faces.extend(faces)					 # add faces to the mesh (also adds edges)
		scn = bpy.data.scenes.active		 # link object to current scene
		ob = scn.objects.new(me, 'Spocznik nastopnica')




	# ---------Bieg drugi schodow ---------------------------------------
	if spS > 0 and il2>1:
		#pierwszy schodek
		#	m=w*il
		if toggle==1:
			# n=d*il-d
			m=w*il+w
			il2=il2-1
		if toggle==0:
			m=w*il
		d=d*(-1)

		scx=0
		if typsta ==3: scx=(szS.val-szSS1.val)/2

		#cztery pierwsze wierzcholki
		coords=[ [-s/2-sp+scx,n+0,0+m-w],[s/2-sp-scx,n+0,0+m-w], [-s/2-sp+scx,n+0,w+m-szty], [s/2-sp-scx,n+0,w+m-szty] ]
		#dodajemy nastepne 4
		coords.extend([[-s/2-sp+scx,n+d,0+m],[s/2-sp-scx,n+d,0+m], [-s/2-sp+scx,n+d,w+m-szty], [s/2-sp-scx,n+d,w+m-szty]])
		# zamykamy 5 face'ami
		faces= [[1,0,2,3], [0,1,5,4], [4,6,2,0], [1,3,7,5], [6,7,3,2]]
		#srodkowe schodki w petli
		for i in xrange(il2):
			if i!=0:
				if toggle==0:
					coords.extend([[-s/2-sp+scx,n+(i)*d,(i+1)*w+m-szty], [s/2-sp-scx,n+(i)*d,(i+1)*w+m-szty]])
					coords.extend([[-s/2-sp+scx,n+(i+1)*d,(i)*w+m],[s/2-sp-scx,n+(i+1)*d,(i)*w+m], [-s/2-sp+scx,n+(i+1)*d,(i+1)*w+m-szty], [s/2-sp-scx,n+(i+1)*d,(i+1)*w+m-szty]])
					v=i*6
					faces.extend([[v+1,v,v+2,v+3], [v+4,v+6,v+2,v], [v+1,v+3,v+7,v+5], [v+6,v+7,v+3,v+2]])
					faces.extend([[v,v-2,v+4],[v-1,v+1,v+5],[v-2,v-1,v+5,v+4]])
				if toggle==1:
					coords.extend([[-s/2-sp+scx,n+(i)*d,(i+1)*w+m-szty], [s/2-sp-scx,n+(i)*d,(i+1)*w+m-szty]])
					coords.extend([[-s/2-sp+scx,n+(i+1)*d,(i)*w+m],[s/2-sp-scx,n+(i+1)*d,(i)*w+m], [-s/2-sp+scx,n+(i+1)*d,(i+1)*w+m-szty], [s/2-sp-scx,n+(i+1)*d,(i+1)*w+m-szty]])
					v=i*6
					faces.extend([[v+1,v,v+2,v+3], [v+4,v+6,v+2,v], [v+1,v+3,v+7,v+5], [v+6,v+7,v+3,v+2]])
					faces.extend([[v,v-2,v+4],[v-1,v+1,v+5],[v-2,v-1,v+5,v+4]])
		#domkniecie ostatiego
		if toggle==0:faces.extend([[v+6,v+4,v+5,v+7]])
		if toggle==1:
			m=m-w
			i=il2
			coords.extend([[-s/2-sp+scx,n+(i+1)*d+2*szty,(i+1)*w+m-szty],[s/2-sp-scx,n+(i+1)*d+2*szty,(i+1)*w+m-szty], [-s/2-sp+scx,n+(i+1)*d+2*szty,(i+1)*w+m-szty], [s/2-sp-scx,n+(i+1)*d+2*szty,(i+1)*w+m-szty]])
			v=i*6
			faces.extend([[v,v-2,v+4],[v-1,v+1,v+5],[v-2,v-1,v+5,v+4]])


		if typsta==1 or typsta==2 or typsta==3:
			me = bpy.data.meshes.new('Schody1')					# create a new mesh

 			try:
				mati = Material.Get("Stairs")
			except:
				mati = Material.New('Stairs')
				mati.setRGBCol(0.9,0.9,0.9)

			me.materials = [mati]

			me.verts.extend(coords)					# add vertices to mesh
			me.faces.extend(faces)					 # add faces to the mesh (also adds edges)

			scn = bpy.data.scenes.active		 # link object to current scene
			ob = scn.objects.new(me, 'Schody1')


		if editmode: Window.EditMode(1)	# optional, just being nice

#	if il2 > 0: Draw.PupMenu('INFO:	Create stairs with 2 flights')
#	else: Draw.PupMenu('INFO:	Create stairs with 1 flights')


# ---------------------------------------------------------------------------------------------------

#----------------------------	Nastopnice  ----------------------------------------------------------------

	if szty>0:
		d=szX.val-sztx
		w=wysY.val

 	#pierwszy schodek
		r=0
		a=0

		#cztery pierwsze wierzcholki
	#-	coords=[ [-s/2,0-sztx,w-szty],[s/2,0-sztx,w-szty], [-s/2,0-sztx,w], [s/2,0-sztx,w] ]
		coords=([[-s/2,a*d-sztx,(a+1)*w-szty],[s/2,a*d-sztx,(a+1)*w-szty], [-s/2,a*d-sztx,(a+1)*w], [s/2,a*d-sztx,(a+1)*w] ])
		#dodajemy nastepne 4
	#-	coords.extend([[-s/2,d,w-szty],[s/2,d,w-szty], [-s/2,d,w], [s/2,d,w]])
		coords.extend([[-s/2,a*d+d,(a+1)*w-szty],[s/2,a*d+d,(a+1)*w-szty], [-s/2,a*d+d,(a+1)*w], [s/2,a*d+d,(a+1)*w]])
		# zamykamy 5 face'ami
		faces=( [[r+0,r+1,r+3,r+2], [r+1,r+0,r+4,r+5], [r+6,r+4,r+0,r+2], [r+3,r+1,r+5,r+7], [r+7,r+6,r+2,r+3]])
		faces.extend([[r+5,r+4,r+6,r+7]])

	#	srodkowe schodki w petli
		if toggle ==0: il=il
		if toggle ==1: il=il
		for a in xrange(1,il):
			# if a!=0:
				coords.extend([[-s/2,a*d-sztx,(a+1)*w-szty],[s/2,a*d-sztx,(a+1)*w-szty], [-s/2,a*d-sztx,(a+1)*w], [s/2,a*d-sztx,(a+1)*w] ])
				coords.extend([[-s/2,a*d+d,(a+1)*w-szty],[s/2,a*d+d,(a+1)*w-szty], [-s/2,a*d+d,(a+1)*w], [s/2,a*d+d,(a+1)*w]])
				r=r+8
				faces.extend([[r+0,r+1,r+3,r+2], [r+1,r+0,r+4,r+5], [r+6,r+4,r+0,r+2], [r+3,r+1,r+5,r+7], [r+7,r+6,r+2,r+3]])
				faces.extend([[r+5,r+4,r+6,r+7]])

		if typsta==2 or typsta==3 or typsta==4:
			me = bpy.data.meshes.new('Trips')					# create a new mesh

 			try:
				mati = Material.Get("Trips")
			except:
				mati = Material.New('Trips')
				mati.setRGBCol(0.6,0.5,0.4)

			me.materials = [mati]

			me.verts.extend(coords)					# add vertices to mesh
			me.faces.extend(faces)					 # add faces to the mesh (also adds edges)

			scn = bpy.data.scenes.active		 # link object to current scene
			ob = scn.objects.new(me, 'Trips')

# ------------------------drugi bieg nastopnic ---------------------------
		if spS > 0 and il2>1:
			w=wysY.val
			#pierwszy schodek
			#	m=w*il
			if toggle==1:
				n=d*il
				m=w*il+w
				il2=il2
			if toggle==0:
				m=w*il
			d=d*(-1)
			 #pierwszy schodek
			r=0
			a=0

			#cztery pierwsze wierzcholki

			coords=([[-s/2-sp,n+a*d+sztx,(a+1)*w-szty+m],[s/2-sp,n+a*d+sztx,(a+1)*w-szty+m], [-s/2-sp,n+a*d+sztx,(a+1)*w+m], [s/2-sp,n+a*d+sztx,(a+1)*w+m] ])
			coords.extend([[-s/2-sp,n+a*d+d,(a+1)*w-szty+m],[s/2-sp,n+a*d+d,(a+1)*w-szty+m], [-s/2-sp,n+a*d+d,(a+1)*w+m], [s/2-sp,n+a*d+d,(a+1)*w+m]])

			faces=( [[r+0,r+1,r+3,r+2], [r+1,r+0,r+4,r+5], [r+6,r+4,r+0,r+2], [r+3,r+1,r+5,r+7], [r+7,r+6,r+2,r+3]])
			faces.extend([[r+5,r+4,r+6,r+7]])

		#	srodkowe schodki w petli
			if toggle ==0: il=il2
			if toggle ==1: il=il2
			for a in xrange(1,il2):
				# if a!=0:
					coords.extend([[-s/2-sp,n+a*d+sztx,(a+1)*w-szty+m],[s/2-sp,n+a*d+sztx,(a+1)*w-szty+m], [-s/2-sp,n+a*d+sztx,(a+1)*w+m], [s/2-sp,n+a*d+sztx,(a+1)*w+m] ])
					coords.extend([[-s/2-sp,n+a*d+d,(a+1)*w-szty+m],[s/2-sp,n+a*d+d,(a+1)*w-szty+m], [-s/2-sp,n+a*d+d,(a+1)*w+m], [s/2-sp,n+a*d+d,(a+1)*w+m]])
					r=r+8
					faces.extend([[r+0,r+1,r+3,r+2], [r+1,r+0,r+4,r+5], [r+6,r+4,r+0,r+2], [r+3,r+1,r+5,r+7], [r+7,r+6,r+2,r+3]])
					faces.extend([[r+5,r+4,r+6,r+7]])

			if typsta==2 or typsta==3 or typsta==4:
				me = bpy.data.meshes.new('Trips1')					# create a new mesh


				me.materials = []


				try:
					mati = Material.Get("Trips")
				except:
					mati = Material.New('Trips')
					mati.setRGBCol(0.6,0.5,0.4)

				me.materials = [mati]


				me.verts.extend(coords)					# add vertices to mesh
				me.faces.extend(faces)					 # add faces to the mesh (also adds edges)

				scn = bpy.data.scenes.active		 # link object to current scene
				ob = scn.objects.new(me, 'Trips1')


# --------------------------------------------------DESKA BOCZNA zewnetrzna-----------------------------
def Deska ():
	global toggle,toggle2, Material, mati, scx, dbx,dby,dbya,sp,y


	dbx=dbx1.val
	dby=dby1.val
#	dbya=dby2.val

	y=ydb.val

	typsta=typ.val
	scx=0
	szty = sztdy.val
	sztx = sztdx.val
	if typsta >1: szty = sztdy.val

	dsp=dspS.val
	s=szS.val
	w=wysY.val
	d=szX.val-sztx
	sp = spS.val
	dsp=dspS.val

	sp1=s*2+sp
	sxc=0
	if typsta ==3: scx=(szS.val-szSS1.val)/2




	editmode = Window.EditMode()		# are we in edit mode?	If so ...
	if editmode: Window.EditMode(0) # leave edit mode before getting the mesh
	# define vertices and faces for a pyramid

	#pierwszy
	#cztery pierwsze wierzcholki


#	if toggle2 ==0: coords=[ [s/2,0,y+0-dby/2],[s/2+dbx,0,y+w-dby/2], [s/2,0,y+w+dby/2], [s/2+dbx,0,y+w+dby/2] ]
#	if toggle2 ==1: coords=[ [s/2,0,y+0+dby/2],[s/2+dbx,0,y+0+dby/2], [s/2,d,y+w+dby/2], [s/2+dbx,d,y+w+dby/2]]


	coords=[ [s/2,0,y+0+dby/2],[s/2+dbx,0,y+0+dby/2], [s/2,d,y+w-dby/2], [s/2+dbx,d,y+w-dby/2]]
	#dodajemy nastepne 4
	coords.extend([[s/2,0,y+0-dby/2],[s/2+dbx,0,y+0-dby/2], [s/2,d,y+w+dby/2], [s/2+dbx,d,y+w+dby/2]])
	# zamykamy 5 face'ami
	faces = [[5,4,2,3], [1,0,4,5] , [7,6,0,1] , [7,1,5,3 ],[0,6,2,4 ] ] #, [3,1,5,7], [7,6,2,3]]

	i=ild.val-2

	coords.extend([[s/2,(i)*d+d,y+(i+1)*w+dby/2], [s/2+dbx,(i)*d+d,y+(i+1)*w+dby/2]])
	coords.extend([[s/2,d,y+w-dby/2],[s/2+dbx,d,y+w-dby/2], [s/2,(i+1)*d,y+(i+1)*w-dby/2], [s/2+dbx,(i+1)*d,y+(i+1)*w-dby/2]])
	v=6
	faces.extend([[v,v+1,v+3,v+2], [v+6,v+4,v,v+2], [v+3,v+1,v+5,v+7], [v+7,v+6,v+2,v+3]])
	faces.extend([[v+5,v+4,v+6,v+7]])  #  ,[v+1,v-1,v+5],[v-1,v-2,v+4,v+5]])

	if ilosc.val<>ild.val:

		if toggle1 ==0:	dsp=dsp-d

		coords.extend([[s/2,(i+1)*d+d+dsp,y+(i+1)*w-dby/2], [s/2+dbx,(i+1)*d+d+dsp+dbx,y+(i+1)*w-dby/2]])
		coords.extend([[s/2,(i+1)*d+d+dsp,y+(i+1)*w+dby/2], [s/2+dbx,(i+1)*d+d+dsp+dbx,y+(i+1)*w+dby/2]])
		faces.extend([[v+7,v+6,v+8,v+9],[v+11,v+10,v+2,v+3],[v+3,v+7,v+9,v+11],[v+10,v+8,v+6,v+2]])

		coords.extend([[s/2-sp1,(i+1)*d+d+dsp,y+(i+1)*w-dby/2], [s/2-dbx-sp1,(i+1)*d+d+dsp+dbx,y+(i+1)*w-dby/2]])
		coords.extend([[s/2-sp1,(i+1)*d+d+dsp,y+(i+1)*w+dby/2], [s/2-dbx-sp1,(i+1)*d+d+dsp+dbx,y+(i+1)*w+dby/2]])
		faces.extend([[v+15,v+14,v+10,v+11],[v+11,v+9,v+13,v+15],[v+9,v+8,v+12,v+13],[v+14,v+12,v+8,v+10]])


		if toggle1 ==0: i2=ilosc.val-i
		if toggle1 ==1: i2=ilosc.val-i

		if toggle1 ==1:	xst=(i)*d+2*d
		if toggle1 ==0:	xst=(i)*d+1*d
		if toggle1 ==0:

			xen=xst-i2*d+3*d
			yen=(ilosc.val-1)*w
		if toggle1 ==1:
			xen=xst-i2*d+3*d
			xen=xen-d
			yen=(ilosc.val-1)*w
			yen=yen+w

		coords.extend([[s/2-sp1,xst+dby,y+(i+1)*w+dby/2], [s/2-dbx-sp1,xst+dby,y+(i+1)*w+dby/2]])
		coords.extend([[s/2-sp1,xen,y+yen+dby/2], [s/2-dbx-sp1,xen,y+yen+dby/2]])
		coords.extend([[s/2-sp1,xen,y+yen-dby/2], [s/2-dbx-sp1,xen,y+yen-dby/2]])
		coords.extend([[s/2-sp1,xst+dby,y+(i+1)*w-dby/2], [s/2-dbx-sp1,xst+dby,y+(i+1)*w-dby/2]])
		faces.extend([[v+19,v+18,v+16,v+17]])
		faces.extend([[v+20,v+21,v+23,v+22]])
		faces.extend([[v+19,v+17,v+23,v+21]])
		faces.extend([[v+20,v+22,v+16,v+18]])

		faces.extend([[v+17,v+16,v+14,v+15]])
		faces.extend([[v+22,v+23,v+13,v+12]])
		faces.extend([[v+15,v+13,v+23,v+17]])
		faces.extend([[v+12,v+14,v+16,v+22]])

		faces.extend([[v+19,v+21,v+20,v+18]])


		v==0
		i==0
	if typsta==4 :
		me = bpy.data.meshes.new('Stinger')					# create a new mesh

 		try:
			mati = Material.Get("Trips")
		except:
			mati = Material.New('Trips')
			mati.setRGBCol(0.6,0.5,0.4)

		me.materials = [mati]

		me.verts.extend(coords)					# add vertices to mesh
		me.faces.extend(faces)					 # add faces to the mesh (also adds edges)

		scn = bpy.data.scenes.active		 # link object to current scene
		ob = scn.objects.new(me, 'Stinger')


#--------wewnetrzna decha-------------------------------

# if typsta==4 :
		dbx=dbx1.val
		dby=dby1.val
	#	dbya=dby2.val

		y=ydb.val

		typsta=typ.val
		scx=0
		szty = sztdy.val
		sztx = sztdx.val
		if typsta >1: szty = sztdy.val

		dsp=dspS.val
		s=(szS.val+dbx*2)*(-1)
		w=wysY.val
		d=szX.val-sztx
		sp = spS.val
		dsp=dspS.val



		sp1=s*2+sp
		sxc=0


		coords=[ [s/2,0,y+0+dby/2],[s/2+dbx,0,y+0+dby/2], [s/2,d,y+w-dby/2], [s/2+dbx,d,y+w-dby/2]]
		#dodajemy nastepne 4
		coords.extend([[s/2,0,y+0-dby/2],[s/2+dbx,0,y+0-dby/2], [s/2,d,y+w+dby/2], [s/2+dbx,d,y+w+dby/2]])
		# zamykamy 5 face'ami
		faces = [[5,4,2,3], [1,0,4,5] , [7,6,0,1] , [7,1,5,3 ],[0,6,2,4 ] ] #, [3,1,5,7], [7,6,2,3]]

		i=ild.val-2

		coords.extend([[s/2,(i)*d+d,y+(i+1)*w+dby/2], [s/2+dbx,(i)*d+d,y+(i+1)*w+dby/2]])
		coords.extend([[s/2,d,y+w-dby/2],[s/2+dbx,d,y+w-dby/2], [s/2,(i+1)*d,y+(i+1)*w-dby/2], [s/2+dbx,(i+1)*d,y+(i+1)*w-dby/2]])

	#	if toggle1==0:
	#		coords.extend([[s/2,(i)*d+d,y+(i+1)*w+dby/2], [s/2+dbx,(i)*d+d,y+(i+1)*w+dby/2]])
	#		coords.extend([[s/2,d,y+w-dby/2],[s/2+dbx,d,y+w-dby/2], [s/2,(i+1)*d,y+(i+1)*w-dby/2], [s/2+dbx,(i+1)*d,y+(i+1)*w-dby/2]])
	#	if toggle1==1:
	#		coords.extend([[s/2,(i)*d+2*d,y+(i+1)*w+dby/2+w], [s/2+dbx,(i)*d+2*d,y+(i+1)*w+dby/2+w]])
	#		coords.extend([[s/2,d,y+w-dby/2],[s/2+dbx,d,y+w-dby/2], [s/2,(i+1)*d+d,y+(i+1)*w-dby/2+w], [s/2+dbx,(i+1)*d+d,y+(i+1)*w-dby/2+w]])
		v=6
		faces.extend([[v,v+1,v+3,v+2], [v+6,v+4,v,v+2], [v+3,v+1,v+5,v+7], [v+7,v+6,v+2,v+3]])
		faces.extend([[v+5,v+4,v+6,v+7]])  #  ,[v+1,v-1,v+5],[v-1,v-2,v+4,v+5]])

		if ilosc.val<>ild.val:
			s=szS.val+2*spS.val-2*dbx

			sp1=s   #-sp
			if toggle1 ==0: i2=ilosc.val-i
			if toggle1 ==1: i2=ilosc.val-i

			if toggle1 ==1:	xst=(i)*d+2*d
			if toggle1 ==0:	xst=(i)*d+1*d
			if toggle1 ==0:

				xen=xst-i2*d+3*d
				yen=(ilosc.val-1)*w
			if toggle1 ==1:
				xen=xst-i2*d+3*d
				xen=xen-d
				yen=(ilosc.val-1)*w
				yen=yen+w
			# v=8
			coords.extend([[s/2-sp1,xst+dby-d,y+(i+1)*w+dby/2+w], [s/2-dbx-sp1,xst+dby-d,y+(i+1)*w+dby/2+w]])
			coords.extend([[s/2-sp1,xen,y+yen+dby/2], [s/2-dbx-sp1,xen,y+yen+dby/2]])
			coords.extend([[s/2-sp1,xen,y+yen-dby/2], [s/2-dbx-sp1,xen,y+yen-dby/2]])
			coords.extend([[s/2-sp1,xst+dby-d,y+(i+1)*w-dby/2+w], [s/2-dbx-sp1,xst+dby-d,y+(i+1)*w-dby/2+w]])

			faces.extend([[v+9,v+8,v+14,v+15]])
			faces.extend([[v+12,v+13,v+15,v+14]])
			faces.extend([[v+8,v+9,v+11,v+10]])
			faces.extend([[v+8,v+10,v+12,v+14]])
			faces.extend([[v+11,v+9,v+15,v+13]])
			faces.extend([[v+11,v+13,v+12,v+10]])

			if toggle1==1:
				s=(szS.val+dbx*2)*(-1)
				coords.extend([[s/2,(i)*d+2*d,y+(i+1)*w+dby/2], [s/2+dbx,(i)*d+2*d,y+(i+1)*w+dby/2]])
				coords.extend([[s/2,(i)*d+2*d,y+(i+1)*w-dby/2], [s/2+dbx,(i)*d+2*d,y+(i+1)*w-dby/2]])
		#	faces.extend([[v+8,v+14,v+18,v+16]])

				faces.extend([[v+7,v+6,v+18,v+19]])
				faces.extend([[v+2,v+3,v+17,v+16]])
				faces.extend([[v+6,v+2,v+16,v+18]])
				faces.extend([[v+3,v+7,v+19,v+17]])
				faces.extend([[v+19,v+18,v+16,v+17]])


		me = bpy.data.meshes.new('Stinger2')					# create a new mesh

 		try:
			mati = Material.Get("Trips")
		except:
			mati = Material.New('Trips')
			mati.setRGBCol(0.6,0.5,0.4)

		me.materials = [mati]

		me.verts.extend(coords)					# add vertices to mesh
		me.faces.extend(faces)					 # add faces to the mesh (also adds edges)

		scn = bpy.data.scenes.active		 # link object to current scene
		ob = scn.objects.new(me, 'Stinger2')
