#!BPY

""" Registration info for Blender menus:
Name: '3d Cursor Menu'
Blender: 248
Group: 'System'
Tooltip: 'Right Click on 3d Cursor for a menu with options'
"""

# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2006 Mariano Hidalgo
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

__author__ = "Mariano Hidalgo a.k.a. uselessdreamer"
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/SpaceHandlers/3d_Cursor_Menu")
__version__ = "1.0"

__bpydoc__ = """\
This SpaceHandler script adds a right-click menu to the 3D Cursor,

with some useful operations, including resetting the cursor's position to the center of the space

and an option to spin the 3d View for display purposes.

Run the script from the object scripts menu and it will load in the current .blend,

then just make it active for each 3d View you want.
 
Right click on the 3D Cursor and the menu will show up.

Please note this needs the Enable Script Links option pressed. 
"""

import Blender
from Blender import Text
script_text = """#SPACEHANDLER.VIEW3D.EVENT
import Blender
from Blender import *
from Blender.BGL import *
import math

x,y,z = Window.GetCursorPos()
v = Mathutils.Vector(x,y,z,1)
matview = Window.GetPerspMatrix() 
winId = Window.GetAreaID()
for screen in Window.GetScreenInfo(Window.Types.VIEW3D): 
	if screen['id']== winId: 
		x0, y0, x1, y1 = screen['vertices'] 
		break 

evt = Blender.event
if evt==Draw.RIGHTMOUSE: 

	mouse_co= Window.GetMouseCoords() 
	proj=v*matview 
	pt=[(proj[0]/proj[3])*(x1-x0)/2+(x1+x0)/2, (proj[1]/proj[3])*(y1-y0)/2+(y1+y0)/2] 

	if mouse_co[0]<pt[0]+8 and mouse_co[0]>pt[0]-8 and mouse_co[1]>pt[1]-8 and mouse_co[1]<pt[1]+8: 
		c = Draw.PupMenu("3d Cursor Menu%t|Reset Position%x01|Spin 3dView%x07|Snap to grid%x02|%l|Snap selection to Cursor%x3|Snap Cursor to selection%x4|%l|Set Pivot around Cursor%x05|Reset Pivot Point%x06")
		if c == 1:
			Window.SetCursorPos(0,0,0)
		elif c == 2:
			x,y,z = Window.GetCursorPos()
			x = int(math.floor(x))
			y = int(math.floor(y))
			z = int(math.floor(z))
			Window.SetCursorPos(x,y,z)
		elif c == 3 and not Window.EditMode():
			obs = Object.GetSelected()
			if obs:
				for ob in obs:
					ob.setLocation(Window.GetCursorPos())
		elif c == 3 and Window.EditMode():
			#Window.EditMode(0)
			me = Object.GetSelected()[0].getData(0,1)
			x,y,z = Window.GetCursorPos()
			for v in me.verts:
				v.co = Window.GetCursorPos()
			#Window.EditMode(1)
		elif c == 4:
			ob = Object.GetSelected()[0]
			Window.SetCursorPos(ob.getLocation())
		elif c == 5:
			#Window.SetKeyQualifiers(3)
			Window.QAdd(winId,Draw.PERIODKEY,1)
			Window.QHandle(winId)
			#Window.SetKeyQualifiers(0)
		elif c == 6:
			#Window.SetKeyQualifiers(3)
			Window.QAdd(winId,Draw.COMMAKEY,1)
			Window.QHandle(winId)
		elif c == 7:
			winId = Window.GetAreaID()
			count = 0
			while 1:
				count += 1
				if count >= 12000:				
					Window.QAdd(winId,Draw.PAD6,1)
					Window.QHandle(winId)	
					Window.Redraw()
					count = 0	
				if Window.GetMouseButtons() == Window.MButs["R"]:
					break	
		Draw.Redraw()
		Blender.event = None
"""
try:
	txt = Text.Get("3d Cursor Menu")
	Text.unlink(txt)	
	txt = Text.New("3d Cursor Menu")
	txt.write(script_text)
except:
	txt = Text.New("3d Cursor Menu")
	txt.write(script_text)

Blender.Draw.PupMenu("3d Cursor Menu Setup%t|Enable in [View] --> [SpaceHandler Scripts] menu.")		