#!BPY

"""
Name: 'Mesh Read/Write UV'
Blender: 248
Group: 'UV'
Tooltip: 'Select 1 object for UVs to mesh, 2 obs, to write back to mesh.'
"""
__author__ = "Campbell Barton AKA Ideasman"
__url__ = ["http://members.iinet.net.au/~cpbarton/ideasman/", "blender", "elysiun"]
# -------------------------------------------------------------------------- 
# By Campbell Barton (AKA Ideasman)
# -------------------------------------------------------------------------- 
# ***** BEGIN GPL LICENSE BLOCK ***** 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, 
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
# 
# ***** END GPL LICENCE BLOCK ***** 
# -------------------------------------------------------------------------- 

from Blender import Draw, Object, Scene, Mathutils, Mesh, Window

def error(msg):
	Draw.PupBlock('Error Message...', msg.split('|'))

def write_obuv(ob, scn):
	mesource = ob.getData(mesh=1)
	
	if not mesource.faceUV:
		error('Mesh has no uv coords|Aborting.')
		return
	
	meuv = Mesh.New('uvmesh')
	for f in mesource.faces:
		meuv.verts.extend( [Mathutils.Vector(uv.x, 0, uv.y) for uv in f.uv] )
		print range(len(f.v), 0, -1)
		meuv.faces.extend( [[meuv.verts[-i] for i in range(len(f.v), 0, -1)],] ) # 4,3,2,1 or 3,2,1
	
	# Finish mesh and link to the scene.
	obuv = Object.New('Mesh', 'uvmesh')
	obuv.link(meuv)
	obuv.Layers = ob.Layers
	scn.link(obuv)
	ob.sel=0
	obuv.sel= 1
	Window.RedrawAll()

	
def copy_mesh2uvs(ob1, ob2):
	'''
	ob1 is the uv mesh
	'''
	me1 = ob1.getData(mesh=1)
	me2 = ob2.getData(mesh=1)
	
	len_faces = len(me1.faces)
	if len_faces != len(me2.faces):
		error('Copy mesh to uvs failed|face count differs')
		return
	
	if not me2.faceUV:
		error('Copy mesh to uvs failed|Target mesh does not|have texface enabled|Aborting.')
		return
	
	i=len_faces
	while i:
		i-=1
		f1 = me1.faces[i]
		f2 = me2.faces[i]
		
		if len(f1.v) != len(f2.v):
			error('Copy mesh to uvs failed|tri/quad order differs|Aborting.')	
			return
		
		f2.uv = [Mathutils.Vector(v.co.x, v.co.z) for v in f1.v] # f2 is the real mesh.	
	ob1.sel = 0
	ob2.sel = 1 # Make active.
	Window.RedrawAll()
	


def rw_uv():
	UVMESHNAME = 'uvmesh'
	scn = Scene.GetCurrent()
	obact = scn.getActiveObject()
	
	if not obact or obact.getType() != 'Mesh':
		error('No Active object|Select a mesh to|write UVs Sel 2 meshes|to copy from active|Abortint.')
		return
		
	obsel = [ob for ob in Object.GetSelected() if ob != obact] 
	if len(obsel) > 1:
		error('Select only 2 mesh objects|Aborting.')
		return
	
	if not obsel: # Only 1 active object.
		write_obuv(obact, scn)
	else:
		# 2 objects selected.
		ob1 = obsel[0]
		ob2 = obact
		
		if ob1.getData(1).startswith(UVMESHNAME):
			pass
		elif ob2.getData(1).startswith(UVMESHNAME):
			ob1, ob2 = ob2, ob1
		else:
			error('One objects mesh data|must be called "uvmesh"|Aborting.')
			return
		
		if ob1.getType() != 'Mesh' or ob2.getType() != 'Mesh':
			error('Select only 2 mesh objects|Aborting.')
			return
		
		copy_mesh2uvs(ob1, ob2)


if __name__ == '__main__':
	rw_uv()
	