// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HostFirewall Status of the host firewall
//
// +k8s:deepcopy-gen=true
//
// swagger:model HostFirewall
type HostFirewall struct {

	// devices
	Devices []string `json:"devices"`

	// mode
	// Enum: [Disabled Enabled]
	Mode string `json:"mode,omitempty"`
}

// Validate validates this host firewall
func (m *HostFirewall) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var hostFirewallTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["Disabled","Enabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hostFirewallTypeModePropEnum = append(hostFirewallTypeModePropEnum, v)
	}
}

const (

	// HostFirewallModeDisabled captures enum value "Disabled"
	HostFirewallModeDisabled string = "Disabled"

	// HostFirewallModeEnabled captures enum value "Enabled"
	HostFirewallModeEnabled string = "Enabled"
)

// prop value enum
func (m *HostFirewall) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, hostFirewallTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HostFirewall) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this host firewall based on context it is used
func (m *HostFirewall) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HostFirewall) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostFirewall) UnmarshalBinary(b []byte) error {
	var res HostFirewall
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
