// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package policy

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// DeletePolicyReader is a Reader for the DeletePolicy structure.
type DeletePolicyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeletePolicyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeletePolicyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeletePolicyInvalid()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeletePolicyForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeletePolicyNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeletePolicyFailure()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDeletePolicyOK creates a DeletePolicyOK with default headers values
func NewDeletePolicyOK() *DeletePolicyOK {
	return &DeletePolicyOK{}
}

/*
DeletePolicyOK describes a response with status code 200, with default header values.

Success
*/
type DeletePolicyOK struct {
	Payload *models.Policy
}

// IsSuccess returns true when this delete policy o k response has a 2xx status code
func (o *DeletePolicyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete policy o k response has a 3xx status code
func (o *DeletePolicyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete policy o k response has a 4xx status code
func (o *DeletePolicyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete policy o k response has a 5xx status code
func (o *DeletePolicyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete policy o k response a status code equal to that given
func (o *DeletePolicyOK) IsCode(code int) bool {
	return code == 200
}

func (o *DeletePolicyOK) Error() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyOK  %+v", 200, o.Payload)
}

func (o *DeletePolicyOK) String() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyOK  %+v", 200, o.Payload)
}

func (o *DeletePolicyOK) GetPayload() *models.Policy {
	return o.Payload
}

func (o *DeletePolicyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Policy)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePolicyInvalid creates a DeletePolicyInvalid with default headers values
func NewDeletePolicyInvalid() *DeletePolicyInvalid {
	return &DeletePolicyInvalid{}
}

/*
DeletePolicyInvalid describes a response with status code 400, with default header values.

Invalid request
*/
type DeletePolicyInvalid struct {
	Payload models.Error
}

// IsSuccess returns true when this delete policy invalid response has a 2xx status code
func (o *DeletePolicyInvalid) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete policy invalid response has a 3xx status code
func (o *DeletePolicyInvalid) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete policy invalid response has a 4xx status code
func (o *DeletePolicyInvalid) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete policy invalid response has a 5xx status code
func (o *DeletePolicyInvalid) IsServerError() bool {
	return false
}

// IsCode returns true when this delete policy invalid response a status code equal to that given
func (o *DeletePolicyInvalid) IsCode(code int) bool {
	return code == 400
}

func (o *DeletePolicyInvalid) Error() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyInvalid  %+v", 400, o.Payload)
}

func (o *DeletePolicyInvalid) String() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyInvalid  %+v", 400, o.Payload)
}

func (o *DeletePolicyInvalid) GetPayload() models.Error {
	return o.Payload
}

func (o *DeletePolicyInvalid) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePolicyForbidden creates a DeletePolicyForbidden with default headers values
func NewDeletePolicyForbidden() *DeletePolicyForbidden {
	return &DeletePolicyForbidden{}
}

/*
DeletePolicyForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeletePolicyForbidden struct {
}

// IsSuccess returns true when this delete policy forbidden response has a 2xx status code
func (o *DeletePolicyForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete policy forbidden response has a 3xx status code
func (o *DeletePolicyForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete policy forbidden response has a 4xx status code
func (o *DeletePolicyForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete policy forbidden response has a 5xx status code
func (o *DeletePolicyForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete policy forbidden response a status code equal to that given
func (o *DeletePolicyForbidden) IsCode(code int) bool {
	return code == 403
}

func (o *DeletePolicyForbidden) Error() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyForbidden ", 403)
}

func (o *DeletePolicyForbidden) String() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyForbidden ", 403)
}

func (o *DeletePolicyForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeletePolicyNotFound creates a DeletePolicyNotFound with default headers values
func NewDeletePolicyNotFound() *DeletePolicyNotFound {
	return &DeletePolicyNotFound{}
}

/*
DeletePolicyNotFound describes a response with status code 404, with default header values.

Policy not found
*/
type DeletePolicyNotFound struct {
}

// IsSuccess returns true when this delete policy not found response has a 2xx status code
func (o *DeletePolicyNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete policy not found response has a 3xx status code
func (o *DeletePolicyNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete policy not found response has a 4xx status code
func (o *DeletePolicyNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete policy not found response has a 5xx status code
func (o *DeletePolicyNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete policy not found response a status code equal to that given
func (o *DeletePolicyNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *DeletePolicyNotFound) Error() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyNotFound ", 404)
}

func (o *DeletePolicyNotFound) String() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyNotFound ", 404)
}

func (o *DeletePolicyNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeletePolicyFailure creates a DeletePolicyFailure with default headers values
func NewDeletePolicyFailure() *DeletePolicyFailure {
	return &DeletePolicyFailure{}
}

/*
DeletePolicyFailure describes a response with status code 500, with default header values.

Error while deleting policy
*/
type DeletePolicyFailure struct {
	Payload models.Error
}

// IsSuccess returns true when this delete policy failure response has a 2xx status code
func (o *DeletePolicyFailure) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete policy failure response has a 3xx status code
func (o *DeletePolicyFailure) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete policy failure response has a 4xx status code
func (o *DeletePolicyFailure) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete policy failure response has a 5xx status code
func (o *DeletePolicyFailure) IsServerError() bool {
	return true
}

// IsCode returns true when this delete policy failure response a status code equal to that given
func (o *DeletePolicyFailure) IsCode(code int) bool {
	return code == 500
}

func (o *DeletePolicyFailure) Error() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyFailure  %+v", 500, o.Payload)
}

func (o *DeletePolicyFailure) String() string {
	return fmt.Sprintf("[DELETE /policy][%d] deletePolicyFailure  %+v", 500, o.Payload)
}

func (o *DeletePolicyFailure) GetPayload() models.Error {
	return o.Payload
}

func (o *DeletePolicyFailure) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
