# cilium

![Version: 1.9.0-rc3](https://img.shields.io/badge/Version-1.9.0--rc3-informational?style=flat-square) ![AppVersion: 1.9.0-rc3](https://img.shields.io/badge/AppVersion-1.9.0--rc3-informational?style=flat-square)

Helm chart for Cilium

**Homepage:** <https://cilium.io/>

## Source Code

* <https://github.com/cilium/cilium>

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| affinity.podAntiAffinity.requiredDuringSchedulingIgnoredDuringExecution[0].labelSelector.matchExpressions[0].key | string | `"k8s-app"` |  |
| affinity.podAntiAffinity.requiredDuringSchedulingIgnoredDuringExecution[0].labelSelector.matchExpressions[0].operator | string | `"In"` |  |
| affinity.podAntiAffinity.requiredDuringSchedulingIgnoredDuringExecution[0].labelSelector.matchExpressions[0].values[0] | string | `"cilium"` |  |
| affinity.podAntiAffinity.requiredDuringSchedulingIgnoredDuringExecution[0].topologyKey | string | `"kubernetes.io/hostname"` |  |
| agent | bool | `true` |  |
| autoDirectNodeRoutes | bool | `false` |  |
| azure.enabled | bool | `false` |  |
| bandwidthManager | bool | `false` |  |
| bpf.clockProbe | bool | `false` |  |
| bpf.lbMapMax | int | `65536` |  |
| bpf.monitorAggregation | string | `"medium"` |  |
| bpf.monitorFlags | string | `"all"` |  |
| bpf.monitorInterval | string | `"5s"` |  |
| bpf.policyMapMax | int | `16384` |  |
| bpf.preallocateMaps | bool | `false` |  |
| bpf.waitForMount | bool | `false` |  |
| certgen.image.pullPolicy | string | `"IfNotPresent"` |  |
| certgen.image.repository | string | `"docker.io/cilium/certgen"` |  |
| certgen.image.tag | string | `"v0.1.3@sha256:460fdcbabfa08b435dbee455e88add1ec54761ca2693e1d9885408ff55ed7f8e"` |  |
| certgen.ttlSecondsAfterFinished | int | `1800` |  |
| cleanBpfState | bool | `false` |  |
| cleanState | bool | `false` |  |
| cluster.name | string | `"default"` |  |
| clustermesh.apiserver.etcd.image.pullPolicy | string | `"IfNotPresent"` |  |
| clustermesh.apiserver.etcd.image.repository | string | `"quay.io/coreos/etcd"` |  |
| clustermesh.apiserver.etcd.image.tag | string | `"v3.4.13"` |  |
| clustermesh.apiserver.image.pullPolicy | string | `"IfNotPresent"` |  |
| clustermesh.apiserver.image.repository | string | `"docker.io/cilium/clustermesh-apiserver"` |  |
| clustermesh.apiserver.image.tag | string | `"v1.9.0-rc3"` |  |
| clustermesh.apiserver.nodeSelector | object | `{}` |  |
| clustermesh.apiserver.podAnnotations | object | `{}` |  |
| clustermesh.apiserver.replicas | int | `1` |  |
| clustermesh.apiserver.resources | object | `{}` |  |
| clustermesh.apiserver.service.annotations | object | `{}` |  |
| clustermesh.apiserver.service.nodePort | int | `32379` |  |
| clustermesh.apiserver.service.type | string | `"NodePort"` |  |
| clustermesh.apiserver.tls.admin.cert | string | `""` |  |
| clustermesh.apiserver.tls.admin.key | string | `""` |  |
| clustermesh.apiserver.tls.auto.certValidityDuration | int | `1095` |  |
| clustermesh.apiserver.tls.auto.enabled | bool | `true` |  |
| clustermesh.apiserver.tls.auto.method | string | `"helm"` |  |
| clustermesh.apiserver.tls.ca.cert | string | `""` |  |
| clustermesh.apiserver.tls.ca.key | string | `""` |  |
| clustermesh.apiserver.tls.client.cert | string | `""` |  |
| clustermesh.apiserver.tls.client.key | string | `""` |  |
| clustermesh.apiserver.tls.remote.cert | string | `""` |  |
| clustermesh.apiserver.tls.remote.key | string | `""` |  |
| clustermesh.apiserver.tls.server.cert | string | `""` |  |
| clustermesh.apiserver.tls.server.key | string | `""` |  |
| clustermesh.apiserver.tolerations | list | `[]` |  |
| clustermesh.apiserver.updateStrategy.rollingUpdate.maxUnavailable | int | `1` |  |
| clustermesh.apiserver.updateStrategy.type | string | `"RollingUpdate"` |  |
| cni.binPath | string | `"/opt/cni/bin"` |  |
| cni.chainingMode | string | `"none"` |  |
| cni.confFileMountPath | string | `"/tmp/cni-configuration"` |  |
| cni.confPath | string | `"/etc/cni/net.d"` |  |
| cni.configMapKey | string | `"cni-config"` |  |
| cni.customConf | bool | `false` |  |
| cni.hostConfDirMountPath | string | `"/host/etc/cni/net.d"` |  |
| cni.install | bool | `true` |  |
| containerRuntime.integration | string | `"none"` |  |
| daemon.runPath | string | `"/var/run/cilium"` |  |
| datapathMode | string | `"veth"` |  |
| debug.enabled | bool | `false` |  |
| enableCnpStatusUpdates | bool | `false` |  |
| enableCriticalPriorityClass | bool | `true` |  |
| enableXTSocketFallback | bool | `true` |  |
| encryption.enabled | bool | `false` |  |
| encryption.keyFile | string | `"keys"` |  |
| encryption.mountPath | string | `"/etc/ipsec"` |  |
| encryption.nodeEncryption | bool | `false` |  |
| encryption.secretName | string | `"cilium-ipsec-keys"` |  |
| endpointHealthChecking.enabled | bool | `true` |  |
| endpointRoutes.enabled | bool | `false` |  |
| eni | bool | `false` |  |
| etcd.clusterDomain | string | `"cluster.local"` |  |
| etcd.clusterSize | int | `3` |  |
| etcd.enabled | bool | `false` |  |
| etcd.endpoints[0] | string | `"https://CHANGE-ME:2379"` |  |
| etcd.extraArgs | object | `{}` |  |
| etcd.extraConfigmapMounts | list | `[]` |  |
| etcd.extraHostPathMounts | list | `[]` |  |
| etcd.extraInitContainers | list | `[]` |  |
| etcd.image.pullPolicy | string | `"IfNotPresent"` |  |
| etcd.image.repository | string | `"docker.io/cilium/cilium-etcd-operator"` |  |
| etcd.image.tag | string | `"v2.0.7"` |  |
| etcd.k8sService | bool | `false` |  |
| etcd.managed | bool | `false` |  |
| etcd.nodeSelector | object | `{}` |  |
| etcd.podAnnotations | object | `{}` |  |
| etcd.podDisruptionBudget.enabled | bool | `true` |  |
| etcd.podDisruptionBudget.maxUnavailable | int | `2` |  |
| etcd.podLabels | object | `{}` |  |
| etcd.priorityClassName | string | `""` |  |
| etcd.resources | object | `{}` |  |
| etcd.securityContext | object | `{}` |  |
| etcd.ssl | bool | `false` |  |
| etcd.tolerations[0].operator | string | `"Exists"` |  |
| etcd.updateStrategy.rollingUpdate.maxSurge | int | `1` |  |
| etcd.updateStrategy.rollingUpdate.maxUnavailable | int | `1` |  |
| etcd.updateStrategy.type | string | `"RollingUpdate"` |  |
| externalIPs.enabled | bool | `false` |  |
| externalWorkloads.enabled | bool | `false` |  |
| extraArgs | object | `{}` |  |
| extraConfigmapMounts | list | `[]` |  |
| extraEnv | object | `{}` |  |
| extraHostPathMounts | list | `[]` |  |
| extraInitContainers | list | `[]` |  |
| flannel.enabled | bool | `false` |  |
| flannel.masterDevice | string | `"cni0"` |  |
| flannel.uninstallOnExit | bool | `false` |  |
| gke.enabled | bool | `false` |  |
| healthChecking | bool | `true` |  |
| healthPort | int | `9876` |  |
| hostFirewall | bool | `false` |  |
| hostPort.enabled | bool | `false` |  |
| hostServices.enabled | bool | `false` |  |
| hostServices.protocols | string | `"tcp,udp"` |  |
| hubble.enabled | bool | `true` |  |
| hubble.metrics.enabled | string | `nil` |  |
| hubble.metrics.port | int | `9091` |  |
| hubble.metrics.serviceMonitor.enabled | bool | `false` |  |
| hubble.metricsServer | string | `""` |  |
| hubble.relay.dialTimeout | string | `nil` |  |
| hubble.relay.enabled | bool | `false` |  |
| hubble.relay.image.pullPolicy | string | `"IfNotPresent"` |  |
| hubble.relay.image.repository | string | `"docker.io/cilium/hubble-relay"` |  |
| hubble.relay.image.tag | string | `"v1.9.0-rc3"` |  |
| hubble.relay.listenHost | string | `""` |  |
| hubble.relay.listenPort | string | `"4245"` |  |
| hubble.relay.nodeSelector | object | `{}` |  |
| hubble.relay.podAnnotations | object | `{}` |  |
| hubble.relay.replicas | int | `1` |  |
| hubble.relay.resources | object | `{}` |  |
| hubble.relay.retryTimeout | string | `nil` |  |
| hubble.relay.sortBufferDrainTimeout | string | `nil` |  |
| hubble.relay.sortBufferLenMax | string | `nil` |  |
| hubble.relay.tls.client.cert | string | `""` |  |
| hubble.relay.tls.client.key | string | `""` |  |
| hubble.relay.tls.server.cert | string | `""` |  |
| hubble.relay.tls.server.enabled | bool | `false` |  |
| hubble.relay.tls.server.key | string | `""` |  |
| hubble.relay.tolerations | list | `[]` |  |
| hubble.relay.updateStrategy.rollingUpdate.maxUnavailable | int | `1` |  |
| hubble.relay.updateStrategy.type | string | `"RollingUpdate"` |  |
| hubble.socketPath | string | `"/var/run/cilium/hubble.sock"` |  |
| hubble.tls.auto.certValidityDuration | int | `1095` |  |
| hubble.tls.auto.enabled | bool | `true` |  |
| hubble.tls.auto.method | string | `"helm"` |  |
| hubble.tls.auto.schedule | string | `"0 0 1 */4 *"` |  |
| hubble.tls.ca.cert | string | `""` |  |
| hubble.tls.ca.key | string | `""` |  |
| hubble.tls.enabled | bool | `true` |  |
| hubble.tls.server.cert | string | `""` |  |
| hubble.tls.server.key | string | `""` |  |
| hubble.ui.backend.image.pullPolicy | string | `"IfNotPresent"` |  |
| hubble.ui.backend.image.repository | string | `"docker.io/cilium/hubble-ui-backend"` |  |
| hubble.ui.backend.image.tag | string | `"v0.7.3"` |  |
| hubble.ui.backend.resources | object | `{}` |  |
| hubble.ui.enabled | bool | `false` |  |
| hubble.ui.frontend.image.pullPolicy | string | `"IfNotPresent"` |  |
| hubble.ui.frontend.image.repository | string | `"docker.io/cilium/hubble-ui"` |  |
| hubble.ui.frontend.image.tag | string | `"v0.7.3"` |  |
| hubble.ui.frontend.resources | object | `{}` |  |
| hubble.ui.ingress.annotations | object | `{}` |  |
| hubble.ui.ingress.enabled | bool | `false` |  |
| hubble.ui.ingress.hosts[0] | string | `"chart-example.local"` |  |
| hubble.ui.ingress.tls | list | `[]` |  |
| hubble.ui.nodeSelector | object | `{}` |  |
| hubble.ui.podAnnotations | object | `{}` |  |
| hubble.ui.proxy.image.pullPolicy | string | `"IfNotPresent"` |  |
| hubble.ui.proxy.image.repository | string | `"docker.io/envoyproxy/envoy"` |  |
| hubble.ui.proxy.image.tag | string | `"v1.14.5"` |  |
| hubble.ui.proxy.resources | object | `{}` |  |
| hubble.ui.replicas | int | `1` |  |
| hubble.ui.securityContext.enabled | bool | `true` |  |
| hubble.ui.tolerations | list | `[]` |  |
| hubble.ui.updateStrategy.rollingUpdate.maxUnavailable | int | `1` |  |
| hubble.ui.updateStrategy.type | string | `"RollingUpdate"` |  |
| identityAllocationMode | string | `"crd"` |  |
| image.pullPolicy | string | `"IfNotPresent"` |  |
| image.repository | string | `"docker.io/cilium/cilium"` |  |
| image.tag | string | `"v1.9.0-rc3"` |  |
| imagePullSecrets | string | `nil` |  |
| installIptablesRules | bool | `true` |  |
| ipMasqAgent.enabled | bool | `false` |  |
| ipam.mode | string | `"cluster-pool"` |  |
| ipam.operator.clusterPoolIPv4MaskSize | int | `24` |  |
| ipam.operator.clusterPoolIPv4PodCIDR | string | `"10.0.0.0/8"` |  |
| ipam.operator.clusterPoolIPv6MaskSize | int | `120` |  |
| ipam.operator.clusterPoolIPv6PodCIDR | string | `"fd00::/104"` |  |
| ipv4.enabled | bool | `true` |  |
| ipv6.enabled | bool | `false` |  |
| ipvlan.enabled | bool | `false` |  |
| k8s | object | `{}` |  |
| keepDeprecatedLabels | bool | `false` |  |
| keepDeprecatedProbes | bool | `false` |  |
| kubeProxyReplacement | string | `"probe"` |  |
| kubeProxyReplacementHealthzBindAddr | string | `""` |  |
| kvstore.managed | bool | `false` |  |
| kvstore.ssl | string | `nil` |  |
| l7Proxy | bool | `true` |  |
| localRedirectPolicy | bool | `false` |  |
| logSystemLoad | bool | `false` |  |
| maglev | object | `{}` |  |
| masquerade | bool | `true` |  |
| monitor.enabled | bool | `false` |  |
| name | string | `"cilium"` |  |
| nodePort.autoProtectPortRange | bool | `true` |  |
| nodePort.bindProtection | bool | `true` |  |
| nodePort.enableHealthCheck | bool | `true` |  |
| nodePort.enabled | bool | `false` |  |
| nodeSelector | object | `{}` |  |
| nodeinit.bootstrapFile | string | `"/tmp/cilium-bootstrap-time"` |  |
| nodeinit.enabled | bool | `false` |  |
| nodeinit.extraArgs | object | `{}` |  |
| nodeinit.extraConfigmapMounts | list | `[]` |  |
| nodeinit.extraEnv | object | `{}` |  |
| nodeinit.extraHostPathMounts | list | `[]` |  |
| nodeinit.extraInitContainers | list | `[]` |  |
| nodeinit.image.pullPolicy | string | `"IfNotPresent"` |  |
| nodeinit.image.repository | string | `"docker.io/cilium/startup-script"` |  |
| nodeinit.image.tag | string | `"62bfbe88c17778aad7bef9fa57ff9e2d4a9ba0d8"` |  |
| nodeinit.nodeSelector | object | `{}` |  |
| nodeinit.podAnnotations | object | `{}` |  |
| nodeinit.podDisruptionBudget.enabled | bool | `true` |  |
| nodeinit.podDisruptionBudget.maxUnavailable | int | `2` |  |
| nodeinit.podLabels | object | `{}` |  |
| nodeinit.priorityClassName | string | `""` |  |
| nodeinit.resources.requests.cpu | string | `"100m"` |  |
| nodeinit.resources.requests.memory | string | `"100Mi"` |  |
| nodeinit.securityContext | object | `{}` |  |
| nodeinit.tolerations[0].operator | string | `"Exists"` |  |
| nodeinit.updateStrategy.type | string | `"RollingUpdate"` |  |
| operator.affinity.podAntiAffinity.requiredDuringSchedulingIgnoredDuringExecution[0].labelSelector.matchExpressions[0].key | string | `"io.cilium/app"` |  |
| operator.affinity.podAntiAffinity.requiredDuringSchedulingIgnoredDuringExecution[0].labelSelector.matchExpressions[0].operator | string | `"In"` |  |
| operator.affinity.podAntiAffinity.requiredDuringSchedulingIgnoredDuringExecution[0].labelSelector.matchExpressions[0].values[0] | string | `"operator"` |  |
| operator.affinity.podAntiAffinity.requiredDuringSchedulingIgnoredDuringExecution[0].topologyKey | string | `"kubernetes.io/hostname"` |  |
| operator.enabled | bool | `true` |  |
| operator.endpointGCInterval | string | `"5m0s"` |  |
| operator.extraArgs | object | `{}` |  |
| operator.extraConfigmapMounts | list | `[]` |  |
| operator.extraEnv | object | `{}` |  |
| operator.extraHostPathMounts | list | `[]` |  |
| operator.extraInitContainers | list | `[]` |  |
| operator.identityGCInterval | string | `"15m0s"` |  |
| operator.identityHeartbeatTimeout | string | `"30m0s"` |  |
| operator.image.pullPolicy | string | `"IfNotPresent"` |  |
| operator.image.repository | string | `"docker.io/cilium/operator"` |  |
| operator.image.tag | string | `"v1.9.0-rc3"` |  |
| operator.nodeSelector | object | `{}` |  |
| operator.podAnnotations | object | `{}` |  |
| operator.podDisruptionBudget.enabled | bool | `false` |  |
| operator.podDisruptionBudget.maxUnavailable | int | `1` |  |
| operator.podLabels | object | `{}` |  |
| operator.priorityClassName | string | `""` |  |
| operator.prometheus.enabled | bool | `false` |  |
| operator.prometheus.port | int | `6942` |  |
| operator.prometheus.serviceMonitor.enabled | bool | `false` |  |
| operator.replicas | int | `2` |  |
| operator.resources | object | `{}` |  |
| operator.securityContext | object | `{}` |  |
| operator.tolerations[0].operator | string | `"Exists"` |  |
| operator.updateStrategy.rollingUpdate.maxSurge | int | `1` |  |
| operator.updateStrategy.rollingUpdate.maxUnavailable | int | `1` |  |
| operator.updateStrategy.type | string | `"RollingUpdate"` |  |
| podAnnotations | object | `{}` |  |
| podDisruptionBudget.enabled | bool | `true` |  |
| podDisruptionBudget.maxUnavailable | int | `2` |  |
| podLabels | object | `{}` |  |
| pprof.enabled | bool | `false` |  |
| preflight.enabled | bool | `false` |  |
| preflight.extraArgs | object | `{}` |  |
| preflight.extraConfigmapMounts | list | `[]` |  |
| preflight.extraEnv | object | `{}` |  |
| preflight.extraHostPathMounts | list | `[]` |  |
| preflight.extraInitContainers | list | `[]` |  |
| preflight.image.pullPolicy | string | `"IfNotPresent"` |  |
| preflight.image.repository | string | `"docker.io/cilium/cilium"` |  |
| preflight.image.tag | string | `"v1.9.0-rc3"` |  |
| preflight.nodeSelector | object | `{}` |  |
| preflight.podAnnotations | object | `{}` |  |
| preflight.podDisruptionBudget.enabled | bool | `true` |  |
| preflight.podDisruptionBudget.maxUnavailable | int | `2` |  |
| preflight.podLabels | object | `{}` |  |
| preflight.priorityClassName | string | `""` |  |
| preflight.resources | object | `{}` |  |
| preflight.securityContext | object | `{}` |  |
| preflight.tofqdnsPreCache | string | `""` |  |
| preflight.tolerations[0].effect | string | `"NoSchedule"` |  |
| preflight.tolerations[0].key | string | `"node.kubernetes.io/not-ready"` |  |
| preflight.tolerations[1].effect | string | `"NoSchedule"` |  |
| preflight.tolerations[1].key | string | `"node-role.kubernetes.io/master"` |  |
| preflight.tolerations[2].effect | string | `"NoSchedule"` |  |
| preflight.tolerations[2].key | string | `"node.cloudprovider.kubernetes.io/uninitialized"` |  |
| preflight.tolerations[2].value | string | `"true"` |  |
| preflight.tolerations[3].key | string | `"CriticalAddonsOnly"` |  |
| preflight.tolerations[3].operator | string | `"Exists"` |  |
| preflight.updateStrategy.type | string | `"RollingUpdate"` |  |
| preflight.validateCNPs | bool | `true` |  |
| priorityClassName | string | `""` |  |
| prometheus.enabled | bool | `false` |  |
| prometheus.port | int | `9090` |  |
| prometheus.serviceMonitor.enabled | bool | `false` |  |
| proxy.prometheus.port | string | `"9095"` |  |
| proxy.sidecarImageRegex | string | `"cilium/istio_proxy"` |  |
| rbac.create | bool | `true` |  |
| remoteNodeIdentity | bool | `true` |  |
| resources | object | `{}` |  |
| securityContext | object | `{}` |  |
| serviceAccounts.certgen.annotations | object | `{}` |  |
| serviceAccounts.certgen.create | bool | `true` |  |
| serviceAccounts.cilium.annotations | object | `{}` |  |
| serviceAccounts.cilium.create | bool | `true` |  |
| serviceAccounts.clustermeshApiserver.annotations | object | `{}` |  |
| serviceAccounts.clustermeshApiserver.create | bool | `true` |  |
| serviceAccounts.etcd.annotations | object | `{}` |  |
| serviceAccounts.etcd.create | bool | `true` |  |
| serviceAccounts.operator.annotations | object | `{}` |  |
| serviceAccounts.operator.create | bool | `true` |  |
| serviceAccounts.preflight.annotations | object | `{}` |  |
| serviceAccounts.preflight.create | bool | `true` |  |
| serviceAccounts.relay.annotations | object | `{}` |  |
| serviceAccounts.relay.create | bool | `true` |  |
| serviceAccounts.ui.annotations | object | `{}` |  |
| serviceAccounts.ui.create | bool | `true` |  |
| sleepAfterInit | bool | `false` |  |
| sockops.enabled | bool | `false` |  |
| tls.enabled | bool | `true` |  |
| tls.secretsBackend | string | `"local"` |  |
| tolerations[0].operator | string | `"Exists"` |  |
| tunnel | string | `"vxlan"` |  |
| updateStrategy.rollingUpdate.maxUnavailable | int | `2` |  |
| updateStrategy.type | string | `"RollingUpdate"` |  |
| wellKnownIdentities.enabled | bool | `false` |  |

