// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ProxyStatus Status of proxy
//
// +k8s:deepcopy-gen=true
//
// swagger:model ProxyStatus
type ProxyStatus struct {

	// Deployment mode of Envoy L7 proxy
	// Enum: [embedded external]
	EnvoyDeploymentMode string `json:"envoy-deployment-mode,omitempty"`

	// IP address that the proxy listens on
	IP string `json:"ip,omitempty"`

	// Port range used for proxying
	PortRange string `json:"port-range,omitempty"`

	// Detailed description of configured redirects
	Redirects []*ProxyRedirect `json:"redirects"`

	// Total number of listening proxy ports
	TotalPorts int64 `json:"total-ports,omitempty"`

	// Total number of ports configured to redirect to proxies
	TotalRedirects int64 `json:"total-redirects,omitempty"`
}

// Validate validates this proxy status
func (m *ProxyStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnvoyDeploymentMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRedirects(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var proxyStatusTypeEnvoyDeploymentModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["embedded","external"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		proxyStatusTypeEnvoyDeploymentModePropEnum = append(proxyStatusTypeEnvoyDeploymentModePropEnum, v)
	}
}

const (

	// ProxyStatusEnvoyDeploymentModeEmbedded captures enum value "embedded"
	ProxyStatusEnvoyDeploymentModeEmbedded string = "embedded"

	// ProxyStatusEnvoyDeploymentModeExternal captures enum value "external"
	ProxyStatusEnvoyDeploymentModeExternal string = "external"
)

// prop value enum
func (m *ProxyStatus) validateEnvoyDeploymentModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, proxyStatusTypeEnvoyDeploymentModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ProxyStatus) validateEnvoyDeploymentMode(formats strfmt.Registry) error {
	if swag.IsZero(m.EnvoyDeploymentMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateEnvoyDeploymentModeEnum("envoy-deployment-mode", "body", m.EnvoyDeploymentMode); err != nil {
		return err
	}

	return nil
}

func (m *ProxyStatus) validateRedirects(formats strfmt.Registry) error {
	if swag.IsZero(m.Redirects) { // not required
		return nil
	}

	for i := 0; i < len(m.Redirects); i++ {
		if swag.IsZero(m.Redirects[i]) { // not required
			continue
		}

		if m.Redirects[i] != nil {
			if err := m.Redirects[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("redirects" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("redirects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this proxy status based on the context it is used
func (m *ProxyStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRedirects(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ProxyStatus) contextValidateRedirects(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Redirects); i++ {

		if m.Redirects[i] != nil {
			if err := m.Redirects[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("redirects" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("redirects" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ProxyStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ProxyStatus) UnmarshalBinary(b []byte) error {
	var res ProxyStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
