// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package statedb

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetStatedbQueryTableParams creates a new GetStatedbQueryTableParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetStatedbQueryTableParams() *GetStatedbQueryTableParams {
	return &GetStatedbQueryTableParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetStatedbQueryTableParamsWithTimeout creates a new GetStatedbQueryTableParams object
// with the ability to set a timeout on a request.
func NewGetStatedbQueryTableParamsWithTimeout(timeout time.Duration) *GetStatedbQueryTableParams {
	return &GetStatedbQueryTableParams{
		timeout: timeout,
	}
}

// NewGetStatedbQueryTableParamsWithContext creates a new GetStatedbQueryTableParams object
// with the ability to set a context for a request.
func NewGetStatedbQueryTableParamsWithContext(ctx context.Context) *GetStatedbQueryTableParams {
	return &GetStatedbQueryTableParams{
		Context: ctx,
	}
}

// NewGetStatedbQueryTableParamsWithHTTPClient creates a new GetStatedbQueryTableParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetStatedbQueryTableParamsWithHTTPClient(client *http.Client) *GetStatedbQueryTableParams {
	return &GetStatedbQueryTableParams{
		HTTPClient: client,
	}
}

/*
GetStatedbQueryTableParams contains all the parameters to send to the API endpoint

	for the get statedb query table operation.

	Typically these are written to a http.Request.
*/
type GetStatedbQueryTableParams struct {

	/* Index.

	   StateDB index name
	*/
	Index string

	/* Key.

	   Query key (base64 encoded)
	*/
	Key string

	/* Lowerbound.

	   If true perform a LowerBound search
	*/
	Lowerbound bool

	/* Table.

	   StateDB table name
	*/
	Table string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get statedb query table params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetStatedbQueryTableParams) WithDefaults() *GetStatedbQueryTableParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get statedb query table params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetStatedbQueryTableParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get statedb query table params
func (o *GetStatedbQueryTableParams) WithTimeout(timeout time.Duration) *GetStatedbQueryTableParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get statedb query table params
func (o *GetStatedbQueryTableParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get statedb query table params
func (o *GetStatedbQueryTableParams) WithContext(ctx context.Context) *GetStatedbQueryTableParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get statedb query table params
func (o *GetStatedbQueryTableParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get statedb query table params
func (o *GetStatedbQueryTableParams) WithHTTPClient(client *http.Client) *GetStatedbQueryTableParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get statedb query table params
func (o *GetStatedbQueryTableParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIndex adds the index to the get statedb query table params
func (o *GetStatedbQueryTableParams) WithIndex(index string) *GetStatedbQueryTableParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the get statedb query table params
func (o *GetStatedbQueryTableParams) SetIndex(index string) {
	o.Index = index
}

// WithKey adds the key to the get statedb query table params
func (o *GetStatedbQueryTableParams) WithKey(key string) *GetStatedbQueryTableParams {
	o.SetKey(key)
	return o
}

// SetKey adds the key to the get statedb query table params
func (o *GetStatedbQueryTableParams) SetKey(key string) {
	o.Key = key
}

// WithLowerbound adds the lowerbound to the get statedb query table params
func (o *GetStatedbQueryTableParams) WithLowerbound(lowerbound bool) *GetStatedbQueryTableParams {
	o.SetLowerbound(lowerbound)
	return o
}

// SetLowerbound adds the lowerbound to the get statedb query table params
func (o *GetStatedbQueryTableParams) SetLowerbound(lowerbound bool) {
	o.Lowerbound = lowerbound
}

// WithTable adds the table to the get statedb query table params
func (o *GetStatedbQueryTableParams) WithTable(table string) *GetStatedbQueryTableParams {
	o.SetTable(table)
	return o
}

// SetTable adds the table to the get statedb query table params
func (o *GetStatedbQueryTableParams) SetTable(table string) {
	o.Table = table
}

// WriteToRequest writes these params to a swagger request
func (o *GetStatedbQueryTableParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param index
	qrIndex := o.Index
	qIndex := qrIndex
	if qIndex != "" {

		if err := r.SetQueryParam("index", qIndex); err != nil {
			return err
		}
	}

	// query param key
	qrKey := o.Key
	qKey := qrKey
	if qKey != "" {

		if err := r.SetQueryParam("key", qKey); err != nil {
			return err
		}
	}

	// query param lowerbound
	qrLowerbound := o.Lowerbound
	qLowerbound := swag.FormatBool(qrLowerbound)
	if qLowerbound != "" {

		if err := r.SetQueryParam("lowerbound", qLowerbound); err != nil {
			return err
		}
	}

	// path param table
	if err := r.SetPathParam("table", o.Table); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
