// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/listener/v3/listener.proto

package listenerv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"

	v3 "github.com/cilium/proxy/go/envoy/config/core/v3"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort

	_ = v3.TrafficDirection(0)
)

// Validate checks the field values on AdditionalAddress with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *AdditionalAddress) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AdditionalAddress with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AdditionalAddressMultiError, or nil if none found.
func (m *AdditionalAddress) ValidateAll() error {
	return m.validate(true)
}

func (m *AdditionalAddress) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdditionalAddressValidationError{
					field:  "Address",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdditionalAddressValidationError{
					field:  "Address",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdditionalAddressValidationError{
				field:  "Address",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetSocketOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AdditionalAddressValidationError{
					field:  "SocketOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AdditionalAddressValidationError{
					field:  "SocketOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSocketOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AdditionalAddressValidationError{
				field:  "SocketOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AdditionalAddressMultiError(errors)
	}

	return nil
}

// AdditionalAddressMultiError is an error wrapping multiple validation errors
// returned by AdditionalAddress.ValidateAll() if the designated constraints
// aren't met.
type AdditionalAddressMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AdditionalAddressMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AdditionalAddressMultiError) AllErrors() []error { return m }

// AdditionalAddressValidationError is the validation error returned by
// AdditionalAddress.Validate if the designated constraints aren't met.
type AdditionalAddressValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AdditionalAddressValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AdditionalAddressValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AdditionalAddressValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AdditionalAddressValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AdditionalAddressValidationError) ErrorName() string {
	return "AdditionalAddressValidationError"
}

// Error satisfies the builtin error interface
func (e AdditionalAddressValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAdditionalAddress.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AdditionalAddressValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AdditionalAddressValidationError{}

// Validate checks the field values on ListenerCollection with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ListenerCollection) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListenerCollection with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListenerCollectionMultiError, or nil if none found.
func (m *ListenerCollection) ValidateAll() error {
	return m.validate(true)
}

func (m *ListenerCollection) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetEntries() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerCollectionValidationError{
						field:  fmt.Sprintf("Entries[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerCollectionValidationError{
						field:  fmt.Sprintf("Entries[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerCollectionValidationError{
					field:  fmt.Sprintf("Entries[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ListenerCollectionMultiError(errors)
	}

	return nil
}

// ListenerCollectionMultiError is an error wrapping multiple validation errors
// returned by ListenerCollection.ValidateAll() if the designated constraints
// aren't met.
type ListenerCollectionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenerCollectionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenerCollectionMultiError) AllErrors() []error { return m }

// ListenerCollectionValidationError is the validation error returned by
// ListenerCollection.Validate if the designated constraints aren't met.
type ListenerCollectionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenerCollectionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenerCollectionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenerCollectionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenerCollectionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenerCollectionValidationError) ErrorName() string {
	return "ListenerCollectionValidationError"
}

// Error satisfies the builtin error interface
func (e ListenerCollectionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenerCollection.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenerCollectionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenerCollectionValidationError{}

// Validate checks the field values on Listener with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Listener) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Listener with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ListenerMultiError, or nil
// if none found.
func (m *Listener) ValidateAll() error {
	return m.validate(true)
}

func (m *Listener) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	if all {
		switch v := interface{}(m.GetAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "Address",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "Address",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "Address",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetAdditionalAddresses() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("AdditionalAddresses[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("AdditionalAddresses[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerValidationError{
					field:  fmt.Sprintf("AdditionalAddresses[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for StatPrefix

	for idx, item := range m.GetFilterChains() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("FilterChains[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("FilterChains[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerValidationError{
					field:  fmt.Sprintf("FilterChains[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetFilterChainMatcher()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "FilterChainMatcher",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "FilterChainMatcher",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilterChainMatcher()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "FilterChainMatcher",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUseOriginalDst()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "UseOriginalDst",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "UseOriginalDst",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUseOriginalDst()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "UseOriginalDst",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDefaultFilterChain()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "DefaultFilterChain",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "DefaultFilterChain",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDefaultFilterChain()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "DefaultFilterChain",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPerConnectionBufferLimitBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "PerConnectionBufferLimitBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "PerConnectionBufferLimitBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPerConnectionBufferLimitBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "PerConnectionBufferLimitBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDeprecatedV1()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "DeprecatedV1",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "DeprecatedV1",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDeprecatedV1()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "DeprecatedV1",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for DrainType

	for idx, item := range m.GetListenerFilters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("ListenerFilters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("ListenerFilters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerValidationError{
					field:  fmt.Sprintf("ListenerFilters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetListenerFiltersTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "ListenerFiltersTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "ListenerFiltersTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetListenerFiltersTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "ListenerFiltersTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ContinueOnListenerFiltersTimeout

	if all {
		switch v := interface{}(m.GetTransparent()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "Transparent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "Transparent",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTransparent()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "Transparent",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetFreebind()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "Freebind",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "Freebind",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFreebind()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "Freebind",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetSocketOptions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("SocketOptions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("SocketOptions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerValidationError{
					field:  fmt.Sprintf("SocketOptions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetTcpFastOpenQueueLength()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "TcpFastOpenQueueLength",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "TcpFastOpenQueueLength",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTcpFastOpenQueueLength()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "TcpFastOpenQueueLength",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for TrafficDirection

	if all {
		switch v := interface{}(m.GetUdpListenerConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "UdpListenerConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "UdpListenerConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUdpListenerConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "UdpListenerConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetApiListener()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "ApiListener",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "ApiListener",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetApiListener()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "ApiListener",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetConnectionBalanceConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "ConnectionBalanceConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "ConnectionBalanceConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConnectionBalanceConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "ConnectionBalanceConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ReusePort

	if all {
		switch v := interface{}(m.GetEnableReusePort()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "EnableReusePort",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "EnableReusePort",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEnableReusePort()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "EnableReusePort",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetAccessLog() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("AccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  fmt.Sprintf("AccessLog[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerValidationError{
					field:  fmt.Sprintf("AccessLog[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetTcpBacklogSize()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "TcpBacklogSize",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "TcpBacklogSize",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTcpBacklogSize()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "TcpBacklogSize",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if wrapper := m.GetMaxConnectionsToAcceptPerSocketEvent(); wrapper != nil {

		if wrapper.GetValue() <= 0 {
			err := ListenerValidationError{
				field:  "MaxConnectionsToAcceptPerSocketEvent",
				reason: "value must be greater than 0",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetBindToPort()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "BindToPort",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerValidationError{
					field:  "BindToPort",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBindToPort()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerValidationError{
				field:  "BindToPort",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for EnableMptcp

	// no validation rules for IgnoreGlobalConnLimit

	switch v := m.ListenerSpecifier.(type) {
	case *Listener_InternalListener:
		if v == nil {
			err := ListenerValidationError{
				field:  "ListenerSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetInternalListener()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  "InternalListener",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerValidationError{
						field:  "InternalListener",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetInternalListener()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerValidationError{
					field:  "InternalListener",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ListenerMultiError(errors)
	}

	return nil
}

// ListenerMultiError is an error wrapping multiple validation errors returned
// by Listener.ValidateAll() if the designated constraints aren't met.
type ListenerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenerMultiError) AllErrors() []error { return m }

// ListenerValidationError is the validation error returned by
// Listener.Validate if the designated constraints aren't met.
type ListenerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenerValidationError) ErrorName() string { return "ListenerValidationError" }

// Error satisfies the builtin error interface
func (e ListenerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListener.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenerValidationError{}

// Validate checks the field values on ListenerManager with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ListenerManager) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListenerManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListenerManagerMultiError, or nil if none found.
func (m *ListenerManager) ValidateAll() error {
	return m.validate(true)
}

func (m *ListenerManager) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return ListenerManagerMultiError(errors)
	}

	return nil
}

// ListenerManagerMultiError is an error wrapping multiple validation errors
// returned by ListenerManager.ValidateAll() if the designated constraints
// aren't met.
type ListenerManagerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenerManagerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenerManagerMultiError) AllErrors() []error { return m }

// ListenerManagerValidationError is the validation error returned by
// ListenerManager.Validate if the designated constraints aren't met.
type ListenerManagerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenerManagerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenerManagerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenerManagerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenerManagerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenerManagerValidationError) ErrorName() string { return "ListenerManagerValidationError" }

// Error satisfies the builtin error interface
func (e ListenerManagerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenerManager.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenerManagerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenerManagerValidationError{}

// Validate checks the field values on ValidationListenerManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ValidationListenerManager) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ValidationListenerManager with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ValidationListenerManagerMultiError, or nil if none found.
func (m *ValidationListenerManager) ValidateAll() error {
	return m.validate(true)
}

func (m *ValidationListenerManager) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return ValidationListenerManagerMultiError(errors)
	}

	return nil
}

// ValidationListenerManagerMultiError is an error wrapping multiple validation
// errors returned by ValidationListenerManager.ValidateAll() if the
// designated constraints aren't met.
type ValidationListenerManagerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ValidationListenerManagerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ValidationListenerManagerMultiError) AllErrors() []error { return m }

// ValidationListenerManagerValidationError is the validation error returned by
// ValidationListenerManager.Validate if the designated constraints aren't met.
type ValidationListenerManagerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ValidationListenerManagerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ValidationListenerManagerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ValidationListenerManagerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ValidationListenerManagerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ValidationListenerManagerValidationError) ErrorName() string {
	return "ValidationListenerManagerValidationError"
}

// Error satisfies the builtin error interface
func (e ValidationListenerManagerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sValidationListenerManager.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ValidationListenerManagerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ValidationListenerManagerValidationError{}

// Validate checks the field values on ApiListenerManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ApiListenerManager) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ApiListenerManager with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ApiListenerManagerMultiError, or nil if none found.
func (m *ApiListenerManager) ValidateAll() error {
	return m.validate(true)
}

func (m *ApiListenerManager) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return ApiListenerManagerMultiError(errors)
	}

	return nil
}

// ApiListenerManagerMultiError is an error wrapping multiple validation errors
// returned by ApiListenerManager.ValidateAll() if the designated constraints
// aren't met.
type ApiListenerManagerMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ApiListenerManagerMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ApiListenerManagerMultiError) AllErrors() []error { return m }

// ApiListenerManagerValidationError is the validation error returned by
// ApiListenerManager.Validate if the designated constraints aren't met.
type ApiListenerManagerValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ApiListenerManagerValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ApiListenerManagerValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ApiListenerManagerValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ApiListenerManagerValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ApiListenerManagerValidationError) ErrorName() string {
	return "ApiListenerManagerValidationError"
}

// Error satisfies the builtin error interface
func (e ApiListenerManagerValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sApiListenerManager.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ApiListenerManagerValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ApiListenerManagerValidationError{}

// Validate checks the field values on Listener_DeprecatedV1 with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Listener_DeprecatedV1) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Listener_DeprecatedV1 with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Listener_DeprecatedV1MultiError, or nil if none found.
func (m *Listener_DeprecatedV1) ValidateAll() error {
	return m.validate(true)
}

func (m *Listener_DeprecatedV1) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetBindToPort()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Listener_DeprecatedV1ValidationError{
					field:  "BindToPort",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Listener_DeprecatedV1ValidationError{
					field:  "BindToPort",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBindToPort()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Listener_DeprecatedV1ValidationError{
				field:  "BindToPort",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return Listener_DeprecatedV1MultiError(errors)
	}

	return nil
}

// Listener_DeprecatedV1MultiError is an error wrapping multiple validation
// errors returned by Listener_DeprecatedV1.ValidateAll() if the designated
// constraints aren't met.
type Listener_DeprecatedV1MultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Listener_DeprecatedV1MultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Listener_DeprecatedV1MultiError) AllErrors() []error { return m }

// Listener_DeprecatedV1ValidationError is the validation error returned by
// Listener_DeprecatedV1.Validate if the designated constraints aren't met.
type Listener_DeprecatedV1ValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Listener_DeprecatedV1ValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Listener_DeprecatedV1ValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Listener_DeprecatedV1ValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Listener_DeprecatedV1ValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Listener_DeprecatedV1ValidationError) ErrorName() string {
	return "Listener_DeprecatedV1ValidationError"
}

// Error satisfies the builtin error interface
func (e Listener_DeprecatedV1ValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListener_DeprecatedV1.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Listener_DeprecatedV1ValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Listener_DeprecatedV1ValidationError{}

// Validate checks the field values on Listener_ConnectionBalanceConfig with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *Listener_ConnectionBalanceConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Listener_ConnectionBalanceConfig with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// Listener_ConnectionBalanceConfigMultiError, or nil if none found.
func (m *Listener_ConnectionBalanceConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Listener_ConnectionBalanceConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofBalanceTypePresent := false
	switch v := m.BalanceType.(type) {
	case *Listener_ConnectionBalanceConfig_ExactBalance_:
		if v == nil {
			err := Listener_ConnectionBalanceConfigValidationError{
				field:  "BalanceType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofBalanceTypePresent = true

		if all {
			switch v := interface{}(m.GetExactBalance()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Listener_ConnectionBalanceConfigValidationError{
						field:  "ExactBalance",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Listener_ConnectionBalanceConfigValidationError{
						field:  "ExactBalance",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetExactBalance()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Listener_ConnectionBalanceConfigValidationError{
					field:  "ExactBalance",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Listener_ConnectionBalanceConfig_ExtendBalance:
		if v == nil {
			err := Listener_ConnectionBalanceConfigValidationError{
				field:  "BalanceType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofBalanceTypePresent = true

		if all {
			switch v := interface{}(m.GetExtendBalance()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Listener_ConnectionBalanceConfigValidationError{
						field:  "ExtendBalance",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Listener_ConnectionBalanceConfigValidationError{
						field:  "ExtendBalance",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetExtendBalance()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Listener_ConnectionBalanceConfigValidationError{
					field:  "ExtendBalance",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofBalanceTypePresent {
		err := Listener_ConnectionBalanceConfigValidationError{
			field:  "BalanceType",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return Listener_ConnectionBalanceConfigMultiError(errors)
	}

	return nil
}

// Listener_ConnectionBalanceConfigMultiError is an error wrapping multiple
// validation errors returned by
// Listener_ConnectionBalanceConfig.ValidateAll() if the designated
// constraints aren't met.
type Listener_ConnectionBalanceConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Listener_ConnectionBalanceConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Listener_ConnectionBalanceConfigMultiError) AllErrors() []error { return m }

// Listener_ConnectionBalanceConfigValidationError is the validation error
// returned by Listener_ConnectionBalanceConfig.Validate if the designated
// constraints aren't met.
type Listener_ConnectionBalanceConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Listener_ConnectionBalanceConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Listener_ConnectionBalanceConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Listener_ConnectionBalanceConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Listener_ConnectionBalanceConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Listener_ConnectionBalanceConfigValidationError) ErrorName() string {
	return "Listener_ConnectionBalanceConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Listener_ConnectionBalanceConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListener_ConnectionBalanceConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Listener_ConnectionBalanceConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Listener_ConnectionBalanceConfigValidationError{}

// Validate checks the field values on Listener_InternalListenerConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Listener_InternalListenerConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Listener_InternalListenerConfig with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// Listener_InternalListenerConfigMultiError, or nil if none found.
func (m *Listener_InternalListenerConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Listener_InternalListenerConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return Listener_InternalListenerConfigMultiError(errors)
	}

	return nil
}

// Listener_InternalListenerConfigMultiError is an error wrapping multiple
// validation errors returned by Listener_InternalListenerConfig.ValidateAll()
// if the designated constraints aren't met.
type Listener_InternalListenerConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Listener_InternalListenerConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Listener_InternalListenerConfigMultiError) AllErrors() []error { return m }

// Listener_InternalListenerConfigValidationError is the validation error
// returned by Listener_InternalListenerConfig.Validate if the designated
// constraints aren't met.
type Listener_InternalListenerConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Listener_InternalListenerConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Listener_InternalListenerConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Listener_InternalListenerConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Listener_InternalListenerConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Listener_InternalListenerConfigValidationError) ErrorName() string {
	return "Listener_InternalListenerConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Listener_InternalListenerConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListener_InternalListenerConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Listener_InternalListenerConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Listener_InternalListenerConfigValidationError{}

// Validate checks the field values on
// Listener_ConnectionBalanceConfig_ExactBalance with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Listener_ConnectionBalanceConfig_ExactBalance) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// Listener_ConnectionBalanceConfig_ExactBalance with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// Listener_ConnectionBalanceConfig_ExactBalanceMultiError, or nil if none found.
func (m *Listener_ConnectionBalanceConfig_ExactBalance) ValidateAll() error {
	return m.validate(true)
}

func (m *Listener_ConnectionBalanceConfig_ExactBalance) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return Listener_ConnectionBalanceConfig_ExactBalanceMultiError(errors)
	}

	return nil
}

// Listener_ConnectionBalanceConfig_ExactBalanceMultiError is an error wrapping
// multiple validation errors returned by
// Listener_ConnectionBalanceConfig_ExactBalance.ValidateAll() if the
// designated constraints aren't met.
type Listener_ConnectionBalanceConfig_ExactBalanceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Listener_ConnectionBalanceConfig_ExactBalanceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Listener_ConnectionBalanceConfig_ExactBalanceMultiError) AllErrors() []error { return m }

// Listener_ConnectionBalanceConfig_ExactBalanceValidationError is the
// validation error returned by
// Listener_ConnectionBalanceConfig_ExactBalance.Validate if the designated
// constraints aren't met.
type Listener_ConnectionBalanceConfig_ExactBalanceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Listener_ConnectionBalanceConfig_ExactBalanceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Listener_ConnectionBalanceConfig_ExactBalanceValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e Listener_ConnectionBalanceConfig_ExactBalanceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Listener_ConnectionBalanceConfig_ExactBalanceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Listener_ConnectionBalanceConfig_ExactBalanceValidationError) ErrorName() string {
	return "Listener_ConnectionBalanceConfig_ExactBalanceValidationError"
}

// Error satisfies the builtin error interface
func (e Listener_ConnectionBalanceConfig_ExactBalanceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListener_ConnectionBalanceConfig_ExactBalance.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Listener_ConnectionBalanceConfig_ExactBalanceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Listener_ConnectionBalanceConfig_ExactBalanceValidationError{}
