// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package daemon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetHealthzParams creates a new GetHealthzParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetHealthzParams() *GetHealthzParams {
	return &GetHealthzParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetHealthzParamsWithTimeout creates a new GetHealthzParams object
// with the ability to set a timeout on a request.
func NewGetHealthzParamsWithTimeout(timeout time.Duration) *GetHealthzParams {
	return &GetHealthzParams{
		timeout: timeout,
	}
}

// NewGetHealthzParamsWithContext creates a new GetHealthzParams object
// with the ability to set a context for a request.
func NewGetHealthzParamsWithContext(ctx context.Context) *GetHealthzParams {
	return &GetHealthzParams{
		Context: ctx,
	}
}

// NewGetHealthzParamsWithHTTPClient creates a new GetHealthzParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetHealthzParamsWithHTTPClient(client *http.Client) *GetHealthzParams {
	return &GetHealthzParams{
		HTTPClient: client,
	}
}

/*
GetHealthzParams contains all the parameters to send to the API endpoint

	for the get healthz operation.

	Typically these are written to a http.Request.
*/
type GetHealthzParams struct {

	/* Brief.

	   Brief will return a brief representation of the Cilium status.

	*/
	Brief *bool

	/* RequireK8sConnectivity.

	   If set to true, failure of the agent to connect to the Kubernetes control plane will cause the agent's health status to also fail.


	   Default: true
	*/
	RequireK8sConnectivity *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get healthz params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetHealthzParams) WithDefaults() *GetHealthzParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get healthz params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetHealthzParams) SetDefaults() {
	var (
		requireK8sConnectivityDefault = bool(true)
	)

	val := GetHealthzParams{
		RequireK8sConnectivity: &requireK8sConnectivityDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get healthz params
func (o *GetHealthzParams) WithTimeout(timeout time.Duration) *GetHealthzParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get healthz params
func (o *GetHealthzParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get healthz params
func (o *GetHealthzParams) WithContext(ctx context.Context) *GetHealthzParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get healthz params
func (o *GetHealthzParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get healthz params
func (o *GetHealthzParams) WithHTTPClient(client *http.Client) *GetHealthzParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get healthz params
func (o *GetHealthzParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBrief adds the brief to the get healthz params
func (o *GetHealthzParams) WithBrief(brief *bool) *GetHealthzParams {
	o.SetBrief(brief)
	return o
}

// SetBrief adds the brief to the get healthz params
func (o *GetHealthzParams) SetBrief(brief *bool) {
	o.Brief = brief
}

// WithRequireK8sConnectivity adds the requireK8sConnectivity to the get healthz params
func (o *GetHealthzParams) WithRequireK8sConnectivity(requireK8sConnectivity *bool) *GetHealthzParams {
	o.SetRequireK8sConnectivity(requireK8sConnectivity)
	return o
}

// SetRequireK8sConnectivity adds the requireK8sConnectivity to the get healthz params
func (o *GetHealthzParams) SetRequireK8sConnectivity(requireK8sConnectivity *bool) {
	o.RequireK8sConnectivity = requireK8sConnectivity
}

// WriteToRequest writes these params to a swagger request
func (o *GetHealthzParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Brief != nil {

		// header param brief
		if err := r.SetHeaderParam("brief", swag.FormatBool(*o.Brief)); err != nil {
			return err
		}
	}

	if o.RequireK8sConnectivity != nil {

		// header param require-k8s-connectivity
		if err := r.SetHeaderParam("require-k8s-connectivity", swag.FormatBool(*o.RequireK8sConnectivity)); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
