---
title: BGP peer
description: API for this Calico resource.
canonical_url: '/reference/resources/bgppeer'
---

A BGP peer resource (`BGPPeer`) represents a remote BGP peer with
which the node(s) in a {{site.prodname}} cluster will peer.
Configuring BGP peers allows you to peer a {{site.prodname}} network
with your datacenter fabric (e.g. ToR). For more
information on cluster layouts, see {{site.prodname}}'s documentation on
[{{site.prodname}} over IP fabrics]({{ site.baseurl }}/reference/architecture/design/l3-interconnect-fabric).

For `calicoctl` [commands]({{ site.baseurl }}/reference/calicoctl/overview) that specify a resource type on the CLI, the following
aliases are supported (all case insensitive): `bgppeer`, `bgppeers`, `bgpp`, `bgpps`, `bp`, `bps`.

### Sample YAML

```yaml
apiVersion: projectcalico.org/v3
kind: BGPPeer
metadata:
  name: some.name
spec:
  node: rack1-host1
  peerIP: 192.168.1.1
  asNumber: 63400
```

### BGP peer definition

#### Metadata

| Field       | Description                 | Accepted Values   | Schema |
|-------------|-----------------------------|-------------------|--------|
| name     | Unique name to describe this resource instance. Must be specified.| Alphanumeric string with optional `.`, `_`, or `-`. | string |

#### Spec

| Field       | Description                 | Accepted Values   | Schema | Default    |
|-------------|-----------------------------|-------------------|--------|------------|
| node     | If specified, the scope is node level, otherwise the scope is global. | The hostname of the node to which this peer applies. | string | |
| peerIP   | The IP address of this peer and an optional port number. If port number is not set, and peer is Calico node with `listenPort` set, then `listenPort` is used. | Valid IPv4 or IPv6 address. If port number is set use, `IPv4:port` or `[IPv6]:port` format. | string | |
| asNumber | The remote AS Number of the peer. | A valid AS Number, may be specified in dotted notation. | integer/string |
| nodeSelector | Selector for the nodes that should have this peering.  When this is set, the `node` field must be empty. | | [selector](#selectors) |
| peerSelector | Selector for the remote nodes to peer with.  When this is set, the `peerIP` and `asNumber` fields must be empty. | | [selector](#selectors) |
| keepOriginalNextHop | Maintain and forward the original next hop BGP route attribute to a specific Peer within a different AS. | | boolean |
| password   | BGP password for the peerings generated by this BGPPeer resource. |  | [BGPPassword](#bgppassword) | `nil` (no password) |

> **Tip**: the cluster-wide default local AS number used when speaking with a peer is controlled by the
> [BGPConfiguration resource](./bgpconfig).  That value can be overriden per-node by using the `bgp` field of
> the [node resource](./node).
{: .alert .alert-success}

#### BGPPassword

> **Note:** BGP passwords must be 80 characters or fewer.  If a password longer than that
> is configured, the BGP sessions with that password will fail to be established.
{: .alert .alert-info}

| Field        | Description                     | Schema           |
|--------------|---------------------------------|------------------|
| secretKeyRef | Get the password from a secret. | [KeyRef](#keyref) |


#### KeyRef

KeyRef tells {{site.prodname}} where to get a BGP password.  The referenced Kubernetes
secret must be in the same namespace as the {{site.nodecontainer}} pod.

| Field    | Description                         | Schema |
|----------|-------------------------------------|--------|
| name     | The name of the secret              | string |
| key      | The key within the secret           | string |


### Peer scopes

BGP Peers can exist at either global or node-specific scope. A peer's scope
determines which `{{site.nodecontainer}}`s will attempt to establish a BGP session with that peer.
If `{{site.nodecontainer}}` has a `listenPort` set in `BGPConfiguration`, it will be used in peering.

#### Global peer

To assign a BGP peer a global scope, omit the `node` and `nodeSelector` fields. All nodes in
the cluster will attempt to establish BGP connections with it

#### Node-specific peer

A BGP peer can also be node-specific. When the `node` field is included, only the specified node
will peer with it. When the `nodeSelector` field is included, the nodes with labels that match that selector
will peer with it.

### Supported operations

| Datastore type        | Create/Delete | Update | Get/List | Notes
|-----------------------|---------------|--------|----------|------
| etcdv3                | Yes           | Yes    | Yes      |
| Kubernetes API server | Yes           | Yes    | Yes      |

### Selectors

{% include content/selectors.md %}
