14 August 2018

We are very excited to announce v3.2.0 of Calico. Some of the highlights of this release are:

#### GA for Application Layer Policy
With {{site.prodname}} v3.2 we are moving support for application layer policy from "tech preview" to GA. With today’s evolving threat landscape, enterprises are deploying a zero trust network security model to protect their crown jewels. Application layer policy from Tigera Calico, combined with the open source Istio project simplifies authenticating and authorizing network flows using multiple attributes.

#### IPVS kube-proxy
{{site.prodname}} v3.2 updates support for IPVS proxy from beta to GA. IPVS support is activated automatically if {{site.prodname}} detects when kube-proxy is running IPVS mode. IPVS kube-proxy promises greater scale and performance.

#### Labels for OpenStack EndPoints
If using {{site.prodname}} with OpenStack endpoints, each OpenStack VM identified as {{site.prodname}} workload endpoint will now have labels for project name and security groups the virtual machine belongs to.

#### Updated dependencies
All components are built using Go v1.10.3 and all images are based on the latest build of Alpine v3.8

#### Multiple Architectures
Thanks to concerted efforts from the community, images are now available for all components for the arm64 and ppc64le architectures.

#### Other changes

 - Removed the kubeadm installation manfiest in favor of the etcd / kdd manifests. [calico #1933](https://github.com/projectcalico/calico/pull/1933) (@caseydavenport)
 - calico/node is now supported in IPv6 only environments. [calico #1917](https://github.com/projectcalico/calico/pull/1917) (@tmjd)
 - ipAddrsNoIpam is now disabled by default and can be enabled using the new "feature_control" flag in the CNI config. [calico #1901](https://github.com/projectcalico/calico/pull/1901) (@ozdanborne)
 - The address used by Felix for health information now defaults to localhost instead of 0.0.0.0. A new config parameter was added for control over this behavior: HealthHost [calico #1900](https://github.com/projectcalico/calico/pull/1900) (@ozdanborne)
 - calico/node supports an exec based readiness probe for monitoring felix and BIRD readiness [calico #1841](https://github.com/projectcalico/calico/pull/1841) (@ozdanborne)
 - kubernetes manifests now enable BIRD BGP readiness checks by default. [calico #1841](https://github.com/projectcalico/calico/pull/1841) (@ozdanborne)
 - veth MTU is now configurable via the configmap in the Kubernetes self-hosted manifests [calico #1770](https://github.com/projectcalico/calico/pull/1770) (@ketkulka)
 - Substantially reduced the calico/node image size by consolidating shared code in a single binary. [node #26](https://github.com/projectcalico/node/pull/26) (@caseydavenport)
 - Calico's CNI plugin now supports the host-local IPAM plugin's ranges configuration section when substituting "usePodCidr". [cni-plugin #571](https://github.com/projectcalico/cni-plugin/pull/571) (@fasaxc)
 - Fix a bug in the CNI plugin where IP allocations were not properly updated on container restart [cni-plugin #529](https://github.com/projectcalico/cni-plugin/pull/529) (@caseydavenport)
 - When ran as a pod CNI will be configured with K8s CA for tls verification. [cni-plugin #527](https://github.com/projectcalico/cni-plugin/pull/527) (@tmjd)
 - Fix etcd cert file existence check in calico/cni [cni-plugin #526](https://github.com/projectcalico/cni-plugin/pull/526) (@bjhaid)
 - Add the tuning plugin to the calico/cni image [cni-plugin #519](https://github.com/projectcalico/cni-plugin/pull/519) (@eranreshef)
 - Add support for configuring container IP forwarding via the CNI configuration file. [cni-plugin #501](https://github.com/projectcalico/cni-plugin/pull/501) (@caseydavenport)
 - Support configuring MTU via install-cni.sh environment variable [cni-plugin #491](https://github.com/projectcalico/cni-plugin/pull/491) (@ketkulka)
 - The iptables rules for forwarded traffic passing through a HostEndpoint have been improved so that that traffic is allowed by default (when there is no relevant ApplyOnForward policy) even if the host has `iptables -P FORWARD DROP`.  (For the full intended semantics for forwarded traffic through HostEndpoints, which have not changed, see https://docs.projectcalico.org/master/getting-started/bare-metal/policy/forwarded.) [felix #1841](https://github.com/projectcalico/felix/pull/1841) (@neiljerram)
 - Workaround an etcd client issue that caused high CPU when the etcd server was down. [felix #1808](https://github.com/projectcalico/felix/pull/1808) (@fasaxc)
 - Felix now handles no-op policy updates more efficiently, this can significantly reduce CPU usage where policy is frequently rewritten with no changes. [felix #1806](https://github.com/projectcalico/felix/pull/1806) (@fasaxc)
 - HealthCheck default behavior changed from listening on all interfaces to just listening on localhost. This behavior can be controlled by the new HealthHost parameter. [felix #1782](https://github.com/projectcalico/felix/pull/1782) (@ozdanborne)
 - Felix now uses unique temporary IP set names; this works around transient deletion failures and failures caused by other apps incorrectly referencing Calico IP sets. [felix #1779](https://github.com/projectcalico/felix/pull/1779) (@fasaxc)
 - Since Typha no longer exposes its readiness check on 0.0.0.0 (in order to improve security), our manifests have been updated to use a new command-line readiness check. [typha #179](https://github.com/projectcalico/typha/pull/179) (@fasaxc)
 - Typha now supports configuring both port and host to bind to for health checks.  The default is now localhost. [typha #140](https://github.com/projectcalico/typha/pull/140) (@renan)
 - IPAM doesn't use old IP blocks after upgrade to Calico 3.1 [libcalico-go #868](https://github.com/projectcalico/libcalico-go/pull/868) (@gunjan5)
 - For updated Kubernetes clusters that allow it, you may include both a pod and namespace selector on a NetworkPolicyPeer. [libcalico-go #867](https://github.com/projectcalico/libcalico-go/pull/867) (@spikecurtis)
 - Can now set the bind address for Felix health endpoints in the FelixConfiguration object [libcalico-go #849](https://github.com/projectcalico/libcalico-go/pull/849) (@renan)
 - When converting do not copy egress type when preDNAT is set on a policy. [libcalico-go #848](https://github.com/projectcalico/libcalico-go/pull/848) (@tmjd)
 - Remove feature flag check for service accounts. [libcalico-go #836](https://github.com/projectcalico/libcalico-go/pull/836) (@saumoh)


#### Limitations

- **Offers only Kubernetes, OpenShift, OpenStack, and host endpoint integrations**: the
Mesos, DC/OS, and libnetwork orchestrators have not been tested. The latest supported release
for these orchestrators is v2.6.

- **GoBGP not supported**: Setting the `CALICO_NETWORKING_BACKEND` environment
variable to `gobgp` is not supported. See [Configuring {{site.nodecontainer}}](https://docs.projectcalico.org/v3.1/reference/node/configuration)
for more information. We plan to resume support for GoBGP in a future release.

- **Route reflectors cannot be clustered**: We plan to resume support for this in a future release.