  22 December 2017

  > **Important**: This release includes breaking changes to the data and
  > resource model. [Review the documentation](https://docs.projectcalico.org/v3.0/getting-started/kubernetes/upgrade/) carefully before attempting an upgrade.
  > Some highlights include:
  > - You must upgrade to Calico v2.6.5 before you can upgrade to v3.0.1.
  > - Calico deployments that access the etcd datastore directly must complete
    a one-time migration.
  > - You must convert any customized Calico manifests via `calicoctl convert`
    before you can use them with v3.0.1.
  {: .alert .alert-danger}

  #### What's new

  ##### Support for etcdv3

  - Calico now stores its data in [etcd version 3](https://coreos.com/blog/etcd3-a-new-etcd.html).

  ##### Support for Windows in policy-only mode

  - Felix now compiles and runs on Windows in policy-only mode. [felix #1638](https://github.com/projectcalico/felix/pull/1638) (@nwoodmsft)

  ##### Migration and upgrade from v2.6.5

  - This version of Calico supports [migration and upgrade](/v3.0/getting-started/kubernetes/upgrade/) from Calico v2.6.5.

  ##### calicoctl enhancements

  - Those using the Kubernetes API datastore can now use `calicoctl` to
    create, read, update, and delete Calico policies.

  - `calicoctl` features two new resources: [BGP Configuration](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/bgpconfig)
    and [Felix Configuration](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/felixconfig).

  - The `calicoctl` policy resource has been split into new [network policy](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/networkpolicy)
    and [global network policy](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/globalnetworkpolicy) resources.

  - [Network policy](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/networkpolicy)
    resources can include a `namespace` value, allowing you to create policies that
    only apply to [workload endpoint resources](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/workloadendpoint)
    in the same namespace.

  - You can now specify `namespaceSelector` expressions in
    [network policy](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/networkpolicy)
    and [global network policy](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/globalnetworkpolicy) rules to select one or more namespaces in their entirety.

  - The `get`, `apply`, `create`, `delete`, and `replace` commands of `calicoctl`
    now include an optional `--namespace=<NS>` flag. Refer to the `calicoctl`
    [Command reference](https://docs.projectcalico.org/v3.0/reference/calicoctl/commands/) section for more details.

  - The `get` command of `calicoctl` now includes optional `--all-namespaces`
    and `--export` flags. Refer to the [calicoctl get](https://docs.projectcalico.org/v3.0/reference/calicoctl/commands/get)
    section for more information.

  - `calicoctl` no longer accepts the following flags in `get` commands:
    `--node=<NODE>`, `--orchestrator=<ORCH>`, `--workload=<WORKLOAD>`, and
    `--scope=<SCOPE>`. These options are now a part of the individual resources.

  - `calicoctl` no longer includes a `config` command. To achieve the equivalent
    functionality, refer to [Modifying low-level component configurations](https://docs.projectcalico.org/v3.0/reference/calicoctl/commands/#modifying-low-level-component-configurations).

  - You can now name [host](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/hostendpoint#endpointport)
    and [workload](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/workloadendpoint#endpointport)
    endpoint ports and reference them by name in your [policy rules](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/networkpolicy#ports).

  - `calicoctl` now allows a `0` value for ICMP entries in policy resources,
    enabling `ping` responses. In addition, it now rejects `255` values in the
    `type` field due to lack of kernel support. Refer to the reference documentation
    of the [network policy](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/networkpolicy#icmp)
    and [global network policy](https://docs.projectcalico.org/v3.0/reference/calicoctl/resources/globalnetworkpolicy#icmp)
    resources for more information.

  - `calicoctl` now offers a new `convert` command, allowing 2.6.x manifests stored under
    version control to be converted to the v3.x format. [calicoctl #1782](https://github.com/projectcalico/calicoctl/pull/1782) (@gunjan5)

  ##### Host endpoint policies can be applied to forwarded traffic

  - The new `ApplyOnForward` flag allows you to specify if a host endpoint policy should
    apply to forwarded traffic or not. Forwarded traffic includes traffic forwarded between
    host endpoints and traffic forwarded between a host endpoint and a workload endpoint on
    the same host. Refer to [Using Calico to secure host interfaces](https://docs.projectcalico.org/v3.0/getting-started/bare-metal/bare-metal)
    for more details.

  ##### CNI plugin changes

  - Calico now assigns the host side of veth pairs a MAC address of `ee:ee:ee:ee:ee:ee`.
    If this fails, it uses a kernel-generated MAC address as before. For more information,
    refer to the [Troubleshooting FAQ](https://docs.projectcalico.org/v2.6/usage/troubleshooting/). [cni-plugin #436](https://github.com/projectcalico/cni-plugin/pull/436) (@tmjd)

  - The CNI plugin now offers an optional environment variable called `CNI_OLD_CONF_NAME`.
    If set, the CNI plug-in cleans up old configuration data during an upgrade, making it
    easier to migrate to a new `CNI_CONF_NAME` value. [cni-plugin #392](https://github.com/projectcalico/cni-plugin/pull/392)(@weikinhuang)

  - The CNI plugin no longer throws a `file exists` message when programming routes.
    [cni-plugin #406](https://github.com/projectcalico/cni-plugin/pull/406) (@gunjan5)

  - After a period of deprecation, this release removes support for the `ETCD_AUTHORITY`
    and `ETCD_SCHEME` environment variables. Calico no longer reads these values. If you have
    not transitioned to `ETCD_ENDPOINTS`, you must do so as of v3.0. Refer to
    [Configuring `calicoctl` - etcdv3 datastore](https://docs.projectcalico.org/v3.0/reference/calicoctl/setup/etcdv3) for more information.

  - A new node controller for Kubernetes deployments clears data associated with deleted
    nodes from the Calico datastore, preventing conflicts that can lead to crash loops. Refer
    to [Configuring the Calico Kubernetes controllers](https://docs.projectcalico.org/v3.0/reference/kube-controllers/configuration) for more information.

  ##### Other changes

  - Calico now works with Kubernetes network services proxy with IPVS/LVS. Calico enforces
    network policies with kube-proxy running in IPVS mode for Kubernetes clusters. Currently
    only workload ingress policy is supported.

  - Rolling update is now enabled by default in the Kubernetes self-hosted manifests.
    [calico #1506](https://github.com/projectcalico/calico/pull/1506) (@caseydavenport)

  - The CoreOS version used for the Kubernetes Vagrant tutorial has been updated, resolving
    an issue causing `kubectl` to hang. [calico #1487](https://github.com/projectcalico/calico/pull/1487) (@2ffs2nns)

  - Typha no longer sends incorrect `updateTypes` to Felix, increasing the accuracy of
    Felix statistics. [typha #70](https://github.com/projectcalico/typha/pull/70) (@fasaxc)

  - The CNI plugin now offers an optional environment variable called `CNI_OLD_CONF_NAME`.
    If set, the CNI plug-in cleans up old configuration data during an upgrade, making it
    easier to migrate to a new `CNI_CONF_NAME` value. [cni-plugin #392](https://github.com/projectcalico/cni-plugin/pull/392)(@weikinhuang)

  #### Limitations

  - **Offers only Kubernetes, OpenShift, and host endpoint integrations**: the
    OpenStack, Mesos, DC/OS, rkt, and Docker orchestrators have not been tested
    and are not supported. (Calico still supports Docker and rkt containers.)
    We plan to resume support for the OpenStack, Mesos, DC/OS, and Docker
    orchestrators in a future release.

  - **GoBGP not supported**: Setting the `CALICO_NETWORKING_BACKEND` environment
    variable to `gobgp` is not supported. See [Configuring calico/node](https://docs.projectcalico.org/v3.0/reference/node/configuration)
    for more information. We plan to resume support for GoBGP in a future release.

  - **Route reflectors cannot be clustered**: We plan to resume support for
    this in a future release.
