import QtQuick 2.8
import QtQuick.Studio.Components 1.0
import backend.Data 1.0 as Data

Item {
    id: battery
    width: 180
    height: 80
    property alias _75Text: batteryValue.text
    property alias _Text: percentSymbol.text

    Text {
        id: batteryValue
        anchors.top: parent.top
        anchors.left: boltVector.right
        width: 123 * eosADAS.scaleFactor
        height: 80 * eosADAS.scaleFactor
        color: "#ffffff"
        text: Data.Values.batteryLevel === undefined ? 50 : Math.floor(
                                                           Data.Values.batteryLevel * 100)
        font.pixelSize: 80 * eosADAS.scaleFactor
        horizontalAlignment: Text.AlignRight
        verticalAlignment: Text.AlignTop
        font.weight: Font.Normal
        font.family: "Slate For FCA Regular"
    }

    Text {
        id: percentSymbol
        anchors.left: batteryValue.right
        anchors.verticalCenter: batteryValue.verticalCenter
        width: 25 * eosADAS.scaleFactor
        height: 30 * eosADAS.scaleFactor
        color: "#ffffff"
        text: "%"
        font.pixelSize: 30 * eosADAS.scaleFactor
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop
        wrapMode: Text.Wrap
        font.weight: Font.Normal
        font.family: "Slate For FCA Book"
    }

    SvgPathItem {
        id: boltVector
        anchors.right: batteryValue.left
        anchors.verticalCenter: batteryValue.verticalCenter
        width: 20
        height: 36
        strokeColor: "transparent"
        fillColor: "#ffffff"
        path: "M 7.996036052703857 36 L 5.996036052703857 36 L 7.996036052703857 22 L 0.996036171913147 22 C -0.7639638185501099 22 0.3360362872481346 20.500000532716513 0.37603628635406494 20.440000534057617 C 2.9560362100601196 15.880000591278076 6.8360371589660645 9.079999923706055 12.016036987304688 0 L 14.016036987304688 0 L 12.016036987304688 14 L 19.03603744506836 14 C 19.83603745698929 14 20.27603667974472 14.379999697208405 19.836036682128906 15.319999694824219 C 11.936036586761475 29.09999942779541 7.996036052703857 36 7.996036052703857 36 Z"
        scale: eosADAS.scaleFactor
        layer.samples: 4
        strokeWidth: 2
        antialiasing: true
        layer.enabled: true
    }
}

/*##^##
Designer {
    D{i:0;height:0;width:0}
}
##^##*/

