import QtQuick 2.8
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 6.2

Button {
    id: offRoadBtn
    checkable: true
    state: "default"
    clip: true
    background: Rectangle {
        id: background
        width: 200
        height: 200
        color: "#00000000"
    }

    Rectangle {
        id: indicator
        x: 0
        y: 66
        width: 100
        height: 2
        color: "#ffffff"
        antialiasing: true
        layer.samples: 4
        layer.enabled: true
    }

    SvgPathItem {
        id: offRoadDef
        x: 32
        y: 24
        width: 35
        height: 27
        strokeColor: "transparent"
        fillColor: "#6d737a"
        path: "M 16.391298294067383 26.99808692932129 L 1.1862989664077759 26.99808692932129 C 0.31929898262023926 26.99808692932129 0.0012990186223760247 26.68090111017227 0.0012990186223760247 25.807636260986328 C 0.0012990186223760247 25.473386615514755 0.0012990186223760247 25.138132244348526 0.0012990186223760247 24.803882598876953 C -0.008439714438281953 24.62860208749771 0.0367683470249176 24.454662144184113 0.13057315349578857 24.306495666503906 C 0.22437795996665955 24.1583291888237 0.3620665967464447 24.043380826711655 0.5242990255355835 23.977794647216797 C 2.666298985481262 23.114567279815674 4.711298942565918 22.0174663066864 6.936298847198486 21.355993270874023 C 7.811710715293884 21.081195831298828 8.752964198589325 21.103774040937424 9.614298820495605 21.42023277282715 C 10.443680346012115 21.739783585071564 11.338341355323792 21.850865088403225 12.220296859741211 21.743793487548828 C 13.10225236415863 21.63672188669443 13.944732367992401 21.314747869968414 14.674299240112305 20.805936813354492 C 15.374472498893738 20.32194745540619 16.21302479505539 20.080857429653406 17.062299728393555 20.119369506835938 C 19.183671712875366 20.260398909449577 21.314247846603394 20.098517805337906 23.39029884338379 19.63857078552246 C 24.472298860549927 19.374583810567856 25.508299112319946 18.91787752509117 26.57029914855957 18.567567825317383 C 26.865396231412888 18.450634233653545 27.179082214832306 18.388069771695882 27.496299743652344 18.382877349853516 C 28.658536672592163 18.457788310945034 29.8153213262558 18.169132888317108 30.80731773376465 17.556673049926758 C 31.7993141412735 16.944213211536407 32.57771646976471 16.038082718849182 33.035301208496094 14.963091850280762 C 33.09902235120535 14.797327682375908 33.20211060345173 14.649691320955753 33.33560562133789 14.533013343811035 C 33.46910063922405 14.416335366666317 33.62896192073822 14.334146149456501 33.801300048828125 14.293588638305664 C 33.93571200966835 14.246131051331758 34.06215622276068 14.178441256284714 34.176300048828125 14.092838287353516 C 34.250734344124794 14.03793278336525 34.33860333263874 14.004305807873607 34.43056106567383 13.995534896850586 C 34.522518798708916 13.986763985827565 34.61512741446495 14.003177024424076 34.69853210449219 14.043027877807617 C 34.781936794519424 14.082878731191158 34.853020034730434 14.144677340984344 34.90422058105469 14.22184944152832 C 34.95542112737894 14.299021542072296 34.98482232587412 14.388681195676327 34.98929977416992 14.481290817260742 C 34.994660766329616 14.581593967974186 34.994660766329616 14.682113192975521 34.98929977416992 14.782416343688965 L 34.98929977416992 23.615440368652344 C 35.0024329777807 24.063279151916504 34.92425285279751 24.509088188409805 34.75955581665039 24.925506591796875 C 34.59485878050327 25.341924995183945 34.347119480371475 25.720167636871338 34.03154373168945 26.03702163696289 C 33.71596798300743 26.353875637054443 33.339212983846664 26.60265637934208 32.924400329589844 26.768095016479492 C 32.50958767533302 26.933533653616905 32.06546729803085 27.012139812111855 31.619298934936523 26.99909019470215 C 26.53929901123047 27.00444354256615 21.459964752197266 27.00444354256615 16.381298065185547 26.99909019470215 L 16.391298294067383 26.99808692932129 Z M 33.203556060791016 11.306365966796875 C 32.833965957164764 9.953844785690308 31.966790080070496 8.792505145072937 30.777172088623047 8.056906700134277 C 29.587554097175598 7.321308255195618 28.164148807525635 7.066271394491196 26.79444694519043 7.34330415725708 C 25.424745082855225 7.6203369200229645 24.210821092128754 8.40879511833191 23.39785385131836 9.549431800842285 C 22.584886610507965 10.690068483352661 22.23346085846424 12.097879648208618 22.4145565032959 13.488525390625 L 16.852558135986328 14.615738868713379 C 16.466297388076782 13.284077644348145 15.595924258232117 12.146561443805695 14.41379165649414 11.428442001342773 C 13.231659054756165 10.710322558879852 11.823967456817627 10.463964879512787 10.46946907043457 10.738153457641602 C 9.114970684051514 11.012342035770416 7.912434160709381 11.787083148956299 7.09998893737793 12.908961296081543 C 6.287543714046478 14.030839443206787 5.924431756138802 15.418046712875366 6.082557201385498 16.795888900756836 C 5.5685572028160095 16.896264173090458 5.0525572299957275 17.018723241984844 4.529557228088379 17.087982177734375 C 4.388224393129349 17.103733284398913 4.24620608985424 17.065023563802242 4.132222652435303 16.97968101501465 C 4.018239215016365 16.894338466227055 3.940797161310911 16.768732085824013 3.915557384490967 16.628263473510742 C 3.864557385444641 16.45862926542759 3.8605572283267975 16.2739384919405 3.8025572299957275 16.106311798095703 C 3.6958686858415604 15.830673396587372 3.6632680259644985 15.531720578670502 3.7080252170562744 15.239442825317383 C 3.7527824081480503 14.947165071964264 3.873323515057564 14.671839609742165 4.057557106018066 14.441085815429688 C 4.184639558196068 14.225383386015892 4.228408474475145 13.970358356833458 4.1805572509765625 13.724407196044922 C 3.934557244181633 12.410494923591614 3.618557244539261 11.108627200126648 3.394557237625122 9.79069995880127 C 3.296885594725609 9.075216472148895 3.2487703253282234 8.353794872760773 3.2505574226379395 7.631628036499023 C 3.227557422593236 6.818588316440582 3.2505573593080044 6.00354140996933 3.2415573596954346 5.189497947692871 C 3.2483657472766936 5.102616123855114 3.2366179153323174 5.015276476740837 3.207099199295044 4.9333176612854 C 3.1775804832577705 4.851358845829964 3.1309710666537285 4.776669301092625 3.0703868865966797 4.714242458343506 C 3.009802706539631 4.651815615594387 2.9366398453712463 4.603089883923531 2.8557891845703125 4.571322441101074 C 2.7749385237693787 4.539554998278618 2.688263200223446 4.525478203780949 2.601557493209839 4.530032634735107 C 2.1455574929714203 4.50594257004559 1.9235573932528496 4.340323030948639 1.8825573921203613 3.992020845413208 C 1.870307320728898 3.7914300113916397 1.92459886521101 3.5924161672592163 2.036949634552002 3.426072359085083 C 2.149300403892994 3.2597285509109497 2.313381627202034 3.135425366461277 2.5035574436187744 3.0725836753845215 C 3.2475574612617493 2.8899006843566895 3.994557201862335 2.72026626765728 4.7405571937561035 2.544609546661377 L 15.218558311462402 0.0874229446053505 C 15.66810166835785 -0.028571084141731262 16.139497756958008 -0.029147081077098846 16.58932113647461 0.08574801683425903 C 17.03914451599121 0.2006431147456169 17.452928096055984 0.42731449007987976 17.792556762695312 0.7448809742927551 C 18.494556784629822 1.3611851334571838 19.182556927204132 1.9905380606651306 19.882556915283203 2.6128647327423096 C 20.49017071723938 3.18471497297287 21.231248438358307 3.59407801926136 22.03766632080078 3.803323268890381 C 22.844084203243256 4.0125685185194016 23.68996673822403 4.014982104301453 24.497556686401367 3.8103418350219727 C 26.03541374206543 3.50589656829834 27.598138570785522 3.34561023209244 29.165557861328125 3.3315517902374268 C 29.78755784034729 3.305454218760133 30.40955650806427 3.2643003463745117 31.032556533813477 3.2643003463745117 C 31.515163362026215 3.2615547731984407 31.98344174027443 3.4288125038146973 32.355838775634766 3.736945390701294 C 32.7282358109951 4.045078277587891 32.98115664720535 4.474563121795654 33.070556640625 4.9506049156188965 C 33.08383344300091 4.993851099163294 33.090575513382646 5.038850616663694 33.09055709838867 5.084103584289551 C 32.95755709707737 6.160126566886902 33.468557097017765 7.129751920700073 33.59055709838867 8.163617134094238 C 33.59937229100615 8.322574943304062 33.667781077325344 8.472297705709934 33.782047271728516 8.582710266113281 C 33.89631346613169 8.693122826516628 34.04797402024269 8.756045478163287 34.20655822753906 8.758841514587402 C 34.34737215936184 8.764905178453773 34.48156448453665 8.820533409714699 34.58560562133789 8.915971755981445 C 34.68964675813913 9.011410102248192 34.75689553283155 9.140566557645798 34.77555847167969 9.280793190002441 C 34.84555847197771 9.63110288977623 34.930558655411005 9.978400826454163 34.983558654785156 10.330718040466309 C 35.002890054136515 10.401572085916996 35.00804143399 10.475569769740105 34.99871826171875 10.548434257507324 C 34.9893950894475 10.621298745274544 34.96577901020646 10.691587328910828 34.929237365722656 10.75523853302002 C 34.89269572123885 10.818889737129211 34.84395141154528 10.87464190647006 34.78582000732422 10.919275283813477 C 34.72768860310316 10.963908661156893 34.661323957145214 10.996537443250418 34.59055709838867 11.015277862548828 C 34.13355711102486 11.129705674946308 33.66455605626106 11.210005708038807 33.203556060791016 11.306365966796875 Z M 12.618557929992676 2.2495062351226807 C 12.944557934999466 3.837442994117737 13.26155772805214 5.361139535903931 13.568557739257812 6.889854907989502 C 13.611557740718126 7.105661749839783 13.733557730913162 7.08558688685298 13.884557723999023 7.053466796875 C 14.329557716846466 6.959114044904709 14.775558322668076 6.867772124707699 15.218558311462402 6.774423122406006 L 17.382556915283203 6.319723606109619 C 17.333556916564703 6.0828379690647125 17.289557494223118 5.878072485327721 17.249557495117188 5.673306941986084 C 17.20040223747492 5.546609103679657 17.18234942946583 5.409896656870842 17.19692611694336 5.274720191955566 C 17.21150280442089 5.139543727040291 17.25828016549349 5.009874649345875 17.33330535888672 4.896668434143066 C 17.40833055227995 4.783462218940258 17.509399481117725 4.690044552087784 17.627973556518555 4.6243085861206055 C 17.746547631919384 4.558572620153427 17.87914304435253 4.522449517389759 18.014556884765625 4.518990993499756 C 18.47155687212944 4.424638241529465 18.928556501865387 4.325266532599926 19.4145565032959 4.217864990234375 C 18.492556512355804 3.3988028168678284 17.629557609558105 2.5968047976493835 16.7215576171875 1.8500127792358398 C 16.45897290110588 1.6304884850978851 16.122611165046692 1.5202216543257236 15.7815580368042 1.541860580444336 C 14.727558016777039 1.7215323150157928 13.687557816505432 1.9985681027173996 12.613557815551758 2.2444875240325928 L 12.618557929992676 2.2495062351226807 Z M 6.827557563781738 3.616617441177368 C 7.150557577610016 5.187490463256836 7.469557493925095 6.72825026512146 7.795557498931885 8.312171936035156 L 12.367557525634766 7.364630222320557 C 12.034557521343231 5.7395546436309814 11.704558044672012 4.152621388435364 11.373558044433594 2.546617031097412 L 6.827557563781738 3.616617441177368 Z M 6.540557384490967 8.565117835998535 L 5.582557201385498 3.917743444442749 C 5.330958753824234 4.016854703426361 5.116392269730568 4.1922155022621155 4.968708515167236 4.419429779052734 C 4.821024760603905 4.646644055843353 4.747567939572036 4.914412587881088 4.758557319641113 5.185482978820801 L 4.758557319641113 8.52697467803955 C 4.758557319641113 8.65445128083229 4.775557197630405 8.782932132482529 4.786557197570801 8.93449878692627 C 5.2595571875572205 8.834123514592648 5.693557411432266 8.75081154704094 6.1255574226379395 8.662481307983398 C 6.24555741995573 8.637387489899993 6.362557381391525 8.6072759591043 6.540557384490967 8.56210708618164 L 6.540557384490967 8.565117835998535 Z M 27.855384826660156 16.717626571655273 C 26.87693017721176 16.70844940468669 25.936827182769775 16.334422707557678 25.21781349182129 15.668248176574707 C 24.498799800872803 15.002073645591736 24.05224445462227 14.09134727716446 23.964948654174805 13.113094329833984 C 23.87765285372734 12.13484138250351 24.15585345029831 11.158954441547394 24.745473861694336 10.375123977661133 C 25.335094273090363 9.591293513774872 26.194009482860565 9.055521607398987 27.155263900756836 8.871950149536133 C 28.116518318653107 8.688378691673279 29.111434161663055 8.870123326778412 29.946622848510742 9.381856918334961 C 30.78181153535843 9.89359050989151 31.397602170705795 10.698751628398895 31.674297332763672 11.64083480834961 C 31.95099249482155 12.582917988300323 31.868824005126953 13.594614624977112 31.443763732910156 14.479273796081543 C 31.01870346069336 15.363932967185974 30.281120121479034 16.058350205421448 29.3743839263916 16.42754364013672 C 28.89204177260399 16.623766377568245 28.375815272331238 16.722349103540182 27.855384826660156 16.717626571655273 Z M 27.886384963989258 14.381895065307617 C 28.312267243862152 14.36892176605761 28.716207444667816 14.18928274512291 29.011899948120117 13.881360054016113 C 29.307592451572418 13.573437362909317 29.471585556399077 13.161649614572525 29.468843460083008 12.733981132507324 C 29.46610136376694 12.306312650442123 29.29684129357338 11.896678775548935 28.997224807739258 11.592601776123047 C 28.697608321905136 11.288524776697159 28.29139843583107 11.11411949666217 27.865385055541992 11.106649398803711 C 27.647818088531494 11.102834385819733 27.43168769776821 11.142730362713337 27.229707717895508 11.223990440368652 C 27.027727738022804 11.305250518023968 26.84397530555725 11.426233783364296 26.68926239013672 11.57982349395752 C 26.534549474716187 11.733413204550743 26.4119987860322 11.916507497429848 26.328819274902344 12.11833667755127 C 26.245639763772488 12.320165857672691 26.203511784551665 12.536654651165009 26.204912185668945 12.755066871643066 C 26.206312586786225 12.973479092121124 26.251214429736137 13.189404606819153 26.33697509765625 13.390142440795898 C 26.422735765576363 13.590880274772644 26.547622725367546 13.772376760840416 26.70429229736328 13.923954963684082 C 26.860961869359016 14.075533166527748 27.046248987317085 14.194131761789322 27.24925422668457 14.272775650024414 C 27.452259466052055 14.351419538259506 27.668884947896004 14.38852058770135 27.886384963989258 14.381895065307617 Z M 15.507843971252441 16.13338279724121 C 15.50860779301729 16.92095512151718 15.276206731796265 17.690995514392853 14.8401460647583 18.345741271972656 C 14.404085397720337 19.00048702955246 13.784031927585602 19.51040831208229 13.05870532989502 19.810768127441406 C 12.333378732204437 20.111127942800522 11.535493433475494 20.188377782702446 10.76634407043457 20.032712936401367 C 9.997194707393646 19.87704809010029 9.29147207736969 19.495489835739136 8.73877239227295 18.93647575378418 C 8.186072707176208 18.377461671829224 7.81132373213768 17.666205883026123 7.662101745605469 16.893007278442383 C 7.5128797590732574 16.119808673858643 7.5959153175354 15.319540083408356 7.900666236877441 14.593799591064453 C 8.205417156219482 13.86805909872055 8.71813815832138 13.249579310417175 9.373737335205078 12.816880226135254 C 10.029336512088776 12.384181141853333 10.798244535923004 12.156778471544385 11.582843780517578 12.163541793823242 C 12.626977443695068 12.170174300670624 13.626019656658173 12.591509819030762 14.361532211303711 13.33542537689209 C 15.09704476594925 14.079340934753418 15.509186593815684 15.085310697555542 15.507843971252441 16.13338279724121 Z M 11.534843444824219 17.776527404785156 C 11.962230175733566 17.77079616812989 12.370411247015 17.597403079271317 12.672059059143066 17.293445587158203 C 12.973706871271133 16.98948809504509 13.144864671397954 16.579106479883194 13.14891529083252 16.150096893310547 C 13.152965910267085 15.7210873067379 12.989587545394897 15.307521373033524 12.693733215332031 14.997879981994629 C 12.397878885269165 14.688238590955734 11.993045330047607 14.507112557068467 11.56584358215332 14.49325180053711 C 11.138456851243973 14.498983037192374 10.73027577996254 14.672375172376633 10.428627967834473 14.976332664489746 C 10.126980155706406 15.28029015660286 9.955822355579585 15.690672725439072 9.95177173614502 16.11968231201172 C 9.947721116710454 16.548691898584366 10.111099481582642 16.962256878614426 10.406953811645508 17.27189826965332 C 10.702808141708374 17.581539660692215 11.107641696929932 17.7626666482538 11.534843444824219 17.776527404785156 Z"
        layer.samples: 4
        strokeWidth: 1
        antialiasing: true
        layer.enabled: true
    }
    states: [
        State {
            name: "default"
            when: !offRoadBtn.checked

            PropertyChanges {
                target: indicator
                visible: false
            }

            PropertyChanges {
                target: offRoadDef
                visible: true
            }
        },
        State {
            name: "checked"
            when: offRoadBtn.checked

            PropertyChanges {
                target: background
                visible: true
            }

            PropertyChanges {
                target: indicator
                visible: true
            }

            PropertyChanges {
                target: offRoadDef
                visible: true
                fillColor: "#ffffff"
            }
        }
    ]

}

/*##^##
Designer {
    D{i:0;height:68;width:100}D{i:2}D{i:3}
}
##^##*/
