import QtQuick
import QtQuick3D
import QtQuick3D.Particles3D

Node {
    property bool show: false
    property real showAnimated: show

    Behavior on showAnimated {
        NumberAnimation {
            duration: 1000
            easing.type: Easing.InOutQuad
        }
    }

    visible: showAnimated

    // Effect is separated into 2 systems so we can
    // control hide/show animations separately for "air"
    // particles and for "ground" particles.
    ParticleSystem3D {
        id: particleSystem_rain
        y: (1.0 - showAnimated) * 200
        paused: !show
        startTime: 10000

        ParticleEmitter3D {
            id: particleEmitter_clouds
            y: 46
            x: 60
            shape: particleShape1
            scale.x: 0.2
            scale.y: 0.2
            scale.z: 1.0
            lifeSpan: 8000
            lifeSpanVariation: 2000
            emitRate: 4
            velocity: vectorDirection1
            VectorDirection3D {
                id: vectorDirection1
                direction.y: 0
                directionVariation.x: 0
                directionVariation.z: 0
                directionVariation.y: 0
                direction.z: 0
            }

            SpriteParticle3D {
                id: spriteParticle1
                color: "#ffffff"
                colorVariation.w: 0.5
                maxAmount: 50
                Texture {
                    id: singleCloudParticle1
                    source: "images/SingleCloudParticle.png"
                }
                fadeOutDuration: 1500
                sprite: singleCloudParticle1
                fadeInDuration: 1500
                billboard: true
                particleScale: 10
            }

            ParticleShape3D {
                id: particleShape1
                type: ParticleShape3D.Sphere
            }
            particleScale: 3
            particleScaleVariation: 2
            particleEndScale: 5
            particleEndScaleVariation: 3
            particleRotationVariation.z: 360
            particle: spriteParticle1
            enabled: true
            system: particleSystem_rain
        }

        ParticleEmitter3D {
            id: particleEmitter_rain_basic
            x: -100
            y: 10
            scale.x: 1
            scale.y: 1
            scale.z: 2
            shape: particleShape
            emitRate: 100
            velocity: vectorDirection2
            VectorDirection3D {
                id: vectorDirection2
                direction.x: 0
                direction.y: -140
                direction.z: 0
                directionVariation.x : 5
                directionVariation.y : 40
                directionVariation.z : 5
            }

            SpriteParticle3D {
                id: spriteParticle2
                color: "#80a0a0f0"
                sprite: rainDrop
                maxAmount: 100
                blendMode: SpriteParticle3D.SourceOver
                fadeOutDuration: 0
                billboard: true
                fadeInDuration: 0
                particleScale: 10
                colorVariation.w: 0.3
                Texture {
                    id: rainDrop
                    source: "images/RainDrop.png"
                }
            }

            ParticleShape3D {
                id: particleShape
            }
            particleEndScale: 1
            particleRotationVariation.z: -2
            particleScaleVariation: 0
            system: particleSystem_rain
            enabled: true
            particle: spriteParticle2
            particleScale: 1
            lifeSpan: 800
            lifeSpanVariation: 200
        }

        ParticleEmitter3D {
            id: particleEmitter_rain_variety
            y: 100
            x: -100
            lifeSpan: 800
            emitRate: 10
            shape: particleShape3
            velocity: vectorDirection3
            VectorDirection3D {
                id: vectorDirection3
                directionVariation.x: 2
                directionVariation.z: 2
                directionVariation.y: 50
                direction.x: 0
                direction.y: -400
                direction.z: 0
            }

            SpriteParticle3D {
                id: spriteParticle3
                color: "#80ddddff"
                unifiedColorVariation: true
                maxAmount: 10
                Texture {
                    id: varietyRain
                    source: "images/VarietyRain.png"
                }
                blendMode: SpriteParticle3D.SourceOver
                fadeOutDuration: 0
                sprite: varietyRain
                fadeInDuration: 0
                billboard: true
                particleScale: 10
                colorVariation.w: 0.4
            }

            ParticleShape3D {
                id: particleShape3
                extents.z: 5
                extents.y: 100
                extents.x: 300
            }
            particleEndScale: 10
            particleRotationVariation.z: -2
            particleScaleVariation: 15
            particle: spriteParticle3
            enabled: true
            system: particleSystem_rain
            particleScale: 10
            lifeSpanVariation: 200
        }
    }

    ParticleSystem3D {
        id: particleSystem_rain2
        y: -(1.0 - showAnimated) * 100
        paused: !show
        startTime: 1000

        ParticleEmitter3D {
            id: particleEmitter_ripple
            x: 50
            emitRate: 200
            shape: particleShape9
            scale.x: 2
            scale.y: 0
            scale.z: 1
            velocity: vectorDirection9
            VectorDirection3D {
                id: vectorDirection9
                directionVariation.x: 0
                directionVariation.z: 0
                directionVariation.y: 0
                direction.x: 20
                direction.y: 0
                direction.z: 0
            }

            SpriteParticle3D {
                id: spriteParticle9
                color: "#40d0d0f0"
                colorVariation.w: 0.2
                maxAmount: 100
                Texture {
                    id: ripple1
                    source: "images/Ripple.png"
                }
                blendMode: SpriteParticle3D.SourceOver
                fadeInDuration: 100
                fadeOutDuration: 400
                sprite: ripple1
                billboard: true
            }

            ParticleShape3D {
                id: particleShape9
                type: ParticleShape3D.Cube
            }
            particleScale: 0.4
            particleScaleVariation: 0.2
            particleEndScale: 1.5
            particleEndScaleVariation: 0.8
            particleRotationVariation.z: -2
            particleRotation.x: 75
            particle: spriteParticle9
            enabled: true
            system: particleSystem_rain2
            lifeSpan: 400
            lifeSpanVariation: 100
        }

        SpriteParticle3D {
            id: spriteParticleTyresSpray
            color: "#40a0a0b0"
            sprite: rainDrop11
            maxAmount: 400
            blendMode: SpriteParticle3D.SourceOver
            fadeInDuration: 0
            fadeOutDuration: 100
            billboard: true
            particleScale: 1.0
            colorVariation.w: 0.2
            Texture {
                id: rainDrop11
                source: "images/sphere.png"
            }
        }

        ParticleEmitter3D {
            id: particleEmitter_tires_spray_left
            x: 96
            z: 8.8
            y: 0
            depthBias: 1000
            scale.x: 0.01
            scale.y: 0
            scale.z: 0.015
            shape: particleShape10
            emitRate: 200
            velocity: vectorDirection10
            VectorDirection3D {
                id: vectorDirection10
                direction.x: 25
                direction.y: 10
                direction.z: 5
                directionVariation.x : 5
                directionVariation.y : 5
                directionVariation.z : 5
            }
            ParticleShape3D {
                id: particleShape10
            }
            particleRotationVariation.x: 20
            particleRotationVariation.y: 20
            particleRotationVariation.z: 20
            particleScale: 0.5
            particleScaleVariation: 0.3
            particleEndScale: 1
            particleEndScaleVariation: 1.0
            system: particleSystem_rain2
            enabled: true
            particle: spriteParticleTyresSpray
            lifeSpan: 300
            lifeSpanVariation: 100
        }
        ParticleEmitter3D {
            id: particleEmitter_tires_spray_right
            x: 96
            z: -8.8
            y: 0
            depthBias: 1000
            scale.x: 0.01
            scale.y: 0
            scale.z: 0.015
            shape: particleShape11
            emitRate: 200
            velocity: vectorDirection11
            VectorDirection3D {
                id: vectorDirection11
                direction.x: 25
                direction.y: 10
                direction.z: -5
                directionVariation.x : 5
                directionVariation.y : 5
                directionVariation.z : 5
            }
            ParticleShape3D {
                id: particleShape11
            }
            particleRotationVariation.x: 20
            particleRotationVariation.y: 20
            particleRotationVariation.z: 20
            particleScale: 0.5
            particleScaleVariation: 0.3
            particleEndScale: 1
            particleEndScaleVariation: 1.0
            system: particleSystem_rain2
            enabled: true
            particle: spriteParticleTyresSpray
            lifeSpan: 300
            lifeSpanVariation: 100
        }

        Gravity3D {
            particles: [spriteParticleTyresSpray]
        }

    }

}
