
// Created with Qt Design Studio (version 4.7.0), Thu Nov 14 16:08:30 2024
// Do not manually edit this file, it will be overwritten if effect is modified in Qt Design Studio.

import QtQuick
import QtQuick.Layouts
import HelperWidgets
import StudioTheme as StudioTheme

Column {

    Section {
        caption: "General"
        width: parent.width

        SectionLayout {
            PropertyLabel {
                text: "Extra Margin"
                tooltip: "This property specifies how much of extra space is reserved for the effect outside the parent geometry."
            }

            SecondColumnLayout {
                SpinBox {
                    minimumValue: 0
                    maximumValue: 1000
                    decimals: 0
                    stepSize: 1
                    sliderIndicatorVisible: true
                    backendValue: backendValues.extraMargin
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }
                ExpandingSpacer {}
            }
        }
    }

    Section {
        caption: "Displace"
        width: parent.width

        SectionLayout {

            PropertyLabel {
                text: "Source"
                tooltip: "This property defines the item that is going to be used as the displacement map. The source item gets rendered into the intermediate pixel buffer. The red and green component values from the result determine the displacement of the pixels from the source item.\n\nThe format for the displacement map is similar to the tangent space normal maps, which can be created with most 3D-modeling tools. Many image processing tools include the support for generating normal maps. Alternatively, the displacement map for this effect can also be a QML element which is colored appropriately. Like any QML element, it can be animated. It is recommended that the size of the diplacement map matches the size of the source image.\n\nThe displace data is interpreted in the RGBA format. For every pixel: the red channel stores the x-axis displacement, and the green channel stores the y-axis displacement. Blue and alpha channels are ignored for this effect.\n\nAssuming that red channel value 1.0 is fully red (0.0 having no red at all), this effect considers pixel component value 0.5 to cause no displacement at all. Values above 0.5 shift pixels to the left, values below 0.5 do the shift to the right. In a similar way, green channel values above 0.5 displace the pixels upwards, and values below 0.5 shift the pixels downwards. The actual amount of displacement in pixels depends on the displacement property."
            }

            SecondColumnLayout {

                UrlChooser {
                    backendValue: backendValues.displaceDisplacementSourceUrl
                    enabled: comboBox_displaceDisplacementSourceUrl.currentIndex === 0
                }
                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Source Item"
                tooltip: "Set this to use an item in the scene as Source instead of the above image."
            }

            SecondColumnLayout {
                ItemFilterComboBox {
                    id: comboBox_displaceDisplacementSourceUrl
                    backendValue: backendValues.displaceDisplacementSource
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Displacement"
                tooltip: "This property defines the scale for the displacement. The bigger scale, the bigger the displacement of the pixels. The value set to 0.0 causes no displacement.\n\nThe value ranges from -1.0 (inverted maximum shift, according to displacementSource) to 1.0 (maximum shift, according to displacementSource). By default, the property is set to 0.0 (no displacement)."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: -1
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.displaceDisplacement
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }
        }
    }
}
