import QtQuick 2.8
import QtQuick.Studio.Components 1.0
import QtQuick.Timeline 1.0
import backend 1.0

Item {
    id: spinIcon
    width: 197
    height: 133
    state: "washing"

    SvgPathItem {
        id: frame
        x: 0
        y: 0
        width: 197
        height: 133
        fillColor: "#ffffff"
        strokeWidth: 1
        strokeColor: "transparent"
        path: "M 185.5974587496495 4.7210499561906625 C 186.17714240289519 1.5429677789503073 189.36542052533548 -0.4794481729177819 192.26383879156398 0.09838496629140854 C 195.45209902638058 0.676218105500599 197.4809757706653 3.854299911418146 196.90129211741962 6.743465501371867 L 175.45300688489752 118.55417403061972 C 174.00379775178328 127.22167051756827 167.04758809225893 133 158.64217497823105 133 L 38.64766131174639 133 C 30.242248197718503 133 22.996204519661024 127.2216693859178 21.54699538654678 118.84308892043066 L 0.09870004787220152 7.032382654483732 C -0.4809836053734964 3.854300477243377 1.547909207604934 0.676218105500599 4.73616944242154 0.09838496629140854 C 7.9244296772381455 -0.4794481729177819 11.112689344193681 1.5429677789503073 11.69237299743938 4.7210499561906625 L 33.1406673157386 116.53176074873943 C 33.72035096898429 119.13200975140651 36.03908387838388 121.15442614532557 38.93750214461237 121.15442614532557 L 158.9320294397627 121.15442614532557 C 161.83044770599116 121.15442614532557 164.14918061539078 119.13200975140651 164.72886426863647 116.53176074873943 L 185.5974587496495 4.7210499561906625 Z"
    }

    Item {
        id: mask
        width: 200
        height: 200
        anchors.bottom: parent.bottom
        clip: true
        anchors.bottomMargin: -67

        SvgPathItem {
            id: water
            x: 13
            y: 11
            width: 171
            height: 111
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 78
            fillColor: "#4268ef"
            strokeWidth: 1
            strokeColor: "transparent"
            path: "M 0 0 L 171 0 L 152 103 C 151.83333332836628 105.5 150.30000019073486 110.5 145.5 110.5 C 140.69999980926514 110.5 64.5 110.5 27 110.5 C 25.5 110.66666667163372 22.200000047683716 110 21 106 C 19.799999952316284 102 6.5 33.66666793823242 0 0 Z"
        }
    }

    SvgPathItem {
        id: spin
        x: 58
        y: 20
        width: 82
        height: 87
        fillColor: "#ffffff"
        strokeWidth: 1
        strokeColor: "transparent"
        path: "M 80.67673110583523 13.543316394949287 C 82.44109414468649 15.315513479885785 82.44109414468649 17.973808381076196 80.67673110583523 19.746005466012697 C 78.91236806698397 21.518202550949198 76.26582528335348 21.518202550949198 74.50146224450222 19.746005466012697 C 58.842740718358904 4.017756782832793 31.274569698748085 5.346904365466969 16.93912022169646 23.733449270226988 C 3.485852461253394 40.79084553604107 7.67621482641233 63.386359722380874 22.452754635947084 72.91191933449737 C 30.833478840443803 78.22851072134584 42.74292885973246 79.3361320343807 52.66747080538359 75.7917378645077 C 63.25364930140171 72.02581900950302 69.64946648390321 63.386360778692634 69.64946648390321 50.98098158025405 C 69.64946648390321 40.56932428392261 65.2385589525027 33.923583729972336 57.51947077255183 30.157664874967658 C 51.12365464169264 27.056320075358013 42.96347350015287 26.613269120627017 38.11147511044809 28.60699075865622 C 26.42256973157984 33.03748340497798 24.217118069164204 41.89847081024503 27.52529871771458 51.867079264469 C 29.289661756565838 57.4051950723712 35.9060229222113 61.6141647500679 42.96347507761633 60.063492350263076 C 49.57983637471708 58.73434450355096 52.0058363583012 55.41147501880963 52.0058363583012 51.20250705761955 C 52.0058363583012 47.21506378156114 48.477108440224654 43.89219244827424 42.742928859732466 46.3289634565668 C 40.53747509403222 47.21506199903504 37.8909297470236 46.1074379792013 37.00874822759797 43.89219165604042 C 36.12656670817234 41.676945332879534 37.22929444548184 39.018653138488006 39.43474821118209 38.13255459601976 C 51.78528908877503 33.03748815838091 61.048197638986075 41.45542302444932 61.048197638986075 51.20250705761955 C 61.048197638986075 59.39891855894599 55.7551062876924 66.48770663461404 44.948382625432714 68.9244776429066 C 33.259477246564465 71.36124865119915 22.673300853830956 64.71550730501505 19.36512020528058 54.96842327184482 C 14.733667507638515 40.79084659235283 18.26239332243045 26.613269384704957 35.24438689766546 20.410579785485666 C 42.52238421931205 17.752284092061434 53.10856218950902 18.195334782714486 61.70983208606846 22.404302743904573 C 72.29601058208658 27.499369181543422 78.69182776458808 37.46798027654679 78.69182776458808 51.20250705761955 C 78.69182776458808 67.37380563921869 69.87000954686016 79.33612701689982 55.75510523605009 84.43119345453867 C 43.40456435845715 88.86168610086044 28.407481485965448 87.53254485609683 17.821302989947327 80.66528146556045 C -1.366144350987927 68.25990226712187 -6.659234650639297 39.46169900971865 9.88166859211258 18.195333462324783 C 27.745844935598456 -4.4001786113915 61.48928376489998 -5.950851671391174 80.67673110583523 13.543316394949287 Z"
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: spinAnimation
                loops: 1
                running: true
                duration: 1000
                to: 1000
                from: 0
            }
        ]
        enabled: true
        endFrame: 1000
        startFrame: 0

        KeyframeGroup {
            target: spin
            property: "rotation"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 360
                frame: 1000
            }
        }

        KeyframeGroup {
            target: mask
            property: "height"
            Keyframe {
                value: 200
                frame: 0
            }

            Keyframe {
                value: 73
                frame: 1000
            }
        }
    }
    states: [
        State {
            name: "washing"
            when: !BackendObject.waterActive

            PropertyChanges {
                target: spin
                visible: false
            }

            PropertyChanges {
                target: frame
                visible: true
            }

            PropertyChanges {
                target: water
                visible: true
            }
        },
        State {
            name: "draining"
            when: BackendObject.waterActive

            PropertyChanges {
                target: spin
                visible: true
                rotation: 360
            }

            PropertyChanges {
                target: water
                visible: true
            }

            PropertyChanges {
                target: frame
                visible: true
            }

            PropertyChanges {
                target: timeline
                enabled: true
            }

            PropertyChanges {
                target: spinAnimation
                running: true
            }

            PropertyChanges {
                target: mask
                x: 0
                y: 127
                width: 200
                height: 73
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;height:133;width:197}D{i:1;uuid:"3c9534f2-3216-5cac-87f7-298459d10bd3"}D{i:3;uuid:"fa8d21d4-ee0f-5797-8ab1-526b3e725ba3"}
D{i:2}D{i:4;uuid:"ca46511f-6852-5e8c-9abe-82f50252c1a8"}D{i:5}
}
##^##*/

