/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.sra.SRAAccession;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;

abstract class InputResource {
    private final Type type;

    protected InputResource(Type type) {
        this.type = type;
    }

    final Type type() {
        return this.type;
    }

    abstract File asFile();

    abstract Path asPath();

    abstract URL asUrl();

    abstract SeekableStream asUnbufferedSeekableStream();

    abstract InputStream asUnbufferedInputStream();

    abstract SRAAccession asSRAAccession();

    public String toString() {
        String childToString;
        switch (this.type()) {
            case FILE: {
                childToString = this.asFile().toString();
                break;
            }
            case PATH: {
                childToString = this.asPath().toString();
                break;
            }
            case INPUT_STREAM: {
                childToString = this.asUnbufferedInputStream().toString();
                break;
            }
            case SEEKABLE_STREAM: {
                childToString = this.asUnbufferedSeekableStream().toString();
                break;
            }
            case URL: {
                childToString = this.asUrl().toString();
                break;
            }
            case SRA_ACCESSION: {
                childToString = this.asSRAAccession().toString();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return String.format("%s:%s", new Object[]{this.type(), childToString});
    }

    static enum Type {
        FILE,
        PATH,
        URL,
        SEEKABLE_STREAM,
        INPUT_STREAM,
        SRA_ACCESSION;

    }
}

