/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.copy;

import com.github.benmanes.caffeine.jcache.copy.Copier;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;

public abstract class AbstractCopier<A>
implements Copier {
    private static final Map<Class<?>, Function<Object, Object>> JAVA_DEEP_COPY;
    private static final Set<Class<?>> JAVA_IMMUTABLE;
    private final Set<Class<?>> immutableClasses;
    private final Map<Class<?>, Function<Object, Object>> deepCopyStrategies;

    protected AbstractCopier() {
        this(AbstractCopier.javaImmutableClasses(), AbstractCopier.javaDeepCopyStrategies());
    }

    protected AbstractCopier(Set<Class<?>> immutableClasses, Map<Class<?>, Function<Object, Object>> deepCopyStrategies) {
        this.immutableClasses = Objects.requireNonNull(immutableClasses);
        this.deepCopyStrategies = Objects.requireNonNull(deepCopyStrategies);
    }

    public static Set<Class<?>> javaImmutableClasses() {
        return JAVA_IMMUTABLE;
    }

    public static Map<Class<?>, Function<Object, Object>> javaDeepCopyStrategies() {
        return JAVA_DEEP_COPY;
    }

    @Override
    public <T> T copy(T object, ClassLoader classLoader) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(classLoader);
        if (this.isImmutable(object.getClass())) {
            return object;
        }
        if (this.canDeeplyCopy(object.getClass())) {
            return this.deepCopy(object);
        }
        if (this.isArrayOfImmutableTypes(object.getClass())) {
            return AbstractCopier.arrayCopy(object);
        }
        return this.roundtrip(object, classLoader);
    }

    protected boolean isImmutable(Class<?> clazz) {
        return this.immutableClasses.contains(clazz) || clazz.isEnum();
    }

    protected boolean canDeeplyCopy(Class<?> clazz) {
        return this.deepCopyStrategies.containsKey(clazz);
    }

    private boolean isArrayOfImmutableTypes(Class<?> clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        Class<?> component = clazz.getComponentType();
        return component.isPrimitive() || this.isImmutable(component);
    }

    private static <T> T arrayCopy(T object) {
        int length = Array.getLength(object);
        Object copy = Array.newInstance(object.getClass().getComponentType(), length);
        System.arraycopy(object, 0, copy, 0, length);
        return (T)copy;
    }

    private <T> T deepCopy(T object) {
        Object copy = this.deepCopyStrategies.get(object.getClass()).apply(object);
        return (T)copy;
    }

    protected <T> T roundtrip(T object, ClassLoader classLoader) {
        A data = this.serialize(object);
        Object copy = this.deserialize(data, classLoader);
        return (T)copy;
    }

    protected abstract A serialize(Object var1);

    protected abstract Object deserialize(A var1, ClassLoader var2);

    static {
        JAVA_IMMUTABLE = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Short.class, Integer.class, Long.class, BigInteger.class, BigDecimal.class, String.class, Class.class, UUID.class, URL.class, URI.class, Pattern.class, Inet4Address.class, Inet6Address.class, InetSocketAddress.class, LocalDate.class, LocalTime.class, LocalDateTime.class, Instant.class, Duration.class)));
        HashMap<Class, Function<Object, Object>> strategies = new HashMap<Class, Function<Object, Object>>();
        strategies.put(Calendar.class, o -> ((Calendar)o).clone());
        strategies.put(Date.class, o -> ((Date)o).clone());
        JAVA_DEEP_COPY = Collections.unmodifiableMap(strategies);
    }
}

