/*
 * Decompiled with CFR 0.152.
 */
package org.omegat;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public final class CLIParameters {
    protected static final Pattern PARAM = Pattern.compile("\\-\\-([A-Za-z\\-]+)(=(.+))?");
    public static final String HELP_SHORT = "-h";
    public static final String HELP = "--help";
    public static final String PROJECT_DIR = "project";
    public static final String REMOTE_PROJECT = "remote-project";
    public static final String MODE = "mode";
    public static final String CONFIG_FILE = "config-file";
    public static final String RESOURCE_BUNDLE = "resource-bundle";
    public static final String CONFIG_DIR = "config-dir";
    public static final String DISABLE_PROJECT_LOCKING = "disable-project-locking";
    public static final String DISABLE_LOCATION_SAVE = "disable-location-save";
    public static final String NO_TEAM = "no-team";
    public static final String TOKENIZER_SOURCE = "ITokenizer";
    public static final String TOKENIZER_TARGET = "ITokenizerTarget";
    public static final String ALTERNATE_FILENAME_FROM = "alternate-filename-from";
    public static final String ALTERNATE_FILENAME_TO = "alternate-filename-to";
    public static final String QUIET = "quiet";
    public static final String SCRIPT = "script";
    public static final String TAG_VALIDATION = "tag-validation";
    public static final String SOURCE_PATTERN = "source-pattern";
    public static final String PSEUDOTRANSLATETMX = "pseudotranslatetmx";
    public static final String PSEUDOTRANSLATETYPE = "pseudotranslatetype";
    public static final String ALIGNDIR = "alignDir";
    public static final String STATS_OUTPUT = "output-file";
    public static final String STATS_MODE = "stats-type";
    public static final String DEV_MANIFESTS = "dev-manifests";
    public static final String TEAM_TOOL = "team";

    private CLIParameters() {
    }

    private static String normalize(String s) {
        return s.toUpperCase(Locale.ENGLISH).replace('-', '_');
    }

    static TreeMap<String, String> parseArgs(String ... args) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (String arg : args) {
            Matcher m = PARAM.matcher(arg = StringUtil.normalizeUnicode(arg));
            if (m.matches()) {
                params.put(m.group(1), m.group(3));
                continue;
            }
            if (arg.startsWith("resource-bundle=")) {
                params.put(RESOURCE_BUNDLE, arg.substring(RESOURCE_BUNDLE.length() + 1));
                continue;
            }
            File f = new File(arg).getAbsoluteFile();
            if (f.getName().equals("omegat.project")) {
                f = f.getParentFile();
            }
            if (!StaticUtils.isProjectDir(f)) continue;
            params.put(PROJECT_DIR, f.getPath());
        }
        return params;
    }

    static List<String> unparseArgs(Map<String, String> args) {
        return args.entrySet().stream().filter(e -> !((String)e.getKey()).equals(PROJECT_DIR)).map(e -> {
            if (e.getValue() == null) {
                return "--" + (String)e.getKey();
            }
            return "--" + (String)e.getKey() + "=" + (String)e.getValue();
        }).collect(Collectors.toList());
    }

    public static enum TAG_VALIDATION_MODE {
        IGNORE,
        WARN,
        ABORT;


        public static TAG_VALIDATION_MODE parse(String s) {
            try {
                return TAG_VALIDATION_MODE.valueOf(CLIParameters.normalize(s));
            }
            catch (Exception ex) {
                return IGNORE;
            }
        }
    }

    public static enum PSEUDO_TRANSLATE_TYPE {
        EQUAL,
        EMPTY;


        public static PSEUDO_TRANSLATE_TYPE parse(String s) {
            try {
                return PSEUDO_TRANSLATE_TYPE.valueOf(CLIParameters.normalize(s));
            }
            catch (Exception ex) {
                return EQUAL;
            }
        }
    }

    static enum RUN_MODE {
        GUI,
        CONSOLE_TRANSLATE,
        CONSOLE_CREATEPSEUDOTRANSLATETMX,
        CONSOLE_ALIGN,
        CONSOLE_STATS;


        public static RUN_MODE parse(String s) {
            try {
                return RUN_MODE.valueOf(CLIParameters.normalize(s));
            }
            catch (Exception ex) {
                return GUI;
            }
        }
    }
}

