/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.omegat.gui.editor.ViewLabel;

public class ViewParagraph
extends ParagraphView {
    public ViewParagraph(Element elem) {
        super(elem);
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (this.isOutside(e)) {
            return;
        }
        super.removeUpdate(e, a, f);
        this.resetBreakSpots();
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (this.isOutside(e)) {
            return;
        }
        super.insertUpdate(e, a, f);
        this.resetBreakSpots();
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (this.isOutside(e)) {
            return;
        }
        super.changedUpdate(e, a, f);
        this.resetBreakSpots();
    }

    private boolean isOutside(DocumentEvent e) {
        return e.getOffset() + e.getLength() < this.getStartOffset() || this.getEndOffset() < e.getOffset();
    }

    private void resetBreakSpots() {
        for (int i = 0; i < this.layoutPool.getViewCount(); ++i) {
            View v = this.layoutPool.getView(i);
            if (!(v instanceof ViewLabel)) continue;
            ((ViewLabel)v).resetBreakSpots();
        }
    }
}

