/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.api.zzi;
import com.google.android.gms.common.api.zzm;
import com.google.android.gms.common.api.zzn;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.Client, R extends Result, T extends zza.zza<R, A>> T zza(T var1);

    public <A extends Api.Client, T extends zza.zza<? extends Result, A>> T zzb(T var1);

    public <L> zzi<L> zzo(L var1);

    public <C extends Api.Client> C zza(Api.ClientKey<C> var1);

    public boolean zza(Api<?> var1);

    public boolean hasConnectedApi(Api<?> var1);

    public ConnectionResult getConnectionResult(Api<?> var1);

    public boolean zza(Scope var1);

    public Context getContext();

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public PendingResult<Status> clearDefaultAccountAndReconnect();

    public void stopAutoManage(FragmentActivity var1);

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public int getSessionId();

    public static final class Builder {
        private Account zzMY;
        private final Set<Scope> zzWv = new HashSet<Scope>();
        private int zzWw;
        private View zzWx;
        private String zzOe;
        private String zzOd;
        private final Map<Api<?>, zze.zza> zzWy = new HashMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzWz = new HashMap();
        private FragmentActivity zzWA;
        private int zzWB = -1;
        private int zzWC = -1;
        private OnConnectionFailedListener zzWD;
        private Looper zzWt;
        private Api.zza<? extends zzps, zzpt> zzWE;
        private final Set<ConnectionCallbacks> zzWF = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> zzWG = new HashSet<OnConnectionFailedListener>();
        private zzpt.zza zzWH = new zzpt.zza();

        public Builder(Context context) {
            this.mContext = context;
            this.zzWt = context.getMainLooper();
            this.zzOe = context.getPackageName();
            this.zzOd = context.getClass().getName();
            this.zzWE = zzpq.zzNY;
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            zzu.zzb(connectedListener, (Object)"Must provide a connected listener");
            this.zzWF.add(connectedListener);
            zzu.zzb(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzWG.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            zzu.zzb(handler, (Object)"Handler must not be null");
            this.zzWt = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.zzWF.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.zzWG.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.zzWx = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.zzWv.add(scope);
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.zzWz.put(api, null);
            this.zzWv.addAll(api.zzmr());
            return this;
        }

        public Builder addApiIfAvailable(Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopes) {
            this.zzWz.put(api, null);
            this.zza(api, 1, scopes);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            zzu.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzWz.put(api, options);
            this.zzWv.addAll(api.zzmr());
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(Api<O> api, O options, Scope ... scopes) {
            zzu.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzWz.put(api, options);
            this.zza(api, 1, scopes);
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.zzMY = accountName == null ? null : new Account(accountName, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.zzWw = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, int clientId, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            zzu.zzb(clientId >= 0, (Object)"clientId must be non-negative");
            this.zzWB = clientId;
            this.zzWA = zzu.zzb(fragmentActivity, (Object)"Null activity is not permitted.");
            this.zzWD = unresolvedConnectionFailedListener;
            return this;
        }

        public Builder requestServerAuthCode(String serverClientId, ServerAuthCodeCallbacks callbacks) {
            this.zzWH.zza(serverClientId, callbacks);
            return this;
        }

        public zze zzmx() {
            return new zze(this.zzMY, this.zzWv, this.zzWy, this.zzWw, this.zzWx, this.zzOe, this.zzOd, this.zzWH.zzyc());
        }

        public GoogleApiClient build() {
            zzu.zzb(!this.zzWz.isEmpty(), (Object)"must call addApi() to add at least one API");
            if (this.zzWB >= 0) {
                return this.zzmy();
            }
            if (this.zzWC >= 0) {
                return this.zzmz();
            }
            return new zzg(this.mContext, this.zzWt, this.zzmx(), this.zzWE, this.zzWz, this.zzWF, this.zzWG, -1, -1);
        }

        private GoogleApiClient zzmy() {
            zzm zzm2 = zzm.zza(this.zzWA);
            zzg zzg2 = new zzg(this.mContext.getApplicationContext(), this.zzWt, this.zzmx(), this.zzWE, this.zzWz, this.zzWF, this.zzWG, this.zzWB, -1);
            zzm2.zza(this.zzWB, zzg2, this.zzWD);
            return zzg2;
        }

        private GoogleApiClient zzmz() {
            zzn zzn2 = zzn.zzb(this.zzWA);
            GoogleApiClient googleApiClient = zzn2.zzbc(this.zzWC);
            if (googleApiClient == null) {
                googleApiClient = new zzg(this.mContext.getApplicationContext(), this.zzWt, this.zzmx(), this.zzWE, this.zzWz, this.zzWF, this.zzWG, -1, this.zzWC);
            }
            zzn2.zza(this.zzWC, googleApiClient, this.zzWD);
            return googleApiClient;
        }

        private void zza(Api<?> api, int n, Scope ... scopeArray) {
            boolean bl;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            } else {
                throw new IllegalArgumentException("Invalid resolution mode: '" + n + "', use a constant from GoogleApiClient.ResolutionMode");
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzmr());
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.zzWy.put(api, new zze.zza(hashSet, bl));
        }
    }

    public static interface ConnectionProgressReportCallbacks {
        public void onReportServiceBinding(ConnectionResult var1);

        public void onReportAccountValidation(ConnectionResult var1);
    }

    public static interface ServerAuthCodeCallbacks {
        public CheckResult onCheckServerAuthorization(String var1, Set<Scope> var2);

        public boolean onUploadServerAuthCode(String var1, String var2);

        public static class CheckResult {
            private boolean zzWI;
            private Set<Scope> zzWJ;

            public static CheckResult newAuthNotRequiredResult() {
                return new CheckResult(false, null);
            }

            public static CheckResult newAuthRequiredResult(Set<Scope> requiredScopes) {
                zzu.zzb(requiredScopes != null && !requiredScopes.isEmpty(), (Object)"A non-empty scope set is required if further auth is needed.");
                return new CheckResult(true, requiredScopes);
            }

            private CheckResult(boolean requiresNewAuthCode, Set<Scope> requiredScopes) {
                this.zzWI = requiresNewAuthCode;
                this.zzWJ = requiredScopes;
            }

            public boolean zzmA() {
                return this.zzWI;
            }

            public Set<Scope> zzmB() {
                return this.zzWJ;
            }
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

