/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.ValidateAccountRequest;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzo;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzu;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzi<T extends IInterface>
implements Api.Client,
zzj.zza {
    private final Context mContext;
    private final com.google.android.gms.common.internal.zze zzXa;
    private final Looper zzWt;
    private final zzk zzaak;
    final Handler mHandler;
    private final Object zzqt = new Object();
    private zzp zzaal;
    private GoogleApiClient.ConnectionProgressReportCallbacks zzaam;
    private T zzaan;
    private final ArrayList<zzc<?>> zzaao = new ArrayList();
    private zze zzaap;
    private int zzaaq = 1;
    private final Set<Scope> zzWJ;
    private final Account zzMY;
    private GoogleApiClient.ConnectionCallbacks zzaar;
    private GoogleApiClient.OnConnectionFailedListener zzaas;
    private final int zzaat;
    protected AtomicInteger zzaau = new AtomicInteger(0);
    public static final String[] zzaav = new String[]{"service_esmobile", "service_googleme"};

    @Deprecated
    protected zzi(Context context, Looper looper, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.mContext = zzu.zzu(context);
        this.zzWt = zzu.zzb(looper, (Object)"Looper must not be null");
        this.zzaak = zzk.zzah(context);
        this.mHandler = new zzb(looper);
        this.zzaat = n;
        this.zzMY = null;
        this.zzWJ = Collections.emptySet();
        this.zzXa = new GoogleApiClient.Builder(context).zzmx();
        this.zzaar = zzu.zzu(connectionCallbacks);
        this.zzaas = zzu.zzu(onConnectionFailedListener);
    }

    protected zzi(Context context, Looper looper, int n, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, com.google.android.gms.common.internal.zze zze2) {
        this(context, looper, zzk.zzah(context), n, zze2, connectionCallbacks, onConnectionFailedListener);
    }

    protected zzi(Context context, Looper looper, zzk zzk2, int n, com.google.android.gms.common.internal.zze zze2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, zzk2, n, zze2);
        this.zzaar = zzu.zzu(connectionCallbacks);
        this.zzaas = zzu.zzu(onConnectionFailedListener);
    }

    protected zzi(Context context, Looper looper, zzk zzk2, int n, com.google.android.gms.common.internal.zze zze2) {
        this.mContext = zzu.zzb(context, (Object)"Context must not be null");
        this.zzWt = zzu.zzb(looper, (Object)"Looper must not be null");
        this.zzaak = zzu.zzb(zzk2, (Object)"Supervisor must not be null");
        this.mHandler = new zzb(looper);
        this.zzaat = n;
        this.zzXa = zzu.zzu(zze2);
        this.zzMY = zze2.getAccount();
        this.zzWJ = this.zzb(zze2.zznw());
    }

    private Set<Scope> zzb(Set<Scope> set) {
        Set<Scope> set2 = this.zza(set);
        if (set2 == null) {
            return set2;
        }
        for (Scope scope : set2) {
            if (set.contains(scope)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return set2;
    }

    protected Set<Scope> zza(Set<Scope> set) {
        return set;
    }

    protected abstract String getStartServiceAction();

    protected abstract String getServiceDescriptor();

    protected String zzkQ() {
        return this.zzXa.zznz();
    }

    protected abstract T zzT(IBinder var1);

    protected void zznG() {
    }

    protected void onConnectionSuspended(int cause) {
    }

    protected void onConnectionFailed(ConnectionResult result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(int n, T t) {
        zzu.zzV(n == 3 == (t != null));
        Object object = this.zzqt;
        synchronized (object) {
            this.zzaaq = n;
            this.zzaan = t;
            switch (n) {
                case 2: {
                    this.zznH();
                    break;
                }
                case 3: {
                    this.zznG();
                    break;
                }
                case 1: {
                    this.zznI();
                }
            }
        }
    }

    private void zznH() {
        if (this.zzaap != null) {
            Log.e((String)"GmsClient", (String)("Calling connect() while still connected, missing disconnect() for " + this.getStartServiceAction()));
            this.zzaak.zzb(this.getStartServiceAction(), (ServiceConnection)this.zzaap, this.zzkQ());
            this.zzaau.incrementAndGet();
        }
        this.zzaap = new zze(this.zzaau.get());
        boolean bl = this.zzaak.zza(this.getStartServiceAction(), (ServiceConnection)this.zzaap, this.zzkQ());
        if (!bl) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.getStartServiceAction()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzaau.get(), 9));
        }
    }

    private void zznI() {
        if (this.zzaap != null) {
            this.zzaak.zzb(this.getStartServiceAction(), (ServiceConnection)this.zzaap, this.zzkQ());
            this.zzaap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzaaq != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    public void zznJ() {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zza(1, null);
            this.zzaam = new zzf();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzaau.get(), n));
            return;
        }
        this.connect(new zzf());
    }

    @Override
    public void connect(GoogleApiClient.ConnectionProgressReportCallbacks callbacks) {
        this.zza(callbacks);
        this.zza(2, null);
    }

    private void zza(GoogleApiClient.ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        this.zzaam = zzu.zzb(connectionProgressReportCallbacks, (Object)"Connection progress callbacks cannot be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzaaq == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        Object object = this.zzqt;
        synchronized (object) {
            return this.zzaaq == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzaau.incrementAndGet();
        ArrayList<zzc<?>> arrayList = this.zzaao;
        synchronized (arrayList) {
            int n = this.zzaao.size();
            for (int i = 0; i < n; ++i) {
                this.zzaao.get(i).zznR();
            }
            this.zzaao.clear();
        }
        this.zza(1, null);
    }

    public void zzbs(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.zzaau.get(), n));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzWt;
    }

    public final Account zznt() {
        return this.zzMY != null ? this.zzMY : new Account("<<default account>>", "com.google");
    }

    protected final com.google.android.gms.common.internal.zze zznK() {
        return this.zzXa;
    }

    protected Bundle zzkR() {
        return new Bundle();
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzg(n, iBinder, bundle)));
    }

    protected void zza(int n, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzi(n, bundle)));
    }

    protected void zzbt(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, n, -1, (Object)new zzh()));
    }

    protected final void zznL() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle zzlM() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zznM() throws DeadObjectException {
        Object object = this.zzqt;
        synchronized (object) {
            if (this.zzaaq == 4) {
                throw new DeadObjectException();
            }
            this.zznL();
            zzu.zza(this.zzaan != null, (Object)"Client is connected but service is null");
            return this.zzaan;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void zza(zzc<?> zzc2) {
        ArrayList<zzc<?>> arrayList = this.zzaao;
        synchronized (arrayList) {
            this.zzaao.add(zzc2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, this.zzaau.get(), -1, zzc2));
    }

    @Override
    public void validateAccount(IAccountAccessor resolvedAccountAccessor) {
        Bundle bundle = this.zznN();
        ValidateAccountRequest validateAccountRequest = new ValidateAccountRequest(resolvedAccountAccessor, this.zzWJ.toArray(new Scope[this.zzWJ.size()]), this.mContext.getPackageName(), bundle);
        try {
            this.zzaal.zza((zzo)new zzd(this, this.zzaau.get()), validateAccountRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbs(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    protected Bundle zznN() {
        return null;
    }

    @Override
    public void getRemoteService(IAccountAccessor authedAccountAccessor, Set<Scope> scopes) {
        try {
            Bundle bundle = this.zzkR();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzaat).zzcb(this.mContext.getPackageName()).zzf(bundle);
            if (scopes != null) {
                getServiceRequest.zzb(scopes);
            }
            if (this.requiresSignIn()) {
                getServiceRequest.zzb(this.zznt()).zzb(authedAccountAccessor);
            } else if (this.requiresAccount()) {
                getServiceRequest.zzb(this.zzMY);
            }
            this.zzaal.zza((zzo)new zzd(this, this.zzaau.get()), getServiceRequest);
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbs(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    @Override
    public boolean requiresSignIn() {
        return false;
    }

    @Override
    public boolean requiresAccount() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        T t;
        int n;
        Object object = this.zzqt;
        synchronized (object) {
            n = this.zzaaq;
            t = this.zzaan;
        }
        writer.append(prefix).append("mConnectState=");
        switch (n) {
            case 2: {
                writer.print("CONNECTING");
                break;
            }
            case 3: {
                writer.print("CONNECTED");
                break;
            }
            case 4: {
                writer.print("DISCONNECTING");
                break;
            }
            case 1: {
                writer.print("DISCONNECTED");
                break;
            }
            default: {
                writer.print("UNKNOWN");
            }
        }
        writer.append(" mService=");
        if (t == null) {
            writer.println("null");
        } else {
            writer.append(this.getServiceDescriptor()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
    }

    public static final class zzd
    extends zzo.zza {
        private zzi zzaaz;
        private final int zzaaA;

        public zzd(zzi zzi2, int n) {
            this.zzaaz = zzi2;
            this.zzaaA = n;
        }

        @Override
        public void zzb(int n, Bundle bundle) {
            zzu.zzb(this.zzaaz, (Object)"onAccountValidationComplete can be called only once per call to validateAccount");
            this.zzaaz.zza(n, bundle, this.zzaaA);
            this.zznS();
        }

        @Override
        public void zza(int n, IBinder iBinder, Bundle bundle) {
            zzu.zzb(this.zzaaz, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzaaz.zza(n, iBinder, bundle, this.zzaaA);
            this.zznS();
        }

        private void zznS() {
            this.zzaaz = null;
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        public final int statusCode;
        public final Bundle zzaaw;

        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzaaw = bundle;
        }

        protected abstract boolean zznO();

        protected abstract void zzg(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzi.this.zza(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zznO()) break;
                    zzi.this.zza(1, null);
                    this.zzg(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzi.this.zza(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzi.this.zza(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.zzaaw != null) {
                        pendingIntent = (PendingIntent)this.zzaaw.getParcelable("pendingIntent");
                    }
                    this.zzg(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zznP() {
        }

        @Override
        protected /* synthetic */ void zzr(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzg
    extends zza {
        public final IBinder zzaaB;

        public zzg(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzaaB = iBinder;
        }

        @Override
        protected void zzg(ConnectionResult connectionResult) {
            if (zzi.this.zzaas != null) {
                zzi.this.zzaas.onConnectionFailed(connectionResult);
            }
            zzi.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zznO() {
            String string2;
            try {
                string2 = this.zzaaB.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzi.this.getServiceDescriptor().equals(string2)) {
                Log.e((String)"GmsClient", (String)("service descriptor mismatch: " + zzi.this.getServiceDescriptor() + " vs. " + string2));
                return false;
            }
            Object t = zzi.this.zzT(this.zzaaB);
            if (t != null && zzi.this.zza(2, 3, t)) {
                Bundle bundle = zzi.this.zzlM();
                if (zzi.this.zzaar != null) {
                    zzi.this.zzaar.onConnected(bundle);
                }
                GooglePlayServicesUtil.zzac(zzi.this.mContext);
                return true;
            }
            return false;
        }
    }

    protected final class zzi
    extends zza {
        public zzi(int n, Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzg(ConnectionResult connectionResult) {
            zzi.this.zzaam.onReportAccountValidation(connectionResult);
            zzi.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zznO() {
            zzi.this.zzaam.onReportAccountValidation(ConnectionResult.zzVG);
            return true;
        }
    }

    protected final class zzh
    extends zza {
        public zzh() {
            super(0, null);
        }

        @Override
        protected void zzg(ConnectionResult connectionResult) {
            zzi.this.zzaam.onReportServiceBinding(connectionResult);
            zzi.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zznO() {
            zzi.this.zzaam.onReportServiceBinding(ConnectionResult.zzVG);
            return true;
        }
    }

    protected class zzf
    implements GoogleApiClient.ConnectionProgressReportCallbacks {
        @Override
        public void onReportServiceBinding(ConnectionResult result) {
            if (result.isSuccess()) {
                zzi.this.getRemoteService(null, zzi.this.zzWJ);
            } else if (zzi.this.zzaas != null) {
                zzi.this.zzaas.onConnectionFailed(result);
            }
        }

        @Override
        public void onReportAccountValidation(ConnectionResult result) {
            throw new IllegalStateException("Legacy GmsClient received onReportAccountValidation callback.");
        }
    }

    protected abstract class zzc<TListener> {
        private TListener mListener;
        private boolean zzaay;

        public zzc(TListener TListener) {
            this.mListener = TListener;
            this.zzaay = false;
        }

        protected abstract void zzr(TListener var1);

        protected abstract void zznP();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zznQ() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.mListener;
                if (this.zzaay) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.zzr(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zznP();
                    throw runtimeException;
                }
            } else {
                this.zznP();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzaay = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zznR();
            ArrayList arrayList = zzi.this.zzaao;
            synchronized (arrayList) {
                zzi.this.zzaao.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zznR() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.mListener = null;
            }
        }
    }

    final class zzb
    extends Handler {
        public zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (zzi.this.zzaau.get() != msg.arg1) {
                if (this.zzb(msg)) {
                    this.zza(msg);
                }
                return;
            }
            if (!(msg.what != 1 && msg.what != 5 && msg.what != 6 || zzi.this.isConnecting())) {
                this.zza(msg);
                return;
            }
            if (msg.what == 3) {
                ConnectionResult connectionResult = new ConnectionResult(msg.arg2, null);
                zzi.this.zzaam.onReportServiceBinding(connectionResult);
                zzi.this.onConnectionFailed(connectionResult);
                return;
            }
            if (msg.what == 4) {
                zzi.this.zza(4, null);
                if (zzi.this.zzaar != null) {
                    zzi.this.zzaar.onConnectionSuspended(msg.arg2);
                }
                zzi.this.onConnectionSuspended(msg.arg2);
                zzi.this.zza(4, 1, null);
                return;
            }
            if (msg.what == 2 && !zzi.this.isConnected()) {
                this.zza(msg);
                return;
            }
            if (this.zzb(msg)) {
                zzc zzc2 = (zzc)msg.obj;
                zzc2.zznQ();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }

        private void zza(Message message) {
            zzc zzc2 = (zzc)message.obj;
            zzc2.zznP();
            zzc2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5 || message.what == 6;
        }
    }

    public final class zze
    implements ServiceConnection {
        private final int zzaaA;

        public zze(int n) {
            this.zzaaA = n;
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            zzu.zzb(binder, (Object)"Expecting a valid IBinder");
            zzi.this.zzaal = zzp.zza.zzaG(binder);
            zzi.this.zzbt(this.zzaaA);
        }

        public void onServiceDisconnected(ComponentName component) {
            zzi.this.mHandler.sendMessage(zzi.this.mHandler.obtainMessage(4, this.zzaaA, 1));
        }
    }
}

