/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.zzi;
import com.google.android.gms.internal.zzmh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
implements SafeParcelable {
    private final int zzCY;
    private final String mName;
    private final List<Field> zzakq;
    private final zzmh zzamk;
    private final String zzMZ;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new zzi();

    DataTypeCreateRequest(int versionCode, String name, List<Field> fields, IBinder callback, String packageName) {
        this.zzCY = versionCode;
        this.mName = name;
        this.zzakq = Collections.unmodifiableList(fields);
        this.zzamk = callback == null ? null : zzmh.zza.zzbs(callback);
        this.zzMZ = packageName;
    }

    private DataTypeCreateRequest(Builder builder) {
        this(builder.mName, builder.zzakq, null, null);
    }

    public DataTypeCreateRequest(DataTypeCreateRequest request, zzmh callback, String packageName) {
        this(request.mName, request.zzakq, callback, packageName);
    }

    public DataTypeCreateRequest(String name, List<Field> fields, zzmh callback, String packageName) {
        this.zzCY = 2;
        this.mName = name;
        this.zzakq = Collections.unmodifiableList(fields);
        this.zzamk = callback;
        this.zzMZ = packageName;
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.zzakq;
    }

    public IBinder zzqU() {
        return this.zzamk == null ? null : this.zzamk.asBinder();
    }

    public String getPackageName() {
        return this.zzMZ;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataTypeCreateRequest && this.zzb((DataTypeCreateRequest)o);
    }

    private boolean zzb(DataTypeCreateRequest dataTypeCreateRequest) {
        return zzt.equal(this.mName, dataTypeCreateRequest.mName) && zzt.equal(this.zzakq, dataTypeCreateRequest.zzakq);
    }

    public int hashCode() {
        return zzt.hashCode(this.mName, this.zzakq);
    }

    public String toString() {
        return zzt.zzt(this).zzg("name", this.mName).zzg("fields", this.zzakq).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzi.zza(this, dest, flags);
    }

    public static class Builder {
        private String mName;
        private List<Field> zzakq = new ArrayList<Field>();

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.zzakq.contains(field)) {
                this.zzakq.add(field);
            }
            return this;
        }

        public Builder addField(String name, int format) {
            zzu.zzb(name != null && !name.isEmpty(), (Object)"Invalid name specified");
            Field field = Field.zzn(name, format);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            zzu.zza(this.mName != null, (Object)"Must set the name");
            zzu.zza(!this.zzakq.isEmpty(), (Object)"Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

