// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/datacatalog/v1/datacatalog.proto

package datacatalogpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The enum field that lists all the types of entry resources in Data
// Catalog. For example, a BigQuery table entry has the `TABLE` type.
type EntryType int32

const (
	// Default unknown type.
	EntryType_ENTRY_TYPE_UNSPECIFIED EntryType = 0
	// Output only. The entry type that has a GoogleSQL schema, including
	// logical views.
	EntryType_TABLE EntryType = 2
	// Output only. The type of models.
	//
	// For more information, see [Supported models in BigQuery ML]
	// (https://cloud.google.com/bigquery-ml/docs/introduction#supported_models_in).
	EntryType_MODEL EntryType = 5
	// An entry type for streaming entries. For example, a Pub/Sub topic.
	EntryType_DATA_STREAM EntryType = 3
	// An entry type for a set of files or objects. For example, a
	// Cloud Storage fileset.
	EntryType_FILESET EntryType = 4
	// A group of servers that work together. For example, a Kafka cluster.
	EntryType_CLUSTER EntryType = 6
	// A database.
	EntryType_DATABASE EntryType = 7
	// Output only. Connection to a data source. For example, a BigQuery
	// connection.
	EntryType_DATA_SOURCE_CONNECTION EntryType = 8
	// Output only. Routine, for example, a BigQuery routine.
	EntryType_ROUTINE EntryType = 9
	// A Dataplex lake.
	EntryType_LAKE EntryType = 10
	// A Dataplex zone.
	EntryType_ZONE EntryType = 11
	// A service, for example, a Dataproc Metastore service.
	EntryType_SERVICE EntryType = 14
)

// Enum value maps for EntryType.
var (
	EntryType_name = map[int32]string{
		0:  "ENTRY_TYPE_UNSPECIFIED",
		2:  "TABLE",
		5:  "MODEL",
		3:  "DATA_STREAM",
		4:  "FILESET",
		6:  "CLUSTER",
		7:  "DATABASE",
		8:  "DATA_SOURCE_CONNECTION",
		9:  "ROUTINE",
		10: "LAKE",
		11: "ZONE",
		14: "SERVICE",
	}
	EntryType_value = map[string]int32{
		"ENTRY_TYPE_UNSPECIFIED": 0,
		"TABLE":                  2,
		"MODEL":                  5,
		"DATA_STREAM":            3,
		"FILESET":                4,
		"CLUSTER":                6,
		"DATABASE":               7,
		"DATA_SOURCE_CONNECTION": 8,
		"ROUTINE":                9,
		"LAKE":                   10,
		"ZONE":                   11,
		"SERVICE":                14,
	}
)

func (x EntryType) Enum() *EntryType {
	p := new(EntryType)
	*p = x
	return p
}

func (x EntryType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntryType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[0].Descriptor()
}

func (EntryType) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[0]
}

func (x EntryType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntryType.Descriptor instead.
func (EntryType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{0}
}

// Type of the table.
type DatabaseTableSpec_TableType int32

const (
	// Default unknown table type.
	DatabaseTableSpec_TABLE_TYPE_UNSPECIFIED DatabaseTableSpec_TableType = 0
	// Native table.
	DatabaseTableSpec_NATIVE DatabaseTableSpec_TableType = 1
	// External table.
	DatabaseTableSpec_EXTERNAL DatabaseTableSpec_TableType = 2
)

// Enum value maps for DatabaseTableSpec_TableType.
var (
	DatabaseTableSpec_TableType_name = map[int32]string{
		0: "TABLE_TYPE_UNSPECIFIED",
		1: "NATIVE",
		2: "EXTERNAL",
	}
	DatabaseTableSpec_TableType_value = map[string]int32{
		"TABLE_TYPE_UNSPECIFIED": 0,
		"NATIVE":                 1,
		"EXTERNAL":               2,
	}
)

func (x DatabaseTableSpec_TableType) Enum() *DatabaseTableSpec_TableType {
	p := new(DatabaseTableSpec_TableType)
	*p = x
	return p
}

func (x DatabaseTableSpec_TableType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseTableSpec_TableType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[1].Descriptor()
}

func (DatabaseTableSpec_TableType) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[1]
}

func (x DatabaseTableSpec_TableType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseTableSpec_TableType.Descriptor instead.
func (DatabaseTableSpec_TableType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{14, 0}
}

// The fine-grained type of the routine.
type RoutineSpec_RoutineType int32

const (
	// Unspecified type.
	RoutineSpec_ROUTINE_TYPE_UNSPECIFIED RoutineSpec_RoutineType = 0
	// Non-builtin permanent scalar function.
	RoutineSpec_SCALAR_FUNCTION RoutineSpec_RoutineType = 1
	// Stored procedure.
	RoutineSpec_PROCEDURE RoutineSpec_RoutineType = 2
)

// Enum value maps for RoutineSpec_RoutineType.
var (
	RoutineSpec_RoutineType_name = map[int32]string{
		0: "ROUTINE_TYPE_UNSPECIFIED",
		1: "SCALAR_FUNCTION",
		2: "PROCEDURE",
	}
	RoutineSpec_RoutineType_value = map[string]int32{
		"ROUTINE_TYPE_UNSPECIFIED": 0,
		"SCALAR_FUNCTION":          1,
		"PROCEDURE":                2,
	}
)

func (x RoutineSpec_RoutineType) Enum() *RoutineSpec_RoutineType {
	p := new(RoutineSpec_RoutineType)
	*p = x
	return p
}

func (x RoutineSpec_RoutineType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RoutineSpec_RoutineType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[2].Descriptor()
}

func (RoutineSpec_RoutineType) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[2]
}

func (x RoutineSpec_RoutineType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RoutineSpec_RoutineType.Descriptor instead.
func (RoutineSpec_RoutineType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{17, 0}
}

// The input or output mode of the argument.
type RoutineSpec_Argument_Mode int32

const (
	// Unspecified mode.
	RoutineSpec_Argument_MODE_UNSPECIFIED RoutineSpec_Argument_Mode = 0
	// The argument is input-only.
	RoutineSpec_Argument_IN RoutineSpec_Argument_Mode = 1
	// The argument is output-only.
	RoutineSpec_Argument_OUT RoutineSpec_Argument_Mode = 2
	// The argument is both an input and an output.
	RoutineSpec_Argument_INOUT RoutineSpec_Argument_Mode = 3
)

// Enum value maps for RoutineSpec_Argument_Mode.
var (
	RoutineSpec_Argument_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "IN",
		2: "OUT",
		3: "INOUT",
	}
	RoutineSpec_Argument_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"IN":               1,
		"OUT":              2,
		"INOUT":            3,
	}
)

func (x RoutineSpec_Argument_Mode) Enum() *RoutineSpec_Argument_Mode {
	p := new(RoutineSpec_Argument_Mode)
	*p = x
	return p
}

func (x RoutineSpec_Argument_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RoutineSpec_Argument_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[3].Descriptor()
}

func (RoutineSpec_Argument_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes[3]
}

func (x RoutineSpec_Argument_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RoutineSpec_Argument_Mode.Descriptor instead.
func (RoutineSpec_Argument_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{17, 0, 0}
}

// Request message for
// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
type SearchCatalogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The scope of this search request.
	//
	// The `scope` is invalid if `include_org_ids`, `include_project_ids` are
	// empty AND `include_gcp_public_datasets` is set to `false`. In this case,
	// the request returns an error.
	Scope *SearchCatalogRequest_Scope `protobuf:"bytes,6,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query string with a minimum of 3 characters and specific syntax.
	// For more information, see
	// [Data Catalog search
	// syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference).
	//
	// An empty query string returns all data assets (in the specified scope)
	// that you have access to.
	//
	// A query string can be a simple `xyz` or qualified by predicates:
	//
	// * `name:x`
	// * `column:y`
	// * `description:z`
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Number of results to return in a single search page.
	//
	// Can't be negative or 0, defaults to 10 in this case.
	// The maximum number is 1000. If exceeded, throws an "invalid argument"
	// exception.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Pagination token that, if specified, returns the next page of search
	// results. If empty, returns the first page.
	//
	// This token is returned in the [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1.SearchCatalogResponse.next_page_token]
	// field of the response to a previous
	// [SearchCatalogRequest][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog]
	// call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specifies the order of results.
	//
	// Currently supported case-sensitive values are:
	//
	// * `relevance` that can only be descending
	// * `last_modified_timestamp [asc|desc]` with descending (`desc`) as default
	// * `default` that can only be descending
	//
	// If this parameter is omitted, it defaults to the descending `relevance`.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *SearchCatalogRequest) Reset() {
	*x = SearchCatalogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCatalogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCatalogRequest) ProtoMessage() {}

func (x *SearchCatalogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCatalogRequest.ProtoReflect.Descriptor instead.
func (*SearchCatalogRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{0}
}

func (x *SearchCatalogRequest) GetScope() *SearchCatalogRequest_Scope {
	if x != nil {
		return x.Scope
	}
	return nil
}

func (x *SearchCatalogRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchCatalogRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchCatalogRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchCatalogRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
type SearchCatalogResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Search results.
	Results []*SearchCatalogResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Pagination token that can be used in subsequent calls to retrieve the next
	// page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable locations. Search results don't include data from those
	// locations.
	//
	// To get additional information on an error, repeat the search request and
	// restrict it to specific locations by setting the
	// `SearchCatalogRequest.scope.restricted_locations` parameter.
	Unreachable []string `protobuf:"bytes,6,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *SearchCatalogResponse) Reset() {
	*x = SearchCatalogResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCatalogResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCatalogResponse) ProtoMessage() {}

func (x *SearchCatalogResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCatalogResponse.ProtoReflect.Descriptor instead.
func (*SearchCatalogResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{1}
}

func (x *SearchCatalogResponse) GetResults() []*SearchCatalogResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchCatalogResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchCatalogResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [CreateEntryGroup][google.cloud.datacatalog.v1.DataCatalog.CreateEntryGroup].
type CreateEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The names of the project and location that the new entry group belongs to.
	//
	// Note: The entry group itself and its child resources might not be
	// stored in the location specified in its name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the entry group to create.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and must start with a letter or underscore.
	// The maximum size is 64 bytes when encoded in UTF-8.
	EntryGroupId string `protobuf:"bytes,3,opt,name=entry_group_id,json=entryGroupId,proto3" json:"entry_group_id,omitempty"`
	// The entry group to create. Defaults to empty.
	EntryGroup *EntryGroup `protobuf:"bytes,2,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
}

func (x *CreateEntryGroupRequest) Reset() {
	*x = CreateEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryGroupRequest) ProtoMessage() {}

func (x *CreateEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{2}
}

func (x *CreateEntryGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryGroupRequest) GetEntryGroupId() string {
	if x != nil {
		return x.EntryGroupId
	}
	return ""
}

func (x *CreateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if x != nil {
		return x.EntryGroup
	}
	return nil
}

// Request message for
// [UpdateEntryGroup][google.cloud.datacatalog.v1.DataCatalog.UpdateEntryGroup].
type UpdateEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Updates for the entry group. The `name` field must be set.
	EntryGroup *EntryGroup `protobuf:"bytes,1,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
	// Names of fields whose values to overwrite on an entry group.
	//
	// If this parameter is absent or empty, all modifiable fields
	// are overwritten. If such fields are non-required and omitted in the
	// request body, their values are emptied.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEntryGroupRequest) Reset() {
	*x = UpdateEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryGroupRequest) ProtoMessage() {}

func (x *UpdateEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if x != nil {
		return x.EntryGroup
	}
	return nil
}

func (x *UpdateEntryGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [GetEntryGroup][google.cloud.datacatalog.v1.DataCatalog.GetEntryGroup].
type GetEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry group to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fields to return. If empty or omitted, all fields are returned.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *GetEntryGroupRequest) Reset() {
	*x = GetEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryGroupRequest) ProtoMessage() {}

func (x *GetEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*GetEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{4}
}

func (x *GetEntryGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetEntryGroupRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Request message for
// [DeleteEntryGroup][google.cloud.datacatalog.v1.DataCatalog.DeleteEntryGroup].
type DeleteEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry group to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If true, deletes all entries in the entry group.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteEntryGroupRequest) Reset() {
	*x = DeleteEntryGroupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryGroupRequest) ProtoMessage() {}

func (x *DeleteEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteEntryGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntryGroupRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [ListEntryGroups][google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups].
type ListEntryGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the location that contains the entry groups to list.
	//
	// Can be provided as a URL.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	//
	// Default is 10. Maximum limit is 1000.
	// Throws an invalid argument if `page_size` is greater than 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Pagination token that specifies the next page to return.
	// If empty, returns the first page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEntryGroupsRequest) Reset() {
	*x = ListEntryGroupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntryGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryGroupsRequest) ProtoMessage() {}

func (x *ListEntryGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListEntryGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{6}
}

func (x *ListEntryGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntryGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntryGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ListEntryGroups][google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups].
type ListEntryGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry group details.
	EntryGroups []*EntryGroup `protobuf:"bytes,1,rep,name=entry_groups,json=entryGroups,proto3" json:"entry_groups,omitempty"`
	// Pagination token to specify in the next call to retrieve the next page of
	// results. Empty if there are no more items.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntryGroupsResponse) Reset() {
	*x = ListEntryGroupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntryGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryGroupsResponse) ProtoMessage() {}

func (x *ListEntryGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListEntryGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{7}
}

func (x *ListEntryGroupsResponse) GetEntryGroups() []*EntryGroup {
	if x != nil {
		return x.EntryGroups
	}
	return nil
}

func (x *ListEntryGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry].
type CreateEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry group this entry belongs to.
	//
	// Note: The entry itself and its child resources might not be stored in
	// the location specified in its name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the entry to create.
	//
	// The ID must contain only letters (a-z, A-Z), numbers (0-9),
	// and underscores (_).
	// The maximum size is 64 bytes when encoded in UTF-8.
	EntryId string `protobuf:"bytes,3,opt,name=entry_id,json=entryId,proto3" json:"entry_id,omitempty"`
	// Required. The entry to create.
	Entry *Entry `protobuf:"bytes,2,opt,name=entry,proto3" json:"entry,omitempty"`
}

func (x *CreateEntryRequest) Reset() {
	*x = CreateEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryRequest) ProtoMessage() {}

func (x *CreateEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{8}
}

func (x *CreateEntryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryRequest) GetEntryId() string {
	if x != nil {
		return x.EntryId
	}
	return ""
}

func (x *CreateEntryRequest) GetEntry() *Entry {
	if x != nil {
		return x.Entry
	}
	return nil
}

// Request message for
// [UpdateEntry][google.cloud.datacatalog.v1.DataCatalog.UpdateEntry].
type UpdateEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Updates for the entry. The `name` field must be set.
	Entry *Entry `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// Names of fields whose values to overwrite on an entry.
	//
	// If this parameter is absent or empty, all modifiable fields
	// are overwritten. If such fields are non-required and omitted in the
	// request body, their values are emptied.
	//
	// You can modify only the fields listed below.
	//
	// For entries with type `DATA_STREAM`:
	//
	// * `schema`
	//
	// For entries with type `FILESET`:
	//
	// * `schema`
	// * `display_name`
	// * `description`
	// * `gcs_fileset_spec`
	// * `gcs_fileset_spec.file_patterns`
	//
	// For entries with `user_specified_type`:
	//
	// * `schema`
	// * `display_name`
	// * `description`
	// * `user_specified_type`
	// * `user_specified_system`
	// * `linked_resource`
	// * `source_system_timestamps`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEntryRequest) Reset() {
	*x = UpdateEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryRequest) ProtoMessage() {}

func (x *UpdateEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateEntryRequest) GetEntry() *Entry {
	if x != nil {
		return x.Entry
	}
	return nil
}

func (x *UpdateEntryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteEntry][google.cloud.datacatalog.v1.DataCatalog.DeleteEntry].
type DeleteEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteEntryRequest) Reset() {
	*x = DeleteEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryRequest) ProtoMessage() {}

func (x *DeleteEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [GetEntry][google.cloud.datacatalog.v1.DataCatalog.GetEntry].
type GetEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntryRequest) Reset() {
	*x = GetEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryRequest) ProtoMessage() {}

func (x *GetEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryRequest.ProtoReflect.Descriptor instead.
func (*GetEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{11}
}

func (x *GetEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [LookupEntry][google.cloud.datacatalog.v1.DataCatalog.LookupEntry].
type LookupEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A full name, SQL name, or a fully qualified name of a
	// Google Cloud Platform resource.
	//
	// Types that are assignable to TargetName:
	//
	//	*LookupEntryRequest_LinkedResource
	//	*LookupEntryRequest_SqlResource
	//	*LookupEntryRequest_FullyQualifiedName
	TargetName isLookupEntryRequest_TargetName `protobuf_oneof:"target_name"`
}

func (x *LookupEntryRequest) Reset() {
	*x = LookupEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LookupEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupEntryRequest) ProtoMessage() {}

func (x *LookupEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupEntryRequest.ProtoReflect.Descriptor instead.
func (*LookupEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{12}
}

func (m *LookupEntryRequest) GetTargetName() isLookupEntryRequest_TargetName {
	if m != nil {
		return m.TargetName
	}
	return nil
}

func (x *LookupEntryRequest) GetLinkedResource() string {
	if x, ok := x.GetTargetName().(*LookupEntryRequest_LinkedResource); ok {
		return x.LinkedResource
	}
	return ""
}

func (x *LookupEntryRequest) GetSqlResource() string {
	if x, ok := x.GetTargetName().(*LookupEntryRequest_SqlResource); ok {
		return x.SqlResource
	}
	return ""
}

func (x *LookupEntryRequest) GetFullyQualifiedName() string {
	if x, ok := x.GetTargetName().(*LookupEntryRequest_FullyQualifiedName); ok {
		return x.FullyQualifiedName
	}
	return ""
}

type isLookupEntryRequest_TargetName interface {
	isLookupEntryRequest_TargetName()
}

type LookupEntryRequest_LinkedResource struct {
	// The full name of the Google Cloud Platform resource the Data Catalog
	// entry represents. For more information, see [Full Resource Name]
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name).
	//
	// Full names are case-sensitive. For example:
	//
	//   - `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
	//   - `//pubsub.googleapis.com/projects/{PROJECT_ID}/topics/{TOPIC_ID}`
	LinkedResource string `protobuf:"bytes,1,opt,name=linked_resource,json=linkedResource,proto3,oneof"`
}

type LookupEntryRequest_SqlResource struct {
	// The SQL name of the entry. SQL names are case-sensitive.
	//
	// Examples:
	//
	// * `pubsub.topic.{PROJECT_ID}.{TOPIC_ID}`
	// * `pubsub.topic.{PROJECT_ID}.`\“{TOPIC.ID.SEPARATED.WITH.DOTS}`\`
	// * `bigquery.table.{PROJECT_ID}.{DATASET_ID}.{TABLE_ID}`
	// * `bigquery.dataset.{PROJECT_ID}.{DATASET_ID}`
	// * `datacatalog.entry.{PROJECT_ID}.{LOCATION_ID}.{ENTRY_GROUP_ID}.{ENTRY_ID}`
	//
	// Identifiers (`*_ID`) should comply with the
	// [Lexical structure in Standard SQL]
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical).
	SqlResource string `protobuf:"bytes,3,opt,name=sql_resource,json=sqlResource,proto3,oneof"`
}

type LookupEntryRequest_FullyQualifiedName struct {
	// Fully qualified name (FQN) of the resource.
	//
	// FQNs take two forms:
	//
	// * For non-regionalized resources:
	//
	//	`{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
	//
	// * For regionalized resources:
	//
	//	`{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
	//
	// Example for a DPMS table:
	//
	// `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
	FullyQualifiedName string `protobuf:"bytes,5,opt,name=fully_qualified_name,json=fullyQualifiedName,proto3,oneof"`
}

func (*LookupEntryRequest_LinkedResource) isLookupEntryRequest_TargetName() {}

func (*LookupEntryRequest_SqlResource) isLookupEntryRequest_TargetName() {}

func (*LookupEntryRequest_FullyQualifiedName) isLookupEntryRequest_TargetName() {}

// Entry metadata.
// A Data Catalog entry represents another resource in Google
// Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic) or
// outside of it. You can use the `linked_resource` field
// in the entry resource to refer to the original resource ID of the source
// system.
//
// An entry resource contains resource details, for example, its schema.
// Additionally, you can attach flexible metadata to an entry in the form of a
// [Tag][google.cloud.datacatalog.v1.Tag].
type Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of an entry in URL format.
	//
	// Note: The entry itself and its child resources might not be
	// stored in the location specified in its name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource this metadata entry refers to.
	//
	// For Google Cloud Platform resources, `linked_resource` is the
	// [Full Resource Name]
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name).
	// For example, the `linked_resource` for a table resource from BigQuery is:
	//
	// `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
	//
	// Output only when the entry is one of the types in the `EntryType` enum.
	//
	// For entries with a `user_specified_type`, this field is optional and
	// defaults to an empty string.
	//
	// The resource string must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), periods (.), colons (:), slashes (/), dashes (-),
	// and hashes (#).
	// The maximum size is 200 bytes when encoded in UTF-8.
	LinkedResource string `protobuf:"bytes,9,opt,name=linked_resource,json=linkedResource,proto3" json:"linked_resource,omitempty"`
	// Fully qualified name (FQN) of the resource. Set automatically for entries
	// representing resources from synced systems. Settable only during creation
	// and read-only afterwards. Can be used for search and lookup of the entries.
	//
	// FQNs take two forms:
	//
	// * For non-regionalized resources:
	//
	//	`{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
	//
	// * For regionalized resources:
	//
	//	`{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
	//
	// Example for a DPMS table:
	//
	// `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
	FullyQualifiedName string `protobuf:"bytes,29,opt,name=fully_qualified_name,json=fullyQualifiedName,proto3" json:"fully_qualified_name,omitempty"`
	// Required. Entry type.
	//
	// Types that are assignable to EntryType:
	//
	//	*Entry_Type
	//	*Entry_UserSpecifiedType
	EntryType isEntry_EntryType `protobuf_oneof:"entry_type"`
	// The source system of the entry.
	//
	// Types that are assignable to System:
	//
	//	*Entry_IntegratedSystem
	//	*Entry_UserSpecifiedSystem
	System isEntry_System `protobuf_oneof:"system"`
	// Type specification.
	//
	// Types that are assignable to TypeSpec:
	//
	//	*Entry_GcsFilesetSpec
	//	*Entry_BigqueryTableSpec
	//	*Entry_BigqueryDateShardedSpec
	TypeSpec isEntry_TypeSpec `protobuf_oneof:"type_spec"`
	// Type- and system-specific information. Specifications for types contain
	// fields common to all entries of a given type, and sub-specifications with
	// fields specific to a given source system.
	//
	// When extending the API with new types and systems, use this field instead
	// of the legacy `type_spec`.
	//
	// Types that are assignable to Spec:
	//
	//	*Entry_DatabaseTableSpec
	//	*Entry_DataSourceConnectionSpec
	//	*Entry_RoutineSpec
	//	*Entry_FilesetSpec
	Spec isEntry_Spec `protobuf_oneof:"spec"`
	// Display name of an entry.
	//
	// The name must contain only Unicode letters, numbers (0-9), underscores (_),
	// dashes (-), spaces ( ), and can't start or end with spaces.
	// The maximum size is 200 bytes when encoded in UTF-8.
	// Default value is an empty string.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Entry description that can consist of several sentences or paragraphs
	// that describe entry contents.
	//
	// The description must not contain Unicode non-characters as well as C0
	// and C1 control codes except tabs (HT), new lines (LF), carriage returns
	// (CR), and page breaks (FF).
	// The maximum size is 2000 bytes when encoded in UTF-8.
	// Default value is an empty string.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Business Context of the entry. Not supported for BigQuery datasets
	BusinessContext *BusinessContext `protobuf:"bytes,37,opt,name=business_context,json=businessContext,proto3" json:"business_context,omitempty"`
	// Schema of the entry. An entry might not have any schema attached to it.
	Schema *Schema `protobuf:"bytes,5,opt,name=schema,proto3" json:"schema,omitempty"`
	// Timestamps from the underlying resource, not from the Data Catalog
	// entry.
	//
	// Output only when the entry has a type listed in the `EntryType` enum.
	// For entries with `user_specified_type`, this field is optional and defaults
	// to an empty timestamp.
	SourceSystemTimestamps *SystemTimestamps `protobuf:"bytes,7,opt,name=source_system_timestamps,json=sourceSystemTimestamps,proto3" json:"source_system_timestamps,omitempty"`
	// Output only. Resource usage statistics.
	UsageSignal *UsageSignal `protobuf:"bytes,13,opt,name=usage_signal,json=usageSignal,proto3" json:"usage_signal,omitempty"`
	// Cloud labels attached to the entry.
	//
	// In Data Catalog, you can create and modify labels attached only to custom
	// entries. Synced entries have unmodifiable labels that come from the source
	// system.
	Labels map[string]string `protobuf:"bytes,14,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Physical location of the entry.
	DataSource *DataSource `protobuf:"bytes,20,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	// Output only. Additional information related to the entry. Private to the current user.
	PersonalDetails *PersonalDetails `protobuf:"bytes,26,opt,name=personal_details,json=personalDetails,proto3" json:"personal_details,omitempty"`
}

func (x *Entry) Reset() {
	*x = Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entry) ProtoMessage() {}

func (x *Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entry.ProtoReflect.Descriptor instead.
func (*Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{13}
}

func (x *Entry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Entry) GetLinkedResource() string {
	if x != nil {
		return x.LinkedResource
	}
	return ""
}

func (x *Entry) GetFullyQualifiedName() string {
	if x != nil {
		return x.FullyQualifiedName
	}
	return ""
}

func (m *Entry) GetEntryType() isEntry_EntryType {
	if m != nil {
		return m.EntryType
	}
	return nil
}

func (x *Entry) GetType() EntryType {
	if x, ok := x.GetEntryType().(*Entry_Type); ok {
		return x.Type
	}
	return EntryType_ENTRY_TYPE_UNSPECIFIED
}

func (x *Entry) GetUserSpecifiedType() string {
	if x, ok := x.GetEntryType().(*Entry_UserSpecifiedType); ok {
		return x.UserSpecifiedType
	}
	return ""
}

func (m *Entry) GetSystem() isEntry_System {
	if m != nil {
		return m.System
	}
	return nil
}

func (x *Entry) GetIntegratedSystem() IntegratedSystem {
	if x, ok := x.GetSystem().(*Entry_IntegratedSystem); ok {
		return x.IntegratedSystem
	}
	return IntegratedSystem_INTEGRATED_SYSTEM_UNSPECIFIED
}

func (x *Entry) GetUserSpecifiedSystem() string {
	if x, ok := x.GetSystem().(*Entry_UserSpecifiedSystem); ok {
		return x.UserSpecifiedSystem
	}
	return ""
}

func (m *Entry) GetTypeSpec() isEntry_TypeSpec {
	if m != nil {
		return m.TypeSpec
	}
	return nil
}

func (x *Entry) GetGcsFilesetSpec() *GcsFilesetSpec {
	if x, ok := x.GetTypeSpec().(*Entry_GcsFilesetSpec); ok {
		return x.GcsFilesetSpec
	}
	return nil
}

func (x *Entry) GetBigqueryTableSpec() *BigQueryTableSpec {
	if x, ok := x.GetTypeSpec().(*Entry_BigqueryTableSpec); ok {
		return x.BigqueryTableSpec
	}
	return nil
}

func (x *Entry) GetBigqueryDateShardedSpec() *BigQueryDateShardedSpec {
	if x, ok := x.GetTypeSpec().(*Entry_BigqueryDateShardedSpec); ok {
		return x.BigqueryDateShardedSpec
	}
	return nil
}

func (m *Entry) GetSpec() isEntry_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (x *Entry) GetDatabaseTableSpec() *DatabaseTableSpec {
	if x, ok := x.GetSpec().(*Entry_DatabaseTableSpec); ok {
		return x.DatabaseTableSpec
	}
	return nil
}

func (x *Entry) GetDataSourceConnectionSpec() *DataSourceConnectionSpec {
	if x, ok := x.GetSpec().(*Entry_DataSourceConnectionSpec); ok {
		return x.DataSourceConnectionSpec
	}
	return nil
}

func (x *Entry) GetRoutineSpec() *RoutineSpec {
	if x, ok := x.GetSpec().(*Entry_RoutineSpec); ok {
		return x.RoutineSpec
	}
	return nil
}

func (x *Entry) GetFilesetSpec() *FilesetSpec {
	if x, ok := x.GetSpec().(*Entry_FilesetSpec); ok {
		return x.FilesetSpec
	}
	return nil
}

func (x *Entry) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Entry) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Entry) GetBusinessContext() *BusinessContext {
	if x != nil {
		return x.BusinessContext
	}
	return nil
}

func (x *Entry) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *Entry) GetSourceSystemTimestamps() *SystemTimestamps {
	if x != nil {
		return x.SourceSystemTimestamps
	}
	return nil
}

func (x *Entry) GetUsageSignal() *UsageSignal {
	if x != nil {
		return x.UsageSignal
	}
	return nil
}

func (x *Entry) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Entry) GetDataSource() *DataSource {
	if x != nil {
		return x.DataSource
	}
	return nil
}

func (x *Entry) GetPersonalDetails() *PersonalDetails {
	if x != nil {
		return x.PersonalDetails
	}
	return nil
}

type isEntry_EntryType interface {
	isEntry_EntryType()
}

type Entry_Type struct {
	// The type of the entry.
	// Only used for entries with types listed in the `EntryType` enum.
	//
	// Currently, only `FILESET` enum value is allowed. All other entries
	// created in Data Catalog must use the `user_specified_type`.
	Type EntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.datacatalog.v1.EntryType,oneof"`
}

type Entry_UserSpecifiedType struct {
	// Custom entry type that doesn't match any of the values allowed for input
	// and listed in the `EntryType` enum.
	//
	// When creating an entry, first check the type values in the enum.
	// If there are no appropriate types for the new entry,
	// provide a custom value, for example, `my_special_type`.
	//
	// The `user_specified_type` string has the following limitations:
	//
	// * Is case insensitive.
	// * Must begin with a letter or underscore.
	// * Can only contain letters, numbers, and underscores.
	// * Must be at least 1 character and at most 64 characters long.
	UserSpecifiedType string `protobuf:"bytes,16,opt,name=user_specified_type,json=userSpecifiedType,proto3,oneof"`
}

func (*Entry_Type) isEntry_EntryType() {}

func (*Entry_UserSpecifiedType) isEntry_EntryType() {}

type isEntry_System interface {
	isEntry_System()
}

type Entry_IntegratedSystem struct {
	// Output only. Indicates the entry's source system that Data Catalog
	// integrates with, such as BigQuery, Pub/Sub, or Dataproc Metastore.
	IntegratedSystem IntegratedSystem `protobuf:"varint,17,opt,name=integrated_system,json=integratedSystem,proto3,enum=google.cloud.datacatalog.v1.IntegratedSystem,oneof"`
}

type Entry_UserSpecifiedSystem struct {
	// Indicates the entry's source system that Data Catalog doesn't
	// automatically integrate with.
	//
	// The `user_specified_system` string has the following limitations:
	//
	// * Is case insensitive.
	// * Must begin with a letter or underscore.
	// * Can only contain letters, numbers, and underscores.
	// * Must be at least 1 character and at most 64 characters long.
	UserSpecifiedSystem string `protobuf:"bytes,18,opt,name=user_specified_system,json=userSpecifiedSystem,proto3,oneof"`
}

func (*Entry_IntegratedSystem) isEntry_System() {}

func (*Entry_UserSpecifiedSystem) isEntry_System() {}

type isEntry_TypeSpec interface {
	isEntry_TypeSpec()
}

type Entry_GcsFilesetSpec struct {
	// Specification that applies to a Cloud Storage fileset. Valid only
	// for entries with the `FILESET` type.
	GcsFilesetSpec *GcsFilesetSpec `protobuf:"bytes,6,opt,name=gcs_fileset_spec,json=gcsFilesetSpec,proto3,oneof"`
}

type Entry_BigqueryTableSpec struct {
	// Specification that applies to a BigQuery table. Valid only for
	// entries with the `TABLE` type.
	BigqueryTableSpec *BigQueryTableSpec `protobuf:"bytes,12,opt,name=bigquery_table_spec,json=bigqueryTableSpec,proto3,oneof"`
}

type Entry_BigqueryDateShardedSpec struct {
	// Specification for a group of BigQuery tables with the `[prefix]YYYYMMDD`
	// name pattern.
	//
	// For more information, see [Introduction to partitioned tables]
	// (https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding).
	BigqueryDateShardedSpec *BigQueryDateShardedSpec `protobuf:"bytes,15,opt,name=bigquery_date_sharded_spec,json=bigqueryDateShardedSpec,proto3,oneof"`
}

func (*Entry_GcsFilesetSpec) isEntry_TypeSpec() {}

func (*Entry_BigqueryTableSpec) isEntry_TypeSpec() {}

func (*Entry_BigqueryDateShardedSpec) isEntry_TypeSpec() {}

type isEntry_Spec interface {
	isEntry_Spec()
}

type Entry_DatabaseTableSpec struct {
	// Specification that applies to a table resource. Valid only
	// for entries with the `TABLE` type.
	DatabaseTableSpec *DatabaseTableSpec `protobuf:"bytes,24,opt,name=database_table_spec,json=databaseTableSpec,proto3,oneof"`
}

type Entry_DataSourceConnectionSpec struct {
	// Specification that applies to a data source connection. Valid only
	// for entries with the `DATA_SOURCE_CONNECTION` type.
	DataSourceConnectionSpec *DataSourceConnectionSpec `protobuf:"bytes,27,opt,name=data_source_connection_spec,json=dataSourceConnectionSpec,proto3,oneof"`
}

type Entry_RoutineSpec struct {
	// Specification that applies to a user-defined function or procedure. Valid
	// only for entries with the `ROUTINE` type.
	RoutineSpec *RoutineSpec `protobuf:"bytes,28,opt,name=routine_spec,json=routineSpec,proto3,oneof"`
}

type Entry_FilesetSpec struct {
	// Specification that applies to a fileset resource. Valid only
	// for entries with the `FILESET` type.
	FilesetSpec *FilesetSpec `protobuf:"bytes,33,opt,name=fileset_spec,json=filesetSpec,proto3,oneof"`
}

func (*Entry_DatabaseTableSpec) isEntry_Spec() {}

func (*Entry_DataSourceConnectionSpec) isEntry_Spec() {}

func (*Entry_RoutineSpec) isEntry_Spec() {}

func (*Entry_FilesetSpec) isEntry_Spec() {}

// Specification that applies to a table resource. Valid only
// for entries with the `TABLE` type.
type DatabaseTableSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of this table.
	Type DatabaseTableSpec_TableType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.datacatalog.v1.DatabaseTableSpec_TableType" json:"type,omitempty"`
	// Fields specific to a Dataplex table and present only in the Dataplex table
	// entries.
	DataplexTable *DataplexTableSpec `protobuf:"bytes,2,opt,name=dataplex_table,json=dataplexTable,proto3" json:"dataplex_table,omitempty"`
}

func (x *DatabaseTableSpec) Reset() {
	*x = DatabaseTableSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseTableSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseTableSpec) ProtoMessage() {}

func (x *DatabaseTableSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseTableSpec.ProtoReflect.Descriptor instead.
func (*DatabaseTableSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{14}
}

func (x *DatabaseTableSpec) GetType() DatabaseTableSpec_TableType {
	if x != nil {
		return x.Type
	}
	return DatabaseTableSpec_TABLE_TYPE_UNSPECIFIED
}

func (x *DatabaseTableSpec) GetDataplexTable() *DataplexTableSpec {
	if x != nil {
		return x.DataplexTable
	}
	return nil
}

// Specification that applies to a fileset. Valid only for entries with the
// 'FILESET' type.
type FilesetSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fields specific to a Dataplex fileset and present only in the Dataplex
	// fileset entries.
	DataplexFileset *DataplexFilesetSpec `protobuf:"bytes,1,opt,name=dataplex_fileset,json=dataplexFileset,proto3" json:"dataplex_fileset,omitempty"`
}

func (x *FilesetSpec) Reset() {
	*x = FilesetSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilesetSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilesetSpec) ProtoMessage() {}

func (x *FilesetSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilesetSpec.ProtoReflect.Descriptor instead.
func (*FilesetSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{15}
}

func (x *FilesetSpec) GetDataplexFileset() *DataplexFilesetSpec {
	if x != nil {
		return x.DataplexFileset
	}
	return nil
}

// Specification that applies to a data source connection. Valid only for
// entries with the `DATA_SOURCE_CONNECTION` type.
type DataSourceConnectionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fields specific to BigQuery connections.
	BigqueryConnectionSpec *BigQueryConnectionSpec `protobuf:"bytes,1,opt,name=bigquery_connection_spec,json=bigqueryConnectionSpec,proto3" json:"bigquery_connection_spec,omitempty"`
}

func (x *DataSourceConnectionSpec) Reset() {
	*x = DataSourceConnectionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSourceConnectionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSourceConnectionSpec) ProtoMessage() {}

func (x *DataSourceConnectionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSourceConnectionSpec.ProtoReflect.Descriptor instead.
func (*DataSourceConnectionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{16}
}

func (x *DataSourceConnectionSpec) GetBigqueryConnectionSpec() *BigQueryConnectionSpec {
	if x != nil {
		return x.BigqueryConnectionSpec
	}
	return nil
}

// Specification that applies to a routine. Valid only for
// entries with the `ROUTINE` type.
type RoutineSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the routine.
	RoutineType RoutineSpec_RoutineType `protobuf:"varint,1,opt,name=routine_type,json=routineType,proto3,enum=google.cloud.datacatalog.v1.RoutineSpec_RoutineType" json:"routine_type,omitempty"`
	// The language the routine is written in. The exact value depends on the
	// source system. For BigQuery routines, possible values are:
	//
	// * `SQL`
	// * `JAVASCRIPT`
	Language string `protobuf:"bytes,2,opt,name=language,proto3" json:"language,omitempty"`
	// Arguments of the routine.
	RoutineArguments []*RoutineSpec_Argument `protobuf:"bytes,3,rep,name=routine_arguments,json=routineArguments,proto3" json:"routine_arguments,omitempty"`
	// Return type of the argument. The exact value depends on the source system
	// and the language.
	ReturnType string `protobuf:"bytes,4,opt,name=return_type,json=returnType,proto3" json:"return_type,omitempty"`
	// The body of the routine.
	DefinitionBody string `protobuf:"bytes,5,opt,name=definition_body,json=definitionBody,proto3" json:"definition_body,omitempty"`
	// Contains fields specific to the source system.
	//
	// Types that are assignable to SystemSpec:
	//
	//	*RoutineSpec_BigqueryRoutineSpec
	SystemSpec isRoutineSpec_SystemSpec `protobuf_oneof:"system_spec"`
}

func (x *RoutineSpec) Reset() {
	*x = RoutineSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoutineSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoutineSpec) ProtoMessage() {}

func (x *RoutineSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoutineSpec.ProtoReflect.Descriptor instead.
func (*RoutineSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{17}
}

func (x *RoutineSpec) GetRoutineType() RoutineSpec_RoutineType {
	if x != nil {
		return x.RoutineType
	}
	return RoutineSpec_ROUTINE_TYPE_UNSPECIFIED
}

func (x *RoutineSpec) GetLanguage() string {
	if x != nil {
		return x.Language
	}
	return ""
}

func (x *RoutineSpec) GetRoutineArguments() []*RoutineSpec_Argument {
	if x != nil {
		return x.RoutineArguments
	}
	return nil
}

func (x *RoutineSpec) GetReturnType() string {
	if x != nil {
		return x.ReturnType
	}
	return ""
}

func (x *RoutineSpec) GetDefinitionBody() string {
	if x != nil {
		return x.DefinitionBody
	}
	return ""
}

func (m *RoutineSpec) GetSystemSpec() isRoutineSpec_SystemSpec {
	if m != nil {
		return m.SystemSpec
	}
	return nil
}

func (x *RoutineSpec) GetBigqueryRoutineSpec() *BigQueryRoutineSpec {
	if x, ok := x.GetSystemSpec().(*RoutineSpec_BigqueryRoutineSpec); ok {
		return x.BigqueryRoutineSpec
	}
	return nil
}

type isRoutineSpec_SystemSpec interface {
	isRoutineSpec_SystemSpec()
}

type RoutineSpec_BigqueryRoutineSpec struct {
	// Fields specific for BigQuery routines.
	BigqueryRoutineSpec *BigQueryRoutineSpec `protobuf:"bytes,6,opt,name=bigquery_routine_spec,json=bigqueryRoutineSpec,proto3,oneof"`
}

func (*RoutineSpec_BigqueryRoutineSpec) isRoutineSpec_SystemSpec() {}

// Business Context of the entry.
type BusinessContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry overview fields for rich text descriptions of entries.
	EntryOverview *EntryOverview `protobuf:"bytes,1,opt,name=entry_overview,json=entryOverview,proto3" json:"entry_overview,omitempty"`
	// Contact people for the entry.
	Contacts *Contacts `protobuf:"bytes,2,opt,name=contacts,proto3" json:"contacts,omitempty"`
}

func (x *BusinessContext) Reset() {
	*x = BusinessContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BusinessContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BusinessContext) ProtoMessage() {}

func (x *BusinessContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BusinessContext.ProtoReflect.Descriptor instead.
func (*BusinessContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{18}
}

func (x *BusinessContext) GetEntryOverview() *EntryOverview {
	if x != nil {
		return x.EntryOverview
	}
	return nil
}

func (x *BusinessContext) GetContacts() *Contacts {
	if x != nil {
		return x.Contacts
	}
	return nil
}

// Entry overview fields for rich text descriptions of entries.
type EntryOverview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry overview with support for rich text.
	//
	// The overview must only contain Unicode characters, and should be
	// formatted using HTML.
	// The maximum length is 10 MiB as this value holds HTML descriptions
	// including encoded images. The maximum length of the text without images
	// is 100 KiB.
	Overview string `protobuf:"bytes,1,opt,name=overview,proto3" json:"overview,omitempty"`
}

func (x *EntryOverview) Reset() {
	*x = EntryOverview{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntryOverview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryOverview) ProtoMessage() {}

func (x *EntryOverview) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryOverview.ProtoReflect.Descriptor instead.
func (*EntryOverview) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{19}
}

func (x *EntryOverview) GetOverview() string {
	if x != nil {
		return x.Overview
	}
	return ""
}

// Contact people for the entry.
type Contacts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of contact people for the entry.
	People []*Contacts_Person `protobuf:"bytes,1,rep,name=people,proto3" json:"people,omitempty"`
}

func (x *Contacts) Reset() {
	*x = Contacts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Contacts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Contacts) ProtoMessage() {}

func (x *Contacts) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Contacts.ProtoReflect.Descriptor instead.
func (*Contacts) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{20}
}

func (x *Contacts) GetPeople() []*Contacts_Person {
	if x != nil {
		return x.People
	}
	return nil
}

// Entry group metadata.
//
// An `EntryGroup` resource represents a logical grouping of zero or more
// Data Catalog [Entry][google.cloud.datacatalog.v1.Entry] resources.
type EntryGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the entry group in URL format.
	//
	// Note: The entry group itself and its child resources might not be
	// stored in the location specified in its name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A short name to identify the entry group, for example,
	// "analytics data - jan 2011". Default value is an empty string.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Entry group description. Can consist of several sentences or
	// paragraphs that describe the entry group contents.
	// Default value is an empty string.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Timestamps of the entry group. Default value is empty.
	DataCatalogTimestamps *SystemTimestamps `protobuf:"bytes,4,opt,name=data_catalog_timestamps,json=dataCatalogTimestamps,proto3" json:"data_catalog_timestamps,omitempty"`
}

func (x *EntryGroup) Reset() {
	*x = EntryGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EntryGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryGroup) ProtoMessage() {}

func (x *EntryGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryGroup.ProtoReflect.Descriptor instead.
func (*EntryGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{21}
}

func (x *EntryGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntryGroup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EntryGroup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntryGroup) GetDataCatalogTimestamps() *SystemTimestamps {
	if x != nil {
		return x.DataCatalogTimestamps
	}
	return nil
}

// Request message for
// [CreateTagTemplate][google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplate].
type CreateTagTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project and the template location
	// [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the tag template to create.
	//
	// The ID must contain only lowercase letters (a-z), numbers (0-9),
	// or underscores (_), and must start with a letter or underscore.
	// The maximum size is 64 bytes when encoded in UTF-8.
	TagTemplateId string `protobuf:"bytes,3,opt,name=tag_template_id,json=tagTemplateId,proto3" json:"tag_template_id,omitempty"`
	// Required. The tag template to create.
	TagTemplate *TagTemplate `protobuf:"bytes,2,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
}

func (x *CreateTagTemplateRequest) Reset() {
	*x = CreateTagTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTagTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTagTemplateRequest) ProtoMessage() {}

func (x *CreateTagTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTagTemplateRequest.ProtoReflect.Descriptor instead.
func (*CreateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{22}
}

func (x *CreateTagTemplateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTagTemplateRequest) GetTagTemplateId() string {
	if x != nil {
		return x.TagTemplateId
	}
	return ""
}

func (x *CreateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if x != nil {
		return x.TagTemplate
	}
	return nil
}

// Request message for
// [GetTagTemplate][google.cloud.datacatalog.v1.DataCatalog.GetTagTemplate].
type GetTagTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTagTemplateRequest) Reset() {
	*x = GetTagTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTagTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTagTemplateRequest) ProtoMessage() {}

func (x *GetTagTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTagTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetTagTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{23}
}

func (x *GetTagTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [UpdateTagTemplate][google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplate].
type UpdateTagTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The template to update. The `name` field must be set.
	TagTemplate *TagTemplate `protobuf:"bytes,1,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
	// Names of fields whose values to overwrite on a tag template. Currently,
	// only `display_name` and `is_publicly_readable` can be overwritten.
	//
	// If this parameter is absent or empty, all modifiable fields
	// are overwritten. If such fields are non-required and omitted in the
	// request body, their values are emptied.
	//
	// Note: Updating the `is_publicly_readable` field may require up to 12
	// hours to take effect in search results.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTagTemplateRequest) Reset() {
	*x = UpdateTagTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTagTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTagTemplateRequest) ProtoMessage() {}

func (x *UpdateTagTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTagTemplateRequest.ProtoReflect.Descriptor instead.
func (*UpdateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{24}
}

func (x *UpdateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if x != nil {
		return x.TagTemplate
	}
	return nil
}

func (x *UpdateTagTemplateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTagTemplate][google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplate].
type DeleteTagTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. If true, deletes all tags that use this template.
	//
	// Currently, `true` is the only supported value.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteTagTemplateRequest) Reset() {
	*x = DeleteTagTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTagTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTagTemplateRequest) ProtoMessage() {}

func (x *DeleteTagTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTagTemplateRequest.ProtoReflect.Descriptor instead.
func (*DeleteTagTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{25}
}

func (x *DeleteTagTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTagTemplateRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [CreateTag][google.cloud.datacatalog.v1.DataCatalog.CreateTag].
type CreateTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resource to attach this tag to.
	//
	// Tags can be attached to entries or entry groups. An entry can have up to
	// 1000 attached tags.
	//
	// Note: The tag and its child resources might not be stored in
	// the location specified in its name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The tag to create.
	Tag *Tag `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *CreateTagRequest) Reset() {
	*x = CreateTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTagRequest) ProtoMessage() {}

func (x *CreateTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTagRequest.ProtoReflect.Descriptor instead.
func (*CreateTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{26}
}

func (x *CreateTagRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTagRequest) GetTag() *Tag {
	if x != nil {
		return x.Tag
	}
	return nil
}

// Request message for
// [UpdateTag][google.cloud.datacatalog.v1.DataCatalog.UpdateTag].
type UpdateTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The updated tag. The "name" field must be set.
	Tag *Tag `protobuf:"bytes,1,opt,name=tag,proto3" json:"tag,omitempty"`
	// Names of fields whose values to overwrite on a tag. Currently, a tag has
	// the only modifiable field with the name `fields`.
	//
	// In general, if this parameter is absent or empty, all modifiable fields
	// are overwritten. If such fields are non-required and omitted in the
	// request body, their values are emptied.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTagRequest) Reset() {
	*x = UpdateTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTagRequest) ProtoMessage() {}

func (x *UpdateTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTagRequest.ProtoReflect.Descriptor instead.
func (*UpdateTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{27}
}

func (x *UpdateTagRequest) GetTag() *Tag {
	if x != nil {
		return x.Tag
	}
	return nil
}

func (x *UpdateTagRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTag][google.cloud.datacatalog.v1.DataCatalog.DeleteTag].
type DeleteTagRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTagRequest) Reset() {
	*x = DeleteTagRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTagRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTagRequest) ProtoMessage() {}

func (x *DeleteTagRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTagRequest.ProtoReflect.Descriptor instead.
func (*DeleteTagRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{28}
}

func (x *DeleteTagRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [CreateTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplateField].
type CreateTagTemplateFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project and the template location
	// [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the tag template field to create.
	//
	// Note: Adding a required field to an existing template is *not* allowed.
	//
	// Field IDs can contain letters (both uppercase and lowercase), numbers
	// (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
	// character long and at most 128 characters long. Field IDs must also be
	// unique within their template.
	TagTemplateFieldId string `protobuf:"bytes,2,opt,name=tag_template_field_id,json=tagTemplateFieldId,proto3" json:"tag_template_field_id,omitempty"`
	// Required. The tag template field to create.
	TagTemplateField *TagTemplateField `protobuf:"bytes,3,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
}

func (x *CreateTagTemplateFieldRequest) Reset() {
	*x = CreateTagTemplateFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTagTemplateFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTagTemplateFieldRequest) ProtoMessage() {}

func (x *CreateTagTemplateFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTagTemplateFieldRequest.ProtoReflect.Descriptor instead.
func (*CreateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{29}
}

func (x *CreateTagTemplateFieldRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTagTemplateFieldRequest) GetTagTemplateFieldId() string {
	if x != nil {
		return x.TagTemplateFieldId
	}
	return ""
}

func (x *CreateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if x != nil {
		return x.TagTemplateField
	}
	return nil
}

// Request message for
// [UpdateTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplateField].
type UpdateTagTemplateFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The template to update.
	TagTemplateField *TagTemplateField `protobuf:"bytes,2,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
	// Optional. Names of fields whose values to overwrite on an individual field of a tag
	// template. The following fields are modifiable:
	//
	// * `display_name`
	// * `type.enum_type`
	// * `is_required`
	//
	// If this parameter is absent or empty, all modifiable fields
	// are overwritten. If such fields are non-required and omitted in the request
	// body, their values are emptied with one exception: when updating an enum
	// type, the provided values are merged with the existing values. Therefore,
	// enum values can only be added, existing enum values cannot be deleted or
	// renamed.
	//
	// Additionally, updating a template field from optional to required is
	// *not* allowed.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateTagTemplateFieldRequest) Reset() {
	*x = UpdateTagTemplateFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTagTemplateFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTagTemplateFieldRequest) ProtoMessage() {}

func (x *UpdateTagTemplateFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTagTemplateFieldRequest.ProtoReflect.Descriptor instead.
func (*UpdateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{30}
}

func (x *UpdateTagTemplateFieldRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if x != nil {
		return x.TagTemplateField
	}
	return nil
}

func (x *UpdateTagTemplateFieldRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [RenameTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateField].
type RenameTagTemplateFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new ID of this tag template field. For example, `my_new_field`.
	NewTagTemplateFieldId string `protobuf:"bytes,2,opt,name=new_tag_template_field_id,json=newTagTemplateFieldId,proto3" json:"new_tag_template_field_id,omitempty"`
}

func (x *RenameTagTemplateFieldRequest) Reset() {
	*x = RenameTagTemplateFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameTagTemplateFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameTagTemplateFieldRequest) ProtoMessage() {}

func (x *RenameTagTemplateFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameTagTemplateFieldRequest.ProtoReflect.Descriptor instead.
func (*RenameTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{31}
}

func (x *RenameTagTemplateFieldRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RenameTagTemplateFieldRequest) GetNewTagTemplateFieldId() string {
	if x != nil {
		return x.NewTagTemplateFieldId
	}
	return ""
}

// Request message for
// [RenameTagTemplateFieldEnumValue][google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateFieldEnumValue].
type RenameTagTemplateFieldEnumValueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the enum field value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new display name of the enum value. For example, `my_new_enum_value`.
	NewEnumValueDisplayName string `protobuf:"bytes,2,opt,name=new_enum_value_display_name,json=newEnumValueDisplayName,proto3" json:"new_enum_value_display_name,omitempty"`
}

func (x *RenameTagTemplateFieldEnumValueRequest) Reset() {
	*x = RenameTagTemplateFieldEnumValueRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenameTagTemplateFieldEnumValueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenameTagTemplateFieldEnumValueRequest) ProtoMessage() {}

func (x *RenameTagTemplateFieldEnumValueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenameTagTemplateFieldEnumValueRequest.ProtoReflect.Descriptor instead.
func (*RenameTagTemplateFieldEnumValueRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{32}
}

func (x *RenameTagTemplateFieldEnumValueRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RenameTagTemplateFieldEnumValueRequest) GetNewEnumValueDisplayName() string {
	if x != nil {
		return x.NewEnumValueDisplayName
	}
	return ""
}

// Request message for
// [DeleteTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplateField].
type DeleteTagTemplateFieldRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the tag template field to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. If true, deletes this field from any tags that use it.
	//
	// Currently, `true` is the only supported value.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteTagTemplateFieldRequest) Reset() {
	*x = DeleteTagTemplateFieldRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTagTemplateFieldRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTagTemplateFieldRequest) ProtoMessage() {}

func (x *DeleteTagTemplateFieldRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTagTemplateFieldRequest.ProtoReflect.Descriptor instead.
func (*DeleteTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{33}
}

func (x *DeleteTagTemplateFieldRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTagTemplateFieldRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [ListTags][google.cloud.datacatalog.v1.DataCatalog.ListTags].
type ListTagsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Data Catalog resource to list the tags of.
	//
	// The resource can be an [Entry][google.cloud.datacatalog.v1.Entry]
	// or an [EntryGroup][google.cloud.datacatalog.v1.EntryGroup]
	// (without `/entries/{entries}` at the end).
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of tags to return. Default is 10. Maximum limit is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Pagination token that specifies the next page to return. If empty, the
	// first page is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTagsRequest) Reset() {
	*x = ListTagsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTagsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTagsRequest) ProtoMessage() {}

func (x *ListTagsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTagsRequest.ProtoReflect.Descriptor instead.
func (*ListTagsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{34}
}

func (x *ListTagsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTagsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTagsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [ListTags][google.cloud.datacatalog.v1.DataCatalog.ListTags].
type ListTagsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Tag][google.cloud.datacatalog.v1.Tag] details.
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// Pagination token of the next results page. Empty if there are
	// no more items in results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTagsResponse) Reset() {
	*x = ListTagsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTagsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTagsResponse) ProtoMessage() {}

func (x *ListTagsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTagsResponse.ProtoReflect.Descriptor instead.
func (*ListTagsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{35}
}

func (x *ListTagsResponse) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ListTagsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [ListEntries][google.cloud.datacatalog.v1.DataCatalog.ListEntries].
type ListEntriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry group that contains the entries to list.
	//
	// Can be provided in URL format.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default is 10. Maximum limit is
	// 1000. Throws an invalid argument if `page_size` is more than 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Pagination token that specifies the next page to return. If empty, the
	// first page is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The fields to return for each entry. If empty or omitted, all
	// fields are returned.
	//
	// For example, to return a list of entries with only the `name` field,
	// set `read_mask` to only one path with the `name` value.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,4,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListEntriesRequest) Reset() {
	*x = ListEntriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntriesRequest) ProtoMessage() {}

func (x *ListEntriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntriesRequest.ProtoReflect.Descriptor instead.
func (*ListEntriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{36}
}

func (x *ListEntriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntriesRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [ListEntries][google.cloud.datacatalog.v1.DataCatalog.ListEntries].
type ListEntriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry details.
	Entries []*Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// Pagination token of the next results page. Empty if there are no more items
	// in results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntriesResponse) Reset() {
	*x = ListEntriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListEntriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntriesResponse) ProtoMessage() {}

func (x *ListEntriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntriesResponse.ProtoReflect.Descriptor instead.
func (*ListEntriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{37}
}

func (x *ListEntriesResponse) GetEntries() []*Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *ListEntriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [StarEntry][google.cloud.datacatalog.v1.DataCatalog.StarEntry].
type StarEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry to mark as starred.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StarEntryRequest) Reset() {
	*x = StarEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StarEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StarEntryRequest) ProtoMessage() {}

func (x *StarEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StarEntryRequest.ProtoReflect.Descriptor instead.
func (*StarEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{38}
}

func (x *StarEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for
// [StarEntry][google.cloud.datacatalog.v1.DataCatalog.StarEntry].
// Empty for now
type StarEntryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StarEntryResponse) Reset() {
	*x = StarEntryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StarEntryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StarEntryResponse) ProtoMessage() {}

func (x *StarEntryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StarEntryResponse.ProtoReflect.Descriptor instead.
func (*StarEntryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{39}
}

// Request message for
// [UnstarEntry][google.cloud.datacatalog.v1.DataCatalog.UnstarEntry].
type UnstarEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the entry to mark as **not** starred.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *UnstarEntryRequest) Reset() {
	*x = UnstarEntryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnstarEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnstarEntryRequest) ProtoMessage() {}

func (x *UnstarEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnstarEntryRequest.ProtoReflect.Descriptor instead.
func (*UnstarEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{40}
}

func (x *UnstarEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for
// [UnstarEntry][google.cloud.datacatalog.v1.DataCatalog.UnstarEntry].
// Empty for now
type UnstarEntryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UnstarEntryResponse) Reset() {
	*x = UnstarEntryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnstarEntryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnstarEntryResponse) ProtoMessage() {}

func (x *UnstarEntryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnstarEntryResponse.ProtoReflect.Descriptor instead.
func (*UnstarEntryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{41}
}

// Request message for
// [ModifyEntryOverview][google.cloud.datacatalog.v1.DataCatalog.ModifyEntryOverview].
type ModifyEntryOverviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the entry.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new value for the Entry Overview.
	EntryOverview *EntryOverview `protobuf:"bytes,2,opt,name=entry_overview,json=entryOverview,proto3" json:"entry_overview,omitempty"`
}

func (x *ModifyEntryOverviewRequest) Reset() {
	*x = ModifyEntryOverviewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModifyEntryOverviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyEntryOverviewRequest) ProtoMessage() {}

func (x *ModifyEntryOverviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyEntryOverviewRequest.ProtoReflect.Descriptor instead.
func (*ModifyEntryOverviewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{42}
}

func (x *ModifyEntryOverviewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModifyEntryOverviewRequest) GetEntryOverview() *EntryOverview {
	if x != nil {
		return x.EntryOverview
	}
	return nil
}

// Request message for
// [ModifyEntryContacts][google.cloud.datacatalog.v1.DataCatalog.ModifyEntryContacts].
type ModifyEntryContactsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the entry.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new value for the Contacts.
	Contacts *Contacts `protobuf:"bytes,2,opt,name=contacts,proto3" json:"contacts,omitempty"`
}

func (x *ModifyEntryContactsRequest) Reset() {
	*x = ModifyEntryContactsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModifyEntryContactsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModifyEntryContactsRequest) ProtoMessage() {}

func (x *ModifyEntryContactsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModifyEntryContactsRequest.ProtoReflect.Descriptor instead.
func (*ModifyEntryContactsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{43}
}

func (x *ModifyEntryContactsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ModifyEntryContactsRequest) GetContacts() *Contacts {
	if x != nil {
		return x.Contacts
	}
	return nil
}

// The criteria that select the subspace used for query matching.
type SearchCatalogRequest_Scope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of organization IDs to search within.
	//
	// To find your organization ID, follow the steps from
	// [Creating and managing organizations]
	// (/resource-manager/docs/creating-managing-organization).
	IncludeOrgIds []string `protobuf:"bytes,2,rep,name=include_org_ids,json=includeOrgIds,proto3" json:"include_org_ids,omitempty"`
	// The list of project IDs to search within.
	//
	// For more information on the distinction between project names, IDs, and
	// numbers, see [Projects](/docs/overview/#projects).
	IncludeProjectIds []string `protobuf:"bytes,3,rep,name=include_project_ids,json=includeProjectIds,proto3" json:"include_project_ids,omitempty"`
	// If `true`, include Google Cloud Platform (GCP) public datasets in
	// search results. By default, they are excluded.
	//
	// See [Google Cloud Public Datasets](/public-datasets) for more
	// information.
	IncludeGcpPublicDatasets bool `protobuf:"varint,7,opt,name=include_gcp_public_datasets,json=includeGcpPublicDatasets,proto3" json:"include_gcp_public_datasets,omitempty"`
	// Optional. The list of locations to search within. If empty, all locations are
	// searched.
	//
	// Returns an error if any location in the list isn't one of the [Supported
	// regions](https://cloud.google.com/data-catalog/docs/concepts/regions#supported_regions).
	//
	// If a location is unreachable, its name is returned in the
	// `SearchCatalogResponse.unreachable` field. To get additional information
	// on the error, repeat the search request and set the location name as the
	// value of this parameter.
	RestrictedLocations []string `protobuf:"bytes,16,rep,name=restricted_locations,json=restrictedLocations,proto3" json:"restricted_locations,omitempty"`
	// Optional. If `true`, search only among starred entries.
	//
	// By default, all results are returned, starred or not.
	StarredOnly bool `protobuf:"varint,18,opt,name=starred_only,json=starredOnly,proto3" json:"starred_only,omitempty"`
	// Optional. This field is deprecated. The search mechanism for public and private tag
	// templates is the same.
	//
	// Deprecated: Do not use.
	IncludePublicTagTemplates bool `protobuf:"varint,19,opt,name=include_public_tag_templates,json=includePublicTagTemplates,proto3" json:"include_public_tag_templates,omitempty"`
}

func (x *SearchCatalogRequest_Scope) Reset() {
	*x = SearchCatalogRequest_Scope{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCatalogRequest_Scope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCatalogRequest_Scope) ProtoMessage() {}

func (x *SearchCatalogRequest_Scope) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCatalogRequest_Scope.ProtoReflect.Descriptor instead.
func (*SearchCatalogRequest_Scope) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SearchCatalogRequest_Scope) GetIncludeOrgIds() []string {
	if x != nil {
		return x.IncludeOrgIds
	}
	return nil
}

func (x *SearchCatalogRequest_Scope) GetIncludeProjectIds() []string {
	if x != nil {
		return x.IncludeProjectIds
	}
	return nil
}

func (x *SearchCatalogRequest_Scope) GetIncludeGcpPublicDatasets() bool {
	if x != nil {
		return x.IncludeGcpPublicDatasets
	}
	return false
}

func (x *SearchCatalogRequest_Scope) GetRestrictedLocations() []string {
	if x != nil {
		return x.RestrictedLocations
	}
	return nil
}

func (x *SearchCatalogRequest_Scope) GetStarredOnly() bool {
	if x != nil {
		return x.StarredOnly
	}
	return false
}

// Deprecated: Do not use.
func (x *SearchCatalogRequest_Scope) GetIncludePublicTagTemplates() bool {
	if x != nil {
		return x.IncludePublicTagTemplates
	}
	return false
}

// Input or output argument of a function or stored procedure.
type RoutineSpec_Argument struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the argument. A return argument of a function might not have
	// a name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies whether the argument is input or output.
	Mode RoutineSpec_Argument_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=google.cloud.datacatalog.v1.RoutineSpec_Argument_Mode" json:"mode,omitempty"`
	// Type of the argument. The exact value depends on the source system and
	// the language.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *RoutineSpec_Argument) Reset() {
	*x = RoutineSpec_Argument{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoutineSpec_Argument) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoutineSpec_Argument) ProtoMessage() {}

func (x *RoutineSpec_Argument) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoutineSpec_Argument.ProtoReflect.Descriptor instead.
func (*RoutineSpec_Argument) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{17, 0}
}

func (x *RoutineSpec_Argument) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RoutineSpec_Argument) GetMode() RoutineSpec_Argument_Mode {
	if x != nil {
		return x.Mode
	}
	return RoutineSpec_Argument_MODE_UNSPECIFIED
}

func (x *RoutineSpec_Argument) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// A contact person for the entry.
type Contacts_Person struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Designation of the person, for example, Data Steward.
	Designation string `protobuf:"bytes,1,opt,name=designation,proto3" json:"designation,omitempty"`
	// Email of the person in the format of `john.doe@xyz`,
	// `<john.doe@xyz>`, or `John Doe<john.doe@xyz>`.
	Email string `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
}

func (x *Contacts_Person) Reset() {
	*x = Contacts_Person{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Contacts_Person) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Contacts_Person) ProtoMessage() {}

func (x *Contacts_Person) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Contacts_Person.ProtoReflect.Descriptor instead.
func (*Contacts_Person) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP(), []int{20, 0}
}

func (x *Contacts_Person) GetDesignation() string {
	if x != nil {
		return x.Designation
	}
	return ""
}

func (x *Contacts_Person) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

var File_google_cloud_datacatalog_v1_datacatalog_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1_datacatalog_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f,
	0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76,
	0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f,
	0x76, 0x31, 0x2f, 0x67, 0x63, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x75,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaa, 0x04, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x1a, 0xc6, 0x02, 0x0a, 0x05, 0x53, 0x63,
	0x6f, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x6f,
	0x72, 0x67, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x4f, 0x72, 0x67, 0x49, 0x64, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x67, 0x63, 0x70, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x18, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x47, 0x63, 0x70, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x12, 0x36, 0x0a, 0x14, 0x72, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x72,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73,
	0x74, 0x61, 0x72, 0x72, 0x65, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x46, 0x0a, 0x1c, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x74, 0x61, 0x67,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x22, 0xad, 0x01, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x07,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0xd5, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64,
	0x12, 0x48, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0a,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xa5, 0x01, 0x0a, 0x17, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x92, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37,
	0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72,
	0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x77, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x22, 0xa5, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xba, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x90, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x05,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x52, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x4f, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7, 0x01,
	0x0a, 0x12, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x0f, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0e, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x23, 0x0a, 0x0c, 0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x71, 0x6c, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x32, 0x0a, 0x14, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc3, 0x0f, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6c,
	0x69, 0x6e, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x30, 0x0a,
	0x14, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x64,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x66, 0x75, 0x6c,
	0x6c, 0x79, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x3c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x30, 0x0a,
	0x13, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x11, 0x75, 0x73,
	0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x61, 0x0a, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x65, 0x64, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x53, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x12, 0x34, 0x0a, 0x15, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x01, 0x52, 0x13, 0x75, 0x73, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x65, 0x64, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x57, 0x0a, 0x10, 0x67, 0x63, 0x73, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x63, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x48,
	0x02, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x60, 0x0a, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x02,
	0x52, 0x11, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x73, 0x0a, 0x1a, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x65, 0x64, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61,
	0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x65, 0x64, 0x53, 0x70, 0x65, 0x63, 0x48, 0x02, 0x52,
	0x17, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x65, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x65, 0x64, 0x53, 0x70, 0x65, 0x63, 0x12, 0x60, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x70, 0x65, 0x63, 0x48, 0x03, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x76, 0x0a, 0x1b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x48, 0x03, 0x52, 0x18, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x4d, 0x0a, 0x0c, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x48, 0x03, 0x52, 0x0b, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x4d, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x48, 0x03, 0x52, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x10, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75,
	0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f, 0x62,
	0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x3b,
	0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x67, 0x0a, 0x18, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x52, 0x16, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x73, 0x12, 0x50, 0x0a, 0x0c, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x73, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4d,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5c, 0x0a,
	0x10, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x65, 0x72, 0x73,
	0x6f, 0x6e, 0x61, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x20, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x51, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x7d,
	0x42, 0x0c, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x0b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x42, 0x06, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x22, 0xfb, 0x01,
	0x0a, 0x11, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x4c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x55, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x5f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x41, 0x0a, 0x09, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x6a, 0x0a, 0x0b, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5b, 0x0a, 0x10, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x74, 0x22, 0x89, 0x01, 0x0a, 0x18, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x6d, 0x0a, 0x18, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x16, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x22, 0xaf, 0x05, 0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x57, 0x0a, 0x0c, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x65, 0x5f, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x41, 0x72,
	0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x41,
	0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x74, 0x75,
	0x72, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f,
	0x64, 0x79, 0x12, 0x66, 0x0a, 0x15, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x1a, 0xb8, 0x01, 0x0a, 0x08, 0x41,
	0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x41, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x6f, 0x64,
	0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x38, 0x0a, 0x04, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x4e, 0x10,
	0x01, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x55, 0x54, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e,
	0x4f, 0x55, 0x54, 0x10, 0x03, 0x22, 0x4f, 0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x43, 0x41, 0x4c, 0x41, 0x52, 0x5f, 0x46, 0x55, 0x4e,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x4f, 0x43, 0x45,
	0x44, 0x55, 0x52, 0x45, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0xa7, 0x01, 0x0a, 0x0f, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65,
	0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x51, 0x0a, 0x0e, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x52, 0x0d, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x12, 0x41, 0x0a, 0x08,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x73, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x22,
	0x2b, 0x0a, 0x0d, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77,
	0x12, 0x1a, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x22, 0x92, 0x01, 0x0a,
	0x08, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x65, 0x6f,
	0x70, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73,
	0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x1a,
	0x40, 0x0a, 0x06, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x65,
	0x6d, 0x61, 0x69, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x22, 0xc0, 0x02, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x17, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x64, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x73, 0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x7d, 0x22, 0xe1, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x74, 0x61, 0x67,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x61, 0x67,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x5b, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x54,
	0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x50, 0x0a, 0x0c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x79, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x8b, 0x01, 0x0a,
	0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x37, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x74, 0x61, 0x67, 0x22, 0x88, 0x01, 0x0a, 0x10, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x37, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x4e, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12,
	0x1e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x81, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x36, 0x0a, 0x15, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x12, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12, 0x60, 0x0a, 0x12, 0x74, 0x61, 0x67, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x8c, 0x02, 0x0a, 0x1d, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x12, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa7, 0x01, 0x0a, 0x1d, 0x52, 0x65, 0x6e,
	0x61, 0x6d, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x19, 0x6e, 0x65, 0x77, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x6e, 0x65, 0x77,
	0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x49, 0x64, 0x22, 0xbd, 0x01, 0x0a, 0x26, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x54, 0x61, 0x67,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75,
	0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x36, 0x0a, 0x34, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x41, 0x0a, 0x1b, 0x6e, 0x65, 0x77, 0x5f, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x6e, 0x65, 0x77, 0x45, 0x6e,
	0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x8d, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x70, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x04,
	0x74, 0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x52, 0x04, 0x74, 0x61,
	0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd0, 0x01, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x7b, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x50, 0x0a, 0x10, 0x53, 0x74,
	0x61, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x13, 0x0a, 0x11,
	0x53, 0x74, 0x61, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x52, 0x0a, 0x12, 0x55, 0x6e, 0x73, 0x74, 0x61, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x15, 0x0a, 0x13, 0x55, 0x6e, 0x73, 0x74, 0x61, 0x72, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb2, 0x01, 0x0a,
	0x1a, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4f, 0x76, 0x65, 0x72,
	0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x56, 0x0a, 0x0e, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0d, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65,
	0x77, 0x22, 0xa2, 0x01, 0x0a, 0x1a, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x46,
	0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x2a, 0xc0, 0x01, 0x0a, 0x09, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x4e, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x4d,
	0x4f, 0x44, 0x45, 0x4c, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53,
	0x54, 0x52, 0x45, 0x41, 0x4d, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x49, 0x4c, 0x45, 0x53,
	0x45, 0x54, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x10,
	0x06, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x07, 0x12,
	0x1a, 0x0a, 0x16, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x43,
	0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x4f, 0x55, 0x54, 0x49, 0x4e, 0x45, 0x10, 0x09, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x41, 0x4b, 0x45,
	0x10, 0x0a, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x4f, 0x4e, 0x45, 0x10, 0x0b, 0x12, 0x0b, 0x0a, 0x07,
	0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x0e, 0x32, 0xf1, 0x37, 0x0a, 0x0b, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0xa3, 0x01, 0x0a, 0x0d, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x22, 0x12, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x0b, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0xdb, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x2f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x3a, 0x0b, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0xbc, 0x01,
	0x0a, 0x0d, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x4f, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xda, 0x41, 0x0e, 0x6e, 0x61,
	0x6d, 0x65, 0x2c, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xeb, 0x01, 0x0a,
	0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x22, 0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0xda, 0x41, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0xda, 0x41, 0x17, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa0, 0x01, 0x0a, 0x10, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3e, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbe, 0x01,
	0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xc4,
	0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x22, 0x60, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x39, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0xda, 0x41, 0x15,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x2c,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x12, 0xce, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x6a, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x48, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0xda, 0x41, 0x05, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0xda, 0x41, 0x11, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa0, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa6, 0x01, 0x0a, 0x08, 0x47, 0x65,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x7e, 0x0a, 0x0b, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x1a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x14, 0x12, 0x12,
	0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x6c, 0x6f, 0x6f, 0x6b,
	0x75, 0x70, 0x12, 0xbc, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0xd4, 0x01, 0x0a, 0x13, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x22, 0x58,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4f, 0x76, 0x65,
	0x72, 0x76, 0x69, 0x65, 0x77, 0x3a, 0x01, 0x2a, 0x12, 0xcf, 0x01, 0x0a, 0x13, 0x4d, 0x6f, 0x64,
	0x69, 0x66, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x64, 0x69, 0x66, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73,
	0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0xe2, 0x01, 0x0a, 0x11, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74,
	0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x3a, 0x0c, 0x74, 0x61, 0x67,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x64, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0xaf, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xf3, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x7d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4d,
	0x32, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x0c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0xda, 0x41, 0x0c,
	0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0xda, 0x41, 0x18, 0x74,
	0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xa9, 0x01, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x45, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x12, 0x8d, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x87, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4f, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x3a, 0x12, 0x74,
	0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64,
	0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x12, 0x9b, 0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x95, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4f, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x12, 0x74,
	0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0xda, 0x41, 0x17, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0xda, 0x41, 0x23, 0x6e, 0x61,
	0x6d, 0x65, 0x2c, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x12, 0xf1, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22,
	0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1e, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e, 0x65, 0x77, 0x5f,
	0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x69, 0x64, 0x12, 0x92, 0x02, 0x0a, 0x1f, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x54, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e,
	0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x22, 0x7b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x52, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65,
	0x6e, 0x61, 0x6d, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x6e,
	0x65, 0x77, 0x5f, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbc, 0x01, 0x0a, 0x16, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x0a, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0xf9, 0x01, 0x0a, 0x09, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x22, 0x9a, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x86, 0x01, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x74, 0x61, 0x67, 0x73, 0x3a, 0x03, 0x74, 0x61, 0x67, 0x5a, 0x3d, 0x22, 0x36, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74,
	0x61, 0x67, 0x73, 0x3a, 0x03, 0x74, 0x61, 0x67, 0xda, 0x41, 0x0a, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x74, 0x61, 0x67, 0x12, 0x8c, 0x02, 0x0a, 0x09, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x61, 0x67, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x61, 0x67, 0x22, 0xad, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8e, 0x01, 0x32, 0x44,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x03, 0x74, 0x61, 0x67, 0x5a, 0x41, 0x32, 0x3a, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x74, 0x61, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x03, 0x74, 0x61, 0x67, 0xda, 0x41, 0x03, 0x74,
	0x61, 0x67, 0xda, 0x41, 0x0f, 0x74, 0x61, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x12, 0xde, 0x01, 0x0a, 0x09, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x61, 0x67, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x89, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x7c, 0x2a, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x38, 0x2a, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xf5, 0x01, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61,
	0x67, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x8b, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7c, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x5a, 0x38, 0x12, 0x36, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x74, 0x61, 0x67, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xbc, 0x01,
	0x0a, 0x09, 0x53, 0x74, 0x61, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x43, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74,
	0x61, 0x72, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc4, 0x01, 0x0a,
	0x0b, 0x55, 0x6e, 0x73, 0x74, 0x61, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x73, 0x74, 0x61,
	0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x73, 0x74,
	0x61, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x72, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xf2, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22,
	0xa6, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8d, 0x01, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0x5a,
	0x45, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xbc, 0x02, 0x0a, 0x0c, 0x47, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x22, 0xf0, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xde, 0x01, 0x22, 0x41,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x3a, 0x01, 0x2a, 0x5a, 0x45, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0x5a, 0x4f, 0x22, 0x4a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x08, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0xe3, 0x02, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74,
	0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xf7, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf0, 0x01, 0x22, 0x47, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x4b, 0x22, 0x46, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x5a, 0x55, 0x22, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x1a, 0x4e, 0xca,
	0x41, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x8f, 0x03,
	0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x50, 0x01, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x3b,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0xf8, 0x01, 0x01, 0xaa, 0x02,
	0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1b, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0xea, 0x41, 0xc0, 0x01, 0x0a,
	0x34, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6e, 0x75, 0x6d,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x87, 0x01, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61,
	0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescData = file_google_cloud_datacatalog_v1_datacatalog_proto_rawDesc
)

func file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1_datacatalog_proto_rawDescData
}

var file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes = make([]protoimpl.MessageInfo, 48)
var file_google_cloud_datacatalog_v1_datacatalog_proto_goTypes = []interface{}{
	(EntryType)(0),                                 // 0: google.cloud.datacatalog.v1.EntryType
	(DatabaseTableSpec_TableType)(0),               // 1: google.cloud.datacatalog.v1.DatabaseTableSpec.TableType
	(RoutineSpec_RoutineType)(0),                   // 2: google.cloud.datacatalog.v1.RoutineSpec.RoutineType
	(RoutineSpec_Argument_Mode)(0),                 // 3: google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode
	(*SearchCatalogRequest)(nil),                   // 4: google.cloud.datacatalog.v1.SearchCatalogRequest
	(*SearchCatalogResponse)(nil),                  // 5: google.cloud.datacatalog.v1.SearchCatalogResponse
	(*CreateEntryGroupRequest)(nil),                // 6: google.cloud.datacatalog.v1.CreateEntryGroupRequest
	(*UpdateEntryGroupRequest)(nil),                // 7: google.cloud.datacatalog.v1.UpdateEntryGroupRequest
	(*GetEntryGroupRequest)(nil),                   // 8: google.cloud.datacatalog.v1.GetEntryGroupRequest
	(*DeleteEntryGroupRequest)(nil),                // 9: google.cloud.datacatalog.v1.DeleteEntryGroupRequest
	(*ListEntryGroupsRequest)(nil),                 // 10: google.cloud.datacatalog.v1.ListEntryGroupsRequest
	(*ListEntryGroupsResponse)(nil),                // 11: google.cloud.datacatalog.v1.ListEntryGroupsResponse
	(*CreateEntryRequest)(nil),                     // 12: google.cloud.datacatalog.v1.CreateEntryRequest
	(*UpdateEntryRequest)(nil),                     // 13: google.cloud.datacatalog.v1.UpdateEntryRequest
	(*DeleteEntryRequest)(nil),                     // 14: google.cloud.datacatalog.v1.DeleteEntryRequest
	(*GetEntryRequest)(nil),                        // 15: google.cloud.datacatalog.v1.GetEntryRequest
	(*LookupEntryRequest)(nil),                     // 16: google.cloud.datacatalog.v1.LookupEntryRequest
	(*Entry)(nil),                                  // 17: google.cloud.datacatalog.v1.Entry
	(*DatabaseTableSpec)(nil),                      // 18: google.cloud.datacatalog.v1.DatabaseTableSpec
	(*FilesetSpec)(nil),                            // 19: google.cloud.datacatalog.v1.FilesetSpec
	(*DataSourceConnectionSpec)(nil),               // 20: google.cloud.datacatalog.v1.DataSourceConnectionSpec
	(*RoutineSpec)(nil),                            // 21: google.cloud.datacatalog.v1.RoutineSpec
	(*BusinessContext)(nil),                        // 22: google.cloud.datacatalog.v1.BusinessContext
	(*EntryOverview)(nil),                          // 23: google.cloud.datacatalog.v1.EntryOverview
	(*Contacts)(nil),                               // 24: google.cloud.datacatalog.v1.Contacts
	(*EntryGroup)(nil),                             // 25: google.cloud.datacatalog.v1.EntryGroup
	(*CreateTagTemplateRequest)(nil),               // 26: google.cloud.datacatalog.v1.CreateTagTemplateRequest
	(*GetTagTemplateRequest)(nil),                  // 27: google.cloud.datacatalog.v1.GetTagTemplateRequest
	(*UpdateTagTemplateRequest)(nil),               // 28: google.cloud.datacatalog.v1.UpdateTagTemplateRequest
	(*DeleteTagTemplateRequest)(nil),               // 29: google.cloud.datacatalog.v1.DeleteTagTemplateRequest
	(*CreateTagRequest)(nil),                       // 30: google.cloud.datacatalog.v1.CreateTagRequest
	(*UpdateTagRequest)(nil),                       // 31: google.cloud.datacatalog.v1.UpdateTagRequest
	(*DeleteTagRequest)(nil),                       // 32: google.cloud.datacatalog.v1.DeleteTagRequest
	(*CreateTagTemplateFieldRequest)(nil),          // 33: google.cloud.datacatalog.v1.CreateTagTemplateFieldRequest
	(*UpdateTagTemplateFieldRequest)(nil),          // 34: google.cloud.datacatalog.v1.UpdateTagTemplateFieldRequest
	(*RenameTagTemplateFieldRequest)(nil),          // 35: google.cloud.datacatalog.v1.RenameTagTemplateFieldRequest
	(*RenameTagTemplateFieldEnumValueRequest)(nil), // 36: google.cloud.datacatalog.v1.RenameTagTemplateFieldEnumValueRequest
	(*DeleteTagTemplateFieldRequest)(nil),          // 37: google.cloud.datacatalog.v1.DeleteTagTemplateFieldRequest
	(*ListTagsRequest)(nil),                        // 38: google.cloud.datacatalog.v1.ListTagsRequest
	(*ListTagsResponse)(nil),                       // 39: google.cloud.datacatalog.v1.ListTagsResponse
	(*ListEntriesRequest)(nil),                     // 40: google.cloud.datacatalog.v1.ListEntriesRequest
	(*ListEntriesResponse)(nil),                    // 41: google.cloud.datacatalog.v1.ListEntriesResponse
	(*StarEntryRequest)(nil),                       // 42: google.cloud.datacatalog.v1.StarEntryRequest
	(*StarEntryResponse)(nil),                      // 43: google.cloud.datacatalog.v1.StarEntryResponse
	(*UnstarEntryRequest)(nil),                     // 44: google.cloud.datacatalog.v1.UnstarEntryRequest
	(*UnstarEntryResponse)(nil),                    // 45: google.cloud.datacatalog.v1.UnstarEntryResponse
	(*ModifyEntryOverviewRequest)(nil),             // 46: google.cloud.datacatalog.v1.ModifyEntryOverviewRequest
	(*ModifyEntryContactsRequest)(nil),             // 47: google.cloud.datacatalog.v1.ModifyEntryContactsRequest
	(*SearchCatalogRequest_Scope)(nil),             // 48: google.cloud.datacatalog.v1.SearchCatalogRequest.Scope
	nil,                                            // 49: google.cloud.datacatalog.v1.Entry.LabelsEntry
	(*RoutineSpec_Argument)(nil),                   // 50: google.cloud.datacatalog.v1.RoutineSpec.Argument
	(*Contacts_Person)(nil),                        // 51: google.cloud.datacatalog.v1.Contacts.Person
	(*SearchCatalogResult)(nil),                    // 52: google.cloud.datacatalog.v1.SearchCatalogResult
	(*fieldmaskpb.FieldMask)(nil),                  // 53: google.protobuf.FieldMask
	(IntegratedSystem)(0),                          // 54: google.cloud.datacatalog.v1.IntegratedSystem
	(*GcsFilesetSpec)(nil),                         // 55: google.cloud.datacatalog.v1.GcsFilesetSpec
	(*BigQueryTableSpec)(nil),                      // 56: google.cloud.datacatalog.v1.BigQueryTableSpec
	(*BigQueryDateShardedSpec)(nil),                // 57: google.cloud.datacatalog.v1.BigQueryDateShardedSpec
	(*Schema)(nil),                                 // 58: google.cloud.datacatalog.v1.Schema
	(*SystemTimestamps)(nil),                       // 59: google.cloud.datacatalog.v1.SystemTimestamps
	(*UsageSignal)(nil),                            // 60: google.cloud.datacatalog.v1.UsageSignal
	(*DataSource)(nil),                             // 61: google.cloud.datacatalog.v1.DataSource
	(*PersonalDetails)(nil),                        // 62: google.cloud.datacatalog.v1.PersonalDetails
	(*DataplexTableSpec)(nil),                      // 63: google.cloud.datacatalog.v1.DataplexTableSpec
	(*DataplexFilesetSpec)(nil),                    // 64: google.cloud.datacatalog.v1.DataplexFilesetSpec
	(*BigQueryConnectionSpec)(nil),                 // 65: google.cloud.datacatalog.v1.BigQueryConnectionSpec
	(*BigQueryRoutineSpec)(nil),                    // 66: google.cloud.datacatalog.v1.BigQueryRoutineSpec
	(*TagTemplate)(nil),                            // 67: google.cloud.datacatalog.v1.TagTemplate
	(*Tag)(nil),                                    // 68: google.cloud.datacatalog.v1.Tag
	(*TagTemplateField)(nil),                       // 69: google.cloud.datacatalog.v1.TagTemplateField
	(*v1.SetIamPolicyRequest)(nil),                 // 70: google.iam.v1.SetIamPolicyRequest
	(*v1.GetIamPolicyRequest)(nil),                 // 71: google.iam.v1.GetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),           // 72: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                          // 73: google.protobuf.Empty
	(*v1.Policy)(nil),                              // 74: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil),          // 75: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_datacatalog_v1_datacatalog_proto_depIdxs = []int32{
	48, // 0: google.cloud.datacatalog.v1.SearchCatalogRequest.scope:type_name -> google.cloud.datacatalog.v1.SearchCatalogRequest.Scope
	52, // 1: google.cloud.datacatalog.v1.SearchCatalogResponse.results:type_name -> google.cloud.datacatalog.v1.SearchCatalogResult
	25, // 2: google.cloud.datacatalog.v1.CreateEntryGroupRequest.entry_group:type_name -> google.cloud.datacatalog.v1.EntryGroup
	25, // 3: google.cloud.datacatalog.v1.UpdateEntryGroupRequest.entry_group:type_name -> google.cloud.datacatalog.v1.EntryGroup
	53, // 4: google.cloud.datacatalog.v1.UpdateEntryGroupRequest.update_mask:type_name -> google.protobuf.FieldMask
	53, // 5: google.cloud.datacatalog.v1.GetEntryGroupRequest.read_mask:type_name -> google.protobuf.FieldMask
	25, // 6: google.cloud.datacatalog.v1.ListEntryGroupsResponse.entry_groups:type_name -> google.cloud.datacatalog.v1.EntryGroup
	17, // 7: google.cloud.datacatalog.v1.CreateEntryRequest.entry:type_name -> google.cloud.datacatalog.v1.Entry
	17, // 8: google.cloud.datacatalog.v1.UpdateEntryRequest.entry:type_name -> google.cloud.datacatalog.v1.Entry
	53, // 9: google.cloud.datacatalog.v1.UpdateEntryRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 10: google.cloud.datacatalog.v1.Entry.type:type_name -> google.cloud.datacatalog.v1.EntryType
	54, // 11: google.cloud.datacatalog.v1.Entry.integrated_system:type_name -> google.cloud.datacatalog.v1.IntegratedSystem
	55, // 12: google.cloud.datacatalog.v1.Entry.gcs_fileset_spec:type_name -> google.cloud.datacatalog.v1.GcsFilesetSpec
	56, // 13: google.cloud.datacatalog.v1.Entry.bigquery_table_spec:type_name -> google.cloud.datacatalog.v1.BigQueryTableSpec
	57, // 14: google.cloud.datacatalog.v1.Entry.bigquery_date_sharded_spec:type_name -> google.cloud.datacatalog.v1.BigQueryDateShardedSpec
	18, // 15: google.cloud.datacatalog.v1.Entry.database_table_spec:type_name -> google.cloud.datacatalog.v1.DatabaseTableSpec
	20, // 16: google.cloud.datacatalog.v1.Entry.data_source_connection_spec:type_name -> google.cloud.datacatalog.v1.DataSourceConnectionSpec
	21, // 17: google.cloud.datacatalog.v1.Entry.routine_spec:type_name -> google.cloud.datacatalog.v1.RoutineSpec
	19, // 18: google.cloud.datacatalog.v1.Entry.fileset_spec:type_name -> google.cloud.datacatalog.v1.FilesetSpec
	22, // 19: google.cloud.datacatalog.v1.Entry.business_context:type_name -> google.cloud.datacatalog.v1.BusinessContext
	58, // 20: google.cloud.datacatalog.v1.Entry.schema:type_name -> google.cloud.datacatalog.v1.Schema
	59, // 21: google.cloud.datacatalog.v1.Entry.source_system_timestamps:type_name -> google.cloud.datacatalog.v1.SystemTimestamps
	60, // 22: google.cloud.datacatalog.v1.Entry.usage_signal:type_name -> google.cloud.datacatalog.v1.UsageSignal
	49, // 23: google.cloud.datacatalog.v1.Entry.labels:type_name -> google.cloud.datacatalog.v1.Entry.LabelsEntry
	61, // 24: google.cloud.datacatalog.v1.Entry.data_source:type_name -> google.cloud.datacatalog.v1.DataSource
	62, // 25: google.cloud.datacatalog.v1.Entry.personal_details:type_name -> google.cloud.datacatalog.v1.PersonalDetails
	1,  // 26: google.cloud.datacatalog.v1.DatabaseTableSpec.type:type_name -> google.cloud.datacatalog.v1.DatabaseTableSpec.TableType
	63, // 27: google.cloud.datacatalog.v1.DatabaseTableSpec.dataplex_table:type_name -> google.cloud.datacatalog.v1.DataplexTableSpec
	64, // 28: google.cloud.datacatalog.v1.FilesetSpec.dataplex_fileset:type_name -> google.cloud.datacatalog.v1.DataplexFilesetSpec
	65, // 29: google.cloud.datacatalog.v1.DataSourceConnectionSpec.bigquery_connection_spec:type_name -> google.cloud.datacatalog.v1.BigQueryConnectionSpec
	2,  // 30: google.cloud.datacatalog.v1.RoutineSpec.routine_type:type_name -> google.cloud.datacatalog.v1.RoutineSpec.RoutineType
	50, // 31: google.cloud.datacatalog.v1.RoutineSpec.routine_arguments:type_name -> google.cloud.datacatalog.v1.RoutineSpec.Argument
	66, // 32: google.cloud.datacatalog.v1.RoutineSpec.bigquery_routine_spec:type_name -> google.cloud.datacatalog.v1.BigQueryRoutineSpec
	23, // 33: google.cloud.datacatalog.v1.BusinessContext.entry_overview:type_name -> google.cloud.datacatalog.v1.EntryOverview
	24, // 34: google.cloud.datacatalog.v1.BusinessContext.contacts:type_name -> google.cloud.datacatalog.v1.Contacts
	51, // 35: google.cloud.datacatalog.v1.Contacts.people:type_name -> google.cloud.datacatalog.v1.Contacts.Person
	59, // 36: google.cloud.datacatalog.v1.EntryGroup.data_catalog_timestamps:type_name -> google.cloud.datacatalog.v1.SystemTimestamps
	67, // 37: google.cloud.datacatalog.v1.CreateTagTemplateRequest.tag_template:type_name -> google.cloud.datacatalog.v1.TagTemplate
	67, // 38: google.cloud.datacatalog.v1.UpdateTagTemplateRequest.tag_template:type_name -> google.cloud.datacatalog.v1.TagTemplate
	53, // 39: google.cloud.datacatalog.v1.UpdateTagTemplateRequest.update_mask:type_name -> google.protobuf.FieldMask
	68, // 40: google.cloud.datacatalog.v1.CreateTagRequest.tag:type_name -> google.cloud.datacatalog.v1.Tag
	68, // 41: google.cloud.datacatalog.v1.UpdateTagRequest.tag:type_name -> google.cloud.datacatalog.v1.Tag
	53, // 42: google.cloud.datacatalog.v1.UpdateTagRequest.update_mask:type_name -> google.protobuf.FieldMask
	69, // 43: google.cloud.datacatalog.v1.CreateTagTemplateFieldRequest.tag_template_field:type_name -> google.cloud.datacatalog.v1.TagTemplateField
	69, // 44: google.cloud.datacatalog.v1.UpdateTagTemplateFieldRequest.tag_template_field:type_name -> google.cloud.datacatalog.v1.TagTemplateField
	53, // 45: google.cloud.datacatalog.v1.UpdateTagTemplateFieldRequest.update_mask:type_name -> google.protobuf.FieldMask
	68, // 46: google.cloud.datacatalog.v1.ListTagsResponse.tags:type_name -> google.cloud.datacatalog.v1.Tag
	53, // 47: google.cloud.datacatalog.v1.ListEntriesRequest.read_mask:type_name -> google.protobuf.FieldMask
	17, // 48: google.cloud.datacatalog.v1.ListEntriesResponse.entries:type_name -> google.cloud.datacatalog.v1.Entry
	23, // 49: google.cloud.datacatalog.v1.ModifyEntryOverviewRequest.entry_overview:type_name -> google.cloud.datacatalog.v1.EntryOverview
	24, // 50: google.cloud.datacatalog.v1.ModifyEntryContactsRequest.contacts:type_name -> google.cloud.datacatalog.v1.Contacts
	3,  // 51: google.cloud.datacatalog.v1.RoutineSpec.Argument.mode:type_name -> google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode
	4,  // 52: google.cloud.datacatalog.v1.DataCatalog.SearchCatalog:input_type -> google.cloud.datacatalog.v1.SearchCatalogRequest
	6,  // 53: google.cloud.datacatalog.v1.DataCatalog.CreateEntryGroup:input_type -> google.cloud.datacatalog.v1.CreateEntryGroupRequest
	8,  // 54: google.cloud.datacatalog.v1.DataCatalog.GetEntryGroup:input_type -> google.cloud.datacatalog.v1.GetEntryGroupRequest
	7,  // 55: google.cloud.datacatalog.v1.DataCatalog.UpdateEntryGroup:input_type -> google.cloud.datacatalog.v1.UpdateEntryGroupRequest
	9,  // 56: google.cloud.datacatalog.v1.DataCatalog.DeleteEntryGroup:input_type -> google.cloud.datacatalog.v1.DeleteEntryGroupRequest
	10, // 57: google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups:input_type -> google.cloud.datacatalog.v1.ListEntryGroupsRequest
	12, // 58: google.cloud.datacatalog.v1.DataCatalog.CreateEntry:input_type -> google.cloud.datacatalog.v1.CreateEntryRequest
	13, // 59: google.cloud.datacatalog.v1.DataCatalog.UpdateEntry:input_type -> google.cloud.datacatalog.v1.UpdateEntryRequest
	14, // 60: google.cloud.datacatalog.v1.DataCatalog.DeleteEntry:input_type -> google.cloud.datacatalog.v1.DeleteEntryRequest
	15, // 61: google.cloud.datacatalog.v1.DataCatalog.GetEntry:input_type -> google.cloud.datacatalog.v1.GetEntryRequest
	16, // 62: google.cloud.datacatalog.v1.DataCatalog.LookupEntry:input_type -> google.cloud.datacatalog.v1.LookupEntryRequest
	40, // 63: google.cloud.datacatalog.v1.DataCatalog.ListEntries:input_type -> google.cloud.datacatalog.v1.ListEntriesRequest
	46, // 64: google.cloud.datacatalog.v1.DataCatalog.ModifyEntryOverview:input_type -> google.cloud.datacatalog.v1.ModifyEntryOverviewRequest
	47, // 65: google.cloud.datacatalog.v1.DataCatalog.ModifyEntryContacts:input_type -> google.cloud.datacatalog.v1.ModifyEntryContactsRequest
	26, // 66: google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplate:input_type -> google.cloud.datacatalog.v1.CreateTagTemplateRequest
	27, // 67: google.cloud.datacatalog.v1.DataCatalog.GetTagTemplate:input_type -> google.cloud.datacatalog.v1.GetTagTemplateRequest
	28, // 68: google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplate:input_type -> google.cloud.datacatalog.v1.UpdateTagTemplateRequest
	29, // 69: google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplate:input_type -> google.cloud.datacatalog.v1.DeleteTagTemplateRequest
	33, // 70: google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplateField:input_type -> google.cloud.datacatalog.v1.CreateTagTemplateFieldRequest
	34, // 71: google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplateField:input_type -> google.cloud.datacatalog.v1.UpdateTagTemplateFieldRequest
	35, // 72: google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateField:input_type -> google.cloud.datacatalog.v1.RenameTagTemplateFieldRequest
	36, // 73: google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateFieldEnumValue:input_type -> google.cloud.datacatalog.v1.RenameTagTemplateFieldEnumValueRequest
	37, // 74: google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplateField:input_type -> google.cloud.datacatalog.v1.DeleteTagTemplateFieldRequest
	30, // 75: google.cloud.datacatalog.v1.DataCatalog.CreateTag:input_type -> google.cloud.datacatalog.v1.CreateTagRequest
	31, // 76: google.cloud.datacatalog.v1.DataCatalog.UpdateTag:input_type -> google.cloud.datacatalog.v1.UpdateTagRequest
	32, // 77: google.cloud.datacatalog.v1.DataCatalog.DeleteTag:input_type -> google.cloud.datacatalog.v1.DeleteTagRequest
	38, // 78: google.cloud.datacatalog.v1.DataCatalog.ListTags:input_type -> google.cloud.datacatalog.v1.ListTagsRequest
	42, // 79: google.cloud.datacatalog.v1.DataCatalog.StarEntry:input_type -> google.cloud.datacatalog.v1.StarEntryRequest
	44, // 80: google.cloud.datacatalog.v1.DataCatalog.UnstarEntry:input_type -> google.cloud.datacatalog.v1.UnstarEntryRequest
	70, // 81: google.cloud.datacatalog.v1.DataCatalog.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	71, // 82: google.cloud.datacatalog.v1.DataCatalog.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	72, // 83: google.cloud.datacatalog.v1.DataCatalog.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	5,  // 84: google.cloud.datacatalog.v1.DataCatalog.SearchCatalog:output_type -> google.cloud.datacatalog.v1.SearchCatalogResponse
	25, // 85: google.cloud.datacatalog.v1.DataCatalog.CreateEntryGroup:output_type -> google.cloud.datacatalog.v1.EntryGroup
	25, // 86: google.cloud.datacatalog.v1.DataCatalog.GetEntryGroup:output_type -> google.cloud.datacatalog.v1.EntryGroup
	25, // 87: google.cloud.datacatalog.v1.DataCatalog.UpdateEntryGroup:output_type -> google.cloud.datacatalog.v1.EntryGroup
	73, // 88: google.cloud.datacatalog.v1.DataCatalog.DeleteEntryGroup:output_type -> google.protobuf.Empty
	11, // 89: google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups:output_type -> google.cloud.datacatalog.v1.ListEntryGroupsResponse
	17, // 90: google.cloud.datacatalog.v1.DataCatalog.CreateEntry:output_type -> google.cloud.datacatalog.v1.Entry
	17, // 91: google.cloud.datacatalog.v1.DataCatalog.UpdateEntry:output_type -> google.cloud.datacatalog.v1.Entry
	73, // 92: google.cloud.datacatalog.v1.DataCatalog.DeleteEntry:output_type -> google.protobuf.Empty
	17, // 93: google.cloud.datacatalog.v1.DataCatalog.GetEntry:output_type -> google.cloud.datacatalog.v1.Entry
	17, // 94: google.cloud.datacatalog.v1.DataCatalog.LookupEntry:output_type -> google.cloud.datacatalog.v1.Entry
	41, // 95: google.cloud.datacatalog.v1.DataCatalog.ListEntries:output_type -> google.cloud.datacatalog.v1.ListEntriesResponse
	23, // 96: google.cloud.datacatalog.v1.DataCatalog.ModifyEntryOverview:output_type -> google.cloud.datacatalog.v1.EntryOverview
	24, // 97: google.cloud.datacatalog.v1.DataCatalog.ModifyEntryContacts:output_type -> google.cloud.datacatalog.v1.Contacts
	67, // 98: google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplate:output_type -> google.cloud.datacatalog.v1.TagTemplate
	67, // 99: google.cloud.datacatalog.v1.DataCatalog.GetTagTemplate:output_type -> google.cloud.datacatalog.v1.TagTemplate
	67, // 100: google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplate:output_type -> google.cloud.datacatalog.v1.TagTemplate
	73, // 101: google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplate:output_type -> google.protobuf.Empty
	69, // 102: google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplateField:output_type -> google.cloud.datacatalog.v1.TagTemplateField
	69, // 103: google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplateField:output_type -> google.cloud.datacatalog.v1.TagTemplateField
	69, // 104: google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateField:output_type -> google.cloud.datacatalog.v1.TagTemplateField
	69, // 105: google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateFieldEnumValue:output_type -> google.cloud.datacatalog.v1.TagTemplateField
	73, // 106: google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplateField:output_type -> google.protobuf.Empty
	68, // 107: google.cloud.datacatalog.v1.DataCatalog.CreateTag:output_type -> google.cloud.datacatalog.v1.Tag
	68, // 108: google.cloud.datacatalog.v1.DataCatalog.UpdateTag:output_type -> google.cloud.datacatalog.v1.Tag
	73, // 109: google.cloud.datacatalog.v1.DataCatalog.DeleteTag:output_type -> google.protobuf.Empty
	39, // 110: google.cloud.datacatalog.v1.DataCatalog.ListTags:output_type -> google.cloud.datacatalog.v1.ListTagsResponse
	43, // 111: google.cloud.datacatalog.v1.DataCatalog.StarEntry:output_type -> google.cloud.datacatalog.v1.StarEntryResponse
	45, // 112: google.cloud.datacatalog.v1.DataCatalog.UnstarEntry:output_type -> google.cloud.datacatalog.v1.UnstarEntryResponse
	74, // 113: google.cloud.datacatalog.v1.DataCatalog.SetIamPolicy:output_type -> google.iam.v1.Policy
	74, // 114: google.cloud.datacatalog.v1.DataCatalog.GetIamPolicy:output_type -> google.iam.v1.Policy
	75, // 115: google.cloud.datacatalog.v1.DataCatalog.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	84, // [84:116] is the sub-list for method output_type
	52, // [52:84] is the sub-list for method input_type
	52, // [52:52] is the sub-list for extension type_name
	52, // [52:52] is the sub-list for extension extendee
	0,  // [0:52] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1_datacatalog_proto_init() }
func file_google_cloud_datacatalog_v1_datacatalog_proto_init() {
	if File_google_cloud_datacatalog_v1_datacatalog_proto != nil {
		return
	}
	file_google_cloud_datacatalog_v1_bigquery_proto_init()
	file_google_cloud_datacatalog_v1_common_proto_init()
	file_google_cloud_datacatalog_v1_data_source_proto_init()
	file_google_cloud_datacatalog_v1_dataplex_spec_proto_init()
	file_google_cloud_datacatalog_v1_gcs_fileset_spec_proto_init()
	file_google_cloud_datacatalog_v1_schema_proto_init()
	file_google_cloud_datacatalog_v1_search_proto_init()
	file_google_cloud_datacatalog_v1_table_spec_proto_init()
	file_google_cloud_datacatalog_v1_tags_proto_init()
	file_google_cloud_datacatalog_v1_timestamps_proto_init()
	file_google_cloud_datacatalog_v1_usage_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCatalogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCatalogResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEntryGroupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntryGroupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntryGroupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LookupEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseTableSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilesetSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSourceConnectionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoutineSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BusinessContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntryOverview); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Contacts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EntryGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTagTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTagTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTagTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTagTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTagRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTagTemplateFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTagTemplateFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameTagTemplateFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenameTagTemplateFieldEnumValueRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTagTemplateFieldRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTagsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTagsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListEntriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StarEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StarEntryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnstarEntryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnstarEntryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModifyEntryOverviewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModifyEntryContactsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCatalogRequest_Scope); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoutineSpec_Argument); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Contacts_Person); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*LookupEntryRequest_LinkedResource)(nil),
		(*LookupEntryRequest_SqlResource)(nil),
		(*LookupEntryRequest_FullyQualifiedName)(nil),
	}
	file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*Entry_Type)(nil),
		(*Entry_UserSpecifiedType)(nil),
		(*Entry_IntegratedSystem)(nil),
		(*Entry_UserSpecifiedSystem)(nil),
		(*Entry_GcsFilesetSpec)(nil),
		(*Entry_BigqueryTableSpec)(nil),
		(*Entry_BigqueryDateShardedSpec)(nil),
		(*Entry_DatabaseTableSpec)(nil),
		(*Entry_DataSourceConnectionSpec)(nil),
		(*Entry_RoutineSpec)(nil),
		(*Entry_FilesetSpec)(nil),
	}
	file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes[17].OneofWrappers = []interface{}{
		(*RoutineSpec_BigqueryRoutineSpec)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1_datacatalog_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   48,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_datacatalog_v1_datacatalog_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1_datacatalog_proto_depIdxs,
		EnumInfos:         file_google_cloud_datacatalog_v1_datacatalog_proto_enumTypes,
		MessageInfos:      file_google_cloud_datacatalog_v1_datacatalog_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1_datacatalog_proto = out.File
	file_google_cloud_datacatalog_v1_datacatalog_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1_datacatalog_proto_goTypes = nil
	file_google_cloud_datacatalog_v1_datacatalog_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataCatalogClient is the client API for DataCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataCatalogClient interface {
	// Searches Data Catalog for multiple resources like entries and tags that
	// match a query.
	//
	// This is a [Custom Method]
	// (https://cloud.google.com/apis/design/custom_methods) that doesn't return
	// all information on a resource, only its ID and high level fields. To get
	// more information, you can subsequently call specific get methods.
	//
	// Note: Data Catalog search queries don't guarantee full recall. Results
	// that match your query might not be returned, even in subsequent
	// result pages. Additionally, returned (and not returned) results can vary
	// if you repeat search queries.
	//
	// For more information, see [Data Catalog search syntax]
	// (https://cloud.google.com/data-catalog/docs/how-to/search-reference).
	SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error)
	// Creates an entry group.
	//
	// An entry group contains logically related entries together with [Cloud
	// Identity and Access Management](/data-catalog/docs/concepts/iam) policies.
	// These policies specify users who can create, edit, and view entries
	// within entry groups.
	//
	// Data Catalog automatically creates entry groups with names that start with
	// the `@` symbol for the following resources:
	//
	// * BigQuery entries (`@bigquery`)
	// * Pub/Sub topics (`@pubsub`)
	// * Dataproc Metastore services (`@dataproc_metastore_{SERVICE_NAME_HASH}`)
	//
	// You can create your own entry groups for Cloud Storage fileset entries
	// and custom entries together with the corresponding IAM policies.
	// User-created entry groups can't contain the `@` symbol, it is reserved
	// for automatically created groups.
	//
	// Entry groups, like entries, can be searched.
	//
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Gets an entry group.
	GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Updates an entry group.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `entry_group.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Deletes an entry group.
	//
	// You must enable the Data Catalog API in the project
	// identified by the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists entry groups.
	ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error)
	// Creates an entry.
	//
	// You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM',
	// or custom types. Data Catalog automatically creates entries with other
	// types during metadata ingestion from integrated systems.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	//
	// An entry group can have a maximum of 100,000 entries.
	CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Updates an existing entry.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `entry.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deletes an existing entry.
	//
	// You can delete only the entries created by the
	// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
	// method.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets an entry.
	GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Gets an entry by its target resource name.
	//
	// The resource name comes from the source Google Cloud Platform service.
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Lists entries.
	//
	// Note: Currently, this method can list only custom entries.
	// To get a list of both custom and automatically created entries, use
	// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
	ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error)
	// Modifies entry overview, part of the business context of an
	// [Entry][google.cloud.datacatalog.v1.Entry].
	//
	// To call this method, you must have the `datacatalog.entries.updateOverview`
	// IAM permission on the corresponding project.
	ModifyEntryOverview(ctx context.Context, in *ModifyEntryOverviewRequest, opts ...grpc.CallOption) (*EntryOverview, error)
	// Modifies contacts, part of the business context of an
	// [Entry][google.cloud.datacatalog.v1.Entry].
	//
	// To call this method, you must have the `datacatalog.entries.updateContacts`
	// IAM permission on the corresponding project.
	ModifyEntryContacts(ctx context.Context, in *ModifyEntryContactsRequest, opts ...grpc.CallOption) (*Contacts, error)
	// Creates a tag template.
	//
	// You must enable the Data Catalog API in the project identified by the
	// `parent` parameter.
	// For more information, see [Data Catalog resource project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Updates a tag template.
	//
	// You can't update template fields with this method. These fields are
	// separate resources with their own create, update, and delete methods.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deletes a tag template and all tags that use it.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a field in a tag template.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Updates a field in a tag template.
	//
	// You can't update the field type with this method.
	//
	// You must enable the Data Catalog API in the project
	// identified by the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Renames a field in a tag template.
	//
	// You must enable the Data Catalog API in the project identified by the
	// `name` parameter. For more information, see [Data Catalog resource project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Renames an enum value in a tag template.
	//
	// Within a single enum field, enum values must be unique.
	RenameTagTemplateFieldEnumValue(ctx context.Context, in *RenameTagTemplateFieldEnumValueRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of this field from the tags
	// based on this template.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a tag and assigns it to:
	//
	//   - An [Entry][google.cloud.datacatalog.v1.Entry] if the method name is
	//     `projects.locations.entryGroups.entries.tags.create`.
	//   - Or [EntryGroup][google.cloud.datacatalog.v1.EntryGroup]if the method
	//     name is `projects.locations.entryGroups.tags.create`.
	//
	// Note: The project identified by the `parent` parameter for the [tag]
	// (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the [tag template]
	// (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be in the same organization.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deletes a tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists tags assigned to an [Entry][google.cloud.datacatalog.v1.Entry].
	// The [columns][google.cloud.datacatalog.v1.Tag.column] in the response are
	// lowercased.
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Marks an [Entry][google.cloud.datacatalog.v1.Entry] as starred by
	// the current user. Starring information is private to each user.
	StarEntry(ctx context.Context, in *StarEntryRequest, opts ...grpc.CallOption) (*StarEntryResponse, error)
	// Marks an [Entry][google.cloud.datacatalog.v1.Entry] as NOT starred by
	// the current user. Starring information is private to each user.
	UnstarEntry(ctx context.Context, in *UnstarEntryRequest, opts ...grpc.CallOption) (*UnstarEntryResponse, error)
	// Sets an access control policy for a resource. Replaces any existing
	// policy.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method sets policies only within Data Catalog and can't be
	// used to manage policies in BigQuery, Pub/Sub, Dataproc Metastore, and any
	// external Google Cloud Platform resources synced with the Data Catalog.
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a resource.
	//
	// May return:
	//
	//   - A`NOT_FOUND` error if the resource doesn't exist or you don't have the
	//     permission to view it.
	//   - An empty policy if the resource exists but doesn't have a set policy.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method doesn't get policies from Google Cloud Platform
	// resources ingested into Data Catalog.
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets your permissions on a resource.
	//
	// Returns an empty set of permissions if the resource doesn't exist.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method gets policies only within Data Catalog and can't be
	// used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any
	// external Google Cloud Platform resources ingested into Data Catalog.
	//
	// No Google IAM permissions are required to call this method.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type dataCatalogClient struct {
	cc grpc.ClientConnInterface
}

func NewDataCatalogClient(cc grpc.ClientConnInterface) DataCatalogClient {
	return &dataCatalogClient{cc}
}

func (c *dataCatalogClient) SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error) {
	out := new(SearchCatalogResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/SearchCatalog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error) {
	out := new(ListEntryGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ListEntryGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/LookupEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error) {
	out := new(ListEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ListEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ModifyEntryOverview(ctx context.Context, in *ModifyEntryOverviewRequest, opts ...grpc.CallOption) (*EntryOverview, error) {
	out := new(EntryOverview)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ModifyEntryOverview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ModifyEntryContacts(ctx context.Context, in *ModifyEntryContactsRequest, opts ...grpc.CallOption) (*Contacts, error) {
	out := new(Contacts)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ModifyEntryContacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) RenameTagTemplateFieldEnumValue(ctx context.Context, in *RenameTagTemplateFieldEnumValueRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateFieldEnumValue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ListTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) StarEntry(ctx context.Context, in *StarEntryRequest, opts ...grpc.CallOption) (*StarEntryResponse, error) {
	out := new(StarEntryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/StarEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UnstarEntry(ctx context.Context, in *UnstarEntryRequest, opts ...grpc.CallOption) (*UnstarEntryResponse, error) {
	out := new(UnstarEntryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UnstarEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataCatalogServer is the server API for DataCatalog service.
type DataCatalogServer interface {
	// Searches Data Catalog for multiple resources like entries and tags that
	// match a query.
	//
	// This is a [Custom Method]
	// (https://cloud.google.com/apis/design/custom_methods) that doesn't return
	// all information on a resource, only its ID and high level fields. To get
	// more information, you can subsequently call specific get methods.
	//
	// Note: Data Catalog search queries don't guarantee full recall. Results
	// that match your query might not be returned, even in subsequent
	// result pages. Additionally, returned (and not returned) results can vary
	// if you repeat search queries.
	//
	// For more information, see [Data Catalog search syntax]
	// (https://cloud.google.com/data-catalog/docs/how-to/search-reference).
	SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error)
	// Creates an entry group.
	//
	// An entry group contains logically related entries together with [Cloud
	// Identity and Access Management](/data-catalog/docs/concepts/iam) policies.
	// These policies specify users who can create, edit, and view entries
	// within entry groups.
	//
	// Data Catalog automatically creates entry groups with names that start with
	// the `@` symbol for the following resources:
	//
	// * BigQuery entries (`@bigquery`)
	// * Pub/Sub topics (`@pubsub`)
	// * Dataproc Metastore services (`@dataproc_metastore_{SERVICE_NAME_HASH}`)
	//
	// You can create your own entry groups for Cloud Storage fileset entries
	// and custom entries together with the corresponding IAM policies.
	// User-created entry groups can't contain the `@` symbol, it is reserved
	// for automatically created groups.
	//
	// Entry groups, like entries, can be searched.
	//
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error)
	// Gets an entry group.
	GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error)
	// Updates an entry group.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `entry_group.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*EntryGroup, error)
	// Deletes an entry group.
	//
	// You must enable the Data Catalog API in the project
	// identified by the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*emptypb.Empty, error)
	// Lists entry groups.
	ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error)
	// Creates an entry.
	//
	// You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM',
	// or custom types. Data Catalog automatically creates entries with other
	// types during metadata ingestion from integrated systems.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	//
	// An entry group can have a maximum of 100,000 entries.
	CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error)
	// Updates an existing entry.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `entry.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error)
	// Deletes an existing entry.
	//
	// You can delete only the entries created by the
	// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
	// method.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteEntry(context.Context, *DeleteEntryRequest) (*emptypb.Empty, error)
	// Gets an entry.
	GetEntry(context.Context, *GetEntryRequest) (*Entry, error)
	// Gets an entry by its target resource name.
	//
	// The resource name comes from the source Google Cloud Platform service.
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
	// Lists entries.
	//
	// Note: Currently, this method can list only custom entries.
	// To get a list of both custom and automatically created entries, use
	// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
	ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error)
	// Modifies entry overview, part of the business context of an
	// [Entry][google.cloud.datacatalog.v1.Entry].
	//
	// To call this method, you must have the `datacatalog.entries.updateOverview`
	// IAM permission on the corresponding project.
	ModifyEntryOverview(context.Context, *ModifyEntryOverviewRequest) (*EntryOverview, error)
	// Modifies contacts, part of the business context of an
	// [Entry][google.cloud.datacatalog.v1.Entry].
	//
	// To call this method, you must have the `datacatalog.entries.updateContacts`
	// IAM permission on the corresponding project.
	ModifyEntryContacts(context.Context, *ModifyEntryContactsRequest) (*Contacts, error)
	// Creates a tag template.
	//
	// You must enable the Data Catalog API in the project identified by the
	// `parent` parameter.
	// For more information, see [Data Catalog resource project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error)
	// Updates a tag template.
	//
	// You can't update template fields with this method. These fields are
	// separate resources with their own create, update, and delete methods.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error)
	// Deletes a tag template and all tags that use it.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*emptypb.Empty, error)
	// Creates a field in a tag template.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `parent` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Updates a field in a tag template.
	//
	// You can't update the field type with this method.
	//
	// You must enable the Data Catalog API in the project
	// identified by the `name` parameter. For more information, see [Data Catalog
	// resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Renames a field in a tag template.
	//
	// You must enable the Data Catalog API in the project identified by the
	// `name` parameter. For more information, see [Data Catalog resource project]
	// (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error)
	// Renames an enum value in a tag template.
	//
	// Within a single enum field, enum values must be unique.
	RenameTagTemplateFieldEnumValue(context.Context, *RenameTagTemplateFieldEnumValueRequest) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of this field from the tags
	// based on this template.
	//
	// You must enable the Data Catalog API in the project identified by
	// the `name` parameter. For more information, see [Data Catalog resource
	// project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
	DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*emptypb.Empty, error)
	// Creates a tag and assigns it to:
	//
	//   - An [Entry][google.cloud.datacatalog.v1.Entry] if the method name is
	//     `projects.locations.entryGroups.entries.tags.create`.
	//   - Or [EntryGroup][google.cloud.datacatalog.v1.EntryGroup]if the method
	//     name is `projects.locations.entryGroups.tags.create`.
	//
	// Note: The project identified by the `parent` parameter for the [tag]
	// (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the [tag template]
	// (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be in the same organization.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error)
	// Deletes a tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error)
	// Lists tags assigned to an [Entry][google.cloud.datacatalog.v1.Entry].
	// The [columns][google.cloud.datacatalog.v1.Tag.column] in the response are
	// lowercased.
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Marks an [Entry][google.cloud.datacatalog.v1.Entry] as starred by
	// the current user. Starring information is private to each user.
	StarEntry(context.Context, *StarEntryRequest) (*StarEntryResponse, error)
	// Marks an [Entry][google.cloud.datacatalog.v1.Entry] as NOT starred by
	// the current user. Starring information is private to each user.
	UnstarEntry(context.Context, *UnstarEntryRequest) (*UnstarEntryResponse, error)
	// Sets an access control policy for a resource. Replaces any existing
	// policy.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method sets policies only within Data Catalog and can't be
	// used to manage policies in BigQuery, Pub/Sub, Dataproc Metastore, and any
	// external Google Cloud Platform resources synced with the Data Catalog.
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a resource.
	//
	// May return:
	//
	//   - A`NOT_FOUND` error if the resource doesn't exist or you don't have the
	//     permission to view it.
	//   - An empty policy if the resource exists but doesn't have a set policy.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method doesn't get policies from Google Cloud Platform
	// resources ingested into Data Catalog.
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Gets your permissions on a resource.
	//
	// Returns an empty set of permissions if the resource doesn't exist.
	//
	// Supported resources are:
	//
	// - Tag templates
	// - Entry groups
	//
	// Note: This method gets policies only within Data Catalog and can't be
	// used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any
	// external Google Cloud Platform resources ingested into Data Catalog.
	//
	// No Google IAM permissions are required to call this method.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedDataCatalogServer can be embedded to have forward compatible implementations.
type UnimplementedDataCatalogServer struct {
}

func (*UnimplementedDataCatalogServer) SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCatalog not implemented")
}
func (*UnimplementedDataCatalogServer) CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntryGroups not implemented")
}
func (*UnimplementedDataCatalogServer) CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntry not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntry not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteEntry(context.Context, *DeleteEntryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntry not implemented")
}
func (*UnimplementedDataCatalogServer) GetEntry(context.Context, *GetEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntry not implemented")
}
func (*UnimplementedDataCatalogServer) LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEntry not implemented")
}
func (*UnimplementedDataCatalogServer) ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntries not implemented")
}
func (*UnimplementedDataCatalogServer) ModifyEntryOverview(context.Context, *ModifyEntryOverviewRequest) (*EntryOverview, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyEntryOverview not implemented")
}
func (*UnimplementedDataCatalogServer) ModifyEntryContacts(context.Context, *ModifyEntryContactsRequest) (*Contacts, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ModifyEntryContacts not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) RenameTagTemplateFieldEnumValue(context.Context, *RenameTagTemplateFieldEnumValueRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTagTemplateFieldEnumValue not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTag(context.Context, *CreateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTag not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTag not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTag not implemented")
}
func (*UnimplementedDataCatalogServer) ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTags not implemented")
}
func (*UnimplementedDataCatalogServer) StarEntry(context.Context, *StarEntryRequest) (*StarEntryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StarEntry not implemented")
}
func (*UnimplementedDataCatalogServer) UnstarEntry(context.Context, *UnstarEntryRequest) (*UnstarEntryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnstarEntry not implemented")
}
func (*UnimplementedDataCatalogServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedDataCatalogServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedDataCatalogServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterDataCatalogServer(s *grpc.Server, srv DataCatalogServer) {
	s.RegisterService(&_DataCatalog_serviceDesc, srv)
}

func _DataCatalog_SearchCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SearchCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/SearchCatalog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SearchCatalog(ctx, req.(*SearchCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, req.(*CreateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, req.(*GetEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, req.(*UpdateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, req.(*DeleteEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntryGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntryGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ListEntryGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, req.(*ListEntryGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntry(ctx, req.(*CreateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntry(ctx, req.(*UpdateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntry(ctx, req.(*DeleteEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntry(ctx, req.(*GetEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/LookupEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ListEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntries(ctx, req.(*ListEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ModifyEntryOverview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyEntryOverviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ModifyEntryOverview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ModifyEntryOverview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ModifyEntryOverview(ctx, req.(*ModifyEntryOverviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ModifyEntryContacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyEntryContactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ModifyEntryContacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ModifyEntryContacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ModifyEntryContacts(ctx, req.(*ModifyEntryContactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, req.(*CreateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, req.(*GetTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, req.(*UpdateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, req.(*DeleteTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, req.(*CreateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, req.(*UpdateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, req.(*RenameTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateFieldEnumValue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldEnumValueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateFieldEnumValue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateFieldEnumValue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateFieldEnumValue(ctx, req.(*RenameTagTemplateFieldEnumValueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, req.(*DeleteTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTag(ctx, req.(*UpdateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ListTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_StarEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StarEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).StarEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/StarEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).StarEntry(ctx, req.(*StarEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UnstarEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnstarEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UnstarEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UnstarEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UnstarEntry(ctx, req.(*UnstarEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataCatalog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1.DataCatalog",
	HandlerType: (*DataCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchCatalog",
			Handler:    _DataCatalog_SearchCatalog_Handler,
		},
		{
			MethodName: "CreateEntryGroup",
			Handler:    _DataCatalog_CreateEntryGroup_Handler,
		},
		{
			MethodName: "GetEntryGroup",
			Handler:    _DataCatalog_GetEntryGroup_Handler,
		},
		{
			MethodName: "UpdateEntryGroup",
			Handler:    _DataCatalog_UpdateEntryGroup_Handler,
		},
		{
			MethodName: "DeleteEntryGroup",
			Handler:    _DataCatalog_DeleteEntryGroup_Handler,
		},
		{
			MethodName: "ListEntryGroups",
			Handler:    _DataCatalog_ListEntryGroups_Handler,
		},
		{
			MethodName: "CreateEntry",
			Handler:    _DataCatalog_CreateEntry_Handler,
		},
		{
			MethodName: "UpdateEntry",
			Handler:    _DataCatalog_UpdateEntry_Handler,
		},
		{
			MethodName: "DeleteEntry",
			Handler:    _DataCatalog_DeleteEntry_Handler,
		},
		{
			MethodName: "GetEntry",
			Handler:    _DataCatalog_GetEntry_Handler,
		},
		{
			MethodName: "LookupEntry",
			Handler:    _DataCatalog_LookupEntry_Handler,
		},
		{
			MethodName: "ListEntries",
			Handler:    _DataCatalog_ListEntries_Handler,
		},
		{
			MethodName: "ModifyEntryOverview",
			Handler:    _DataCatalog_ModifyEntryOverview_Handler,
		},
		{
			MethodName: "ModifyEntryContacts",
			Handler:    _DataCatalog_ModifyEntryContacts_Handler,
		},
		{
			MethodName: "CreateTagTemplate",
			Handler:    _DataCatalog_CreateTagTemplate_Handler,
		},
		{
			MethodName: "GetTagTemplate",
			Handler:    _DataCatalog_GetTagTemplate_Handler,
		},
		{
			MethodName: "UpdateTagTemplate",
			Handler:    _DataCatalog_UpdateTagTemplate_Handler,
		},
		{
			MethodName: "DeleteTagTemplate",
			Handler:    _DataCatalog_DeleteTagTemplate_Handler,
		},
		{
			MethodName: "CreateTagTemplateField",
			Handler:    _DataCatalog_CreateTagTemplateField_Handler,
		},
		{
			MethodName: "UpdateTagTemplateField",
			Handler:    _DataCatalog_UpdateTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateField",
			Handler:    _DataCatalog_RenameTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateFieldEnumValue",
			Handler:    _DataCatalog_RenameTagTemplateFieldEnumValue_Handler,
		},
		{
			MethodName: "DeleteTagTemplateField",
			Handler:    _DataCatalog_DeleteTagTemplateField_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _DataCatalog_CreateTag_Handler,
		},
		{
			MethodName: "UpdateTag",
			Handler:    _DataCatalog_UpdateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _DataCatalog_DeleteTag_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _DataCatalog_ListTags_Handler,
		},
		{
			MethodName: "StarEntry",
			Handler:    _DataCatalog_StarEntry_Handler,
		},
		{
			MethodName: "UnstarEntry",
			Handler:    _DataCatalog_UnstarEntry_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataCatalog_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataCatalog_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataCatalog_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1/datacatalog.proto",
}
