// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/dialogflow/v2/intent.proto

package dialogflowpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the options for views of an intent.
// An intent can be a sizable object. Therefore, we provide a resource view that
// does not return training phrases in the response by default.
type IntentView int32

const (
	// Training phrases field is not populated in the response.
	IntentView_INTENT_VIEW_UNSPECIFIED IntentView = 0
	// All fields are populated.
	IntentView_INTENT_VIEW_FULL IntentView = 1
)

// Enum value maps for IntentView.
var (
	IntentView_name = map[int32]string{
		0: "INTENT_VIEW_UNSPECIFIED",
		1: "INTENT_VIEW_FULL",
	}
	IntentView_value = map[string]int32{
		"INTENT_VIEW_UNSPECIFIED": 0,
		"INTENT_VIEW_FULL":        1,
	}
)

func (x IntentView) Enum() *IntentView {
	p := new(IntentView)
	*p = x
	return p
}

func (x IntentView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IntentView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_intent_proto_enumTypes[0].Descriptor()
}

func (IntentView) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_intent_proto_enumTypes[0]
}

func (x IntentView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IntentView.Descriptor instead.
func (IntentView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0}
}

// Represents the different states that webhooks can be in.
type Intent_WebhookState int32

const (
	// Webhook is disabled in the agent and in the intent.
	Intent_WEBHOOK_STATE_UNSPECIFIED Intent_WebhookState = 0
	// Webhook is enabled in the agent and in the intent.
	Intent_WEBHOOK_STATE_ENABLED Intent_WebhookState = 1
	// Webhook is enabled in the agent and in the intent. Also, each slot
	// filling prompt is forwarded to the webhook.
	Intent_WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING Intent_WebhookState = 2
)

// Enum value maps for Intent_WebhookState.
var (
	Intent_WebhookState_name = map[int32]string{
		0: "WEBHOOK_STATE_UNSPECIFIED",
		1: "WEBHOOK_STATE_ENABLED",
		2: "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING",
	}
	Intent_WebhookState_value = map[string]int32{
		"WEBHOOK_STATE_UNSPECIFIED":              0,
		"WEBHOOK_STATE_ENABLED":                  1,
		"WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING": 2,
	}
)

func (x Intent_WebhookState) Enum() *Intent_WebhookState {
	p := new(Intent_WebhookState)
	*p = x
	return p
}

func (x Intent_WebhookState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Intent_WebhookState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_intent_proto_enumTypes[1].Descriptor()
}

func (Intent_WebhookState) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_intent_proto_enumTypes[1]
}

func (x Intent_WebhookState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Intent_WebhookState.Descriptor instead.
func (Intent_WebhookState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 0}
}

// Represents different types of training phrases.
type Intent_TrainingPhrase_Type int32

const (
	// Not specified. This value should never be used.
	Intent_TrainingPhrase_TYPE_UNSPECIFIED Intent_TrainingPhrase_Type = 0
	// Examples do not contain @-prefixed entity type names, but example parts
	// can be annotated with entity types.
	Intent_TrainingPhrase_EXAMPLE Intent_TrainingPhrase_Type = 1
	// Templates are not annotated with entity types, but they can contain
	// @-prefixed entity type names as substrings.
	// Template mode has been deprecated. Example mode is the only supported
	// way to create new training phrases. If you have existing training
	// phrases that you've created in template mode, those will continue to
	// work.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2/intent.proto.
	Intent_TrainingPhrase_TEMPLATE Intent_TrainingPhrase_Type = 2
)

// Enum value maps for Intent_TrainingPhrase_Type.
var (
	Intent_TrainingPhrase_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "EXAMPLE",
		2: "TEMPLATE",
	}
	Intent_TrainingPhrase_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"EXAMPLE":          1,
		"TEMPLATE":         2,
	}
)

func (x Intent_TrainingPhrase_Type) Enum() *Intent_TrainingPhrase_Type {
	p := new(Intent_TrainingPhrase_Type)
	*p = x
	return p
}

func (x Intent_TrainingPhrase_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Intent_TrainingPhrase_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_intent_proto_enumTypes[2].Descriptor()
}

func (Intent_TrainingPhrase_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_intent_proto_enumTypes[2]
}

func (x Intent_TrainingPhrase_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Intent_TrainingPhrase_Type.Descriptor instead.
func (Intent_TrainingPhrase_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 0, 0}
}

// The rich response message integration platform. See
// [Integrations](https://cloud.google.com/dialogflow/docs/integrations).
type Intent_Message_Platform int32

const (
	// Default platform.
	Intent_Message_PLATFORM_UNSPECIFIED Intent_Message_Platform = 0
	// Facebook.
	Intent_Message_FACEBOOK Intent_Message_Platform = 1
	// Slack.
	Intent_Message_SLACK Intent_Message_Platform = 2
	// Telegram.
	Intent_Message_TELEGRAM Intent_Message_Platform = 3
	// Kik.
	Intent_Message_KIK Intent_Message_Platform = 4
	// Skype.
	Intent_Message_SKYPE Intent_Message_Platform = 5
	// Line.
	Intent_Message_LINE Intent_Message_Platform = 6
	// Viber.
	Intent_Message_VIBER Intent_Message_Platform = 7
	// Google Assistant
	// See [Dialogflow webhook
	// format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
	Intent_Message_ACTIONS_ON_GOOGLE Intent_Message_Platform = 8
	// Google Hangouts.
	Intent_Message_GOOGLE_HANGOUTS Intent_Message_Platform = 11
)

// Enum value maps for Intent_Message_Platform.
var (
	Intent_Message_Platform_name = map[int32]string{
		0:  "PLATFORM_UNSPECIFIED",
		1:  "FACEBOOK",
		2:  "SLACK",
		3:  "TELEGRAM",
		4:  "KIK",
		5:  "SKYPE",
		6:  "LINE",
		7:  "VIBER",
		8:  "ACTIONS_ON_GOOGLE",
		11: "GOOGLE_HANGOUTS",
	}
	Intent_Message_Platform_value = map[string]int32{
		"PLATFORM_UNSPECIFIED": 0,
		"FACEBOOK":             1,
		"SLACK":                2,
		"TELEGRAM":             3,
		"KIK":                  4,
		"SKYPE":                5,
		"LINE":                 6,
		"VIBER":                7,
		"ACTIONS_ON_GOOGLE":    8,
		"GOOGLE_HANGOUTS":      11,
	}
)

func (x Intent_Message_Platform) Enum() *Intent_Message_Platform {
	p := new(Intent_Message_Platform)
	*p = x
	return p
}

func (x Intent_Message_Platform) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Intent_Message_Platform) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_intent_proto_enumTypes[3].Descriptor()
}

func (Intent_Message_Platform) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_intent_proto_enumTypes[3]
}

func (x Intent_Message_Platform) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Intent_Message_Platform.Descriptor instead.
func (Intent_Message_Platform) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 0}
}

// Format of response media type.
type Intent_Message_MediaContent_ResponseMediaType int32

const (
	// Unspecified.
	Intent_Message_MediaContent_RESPONSE_MEDIA_TYPE_UNSPECIFIED Intent_Message_MediaContent_ResponseMediaType = 0
	// Response media type is audio.
	Intent_Message_MediaContent_AUDIO Intent_Message_MediaContent_ResponseMediaType = 1
)

// Enum value maps for Intent_Message_MediaContent_ResponseMediaType.
var (
	Intent_Message_MediaContent_ResponseMediaType_name = map[int32]string{
		0: "RESPONSE_MEDIA_TYPE_UNSPECIFIED",
		1: "AUDIO",
	}
	Intent_Message_MediaContent_ResponseMediaType_value = map[string]int32{
		"RESPONSE_MEDIA_TYPE_UNSPECIFIED": 0,
		"AUDIO":                           1,
	}
)

func (x Intent_Message_MediaContent_ResponseMediaType) Enum() *Intent_Message_MediaContent_ResponseMediaType {
	p := new(Intent_Message_MediaContent_ResponseMediaType)
	*p = x
	return p
}

func (x Intent_Message_MediaContent_ResponseMediaType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Intent_Message_MediaContent_ResponseMediaType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_intent_proto_enumTypes[4].Descriptor()
}

func (Intent_Message_MediaContent_ResponseMediaType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_intent_proto_enumTypes[4]
}

func (x Intent_Message_MediaContent_ResponseMediaType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Intent_Message_MediaContent_ResponseMediaType.Descriptor instead.
func (Intent_Message_MediaContent_ResponseMediaType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 13, 0}
}

// Image display options for Actions on Google. This should be used for
// when the image's aspect ratio does not match the image container's
// aspect ratio.
type Intent_Message_BrowseCarouselCard_ImageDisplayOptions int32

const (
	// Fill the gaps between the image and the image container with gray
	// bars.
	Intent_Message_BrowseCarouselCard_IMAGE_DISPLAY_OPTIONS_UNSPECIFIED Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 0
	// Fill the gaps between the image and the image container with gray
	// bars.
	Intent_Message_BrowseCarouselCard_GRAY Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 1
	// Fill the gaps between the image and the image container with white
	// bars.
	Intent_Message_BrowseCarouselCard_WHITE Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 2
	// Image is scaled such that the image width and height match or exceed
	// the container dimensions. This may crop the top and bottom of the
	// image if the scaled image height is greater than the container
	// height, or crop the left and right of the image if the scaled image
	// width is greater than the container width. This is similar to "Zoom
	// Mode" on a widescreen TV when playing a 4:3 video.
	Intent_Message_BrowseCarouselCard_CROPPED Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 3
	// Pad the gaps between image and image frame with a blurred copy of the
	// same image.
	Intent_Message_BrowseCarouselCard_BLURRED_BACKGROUND Intent_Message_BrowseCarouselCard_ImageDisplayOptions = 4
)

// Enum value maps for Intent_Message_BrowseCarouselCard_ImageDisplayOptions.
var (
	Intent_Message_BrowseCarouselCard_ImageDisplayOptions_name = map[int32]string{
		0: "IMAGE_DISPLAY_OPTIONS_UNSPECIFIED",
		1: "GRAY",
		2: "WHITE",
		3: "CROPPED",
		4: "BLURRED_BACKGROUND",
	}
	Intent_Message_BrowseCarouselCard_ImageDisplayOptions_value = map[string]int32{
		"IMAGE_DISPLAY_OPTIONS_UNSPECIFIED": 0,
		"GRAY":                              1,
		"WHITE":                             2,
		"CROPPED":                           3,
		"BLURRED_BACKGROUND":                4,
	}
)

func (x Intent_Message_BrowseCarouselCard_ImageDisplayOptions) Enum() *Intent_Message_BrowseCarouselCard_ImageDisplayOptions {
	p := new(Intent_Message_BrowseCarouselCard_ImageDisplayOptions)
	*p = x
	return p
}

func (x Intent_Message_BrowseCarouselCard_ImageDisplayOptions) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Intent_Message_BrowseCarouselCard_ImageDisplayOptions) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_intent_proto_enumTypes[5].Descriptor()
}

func (Intent_Message_BrowseCarouselCard_ImageDisplayOptions) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_intent_proto_enumTypes[5]
}

func (x Intent_Message_BrowseCarouselCard_ImageDisplayOptions) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Intent_Message_BrowseCarouselCard_ImageDisplayOptions.Descriptor instead.
func (Intent_Message_BrowseCarouselCard_ImageDisplayOptions) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 14, 0}
}

// Type of the URI.
type Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint int32

const (
	// Unspecified
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_URL_TYPE_HINT_UNSPECIFIED Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint = 0
	// Url would be an amp action
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_AMP_ACTION Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint = 1
	// URL that points directly to AMP content, or to a canonical URL
	// which refers to AMP content via <link rel="amphtml">.
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_AMP_CONTENT Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint = 2
)

// Enum value maps for Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint.
var (
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_name = map[int32]string{
		0: "URL_TYPE_HINT_UNSPECIFIED",
		1: "AMP_ACTION",
		2: "AMP_CONTENT",
	}
	Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint_value = map[string]int32{
		"URL_TYPE_HINT_UNSPECIFIED": 0,
		"AMP_ACTION":                1,
		"AMP_CONTENT":               2,
	}
)

func (x Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint) Enum() *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint {
	p := new(Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint)
	*p = x
	return p
}

func (x Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_intent_proto_enumTypes[6].Descriptor()
}

func (Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_intent_proto_enumTypes[6]
}

func (x Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint.Descriptor instead.
func (Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 14, 0, 0, 0}
}

// Text alignments within a cell.
type Intent_Message_ColumnProperties_HorizontalAlignment int32

const (
	// Text is aligned to the leading edge of the column.
	Intent_Message_ColumnProperties_HORIZONTAL_ALIGNMENT_UNSPECIFIED Intent_Message_ColumnProperties_HorizontalAlignment = 0
	// Text is aligned to the leading edge of the column.
	Intent_Message_ColumnProperties_LEADING Intent_Message_ColumnProperties_HorizontalAlignment = 1
	// Text is centered in the column.
	Intent_Message_ColumnProperties_CENTER Intent_Message_ColumnProperties_HorizontalAlignment = 2
	// Text is aligned to the trailing edge of the column.
	Intent_Message_ColumnProperties_TRAILING Intent_Message_ColumnProperties_HorizontalAlignment = 3
)

// Enum value maps for Intent_Message_ColumnProperties_HorizontalAlignment.
var (
	Intent_Message_ColumnProperties_HorizontalAlignment_name = map[int32]string{
		0: "HORIZONTAL_ALIGNMENT_UNSPECIFIED",
		1: "LEADING",
		2: "CENTER",
		3: "TRAILING",
	}
	Intent_Message_ColumnProperties_HorizontalAlignment_value = map[string]int32{
		"HORIZONTAL_ALIGNMENT_UNSPECIFIED": 0,
		"LEADING":                          1,
		"CENTER":                           2,
		"TRAILING":                         3,
	}
)

func (x Intent_Message_ColumnProperties_HorizontalAlignment) Enum() *Intent_Message_ColumnProperties_HorizontalAlignment {
	p := new(Intent_Message_ColumnProperties_HorizontalAlignment)
	*p = x
	return p
}

func (x Intent_Message_ColumnProperties_HorizontalAlignment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Intent_Message_ColumnProperties_HorizontalAlignment) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_intent_proto_enumTypes[7].Descriptor()
}

func (Intent_Message_ColumnProperties_HorizontalAlignment) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_intent_proto_enumTypes[7]
}

func (x Intent_Message_ColumnProperties_HorizontalAlignment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Intent_Message_ColumnProperties_HorizontalAlignment.Descriptor instead.
func (Intent_Message_ColumnProperties_HorizontalAlignment) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 16, 0}
}

// An intent categorizes an end-user's intention for one conversation turn. For
// each agent, you define many intents, where your combined intents can handle a
// complete conversation. When an end-user writes or says something, referred to
// as an end-user expression or end-user input, Dialogflow matches the end-user
// input to the best intent in your agent. Matching an intent is also known as
// intent classification.
//
// For more information, see the [intent
// guide](https://cloud.google.com/dialogflow/docs/intents-overview).
type Intent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of this intent.
	// Required for
	// [Intents.UpdateIntent][google.cloud.dialogflow.v2.Intents.UpdateIntent] and
	// [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2.Intents.BatchUpdateIntents]
	// methods.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of this intent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Indicates whether webhooks are enabled for the intent.
	WebhookState Intent_WebhookState `protobuf:"varint,6,opt,name=webhook_state,json=webhookState,proto3,enum=google.cloud.dialogflow.v2.Intent_WebhookState" json:"webhook_state,omitempty"`
	// Optional. The priority of this intent. Higher numbers represent higher
	// priorities.
	//
	// - If the supplied value is unspecified or 0, the service
	//   translates the value to 500,000, which corresponds to the
	//   `Normal` priority in the console.
	// - If the supplied value is negative, the intent is ignored
	//   in runtime detect intent requests.
	Priority int32 `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
	// Optional. Indicates whether this is a fallback intent.
	IsFallback bool `protobuf:"varint,4,opt,name=is_fallback,json=isFallback,proto3" json:"is_fallback,omitempty"`
	// Optional. Indicates whether Machine Learning is disabled for the intent.
	// Note: If `ml_disabled` setting is set to true, then this intent is not
	// taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	MlDisabled bool `protobuf:"varint,19,opt,name=ml_disabled,json=mlDisabled,proto3" json:"ml_disabled,omitempty"`
	// Optional. Indicates that a live agent should be brought in to handle the
	// interaction with the user. In most cases, when you set this flag to true,
	// you would also want to set end_interaction to true as well. Default is
	// false.
	LiveAgentHandoff bool `protobuf:"varint,20,opt,name=live_agent_handoff,json=liveAgentHandoff,proto3" json:"live_agent_handoff,omitempty"`
	// Optional. Indicates that this intent ends an interaction. Some integrations
	// (e.g., Actions on Google or Dialogflow phone gateway) use this information
	// to close interaction with an end user. Default is false.
	EndInteraction bool `protobuf:"varint,21,opt,name=end_interaction,json=endInteraction,proto3" json:"end_interaction,omitempty"`
	// Optional. The list of context names required for this intent to be
	// triggered.
	// Format: `projects/<Project ID>/agent/sessions/-/contexts/<Context ID>`.
	InputContextNames []string `protobuf:"bytes,7,rep,name=input_context_names,json=inputContextNames,proto3" json:"input_context_names,omitempty"`
	// Optional. The collection of event names that trigger the intent.
	// If the collection of input contexts is not empty, all of the contexts must
	// be present in the active user session for an event to trigger this intent.
	// Event names are limited to 150 characters.
	Events []string `protobuf:"bytes,8,rep,name=events,proto3" json:"events,omitempty"`
	// Optional. The collection of examples that the agent is
	// trained on.
	TrainingPhrases []*Intent_TrainingPhrase `protobuf:"bytes,9,rep,name=training_phrases,json=trainingPhrases,proto3" json:"training_phrases,omitempty"`
	// Optional. The name of the action associated with the intent.
	// Note: The action name must not contain whitespaces.
	Action string `protobuf:"bytes,10,opt,name=action,proto3" json:"action,omitempty"`
	// Optional. The collection of contexts that are activated when the intent
	// is matched. Context messages in this collection should not set the
	// parameters field. Setting the `lifespan_count` to 0 will reset the context
	// when the intent is matched.
	// Format: `projects/<Project ID>/agent/sessions/-/contexts/<Context ID>`.
	OutputContexts []*Context `protobuf:"bytes,11,rep,name=output_contexts,json=outputContexts,proto3" json:"output_contexts,omitempty"`
	// Optional. Indicates whether to delete all contexts in the current
	// session when this intent is matched.
	ResetContexts bool `protobuf:"varint,12,opt,name=reset_contexts,json=resetContexts,proto3" json:"reset_contexts,omitempty"`
	// Optional. The collection of parameters associated with the intent.
	Parameters []*Intent_Parameter `protobuf:"bytes,13,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. The collection of rich messages corresponding to the
	// `Response` field in the Dialogflow console.
	Messages []*Intent_Message `protobuf:"bytes,14,rep,name=messages,proto3" json:"messages,omitempty"`
	// Optional. The list of platforms for which the first responses will be
	// copied from the messages in PLATFORM_UNSPECIFIED (i.e. default platform).
	DefaultResponsePlatforms []Intent_Message_Platform `protobuf:"varint,15,rep,packed,name=default_response_platforms,json=defaultResponsePlatforms,proto3,enum=google.cloud.dialogflow.v2.Intent_Message_Platform" json:"default_response_platforms,omitempty"`
	// Output only.
	// Read-only. The unique identifier of the root intent in the chain of
	// followup intents. It identifies the correct followup intents chain for
	// this intent. We populate this field only in the output.
	//
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	RootFollowupIntentName string `protobuf:"bytes,16,opt,name=root_followup_intent_name,json=rootFollowupIntentName,proto3" json:"root_followup_intent_name,omitempty"`
	// Read-only after creation. The unique identifier of the parent intent in the
	// chain of followup intents. You can set this field when creating an intent,
	// for example with
	// [CreateIntent][google.cloud.dialogflow.v2.Intents.CreateIntent] or
	// [BatchUpdateIntents][google.cloud.dialogflow.v2.Intents.BatchUpdateIntents],
	// in order to make this intent a followup intent.
	//
	// It identifies the parent followup intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	ParentFollowupIntentName string `protobuf:"bytes,17,opt,name=parent_followup_intent_name,json=parentFollowupIntentName,proto3" json:"parent_followup_intent_name,omitempty"`
	// Output only. Read-only. Information about all followup intents that have
	// this intent as a direct or indirect parent. We populate this field only in
	// the output.
	FollowupIntentInfo []*Intent_FollowupIntentInfo `protobuf:"bytes,18,rep,name=followup_intent_info,json=followupIntentInfo,proto3" json:"followup_intent_info,omitempty"`
}

func (x *Intent) Reset() {
	*x = Intent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent) ProtoMessage() {}

func (x *Intent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent.ProtoReflect.Descriptor instead.
func (*Intent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0}
}

func (x *Intent) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Intent) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Intent) GetWebhookState() Intent_WebhookState {
	if x != nil {
		return x.WebhookState
	}
	return Intent_WEBHOOK_STATE_UNSPECIFIED
}

func (x *Intent) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Intent) GetIsFallback() bool {
	if x != nil {
		return x.IsFallback
	}
	return false
}

func (x *Intent) GetMlDisabled() bool {
	if x != nil {
		return x.MlDisabled
	}
	return false
}

func (x *Intent) GetLiveAgentHandoff() bool {
	if x != nil {
		return x.LiveAgentHandoff
	}
	return false
}

func (x *Intent) GetEndInteraction() bool {
	if x != nil {
		return x.EndInteraction
	}
	return false
}

func (x *Intent) GetInputContextNames() []string {
	if x != nil {
		return x.InputContextNames
	}
	return nil
}

func (x *Intent) GetEvents() []string {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *Intent) GetTrainingPhrases() []*Intent_TrainingPhrase {
	if x != nil {
		return x.TrainingPhrases
	}
	return nil
}

func (x *Intent) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *Intent) GetOutputContexts() []*Context {
	if x != nil {
		return x.OutputContexts
	}
	return nil
}

func (x *Intent) GetResetContexts() bool {
	if x != nil {
		return x.ResetContexts
	}
	return false
}

func (x *Intent) GetParameters() []*Intent_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Intent) GetMessages() []*Intent_Message {
	if x != nil {
		return x.Messages
	}
	return nil
}

func (x *Intent) GetDefaultResponsePlatforms() []Intent_Message_Platform {
	if x != nil {
		return x.DefaultResponsePlatforms
	}
	return nil
}

func (x *Intent) GetRootFollowupIntentName() string {
	if x != nil {
		return x.RootFollowupIntentName
	}
	return ""
}

func (x *Intent) GetParentFollowupIntentName() string {
	if x != nil {
		return x.ParentFollowupIntentName
	}
	return ""
}

func (x *Intent) GetFollowupIntentInfo() []*Intent_FollowupIntentInfo {
	if x != nil {
		return x.FollowupIntentInfo
	}
	return nil
}

// The request message for
// [Intents.ListIntents][google.cloud.dialogflow.v2.Intents.ListIntents].
type ListIntentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list all intents from.
	// Format: `projects/<Project ID>/agent` or `projects/<Project
	// ID>/locations/<Location ID>/agent`.
	//
	// Alternatively, you can specify the environment to list intents for.
	// Format: `projects/<Project ID>/agent/environments/<Environment ID>`
	// or `projects/<Project ID>/locations/<Location
	// ID>/agent/environments/<Environment ID>`.
	// Note: training phrases of the intents will not be returned for non-draft
	// environment.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used.
	// For more information, see
	// [Multilingual intent and entity
	// data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,3,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2.IntentView" json:"intent_view,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListIntentsRequest) Reset() {
	*x = ListIntentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIntentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIntentsRequest) ProtoMessage() {}

func (x *ListIntentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIntentsRequest.ProtoReflect.Descriptor instead.
func (*ListIntentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{1}
}

func (x *ListIntentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListIntentsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListIntentsRequest) GetIntentView() IntentView {
	if x != nil {
		return x.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

func (x *ListIntentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIntentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Intents.ListIntents][google.cloud.dialogflow.v2.Intents.ListIntents].
type ListIntentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of agent intents. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Intents []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIntentsResponse) Reset() {
	*x = ListIntentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIntentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIntentsResponse) ProtoMessage() {}

func (x *ListIntentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIntentsResponse.ProtoReflect.Descriptor instead.
func (*ListIntentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{2}
}

func (x *ListIntentsResponse) GetIntents() []*Intent {
	if x != nil {
		return x.Intents
	}
	return nil
}

func (x *ListIntentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Intents.GetIntent][google.cloud.dialogflow.v2.Intents.GetIntent].
type GetIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used.
	// For more information, see
	// [Multilingual intent and entity
	// data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,3,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2.IntentView" json:"intent_view,omitempty"`
}

func (x *GetIntentRequest) Reset() {
	*x = GetIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIntentRequest) ProtoMessage() {}

func (x *GetIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIntentRequest.ProtoReflect.Descriptor instead.
func (*GetIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{3}
}

func (x *GetIntentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetIntentRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *GetIntentRequest) GetIntentView() IntentView {
	if x != nil {
		return x.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for
// [Intents.CreateIntent][google.cloud.dialogflow.v2.Intents.CreateIntent].
type CreateIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create a intent for.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The intent to create.
	Intent *Intent `protobuf:"bytes,2,opt,name=intent,proto3" json:"intent,omitempty"`
	// Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used.
	// For more information, see
	// [Multilingual intent and entity
	// data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,4,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2.IntentView" json:"intent_view,omitempty"`
}

func (x *CreateIntentRequest) Reset() {
	*x = CreateIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIntentRequest) ProtoMessage() {}

func (x *CreateIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIntentRequest.ProtoReflect.Descriptor instead.
func (*CreateIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{4}
}

func (x *CreateIntentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIntentRequest) GetIntent() *Intent {
	if x != nil {
		return x.Intent
	}
	return nil
}

func (x *CreateIntentRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *CreateIntentRequest) GetIntentView() IntentView {
	if x != nil {
		return x.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for
// [Intents.UpdateIntent][google.cloud.dialogflow.v2.Intents.UpdateIntent].
type UpdateIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The intent to update.
	Intent *Intent `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	// Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used.
	// For more information, see
	// [Multilingual intent and entity
	// data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,4,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2.IntentView" json:"intent_view,omitempty"`
}

func (x *UpdateIntentRequest) Reset() {
	*x = UpdateIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIntentRequest) ProtoMessage() {}

func (x *UpdateIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIntentRequest.ProtoReflect.Descriptor instead.
func (*UpdateIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateIntentRequest) GetIntent() *Intent {
	if x != nil {
		return x.Intent
	}
	return nil
}

func (x *UpdateIntentRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *UpdateIntentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateIntentRequest) GetIntentView() IntentView {
	if x != nil {
		return x.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for
// [Intents.DeleteIntent][google.cloud.dialogflow.v2.Intents.DeleteIntent].
type DeleteIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the intent to delete. If this intent has direct or
	// indirect followup intents, we also delete them.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIntentRequest) Reset() {
	*x = DeleteIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIntentRequest) ProtoMessage() {}

func (x *DeleteIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIntentRequest.ProtoReflect.Descriptor instead.
func (*DeleteIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteIntentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type BatchUpdateIntentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the agent to update or create intents in.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The source of the intent batch.
	//
	// Types that are assignable to IntentBatch:
	//	*BatchUpdateIntentsRequest_IntentBatchUri
	//	*BatchUpdateIntentsRequest_IntentBatchInline
	IntentBatch isBatchUpdateIntentsRequest_IntentBatch `protobuf_oneof:"intent_batch"`
	// Optional. The language used to access language-specific data.
	// If not specified, the agent's default language is used.
	// For more information, see
	// [Multilingual intent and entity
	// data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,6,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2.IntentView" json:"intent_view,omitempty"`
}

func (x *BatchUpdateIntentsRequest) Reset() {
	*x = BatchUpdateIntentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateIntentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateIntentsRequest) ProtoMessage() {}

func (x *BatchUpdateIntentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateIntentsRequest.ProtoReflect.Descriptor instead.
func (*BatchUpdateIntentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{7}
}

func (x *BatchUpdateIntentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *BatchUpdateIntentsRequest) GetIntentBatch() isBatchUpdateIntentsRequest_IntentBatch {
	if m != nil {
		return m.IntentBatch
	}
	return nil
}

func (x *BatchUpdateIntentsRequest) GetIntentBatchUri() string {
	if x, ok := x.GetIntentBatch().(*BatchUpdateIntentsRequest_IntentBatchUri); ok {
		return x.IntentBatchUri
	}
	return ""
}

func (x *BatchUpdateIntentsRequest) GetIntentBatchInline() *IntentBatch {
	if x, ok := x.GetIntentBatch().(*BatchUpdateIntentsRequest_IntentBatchInline); ok {
		return x.IntentBatchInline
	}
	return nil
}

func (x *BatchUpdateIntentsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *BatchUpdateIntentsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *BatchUpdateIntentsRequest) GetIntentView() IntentView {
	if x != nil {
		return x.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

type isBatchUpdateIntentsRequest_IntentBatch interface {
	isBatchUpdateIntentsRequest_IntentBatch()
}

type BatchUpdateIntentsRequest_IntentBatchUri struct {
	// The URI to a Google Cloud Storage file containing intents to update or
	// create. The file format can either be a serialized proto (of IntentBatch
	// type) or JSON object. Note: The URI must start with "gs://".
	IntentBatchUri string `protobuf:"bytes,2,opt,name=intent_batch_uri,json=intentBatchUri,proto3,oneof"`
}

type BatchUpdateIntentsRequest_IntentBatchInline struct {
	// The collection of intents to update or create.
	IntentBatchInline *IntentBatch `protobuf:"bytes,3,opt,name=intent_batch_inline,json=intentBatchInline,proto3,oneof"`
}

func (*BatchUpdateIntentsRequest_IntentBatchUri) isBatchUpdateIntentsRequest_IntentBatch() {}

func (*BatchUpdateIntentsRequest_IntentBatchInline) isBatchUpdateIntentsRequest_IntentBatch() {}

// The response message for
// [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2.Intents.BatchUpdateIntents].
type BatchUpdateIntentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The collection of updated or created intents.
	Intents []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
}

func (x *BatchUpdateIntentsResponse) Reset() {
	*x = BatchUpdateIntentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUpdateIntentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUpdateIntentsResponse) ProtoMessage() {}

func (x *BatchUpdateIntentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUpdateIntentsResponse.ProtoReflect.Descriptor instead.
func (*BatchUpdateIntentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{8}
}

func (x *BatchUpdateIntentsResponse) GetIntents() []*Intent {
	if x != nil {
		return x.Intents
	}
	return nil
}

// The request message for
// [Intents.BatchDeleteIntents][google.cloud.dialogflow.v2.Intents.BatchDeleteIntents].
type BatchDeleteIntentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the agent to delete all entities types for. Format:
	// `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The collection of intents to delete. Only intent `name` must be
	// filled in.
	Intents []*Intent `protobuf:"bytes,2,rep,name=intents,proto3" json:"intents,omitempty"`
}

func (x *BatchDeleteIntentsRequest) Reset() {
	*x = BatchDeleteIntentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteIntentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteIntentsRequest) ProtoMessage() {}

func (x *BatchDeleteIntentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteIntentsRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteIntentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{9}
}

func (x *BatchDeleteIntentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchDeleteIntentsRequest) GetIntents() []*Intent {
	if x != nil {
		return x.Intents
	}
	return nil
}

// This message is a wrapper around a collection of intents.
type IntentBatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of intents.
	Intents []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
}

func (x *IntentBatch) Reset() {
	*x = IntentBatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentBatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentBatch) ProtoMessage() {}

func (x *IntentBatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentBatch.ProtoReflect.Descriptor instead.
func (*IntentBatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{10}
}

func (x *IntentBatch) GetIntents() []*Intent {
	if x != nil {
		return x.Intents
	}
	return nil
}

// Represents an example that the agent is trained on.
type Intent_TrainingPhrase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of this training phrase.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The type of the training phrase.
	Type Intent_TrainingPhrase_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dialogflow.v2.Intent_TrainingPhrase_Type" json:"type,omitempty"`
	// Required. The ordered list of training phrase parts.
	// The parts are concatenated in order to form the training phrase.
	//
	// Note: The API does not automatically annotate training phrases like the
	// Dialogflow Console does.
	//
	// Note: Do not forget to include whitespace at part boundaries,
	// so the training phrase is well formatted when the parts are concatenated.
	//
	// If the training phrase does not need to be annotated with parameters,
	// you just need a single part with only the
	// [Part.text][google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part.text]
	// field set.
	//
	// If you want to annotate the training phrase, you must create multiple
	// parts, where the fields of each part are populated in one of two ways:
	//
	// -   `Part.text` is set to a part of the phrase that has no parameters.
	// -   `Part.text` is set to a part of the phrase that you want to annotate,
	//     and the `entity_type`, `alias`, and `user_defined` fields are all
	//     set.
	Parts []*Intent_TrainingPhrase_Part `protobuf:"bytes,3,rep,name=parts,proto3" json:"parts,omitempty"`
	// Optional. Indicates how many times this example was added to
	// the intent. Each time a developer adds an existing sample by editing an
	// intent or training, this counter is increased.
	TimesAddedCount int32 `protobuf:"varint,4,opt,name=times_added_count,json=timesAddedCount,proto3" json:"times_added_count,omitempty"`
}

func (x *Intent_TrainingPhrase) Reset() {
	*x = Intent_TrainingPhrase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_TrainingPhrase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_TrainingPhrase) ProtoMessage() {}

func (x *Intent_TrainingPhrase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_TrainingPhrase.ProtoReflect.Descriptor instead.
func (*Intent_TrainingPhrase) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Intent_TrainingPhrase) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Intent_TrainingPhrase) GetType() Intent_TrainingPhrase_Type {
	if x != nil {
		return x.Type
	}
	return Intent_TrainingPhrase_TYPE_UNSPECIFIED
}

func (x *Intent_TrainingPhrase) GetParts() []*Intent_TrainingPhrase_Part {
	if x != nil {
		return x.Parts
	}
	return nil
}

func (x *Intent_TrainingPhrase) GetTimesAddedCount() int32 {
	if x != nil {
		return x.TimesAddedCount
	}
	return 0
}

// Represents intent parameters.
type Intent_Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of this parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the parameter.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The definition of the parameter value. It can be:
	//
	// - a constant string,
	// - a parameter value defined as `$parameter_name`,
	// - an original parameter value defined as `$parameter_name.original`,
	// - a parameter value from some context defined as
	//   `#context_name.parameter_name`.
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// Optional. The default value to use when the `value` yields an empty
	// result.
	// Default values can be extracted from contexts by using the following
	// syntax: `#context_name.parameter_name`.
	DefaultValue string `protobuf:"bytes,4,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// Optional. The name of the entity type, prefixed with `@`, that
	// describes values of the parameter. If the parameter is
	// required, this must be provided.
	EntityTypeDisplayName string `protobuf:"bytes,5,opt,name=entity_type_display_name,json=entityTypeDisplayName,proto3" json:"entity_type_display_name,omitempty"`
	// Optional. Indicates whether the parameter is required. That is,
	// whether the intent cannot be completed without collecting the parameter
	// value.
	Mandatory bool `protobuf:"varint,6,opt,name=mandatory,proto3" json:"mandatory,omitempty"`
	// Optional. The collection of prompts that the agent can present to the
	// user in order to collect a value for the parameter.
	Prompts []string `protobuf:"bytes,7,rep,name=prompts,proto3" json:"prompts,omitempty"`
	// Optional. Indicates whether the parameter represents a list of values.
	IsList bool `protobuf:"varint,8,opt,name=is_list,json=isList,proto3" json:"is_list,omitempty"`
}

func (x *Intent_Parameter) Reset() {
	*x = Intent_Parameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Parameter) ProtoMessage() {}

func (x *Intent_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Parameter.ProtoReflect.Descriptor instead.
func (*Intent_Parameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Intent_Parameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Intent_Parameter) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Intent_Parameter) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Intent_Parameter) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

func (x *Intent_Parameter) GetEntityTypeDisplayName() string {
	if x != nil {
		return x.EntityTypeDisplayName
	}
	return ""
}

func (x *Intent_Parameter) GetMandatory() bool {
	if x != nil {
		return x.Mandatory
	}
	return false
}

func (x *Intent_Parameter) GetPrompts() []string {
	if x != nil {
		return x.Prompts
	}
	return nil
}

func (x *Intent_Parameter) GetIsList() bool {
	if x != nil {
		return x.IsList
	}
	return false
}

// A rich response message.
// Corresponds to the intent `Response` field in the Dialogflow console.
// For more information, see
// [Rich response
// messages](https://cloud.google.com/dialogflow/docs/intents-rich-messages).
type Intent_Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The rich response message.
	//
	// Types that are assignable to Message:
	//	*Intent_Message_Text_
	//	*Intent_Message_Image_
	//	*Intent_Message_QuickReplies_
	//	*Intent_Message_Card_
	//	*Intent_Message_Payload
	//	*Intent_Message_SimpleResponses_
	//	*Intent_Message_BasicCard_
	//	*Intent_Message_Suggestions_
	//	*Intent_Message_LinkOutSuggestion_
	//	*Intent_Message_ListSelect_
	//	*Intent_Message_CarouselSelect_
	//	*Intent_Message_BrowseCarouselCard_
	//	*Intent_Message_TableCard_
	//	*Intent_Message_MediaContent_
	Message isIntent_Message_Message `protobuf_oneof:"message"`
	// Optional. The platform that this message is intended for.
	Platform Intent_Message_Platform `protobuf:"varint,6,opt,name=platform,proto3,enum=google.cloud.dialogflow.v2.Intent_Message_Platform" json:"platform,omitempty"`
}

func (x *Intent_Message) Reset() {
	*x = Intent_Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message) ProtoMessage() {}

func (x *Intent_Message) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message.ProtoReflect.Descriptor instead.
func (*Intent_Message) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2}
}

func (m *Intent_Message) GetMessage() isIntent_Message_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *Intent_Message) GetText() *Intent_Message_Text {
	if x, ok := x.GetMessage().(*Intent_Message_Text_); ok {
		return x.Text
	}
	return nil
}

func (x *Intent_Message) GetImage() *Intent_Message_Image {
	if x, ok := x.GetMessage().(*Intent_Message_Image_); ok {
		return x.Image
	}
	return nil
}

func (x *Intent_Message) GetQuickReplies() *Intent_Message_QuickReplies {
	if x, ok := x.GetMessage().(*Intent_Message_QuickReplies_); ok {
		return x.QuickReplies
	}
	return nil
}

func (x *Intent_Message) GetCard() *Intent_Message_Card {
	if x, ok := x.GetMessage().(*Intent_Message_Card_); ok {
		return x.Card
	}
	return nil
}

func (x *Intent_Message) GetPayload() *structpb.Struct {
	if x, ok := x.GetMessage().(*Intent_Message_Payload); ok {
		return x.Payload
	}
	return nil
}

func (x *Intent_Message) GetSimpleResponses() *Intent_Message_SimpleResponses {
	if x, ok := x.GetMessage().(*Intent_Message_SimpleResponses_); ok {
		return x.SimpleResponses
	}
	return nil
}

func (x *Intent_Message) GetBasicCard() *Intent_Message_BasicCard {
	if x, ok := x.GetMessage().(*Intent_Message_BasicCard_); ok {
		return x.BasicCard
	}
	return nil
}

func (x *Intent_Message) GetSuggestions() *Intent_Message_Suggestions {
	if x, ok := x.GetMessage().(*Intent_Message_Suggestions_); ok {
		return x.Suggestions
	}
	return nil
}

func (x *Intent_Message) GetLinkOutSuggestion() *Intent_Message_LinkOutSuggestion {
	if x, ok := x.GetMessage().(*Intent_Message_LinkOutSuggestion_); ok {
		return x.LinkOutSuggestion
	}
	return nil
}

func (x *Intent_Message) GetListSelect() *Intent_Message_ListSelect {
	if x, ok := x.GetMessage().(*Intent_Message_ListSelect_); ok {
		return x.ListSelect
	}
	return nil
}

func (x *Intent_Message) GetCarouselSelect() *Intent_Message_CarouselSelect {
	if x, ok := x.GetMessage().(*Intent_Message_CarouselSelect_); ok {
		return x.CarouselSelect
	}
	return nil
}

func (x *Intent_Message) GetBrowseCarouselCard() *Intent_Message_BrowseCarouselCard {
	if x, ok := x.GetMessage().(*Intent_Message_BrowseCarouselCard_); ok {
		return x.BrowseCarouselCard
	}
	return nil
}

func (x *Intent_Message) GetTableCard() *Intent_Message_TableCard {
	if x, ok := x.GetMessage().(*Intent_Message_TableCard_); ok {
		return x.TableCard
	}
	return nil
}

func (x *Intent_Message) GetMediaContent() *Intent_Message_MediaContent {
	if x, ok := x.GetMessage().(*Intent_Message_MediaContent_); ok {
		return x.MediaContent
	}
	return nil
}

func (x *Intent_Message) GetPlatform() Intent_Message_Platform {
	if x != nil {
		return x.Platform
	}
	return Intent_Message_PLATFORM_UNSPECIFIED
}

type isIntent_Message_Message interface {
	isIntent_Message_Message()
}

type Intent_Message_Text_ struct {
	// The text response.
	Text *Intent_Message_Text `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type Intent_Message_Image_ struct {
	// The image response.
	Image *Intent_Message_Image `protobuf:"bytes,2,opt,name=image,proto3,oneof"`
}

type Intent_Message_QuickReplies_ struct {
	// The quick replies response.
	QuickReplies *Intent_Message_QuickReplies `protobuf:"bytes,3,opt,name=quick_replies,json=quickReplies,proto3,oneof"`
}

type Intent_Message_Card_ struct {
	// The card response.
	Card *Intent_Message_Card `protobuf:"bytes,4,opt,name=card,proto3,oneof"`
}

type Intent_Message_Payload struct {
	// A custom platform-specific response.
	Payload *structpb.Struct `protobuf:"bytes,5,opt,name=payload,proto3,oneof"`
}

type Intent_Message_SimpleResponses_ struct {
	// The voice and text-only responses for Actions on Google.
	SimpleResponses *Intent_Message_SimpleResponses `protobuf:"bytes,7,opt,name=simple_responses,json=simpleResponses,proto3,oneof"`
}

type Intent_Message_BasicCard_ struct {
	// The basic card response for Actions on Google.
	BasicCard *Intent_Message_BasicCard `protobuf:"bytes,8,opt,name=basic_card,json=basicCard,proto3,oneof"`
}

type Intent_Message_Suggestions_ struct {
	// The suggestion chips for Actions on Google.
	Suggestions *Intent_Message_Suggestions `protobuf:"bytes,9,opt,name=suggestions,proto3,oneof"`
}

type Intent_Message_LinkOutSuggestion_ struct {
	// The link out suggestion chip for Actions on Google.
	LinkOutSuggestion *Intent_Message_LinkOutSuggestion `protobuf:"bytes,10,opt,name=link_out_suggestion,json=linkOutSuggestion,proto3,oneof"`
}

type Intent_Message_ListSelect_ struct {
	// The list card response for Actions on Google.
	ListSelect *Intent_Message_ListSelect `protobuf:"bytes,11,opt,name=list_select,json=listSelect,proto3,oneof"`
}

type Intent_Message_CarouselSelect_ struct {
	// The carousel card response for Actions on Google.
	CarouselSelect *Intent_Message_CarouselSelect `protobuf:"bytes,12,opt,name=carousel_select,json=carouselSelect,proto3,oneof"`
}

type Intent_Message_BrowseCarouselCard_ struct {
	// Browse carousel card for Actions on Google.
	BrowseCarouselCard *Intent_Message_BrowseCarouselCard `protobuf:"bytes,22,opt,name=browse_carousel_card,json=browseCarouselCard,proto3,oneof"`
}

type Intent_Message_TableCard_ struct {
	// Table card for Actions on Google.
	TableCard *Intent_Message_TableCard `protobuf:"bytes,23,opt,name=table_card,json=tableCard,proto3,oneof"`
}

type Intent_Message_MediaContent_ struct {
	// The media content card for Actions on Google.
	MediaContent *Intent_Message_MediaContent `protobuf:"bytes,24,opt,name=media_content,json=mediaContent,proto3,oneof"`
}

func (*Intent_Message_Text_) isIntent_Message_Message() {}

func (*Intent_Message_Image_) isIntent_Message_Message() {}

func (*Intent_Message_QuickReplies_) isIntent_Message_Message() {}

func (*Intent_Message_Card_) isIntent_Message_Message() {}

func (*Intent_Message_Payload) isIntent_Message_Message() {}

func (*Intent_Message_SimpleResponses_) isIntent_Message_Message() {}

func (*Intent_Message_BasicCard_) isIntent_Message_Message() {}

func (*Intent_Message_Suggestions_) isIntent_Message_Message() {}

func (*Intent_Message_LinkOutSuggestion_) isIntent_Message_Message() {}

func (*Intent_Message_ListSelect_) isIntent_Message_Message() {}

func (*Intent_Message_CarouselSelect_) isIntent_Message_Message() {}

func (*Intent_Message_BrowseCarouselCard_) isIntent_Message_Message() {}

func (*Intent_Message_TableCard_) isIntent_Message_Message() {}

func (*Intent_Message_MediaContent_) isIntent_Message_Message() {}

// Represents a single followup intent in the chain.
type Intent_FollowupIntentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the followup intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	FollowupIntentName string `protobuf:"bytes,1,opt,name=followup_intent_name,json=followupIntentName,proto3" json:"followup_intent_name,omitempty"`
	// The unique identifier of the followup intent's parent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	ParentFollowupIntentName string `protobuf:"bytes,2,opt,name=parent_followup_intent_name,json=parentFollowupIntentName,proto3" json:"parent_followup_intent_name,omitempty"`
}

func (x *Intent_FollowupIntentInfo) Reset() {
	*x = Intent_FollowupIntentInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_FollowupIntentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_FollowupIntentInfo) ProtoMessage() {}

func (x *Intent_FollowupIntentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_FollowupIntentInfo.ProtoReflect.Descriptor instead.
func (*Intent_FollowupIntentInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Intent_FollowupIntentInfo) GetFollowupIntentName() string {
	if x != nil {
		return x.FollowupIntentName
	}
	return ""
}

func (x *Intent_FollowupIntentInfo) GetParentFollowupIntentName() string {
	if x != nil {
		return x.ParentFollowupIntentName
	}
	return ""
}

// Represents a part of a training phrase.
type Intent_TrainingPhrase_Part struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The text for this part.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. The entity type name prefixed with `@`.
	// This field is required for annotated parts of the training phrase.
	EntityType string `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The parameter name for the value extracted from the
	// annotated part of the example.
	// This field is required for annotated parts of the training phrase.
	Alias string `protobuf:"bytes,3,opt,name=alias,proto3" json:"alias,omitempty"`
	// Optional. Indicates whether the text was manually annotated.
	// This field is set to true when the Dialogflow Console is used to
	// manually annotate the part. When creating an annotated part with the
	// API, you must set this to true.
	UserDefined bool `protobuf:"varint,4,opt,name=user_defined,json=userDefined,proto3" json:"user_defined,omitempty"`
}

func (x *Intent_TrainingPhrase_Part) Reset() {
	*x = Intent_TrainingPhrase_Part{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_TrainingPhrase_Part) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_TrainingPhrase_Part) ProtoMessage() {}

func (x *Intent_TrainingPhrase_Part) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_TrainingPhrase_Part.ProtoReflect.Descriptor instead.
func (*Intent_TrainingPhrase_Part) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Intent_TrainingPhrase_Part) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *Intent_TrainingPhrase_Part) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *Intent_TrainingPhrase_Part) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

func (x *Intent_TrainingPhrase_Part) GetUserDefined() bool {
	if x != nil {
		return x.UserDefined
	}
	return false
}

// The text response message.
type Intent_Message_Text struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The collection of the agent's responses.
	Text []string `protobuf:"bytes,1,rep,name=text,proto3" json:"text,omitempty"`
}

func (x *Intent_Message_Text) Reset() {
	*x = Intent_Message_Text{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_Text) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_Text) ProtoMessage() {}

func (x *Intent_Message_Text) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_Text.ProtoReflect.Descriptor instead.
func (*Intent_Message_Text) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *Intent_Message_Text) GetText() []string {
	if x != nil {
		return x.Text
	}
	return nil
}

// The image response message.
type Intent_Message_Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The public URI to an image file.
	ImageUri string `protobuf:"bytes,1,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Optional. A text description of the image to be used for accessibility,
	// e.g., screen readers.
	AccessibilityText string `protobuf:"bytes,2,opt,name=accessibility_text,json=accessibilityText,proto3" json:"accessibility_text,omitempty"`
}

func (x *Intent_Message_Image) Reset() {
	*x = Intent_Message_Image{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_Image) ProtoMessage() {}

func (x *Intent_Message_Image) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_Image.ProtoReflect.Descriptor instead.
func (*Intent_Message_Image) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *Intent_Message_Image) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

func (x *Intent_Message_Image) GetAccessibilityText() string {
	if x != nil {
		return x.AccessibilityText
	}
	return ""
}

// The quick replies response message.
type Intent_Message_QuickReplies struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The title of the collection of quick replies.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The collection of quick replies.
	QuickReplies []string `protobuf:"bytes,2,rep,name=quick_replies,json=quickReplies,proto3" json:"quick_replies,omitempty"`
}

func (x *Intent_Message_QuickReplies) Reset() {
	*x = Intent_Message_QuickReplies{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_QuickReplies) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_QuickReplies) ProtoMessage() {}

func (x *Intent_Message_QuickReplies) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_QuickReplies.ProtoReflect.Descriptor instead.
func (*Intent_Message_QuickReplies) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 2}
}

func (x *Intent_Message_QuickReplies) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Intent_Message_QuickReplies) GetQuickReplies() []string {
	if x != nil {
		return x.QuickReplies
	}
	return nil
}

// The card response message.
type Intent_Message_Card struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The title of the card.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The subtitle of the card.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	// Optional. The public URI to an image file for the card.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Optional. The collection of card buttons.
	Buttons []*Intent_Message_Card_Button `protobuf:"bytes,4,rep,name=buttons,proto3" json:"buttons,omitempty"`
}

func (x *Intent_Message_Card) Reset() {
	*x = Intent_Message_Card{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_Card) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_Card) ProtoMessage() {}

func (x *Intent_Message_Card) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_Card.ProtoReflect.Descriptor instead.
func (*Intent_Message_Card) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 3}
}

func (x *Intent_Message_Card) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Intent_Message_Card) GetSubtitle() string {
	if x != nil {
		return x.Subtitle
	}
	return ""
}

func (x *Intent_Message_Card) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

func (x *Intent_Message_Card) GetButtons() []*Intent_Message_Card_Button {
	if x != nil {
		return x.Buttons
	}
	return nil
}

// The simple response message containing speech or text.
type Intent_Message_SimpleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of text_to_speech or ssml must be provided. The plain text of the
	// speech output. Mutually exclusive with ssml.
	TextToSpeech string `protobuf:"bytes,1,opt,name=text_to_speech,json=textToSpeech,proto3" json:"text_to_speech,omitempty"`
	// One of text_to_speech or ssml must be provided. Structured spoken
	// response to the user in the SSML format. Mutually exclusive with
	// text_to_speech.
	Ssml string `protobuf:"bytes,2,opt,name=ssml,proto3" json:"ssml,omitempty"`
	// Optional. The text to display.
	DisplayText string `protobuf:"bytes,3,opt,name=display_text,json=displayText,proto3" json:"display_text,omitempty"`
}

func (x *Intent_Message_SimpleResponse) Reset() {
	*x = Intent_Message_SimpleResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_SimpleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_SimpleResponse) ProtoMessage() {}

func (x *Intent_Message_SimpleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_SimpleResponse.ProtoReflect.Descriptor instead.
func (*Intent_Message_SimpleResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 4}
}

func (x *Intent_Message_SimpleResponse) GetTextToSpeech() string {
	if x != nil {
		return x.TextToSpeech
	}
	return ""
}

func (x *Intent_Message_SimpleResponse) GetSsml() string {
	if x != nil {
		return x.Ssml
	}
	return ""
}

func (x *Intent_Message_SimpleResponse) GetDisplayText() string {
	if x != nil {
		return x.DisplayText
	}
	return ""
}

// The collection of simple response candidates.
// This message in `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
type Intent_Message_SimpleResponses struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of simple responses.
	SimpleResponses []*Intent_Message_SimpleResponse `protobuf:"bytes,1,rep,name=simple_responses,json=simpleResponses,proto3" json:"simple_responses,omitempty"`
}

func (x *Intent_Message_SimpleResponses) Reset() {
	*x = Intent_Message_SimpleResponses{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_SimpleResponses) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_SimpleResponses) ProtoMessage() {}

func (x *Intent_Message_SimpleResponses) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_SimpleResponses.ProtoReflect.Descriptor instead.
func (*Intent_Message_SimpleResponses) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 5}
}

func (x *Intent_Message_SimpleResponses) GetSimpleResponses() []*Intent_Message_SimpleResponse {
	if x != nil {
		return x.SimpleResponses
	}
	return nil
}

// The basic card message. Useful for displaying information.
type Intent_Message_BasicCard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The title of the card.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The subtitle of the card.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	// Required, unless image is present. The body text of the card.
	FormattedText string `protobuf:"bytes,3,opt,name=formatted_text,json=formattedText,proto3" json:"formatted_text,omitempty"`
	// Optional. The image for the card.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Optional. The collection of card buttons.
	Buttons []*Intent_Message_BasicCard_Button `protobuf:"bytes,5,rep,name=buttons,proto3" json:"buttons,omitempty"`
}

func (x *Intent_Message_BasicCard) Reset() {
	*x = Intent_Message_BasicCard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_BasicCard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_BasicCard) ProtoMessage() {}

func (x *Intent_Message_BasicCard) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_BasicCard.ProtoReflect.Descriptor instead.
func (*Intent_Message_BasicCard) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 6}
}

func (x *Intent_Message_BasicCard) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Intent_Message_BasicCard) GetSubtitle() string {
	if x != nil {
		return x.Subtitle
	}
	return ""
}

func (x *Intent_Message_BasicCard) GetFormattedText() string {
	if x != nil {
		return x.FormattedText
	}
	return ""
}

func (x *Intent_Message_BasicCard) GetImage() *Intent_Message_Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Intent_Message_BasicCard) GetButtons() []*Intent_Message_BasicCard_Button {
	if x != nil {
		return x.Buttons
	}
	return nil
}

// The suggestion chip message that the user can tap to quickly post a reply
// to the conversation.
type Intent_Message_Suggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The text shown the in the suggestion chip.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
}

func (x *Intent_Message_Suggestion) Reset() {
	*x = Intent_Message_Suggestion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_Suggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_Suggestion) ProtoMessage() {}

func (x *Intent_Message_Suggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_Suggestion.ProtoReflect.Descriptor instead.
func (*Intent_Message_Suggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 7}
}

func (x *Intent_Message_Suggestion) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

// The collection of suggestions.
type Intent_Message_Suggestions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of suggested replies.
	Suggestions []*Intent_Message_Suggestion `protobuf:"bytes,1,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
}

func (x *Intent_Message_Suggestions) Reset() {
	*x = Intent_Message_Suggestions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_Suggestions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_Suggestions) ProtoMessage() {}

func (x *Intent_Message_Suggestions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_Suggestions.ProtoReflect.Descriptor instead.
func (*Intent_Message_Suggestions) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 8}
}

func (x *Intent_Message_Suggestions) GetSuggestions() []*Intent_Message_Suggestion {
	if x != nil {
		return x.Suggestions
	}
	return nil
}

// The suggestion chip message that allows the user to jump out to the app
// or website associated with this agent.
type Intent_Message_LinkOutSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the app or site this chip is linking to.
	DestinationName string `protobuf:"bytes,1,opt,name=destination_name,json=destinationName,proto3" json:"destination_name,omitempty"`
	// Required. The URI of the app or site to open when the user taps the
	// suggestion chip.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Intent_Message_LinkOutSuggestion) Reset() {
	*x = Intent_Message_LinkOutSuggestion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_LinkOutSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_LinkOutSuggestion) ProtoMessage() {}

func (x *Intent_Message_LinkOutSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_LinkOutSuggestion.ProtoReflect.Descriptor instead.
func (*Intent_Message_LinkOutSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 9}
}

func (x *Intent_Message_LinkOutSuggestion) GetDestinationName() string {
	if x != nil {
		return x.DestinationName
	}
	return ""
}

func (x *Intent_Message_LinkOutSuggestion) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// The card for presenting a list of options to select from.
type Intent_Message_ListSelect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The overall title of the list.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Required. List items.
	Items []*Intent_Message_ListSelect_Item `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	// Optional. Subtitle of the list.
	Subtitle string `protobuf:"bytes,3,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
}

func (x *Intent_Message_ListSelect) Reset() {
	*x = Intent_Message_ListSelect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_ListSelect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_ListSelect) ProtoMessage() {}

func (x *Intent_Message_ListSelect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_ListSelect.ProtoReflect.Descriptor instead.
func (*Intent_Message_ListSelect) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 10}
}

func (x *Intent_Message_ListSelect) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Intent_Message_ListSelect) GetItems() []*Intent_Message_ListSelect_Item {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *Intent_Message_ListSelect) GetSubtitle() string {
	if x != nil {
		return x.Subtitle
	}
	return ""
}

// The card for presenting a carousel of options to select from.
type Intent_Message_CarouselSelect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Carousel items.
	Items []*Intent_Message_CarouselSelect_Item `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *Intent_Message_CarouselSelect) Reset() {
	*x = Intent_Message_CarouselSelect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_CarouselSelect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_CarouselSelect) ProtoMessage() {}

func (x *Intent_Message_CarouselSelect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_CarouselSelect.ProtoReflect.Descriptor instead.
func (*Intent_Message_CarouselSelect) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 11}
}

func (x *Intent_Message_CarouselSelect) GetItems() []*Intent_Message_CarouselSelect_Item {
	if x != nil {
		return x.Items
	}
	return nil
}

// Additional info about the select item for when it is triggered in a
// dialog.
type Intent_Message_SelectItemInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique key that will be sent back to the agent if this
	// response is given.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. A list of synonyms that can also be used to trigger this
	// item in dialog.
	Synonyms []string `protobuf:"bytes,2,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
}

func (x *Intent_Message_SelectItemInfo) Reset() {
	*x = Intent_Message_SelectItemInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_SelectItemInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_SelectItemInfo) ProtoMessage() {}

func (x *Intent_Message_SelectItemInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_SelectItemInfo.ProtoReflect.Descriptor instead.
func (*Intent_Message_SelectItemInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 12}
}

func (x *Intent_Message_SelectItemInfo) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Intent_Message_SelectItemInfo) GetSynonyms() []string {
	if x != nil {
		return x.Synonyms
	}
	return nil
}

// The media content card for Actions on Google.
type Intent_Message_MediaContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. What type of media is the content (ie "audio").
	MediaType Intent_Message_MediaContent_ResponseMediaType `protobuf:"varint,1,opt,name=media_type,json=mediaType,proto3,enum=google.cloud.dialogflow.v2.Intent_Message_MediaContent_ResponseMediaType" json:"media_type,omitempty"`
	// Required. List of media objects.
	MediaObjects []*Intent_Message_MediaContent_ResponseMediaObject `protobuf:"bytes,2,rep,name=media_objects,json=mediaObjects,proto3" json:"media_objects,omitempty"`
}

func (x *Intent_Message_MediaContent) Reset() {
	*x = Intent_Message_MediaContent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_MediaContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_MediaContent) ProtoMessage() {}

func (x *Intent_Message_MediaContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_MediaContent.ProtoReflect.Descriptor instead.
func (*Intent_Message_MediaContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 13}
}

func (x *Intent_Message_MediaContent) GetMediaType() Intent_Message_MediaContent_ResponseMediaType {
	if x != nil {
		return x.MediaType
	}
	return Intent_Message_MediaContent_RESPONSE_MEDIA_TYPE_UNSPECIFIED
}

func (x *Intent_Message_MediaContent) GetMediaObjects() []*Intent_Message_MediaContent_ResponseMediaObject {
	if x != nil {
		return x.MediaObjects
	}
	return nil
}

// Browse Carousel Card for Actions on Google.
// https://developers.google.com/actions/assistant/responses#browsing_carousel
type Intent_Message_BrowseCarouselCard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of items in the Browse Carousel Card. Minimum of two
	// items, maximum of ten.
	Items []*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// Optional. Settings for displaying the image. Applies to every image in
	// [items][google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.items].
	ImageDisplayOptions Intent_Message_BrowseCarouselCard_ImageDisplayOptions `protobuf:"varint,2,opt,name=image_display_options,json=imageDisplayOptions,proto3,enum=google.cloud.dialogflow.v2.Intent_Message_BrowseCarouselCard_ImageDisplayOptions" json:"image_display_options,omitempty"`
}

func (x *Intent_Message_BrowseCarouselCard) Reset() {
	*x = Intent_Message_BrowseCarouselCard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_BrowseCarouselCard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_BrowseCarouselCard) ProtoMessage() {}

func (x *Intent_Message_BrowseCarouselCard) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_BrowseCarouselCard.ProtoReflect.Descriptor instead.
func (*Intent_Message_BrowseCarouselCard) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 14}
}

func (x *Intent_Message_BrowseCarouselCard) GetItems() []*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *Intent_Message_BrowseCarouselCard) GetImageDisplayOptions() Intent_Message_BrowseCarouselCard_ImageDisplayOptions {
	if x != nil {
		return x.ImageDisplayOptions
	}
	return Intent_Message_BrowseCarouselCard_IMAGE_DISPLAY_OPTIONS_UNSPECIFIED
}

// Table card for Actions on Google.
type Intent_Message_TableCard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Title of the card.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. Subtitle to the title.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	// Optional. Image which should be displayed on the card.
	Image *Intent_Message_Image `protobuf:"bytes,3,opt,name=image,proto3" json:"image,omitempty"`
	// Optional. Display properties for the columns in this table.
	ColumnProperties []*Intent_Message_ColumnProperties `protobuf:"bytes,4,rep,name=column_properties,json=columnProperties,proto3" json:"column_properties,omitempty"`
	// Optional. Rows in this table of data.
	Rows []*Intent_Message_TableCardRow `protobuf:"bytes,5,rep,name=rows,proto3" json:"rows,omitempty"`
	// Optional. List of buttons for the card.
	Buttons []*Intent_Message_BasicCard_Button `protobuf:"bytes,6,rep,name=buttons,proto3" json:"buttons,omitempty"`
}

func (x *Intent_Message_TableCard) Reset() {
	*x = Intent_Message_TableCard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_TableCard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_TableCard) ProtoMessage() {}

func (x *Intent_Message_TableCard) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_TableCard.ProtoReflect.Descriptor instead.
func (*Intent_Message_TableCard) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 15}
}

func (x *Intent_Message_TableCard) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Intent_Message_TableCard) GetSubtitle() string {
	if x != nil {
		return x.Subtitle
	}
	return ""
}

func (x *Intent_Message_TableCard) GetImage() *Intent_Message_Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Intent_Message_TableCard) GetColumnProperties() []*Intent_Message_ColumnProperties {
	if x != nil {
		return x.ColumnProperties
	}
	return nil
}

func (x *Intent_Message_TableCard) GetRows() []*Intent_Message_TableCardRow {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *Intent_Message_TableCard) GetButtons() []*Intent_Message_BasicCard_Button {
	if x != nil {
		return x.Buttons
	}
	return nil
}

// Column properties for
// [TableCard][google.cloud.dialogflow.v2.Intent.Message.TableCard].
type Intent_Message_ColumnProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Column heading.
	Header string `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Optional. Defines text alignment for all cells in this column.
	HorizontalAlignment Intent_Message_ColumnProperties_HorizontalAlignment `protobuf:"varint,2,opt,name=horizontal_alignment,json=horizontalAlignment,proto3,enum=google.cloud.dialogflow.v2.Intent_Message_ColumnProperties_HorizontalAlignment" json:"horizontal_alignment,omitempty"`
}

func (x *Intent_Message_ColumnProperties) Reset() {
	*x = Intent_Message_ColumnProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_ColumnProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_ColumnProperties) ProtoMessage() {}

func (x *Intent_Message_ColumnProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_ColumnProperties.ProtoReflect.Descriptor instead.
func (*Intent_Message_ColumnProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 16}
}

func (x *Intent_Message_ColumnProperties) GetHeader() string {
	if x != nil {
		return x.Header
	}
	return ""
}

func (x *Intent_Message_ColumnProperties) GetHorizontalAlignment() Intent_Message_ColumnProperties_HorizontalAlignment {
	if x != nil {
		return x.HorizontalAlignment
	}
	return Intent_Message_ColumnProperties_HORIZONTAL_ALIGNMENT_UNSPECIFIED
}

// Row of [TableCard][google.cloud.dialogflow.v2.Intent.Message.TableCard].
type Intent_Message_TableCardRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. List of cells that make up this row.
	Cells []*Intent_Message_TableCardCell `protobuf:"bytes,1,rep,name=cells,proto3" json:"cells,omitempty"`
	// Optional. Whether to add a visual divider after this row.
	DividerAfter bool `protobuf:"varint,2,opt,name=divider_after,json=dividerAfter,proto3" json:"divider_after,omitempty"`
}

func (x *Intent_Message_TableCardRow) Reset() {
	*x = Intent_Message_TableCardRow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_TableCardRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_TableCardRow) ProtoMessage() {}

func (x *Intent_Message_TableCardRow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_TableCardRow.ProtoReflect.Descriptor instead.
func (*Intent_Message_TableCardRow) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 17}
}

func (x *Intent_Message_TableCardRow) GetCells() []*Intent_Message_TableCardCell {
	if x != nil {
		return x.Cells
	}
	return nil
}

func (x *Intent_Message_TableCardRow) GetDividerAfter() bool {
	if x != nil {
		return x.DividerAfter
	}
	return false
}

// Cell of
// [TableCardRow][google.cloud.dialogflow.v2.Intent.Message.TableCardRow].
type Intent_Message_TableCardCell struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Text in this cell.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *Intent_Message_TableCardCell) Reset() {
	*x = Intent_Message_TableCardCell{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_TableCardCell) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_TableCardCell) ProtoMessage() {}

func (x *Intent_Message_TableCardCell) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_TableCardCell.ProtoReflect.Descriptor instead.
func (*Intent_Message_TableCardCell) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 18}
}

func (x *Intent_Message_TableCardCell) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Contains information about a button.
type Intent_Message_Card_Button struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The text to show on the button.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. The text to send back to the Dialogflow API or a URI to
	// open.
	Postback string `protobuf:"bytes,2,opt,name=postback,proto3" json:"postback,omitempty"`
}

func (x *Intent_Message_Card_Button) Reset() {
	*x = Intent_Message_Card_Button{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_Card_Button) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_Card_Button) ProtoMessage() {}

func (x *Intent_Message_Card_Button) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_Card_Button.ProtoReflect.Descriptor instead.
func (*Intent_Message_Card_Button) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 3, 0}
}

func (x *Intent_Message_Card_Button) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *Intent_Message_Card_Button) GetPostback() string {
	if x != nil {
		return x.Postback
	}
	return ""
}

// The button object that appears at the bottom of a card.
type Intent_Message_BasicCard_Button struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The title of the button.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Required. Action to take when a user taps on the button.
	OpenUriAction *Intent_Message_BasicCard_Button_OpenUriAction `protobuf:"bytes,2,opt,name=open_uri_action,json=openUriAction,proto3" json:"open_uri_action,omitempty"`
}

func (x *Intent_Message_BasicCard_Button) Reset() {
	*x = Intent_Message_BasicCard_Button{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_BasicCard_Button) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_BasicCard_Button) ProtoMessage() {}

func (x *Intent_Message_BasicCard_Button) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_BasicCard_Button.ProtoReflect.Descriptor instead.
func (*Intent_Message_BasicCard_Button) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 6, 0}
}

func (x *Intent_Message_BasicCard_Button) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Intent_Message_BasicCard_Button) GetOpenUriAction() *Intent_Message_BasicCard_Button_OpenUriAction {
	if x != nil {
		return x.OpenUriAction
	}
	return nil
}

// Opens the given URI.
type Intent_Message_BasicCard_Button_OpenUriAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The HTTP or HTTPS scheme URI.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Intent_Message_BasicCard_Button_OpenUriAction) Reset() {
	*x = Intent_Message_BasicCard_Button_OpenUriAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_BasicCard_Button_OpenUriAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_BasicCard_Button_OpenUriAction) ProtoMessage() {}

func (x *Intent_Message_BasicCard_Button_OpenUriAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_BasicCard_Button_OpenUriAction.ProtoReflect.Descriptor instead.
func (*Intent_Message_BasicCard_Button_OpenUriAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 6, 0, 0}
}

func (x *Intent_Message_BasicCard_Button_OpenUriAction) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// An item in the list.
type Intent_Message_ListSelect_Item struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Additional information about this option.
	Info *Intent_Message_SelectItemInfo `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	// Required. The title of the list item.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The main text describing the item.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The image to display.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
}

func (x *Intent_Message_ListSelect_Item) Reset() {
	*x = Intent_Message_ListSelect_Item{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_ListSelect_Item) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_ListSelect_Item) ProtoMessage() {}

func (x *Intent_Message_ListSelect_Item) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_ListSelect_Item.ProtoReflect.Descriptor instead.
func (*Intent_Message_ListSelect_Item) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 10, 0}
}

func (x *Intent_Message_ListSelect_Item) GetInfo() *Intent_Message_SelectItemInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *Intent_Message_ListSelect_Item) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Intent_Message_ListSelect_Item) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Intent_Message_ListSelect_Item) GetImage() *Intent_Message_Image {
	if x != nil {
		return x.Image
	}
	return nil
}

// An item in the carousel.
type Intent_Message_CarouselSelect_Item struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Additional info about the option item.
	Info *Intent_Message_SelectItemInfo `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	// Required. Title of the carousel item.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The body text of the card.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The image to display.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
}

func (x *Intent_Message_CarouselSelect_Item) Reset() {
	*x = Intent_Message_CarouselSelect_Item{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_CarouselSelect_Item) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_CarouselSelect_Item) ProtoMessage() {}

func (x *Intent_Message_CarouselSelect_Item) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_CarouselSelect_Item.ProtoReflect.Descriptor instead.
func (*Intent_Message_CarouselSelect_Item) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 11, 0}
}

func (x *Intent_Message_CarouselSelect_Item) GetInfo() *Intent_Message_SelectItemInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *Intent_Message_CarouselSelect_Item) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Intent_Message_CarouselSelect_Item) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Intent_Message_CarouselSelect_Item) GetImage() *Intent_Message_Image {
	if x != nil {
		return x.Image
	}
	return nil
}

// Response media object for media content card.
type Intent_Message_MediaContent_ResponseMediaObject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of media card.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Description of media card.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Image to show with the media card.
	//
	// Types that are assignable to Image:
	//	*Intent_Message_MediaContent_ResponseMediaObject_LargeImage
	//	*Intent_Message_MediaContent_ResponseMediaObject_Icon
	Image isIntent_Message_MediaContent_ResponseMediaObject_Image `protobuf_oneof:"image"`
	// Required. Url where the media is stored.
	ContentUrl string `protobuf:"bytes,5,opt,name=content_url,json=contentUrl,proto3" json:"content_url,omitempty"`
}

func (x *Intent_Message_MediaContent_ResponseMediaObject) Reset() {
	*x = Intent_Message_MediaContent_ResponseMediaObject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_MediaContent_ResponseMediaObject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_MediaContent_ResponseMediaObject) ProtoMessage() {}

func (x *Intent_Message_MediaContent_ResponseMediaObject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_MediaContent_ResponseMediaObject.ProtoReflect.Descriptor instead.
func (*Intent_Message_MediaContent_ResponseMediaObject) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 13, 0}
}

func (x *Intent_Message_MediaContent_ResponseMediaObject) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Intent_Message_MediaContent_ResponseMediaObject) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *Intent_Message_MediaContent_ResponseMediaObject) GetImage() isIntent_Message_MediaContent_ResponseMediaObject_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (x *Intent_Message_MediaContent_ResponseMediaObject) GetLargeImage() *Intent_Message_Image {
	if x, ok := x.GetImage().(*Intent_Message_MediaContent_ResponseMediaObject_LargeImage); ok {
		return x.LargeImage
	}
	return nil
}

func (x *Intent_Message_MediaContent_ResponseMediaObject) GetIcon() *Intent_Message_Image {
	if x, ok := x.GetImage().(*Intent_Message_MediaContent_ResponseMediaObject_Icon); ok {
		return x.Icon
	}
	return nil
}

func (x *Intent_Message_MediaContent_ResponseMediaObject) GetContentUrl() string {
	if x != nil {
		return x.ContentUrl
	}
	return ""
}

type isIntent_Message_MediaContent_ResponseMediaObject_Image interface {
	isIntent_Message_MediaContent_ResponseMediaObject_Image()
}

type Intent_Message_MediaContent_ResponseMediaObject_LargeImage struct {
	// Optional. Image to display above media content.
	LargeImage *Intent_Message_Image `protobuf:"bytes,3,opt,name=large_image,json=largeImage,proto3,oneof"`
}

type Intent_Message_MediaContent_ResponseMediaObject_Icon struct {
	// Optional. Icon to display above media content.
	Icon *Intent_Message_Image `protobuf:"bytes,4,opt,name=icon,proto3,oneof"`
}

func (*Intent_Message_MediaContent_ResponseMediaObject_LargeImage) isIntent_Message_MediaContent_ResponseMediaObject_Image() {
}

func (*Intent_Message_MediaContent_ResponseMediaObject_Icon) isIntent_Message_MediaContent_ResponseMediaObject_Image() {
}

// Browsing carousel tile
type Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Action to present to the user.
	OpenUriAction *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction `protobuf:"bytes,1,opt,name=open_uri_action,json=openUriAction,proto3" json:"open_uri_action,omitempty"`
	// Required. Title of the carousel item. Maximum of two lines of text.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. Description of the carousel item. Maximum of four lines of
	// text.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Hero image for the carousel item.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Optional. Text that appears at the bottom of the Browse Carousel
	// Card. Maximum of one line of text.
	Footer string `protobuf:"bytes,5,opt,name=footer,proto3" json:"footer,omitempty"`
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) Reset() {
	*x = Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) ProtoMessage() {}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem.ProtoReflect.Descriptor instead.
func (*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 14, 0}
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetOpenUriAction() *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction {
	if x != nil {
		return x.OpenUriAction
	}
	return nil
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetImage() *Intent_Message_Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem) GetFooter() string {
	if x != nil {
		return x.Footer
	}
	return ""
}

// Actions on Google action to open a given url.
type Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. URL
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Optional. Specifies the type of viewer that is used when opening
	// the URL. Defaults to opening via web browser.
	UrlTypeHint Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint `protobuf:"varint,3,opt,name=url_type_hint,json=urlTypeHint,proto3,enum=google.cloud.dialogflow.v2.Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint" json:"url_type_hint,omitempty"`
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) Reset() {
	*x = Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) ProtoMessage() {}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_intent_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction.ProtoReflect.Descriptor instead.
func (*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP(), []int{0, 2, 14, 0, 0}
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction) GetUrlTypeHint() Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint {
	if x != nil {
		return x.UrlTypeHint
	}
	return Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_URL_TYPE_HINT_UNSPECIFIED
}

var File_google_cloud_dialogflow_v2_intent_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2_intent_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb5, 0x43, 0x0a, 0x06, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x59, 0x0a, 0x0d, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x57, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x77,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x70,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x24, 0x0a, 0x0b,
	0x69, 0x73, 0x5f, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x73, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61,
	0x63, 0x6b, 0x12, 0x24, 0x0a, 0x0b, 0x6d, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x6c,
	0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x31, 0x0a, 0x12, 0x6c, 0x69, 0x76, 0x65,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6c, 0x69, 0x76, 0x65, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x12, 0x2c, 0x0a, 0x0f, 0x65,
	0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x6e, 0x64, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x13, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1b,
	0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x61, 0x0a, 0x10, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x12, 0x1b,
	0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x2a,
	0x0a, 0x0e, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72, 0x65, 0x73,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4b, 0x0a,
	0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x76, 0x0a, 0x1a, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x73, 0x12, 0x3e, 0x0a, 0x19, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
	0x77, 0x75, 0x70, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x72, 0x6f, 0x6f, 0x74,
	0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6f, 0x6c,
	0x6c, 0x6f, 0x77, 0x75, 0x70, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x46,
	0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x6c, 0x0a, 0x14, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x2e, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x66, 0x6f, 0x6c,
	0x6c, 0x6f, 0x77, 0x75, 0x70, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x1a,
	0xbc, 0x03, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x51, 0x0a, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x5f, 0x61, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x41, 0x64, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x83, 0x01, 0x0a, 0x04,
	0x50, 0x61, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19,
	0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65,
	0x64, 0x22, 0x3b, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x45, 0x58, 0x41, 0x4d, 0x50, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x08,
	0x54, 0x45, 0x4d, 0x50, 0x4c, 0x41, 0x54, 0x45, 0x10, 0x02, 0x1a, 0x02, 0x08, 0x01, 0x1a, 0xa5,
	0x02, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x28,
	0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3c, 0x0a, 0x18, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x15, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x1c, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x6c,
	0x69, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x69, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x1a, 0xf1, 0x30, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x45, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x65, 0x78,
	0x74, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x48, 0x0a, 0x05, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x12, 0x5e, 0x0a, 0x0d, 0x71, 0x75, 0x69, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x51, 0x75, 0x69, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x71, 0x75, 0x69, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x04, 0x63, 0x61, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x61,
	0x72, 0x64, 0x48, 0x00, 0x52, 0x04, 0x63, 0x61, 0x72, 0x64, 0x12, 0x33, 0x0a, 0x07, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x67, 0x0a, 0x10, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x53, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x55, 0x0a, 0x0a, 0x62, 0x61, 0x73, 0x69,
	0x63, 0x5f, 0x63, 0x61, 0x72, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x63, 0x43, 0x61,
	0x72, 0x64, 0x48, 0x00, 0x52, 0x09, 0x62, 0x61, 0x73, 0x69, 0x63, 0x43, 0x61, 0x72, 0x64, 0x12,
	0x5a, 0x0a, 0x0b, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0b,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6e, 0x0a, 0x13, 0x6c,
	0x69, 0x6e, 0x6b, 0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x4f, 0x75, 0x74, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x6c, 0x69, 0x6e, 0x6b, 0x4f, 0x75,
	0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0b, 0x6c,
	0x69, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x6c, 0x69, 0x73, 0x74, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x64, 0x0a, 0x0f, 0x63, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65,
	0x6c, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x61, 0x72, 0x6f, 0x75,
	0x73, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x61, 0x72,
	0x6f, 0x75, 0x73, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x71, 0x0a, 0x14, 0x62,
	0x72, 0x6f, 0x77, 0x73, 0x65, 0x5f, 0x63, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x5f, 0x63,
	0x61, 0x72, 0x64, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x72, 0x6f, 0x77, 0x73, 0x65, 0x43, 0x61, 0x72, 0x6f,
	0x75, 0x73, 0x65, 0x6c, 0x43, 0x61, 0x72, 0x64, 0x48, 0x00, 0x52, 0x12, 0x62, 0x72, 0x6f, 0x77,
	0x73, 0x65, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x43, 0x61, 0x72, 0x64, 0x12, 0x55,
	0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x61, 0x72, 0x64, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x43, 0x61, 0x72, 0x64, 0x48, 0x00, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x43, 0x61, 0x72, 0x64, 0x12, 0x5e, 0x0a, 0x0d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x1a, 0x1f, 0x0a, 0x04, 0x54,
	0x65, 0x78, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x1a, 0x5d, 0x0a, 0x05,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x32, 0x0a, 0x12, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x65, 0x78, 0x74, 0x1a, 0x53, 0x0a, 0x0c, 0x51,
	0x75, 0x69, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x71, 0x75, 0x69, 0x63, 0x6b, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x71, 0x75, 0x69, 0x63, 0x6b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73,
	0x1a, 0xff, 0x01, 0x0a, 0x04, 0x43, 0x61, 0x72, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x75, 0x62,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x55, 0x0a, 0x07, 0x62, 0x75, 0x74, 0x74, 0x6f,
	0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x73, 0x1a, 0x42,
	0x0a, 0x06, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x74, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x74, 0x62, 0x61,
	0x63, 0x6b, 0x1a, 0x72, 0x0a, 0x0e, 0x53, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x6f, 0x5f,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x65,
	0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x73,
	0x6d, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x73, 0x73, 0x6d, 0x6c, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x54, 0x65, 0x78, 0x74, 0x1a, 0x7c, 0x0a, 0x0f, 0x53, 0x69, 0x6d, 0x70, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x69, 0x0a, 0x10, 0x73, 0x69, 0x6d,
	0x70, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x53, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x73, 0x1a, 0xd3, 0x03, 0x0a, 0x09, 0x42, 0x61, 0x73, 0x69, 0x63, 0x43, 0x61,
	0x72, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x1f, 0x0a,
	0x08, 0x73, 0x75, 0x62, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x75, 0x62, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x25,
	0x0a, 0x0e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65,
	0x64, 0x54, 0x65, 0x78, 0x74, 0x12, 0x4b, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x12, 0x5a, 0x0a, 0x07, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x42, 0x61, 0x73, 0x69, 0x63, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x73, 0x1a, 0xb9,
	0x01, 0x0a, 0x06, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12,
	0x76, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x63, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x42,
	0x75, 0x74, 0x74, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x55, 0x72, 0x69, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x55, 0x72,
	0x69, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x21, 0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x6e, 0x55,
	0x72, 0x69, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x1a, 0x27, 0x0a, 0x0a, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x1a, 0x6b, 0x0a, 0x0b, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x5c, 0x0a, 0x0b, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0x5a, 0x0a, 0x11, 0x4c, 0x69, 0x6e, 0x6b, 0x4f, 0x75, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x1a, 0x8b, 0x03, 0x0a,
	0x0a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x55, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x2e, 0x49, 0x74, 0x65,
	0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x1f, 0x0a,
	0x08, 0x73, 0x75, 0x62, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x75, 0x62, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x1a, 0xe9,
	0x01, 0x0a, 0x04, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x52, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x19, 0x0a, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a,
	0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x1a, 0xd7, 0x02, 0x0a, 0x0e, 0x43,
	0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x59, 0x0a,
	0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65,
	0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x1a, 0xe9, 0x01, 0x0a, 0x04, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0x52, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x1a, 0x48, 0x0a, 0x0e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x49, 0x74,
	0x65, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1f, 0x0a,
	0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x1a, 0xd8,
	0x04, 0x0a, 0x0c, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x6d, 0x0a, 0x0a, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x4d, 0x65, 0x64, 0x69, 0x61, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x70,
	0x0a, 0x0d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x0c, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x1a, 0xa1, 0x02, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x64,
	0x69, 0x61, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0b, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x0a, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x4b, 0x0a,
	0x04, 0x69, 0x63, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x22, 0x43, 0x0a, 0x11, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x4d, 0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x53,
	0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x01, 0x1a, 0xe1, 0x07, 0x0a, 0x12, 0x42, 0x72,
	0x6f, 0x77, 0x73, 0x65, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x43, 0x61, 0x72, 0x64,
	0x12, 0x6a, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x72, 0x6f, 0x77,
	0x73, 0x65, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x42,
	0x72, 0x6f, 0x77, 0x73, 0x65, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x43, 0x61, 0x72,
	0x64, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x8a, 0x01, 0x0a,
	0x15, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x72, 0x6f, 0x77, 0x73, 0x65, 0x43,
	0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xd9, 0x04, 0x0a, 0x16, 0x42, 0x72,
	0x6f, 0x77, 0x73, 0x65, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x43, 0x61, 0x72, 0x64,
	0x49, 0x74, 0x65, 0x6d, 0x12, 0x8a, 0x01, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x75, 0x72,
	0x69, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x62,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x72, 0x6f, 0x77, 0x73,
	0x65, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x42, 0x72,
	0x6f, 0x77, 0x73, 0x65, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x43, 0x61, 0x72, 0x64,
	0x49, 0x74, 0x65, 0x6d, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x55, 0x72, 0x6c, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x55, 0x72, 0x69, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b,
	0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x6f, 0x6f, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x1a, 0x8a, 0x02, 0x0a, 0x0d, 0x4f, 0x70, 0x65,
	0x6e, 0x55, 0x72, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x97, 0x01, 0x0a,
	0x0d, 0x75, 0x72, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x42, 0x72, 0x6f, 0x77, 0x73, 0x65, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73, 0x65, 0x6c, 0x43,
	0x61, 0x72, 0x64, 0x2e, 0x42, 0x72, 0x6f, 0x77, 0x73, 0x65, 0x43, 0x61, 0x72, 0x6f, 0x75, 0x73,
	0x65, 0x6c, 0x43, 0x61, 0x72, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x55,
	0x72, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x72, 0x6c, 0x54, 0x79, 0x70, 0x65,
	0x48, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x75, 0x72, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x48, 0x69, 0x6e, 0x74, 0x22, 0x4d, 0x0a, 0x0b, 0x55, 0x72, 0x6c, 0x54, 0x79, 0x70,
	0x65, 0x48, 0x69, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x19, 0x55, 0x52, 0x4c, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x48, 0x49, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x4d, 0x50, 0x5f, 0x41, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4d, 0x50, 0x5f, 0x43, 0x4f, 0x4e, 0x54,
	0x45, 0x4e, 0x54, 0x10, 0x02, 0x22, 0x76, 0x0a, 0x13, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x44, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x21,
	0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x50, 0x4c, 0x41, 0x59, 0x5f, 0x4f, 0x50,
	0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x52, 0x41, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x57, 0x48, 0x49, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x4f, 0x50,
	0x50, 0x45, 0x44, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x42, 0x4c, 0x55, 0x52, 0x52, 0x45, 0x44,
	0x5f, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x04, 0x1a, 0xac, 0x03,
	0x0a, 0x09, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x61, 0x72, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x12, 0x1f, 0x0a, 0x08, 0x73, 0x75, 0x62, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x75, 0x62, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x4b, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12,
	0x6d, 0x0a, 0x11, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x50,
	0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x61,
	0x72, 0x64, 0x52, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73,
	0x12, 0x5a, 0x0a, 0x07, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x61,
	0x73, 0x69, 0x63, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x73, 0x1a, 0x98, 0x02, 0x0a,
	0x10, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x87, 0x01, 0x0a, 0x14, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x48, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c,
	0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x22, 0x62, 0x0a, 0x13, 0x48, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61,
	0x6c, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x20, 0x48, 0x4f,
	0x52, 0x49, 0x5a, 0x4f, 0x4e, 0x54, 0x41, 0x4c, 0x5f, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x4d, 0x45,
	0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x4c, 0x45, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x43, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x52, 0x41,
	0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x1a, 0x8d, 0x01, 0x0a, 0x0c, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x43, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x77, 0x12, 0x53, 0x0a, 0x05, 0x63, 0x65, 0x6c, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x61, 0x72, 0x64, 0x43, 0x65, 0x6c,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x12, 0x28, 0x0a,
	0x0d, 0x64, 0x69, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x69, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x41, 0x66, 0x74, 0x65, 0x72, 0x1a, 0x23, 0x0a, 0x0d, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x61, 0x72, 0x64, 0x43, 0x65, 0x6c, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x22, 0xa0, 0x01, 0x0a,
	0x08, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x4c, 0x41,
	0x54, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x41, 0x43, 0x45, 0x42, 0x4f, 0x4f, 0x4b, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x4c, 0x41, 0x43, 0x4b, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x54, 0x45, 0x4c, 0x45, 0x47, 0x52, 0x41, 0x4d, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x4b, 0x49,
	0x4b, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x4b, 0x59, 0x50, 0x45, 0x10, 0x05, 0x12, 0x08,
	0x0a, 0x04, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x56, 0x49, 0x42, 0x45,
	0x52, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x4f,
	0x4e, 0x5f, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x10, 0x08, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x4f,
	0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x48, 0x41, 0x4e, 0x47, 0x4f, 0x55, 0x54, 0x53, 0x10, 0x0b, 0x42,
	0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x85, 0x01, 0x0a, 0x12, 0x46,
	0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x30, 0x0a, 0x14, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x12, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x6f,
	0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x75, 0x70, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x74, 0x0a, 0x0c, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x57, 0x45, 0x42, 0x48, 0x4f, 0x4f, 0x4b, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x19, 0x0a, 0x15, 0x57, 0x45, 0x42, 0x48, 0x4f, 0x4f, 0x4b, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x2a, 0x0a, 0x26,
	0x57, 0x45, 0x42, 0x48, 0x4f, 0x4f, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x45, 0x4e,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x53, 0x4c, 0x4f, 0x54, 0x5f, 0x46,
	0x49, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x3a, 0x91, 0x01, 0xea, 0x41, 0x8d, 0x01, 0x0a,
	0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x29, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x7d, 0x12, 0x3e, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0x94, 0x02, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x4c, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x7b, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xc8, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x4c, 0x0a,
	0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x22, 0x90, 0x02, 0x0a, 0x13,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x4c, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x22, 0x90,
	0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x4c, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x69,
	0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65,
	0x77, 0x22, 0x53, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xae, 0x03, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55,
	0x72, 0x69, 0x12, 0x59, 0x0a, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x48, 0x00, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4c, 0x0a, 0x0b, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x0e, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x22, 0x5a, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x22, 0xa0, 0x01, 0x0a, 0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x4b, 0x0a, 0x0b, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x12, 0x3c, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x2a, 0x3f, 0x0a, 0x0a, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65,
	0x77, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14,
	0x0a, 0x10, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55,
	0x4c, 0x4c, 0x10, 0x01, 0x32, 0xf3, 0x10, 0x0a, 0x07, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0xf0, 0x02, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xff, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x14,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd8, 0x01, 0x5a, 0x33, 0x12, 0x31, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x5a, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x5a, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x25, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0xdd, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47,
	0x65, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x22, 0x7e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xda, 0x41, 0x12, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x5a, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x25, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x02, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xa0, 0x01, 0xda, 0x41, 0x0d, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0xda, 0x41, 0x1b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6c,
	0x3a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5a, 0x3b, 0x3a, 0x06, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x22, 0x31, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x25, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xa0, 0x02, 0x0a,
	0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x22, 0xba, 0x01, 0xda, 0x41, 0x14, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0xda, 0x41, 0x20, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x7a, 0x3a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5a, 0x42, 0x3a,
	0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x32, 0x38, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x32, 0x2c, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc2, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x69, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x5a, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x25, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf6, 0x02, 0x0a, 0x12, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x89, 0x02, 0xca, 0x41, 0x4f, 0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x75, 0x72, 0x69,
	0xda, 0x41, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x7a, 0x3a, 0x01, 0x2a, 0x5a, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x22, 0x31, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0xb0, 0x02,
	0x0a, 0x12, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc3, 0x01, 0xca, 0x41, 0x2f,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0xda,
	0x41, 0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7a, 0x3a, 0x01, 0x2a, 0x5a, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x22, 0x31, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x94, 0x01, 0x0a, 0x1e, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x42, 0x0b, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2,
	0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56,
	0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2_intent_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2_intent_proto_rawDescData = file_google_cloud_dialogflow_v2_intent_proto_rawDesc
)

func file_google_cloud_dialogflow_v2_intent_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2_intent_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2_intent_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2_intent_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2_intent_proto_rawDescData
}

var file_google_cloud_dialogflow_v2_intent_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_dialogflow_v2_intent_proto_msgTypes = make([]protoimpl.MessageInfo, 43)
var file_google_cloud_dialogflow_v2_intent_proto_goTypes = []interface{}{
	(IntentView)(0),                                            // 0: google.cloud.dialogflow.v2.IntentView
	(Intent_WebhookState)(0),                                   // 1: google.cloud.dialogflow.v2.Intent.WebhookState
	(Intent_TrainingPhrase_Type)(0),                            // 2: google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type
	(Intent_Message_Platform)(0),                               // 3: google.cloud.dialogflow.v2.Intent.Message.Platform
	(Intent_Message_MediaContent_ResponseMediaType)(0),         // 4: google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType
	(Intent_Message_BrowseCarouselCard_ImageDisplayOptions)(0), // 5: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.ImageDisplayOptions
	(Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction_UrlTypeHint)(0), // 6: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction.UrlTypeHint
	(Intent_Message_ColumnProperties_HorizontalAlignment)(0),                                // 7: google.cloud.dialogflow.v2.Intent.Message.ColumnProperties.HorizontalAlignment
	(*Intent)(nil),                                                                 // 8: google.cloud.dialogflow.v2.Intent
	(*ListIntentsRequest)(nil),                                                     // 9: google.cloud.dialogflow.v2.ListIntentsRequest
	(*ListIntentsResponse)(nil),                                                    // 10: google.cloud.dialogflow.v2.ListIntentsResponse
	(*GetIntentRequest)(nil),                                                       // 11: google.cloud.dialogflow.v2.GetIntentRequest
	(*CreateIntentRequest)(nil),                                                    // 12: google.cloud.dialogflow.v2.CreateIntentRequest
	(*UpdateIntentRequest)(nil),                                                    // 13: google.cloud.dialogflow.v2.UpdateIntentRequest
	(*DeleteIntentRequest)(nil),                                                    // 14: google.cloud.dialogflow.v2.DeleteIntentRequest
	(*BatchUpdateIntentsRequest)(nil),                                              // 15: google.cloud.dialogflow.v2.BatchUpdateIntentsRequest
	(*BatchUpdateIntentsResponse)(nil),                                             // 16: google.cloud.dialogflow.v2.BatchUpdateIntentsResponse
	(*BatchDeleteIntentsRequest)(nil),                                              // 17: google.cloud.dialogflow.v2.BatchDeleteIntentsRequest
	(*IntentBatch)(nil),                                                            // 18: google.cloud.dialogflow.v2.IntentBatch
	(*Intent_TrainingPhrase)(nil),                                                  // 19: google.cloud.dialogflow.v2.Intent.TrainingPhrase
	(*Intent_Parameter)(nil),                                                       // 20: google.cloud.dialogflow.v2.Intent.Parameter
	(*Intent_Message)(nil),                                                         // 21: google.cloud.dialogflow.v2.Intent.Message
	(*Intent_FollowupIntentInfo)(nil),                                              // 22: google.cloud.dialogflow.v2.Intent.FollowupIntentInfo
	(*Intent_TrainingPhrase_Part)(nil),                                             // 23: google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part
	(*Intent_Message_Text)(nil),                                                    // 24: google.cloud.dialogflow.v2.Intent.Message.Text
	(*Intent_Message_Image)(nil),                                                   // 25: google.cloud.dialogflow.v2.Intent.Message.Image
	(*Intent_Message_QuickReplies)(nil),                                            // 26: google.cloud.dialogflow.v2.Intent.Message.QuickReplies
	(*Intent_Message_Card)(nil),                                                    // 27: google.cloud.dialogflow.v2.Intent.Message.Card
	(*Intent_Message_SimpleResponse)(nil),                                          // 28: google.cloud.dialogflow.v2.Intent.Message.SimpleResponse
	(*Intent_Message_SimpleResponses)(nil),                                         // 29: google.cloud.dialogflow.v2.Intent.Message.SimpleResponses
	(*Intent_Message_BasicCard)(nil),                                               // 30: google.cloud.dialogflow.v2.Intent.Message.BasicCard
	(*Intent_Message_Suggestion)(nil),                                              // 31: google.cloud.dialogflow.v2.Intent.Message.Suggestion
	(*Intent_Message_Suggestions)(nil),                                             // 32: google.cloud.dialogflow.v2.Intent.Message.Suggestions
	(*Intent_Message_LinkOutSuggestion)(nil),                                       // 33: google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
	(*Intent_Message_ListSelect)(nil),                                              // 34: google.cloud.dialogflow.v2.Intent.Message.ListSelect
	(*Intent_Message_CarouselSelect)(nil),                                          // 35: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect
	(*Intent_Message_SelectItemInfo)(nil),                                          // 36: google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
	(*Intent_Message_MediaContent)(nil),                                            // 37: google.cloud.dialogflow.v2.Intent.Message.MediaContent
	(*Intent_Message_BrowseCarouselCard)(nil),                                      // 38: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard
	(*Intent_Message_TableCard)(nil),                                               // 39: google.cloud.dialogflow.v2.Intent.Message.TableCard
	(*Intent_Message_ColumnProperties)(nil),                                        // 40: google.cloud.dialogflow.v2.Intent.Message.ColumnProperties
	(*Intent_Message_TableCardRow)(nil),                                            // 41: google.cloud.dialogflow.v2.Intent.Message.TableCardRow
	(*Intent_Message_TableCardCell)(nil),                                           // 42: google.cloud.dialogflow.v2.Intent.Message.TableCardCell
	(*Intent_Message_Card_Button)(nil),                                             // 43: google.cloud.dialogflow.v2.Intent.Message.Card.Button
	(*Intent_Message_BasicCard_Button)(nil),                                        // 44: google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
	(*Intent_Message_BasicCard_Button_OpenUriAction)(nil),                          // 45: google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
	(*Intent_Message_ListSelect_Item)(nil),                                         // 46: google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
	(*Intent_Message_CarouselSelect_Item)(nil),                                     // 47: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
	(*Intent_Message_MediaContent_ResponseMediaObject)(nil),                        // 48: google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
	(*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem)(nil),               // 49: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem
	(*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction)(nil), // 50: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction
	(*Context)(nil),                                                                // 51: google.cloud.dialogflow.v2.Context
	(*fieldmaskpb.FieldMask)(nil),                                                  // 52: google.protobuf.FieldMask
	(*structpb.Struct)(nil),                                                        // 53: google.protobuf.Struct
	(*emptypb.Empty)(nil),                                                          // 54: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                                                // 55: google.longrunning.Operation
}
var file_google_cloud_dialogflow_v2_intent_proto_depIdxs = []int32{
	1,  // 0: google.cloud.dialogflow.v2.Intent.webhook_state:type_name -> google.cloud.dialogflow.v2.Intent.WebhookState
	19, // 1: google.cloud.dialogflow.v2.Intent.training_phrases:type_name -> google.cloud.dialogflow.v2.Intent.TrainingPhrase
	51, // 2: google.cloud.dialogflow.v2.Intent.output_contexts:type_name -> google.cloud.dialogflow.v2.Context
	20, // 3: google.cloud.dialogflow.v2.Intent.parameters:type_name -> google.cloud.dialogflow.v2.Intent.Parameter
	21, // 4: google.cloud.dialogflow.v2.Intent.messages:type_name -> google.cloud.dialogflow.v2.Intent.Message
	3,  // 5: google.cloud.dialogflow.v2.Intent.default_response_platforms:type_name -> google.cloud.dialogflow.v2.Intent.Message.Platform
	22, // 6: google.cloud.dialogflow.v2.Intent.followup_intent_info:type_name -> google.cloud.dialogflow.v2.Intent.FollowupIntentInfo
	0,  // 7: google.cloud.dialogflow.v2.ListIntentsRequest.intent_view:type_name -> google.cloud.dialogflow.v2.IntentView
	8,  // 8: google.cloud.dialogflow.v2.ListIntentsResponse.intents:type_name -> google.cloud.dialogflow.v2.Intent
	0,  // 9: google.cloud.dialogflow.v2.GetIntentRequest.intent_view:type_name -> google.cloud.dialogflow.v2.IntentView
	8,  // 10: google.cloud.dialogflow.v2.CreateIntentRequest.intent:type_name -> google.cloud.dialogflow.v2.Intent
	0,  // 11: google.cloud.dialogflow.v2.CreateIntentRequest.intent_view:type_name -> google.cloud.dialogflow.v2.IntentView
	8,  // 12: google.cloud.dialogflow.v2.UpdateIntentRequest.intent:type_name -> google.cloud.dialogflow.v2.Intent
	52, // 13: google.cloud.dialogflow.v2.UpdateIntentRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 14: google.cloud.dialogflow.v2.UpdateIntentRequest.intent_view:type_name -> google.cloud.dialogflow.v2.IntentView
	18, // 15: google.cloud.dialogflow.v2.BatchUpdateIntentsRequest.intent_batch_inline:type_name -> google.cloud.dialogflow.v2.IntentBatch
	52, // 16: google.cloud.dialogflow.v2.BatchUpdateIntentsRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 17: google.cloud.dialogflow.v2.BatchUpdateIntentsRequest.intent_view:type_name -> google.cloud.dialogflow.v2.IntentView
	8,  // 18: google.cloud.dialogflow.v2.BatchUpdateIntentsResponse.intents:type_name -> google.cloud.dialogflow.v2.Intent
	8,  // 19: google.cloud.dialogflow.v2.BatchDeleteIntentsRequest.intents:type_name -> google.cloud.dialogflow.v2.Intent
	8,  // 20: google.cloud.dialogflow.v2.IntentBatch.intents:type_name -> google.cloud.dialogflow.v2.Intent
	2,  // 21: google.cloud.dialogflow.v2.Intent.TrainingPhrase.type:type_name -> google.cloud.dialogflow.v2.Intent.TrainingPhrase.Type
	23, // 22: google.cloud.dialogflow.v2.Intent.TrainingPhrase.parts:type_name -> google.cloud.dialogflow.v2.Intent.TrainingPhrase.Part
	24, // 23: google.cloud.dialogflow.v2.Intent.Message.text:type_name -> google.cloud.dialogflow.v2.Intent.Message.Text
	25, // 24: google.cloud.dialogflow.v2.Intent.Message.image:type_name -> google.cloud.dialogflow.v2.Intent.Message.Image
	26, // 25: google.cloud.dialogflow.v2.Intent.Message.quick_replies:type_name -> google.cloud.dialogflow.v2.Intent.Message.QuickReplies
	27, // 26: google.cloud.dialogflow.v2.Intent.Message.card:type_name -> google.cloud.dialogflow.v2.Intent.Message.Card
	53, // 27: google.cloud.dialogflow.v2.Intent.Message.payload:type_name -> google.protobuf.Struct
	29, // 28: google.cloud.dialogflow.v2.Intent.Message.simple_responses:type_name -> google.cloud.dialogflow.v2.Intent.Message.SimpleResponses
	30, // 29: google.cloud.dialogflow.v2.Intent.Message.basic_card:type_name -> google.cloud.dialogflow.v2.Intent.Message.BasicCard
	32, // 30: google.cloud.dialogflow.v2.Intent.Message.suggestions:type_name -> google.cloud.dialogflow.v2.Intent.Message.Suggestions
	33, // 31: google.cloud.dialogflow.v2.Intent.Message.link_out_suggestion:type_name -> google.cloud.dialogflow.v2.Intent.Message.LinkOutSuggestion
	34, // 32: google.cloud.dialogflow.v2.Intent.Message.list_select:type_name -> google.cloud.dialogflow.v2.Intent.Message.ListSelect
	35, // 33: google.cloud.dialogflow.v2.Intent.Message.carousel_select:type_name -> google.cloud.dialogflow.v2.Intent.Message.CarouselSelect
	38, // 34: google.cloud.dialogflow.v2.Intent.Message.browse_carousel_card:type_name -> google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard
	39, // 35: google.cloud.dialogflow.v2.Intent.Message.table_card:type_name -> google.cloud.dialogflow.v2.Intent.Message.TableCard
	37, // 36: google.cloud.dialogflow.v2.Intent.Message.media_content:type_name -> google.cloud.dialogflow.v2.Intent.Message.MediaContent
	3,  // 37: google.cloud.dialogflow.v2.Intent.Message.platform:type_name -> google.cloud.dialogflow.v2.Intent.Message.Platform
	43, // 38: google.cloud.dialogflow.v2.Intent.Message.Card.buttons:type_name -> google.cloud.dialogflow.v2.Intent.Message.Card.Button
	28, // 39: google.cloud.dialogflow.v2.Intent.Message.SimpleResponses.simple_responses:type_name -> google.cloud.dialogflow.v2.Intent.Message.SimpleResponse
	25, // 40: google.cloud.dialogflow.v2.Intent.Message.BasicCard.image:type_name -> google.cloud.dialogflow.v2.Intent.Message.Image
	44, // 41: google.cloud.dialogflow.v2.Intent.Message.BasicCard.buttons:type_name -> google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
	31, // 42: google.cloud.dialogflow.v2.Intent.Message.Suggestions.suggestions:type_name -> google.cloud.dialogflow.v2.Intent.Message.Suggestion
	46, // 43: google.cloud.dialogflow.v2.Intent.Message.ListSelect.items:type_name -> google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item
	47, // 44: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.items:type_name -> google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item
	4,  // 45: google.cloud.dialogflow.v2.Intent.Message.MediaContent.media_type:type_name -> google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaType
	48, // 46: google.cloud.dialogflow.v2.Intent.Message.MediaContent.media_objects:type_name -> google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject
	49, // 47: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.items:type_name -> google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem
	5,  // 48: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.image_display_options:type_name -> google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.ImageDisplayOptions
	25, // 49: google.cloud.dialogflow.v2.Intent.Message.TableCard.image:type_name -> google.cloud.dialogflow.v2.Intent.Message.Image
	40, // 50: google.cloud.dialogflow.v2.Intent.Message.TableCard.column_properties:type_name -> google.cloud.dialogflow.v2.Intent.Message.ColumnProperties
	41, // 51: google.cloud.dialogflow.v2.Intent.Message.TableCard.rows:type_name -> google.cloud.dialogflow.v2.Intent.Message.TableCardRow
	44, // 52: google.cloud.dialogflow.v2.Intent.Message.TableCard.buttons:type_name -> google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button
	7,  // 53: google.cloud.dialogflow.v2.Intent.Message.ColumnProperties.horizontal_alignment:type_name -> google.cloud.dialogflow.v2.Intent.Message.ColumnProperties.HorizontalAlignment
	42, // 54: google.cloud.dialogflow.v2.Intent.Message.TableCardRow.cells:type_name -> google.cloud.dialogflow.v2.Intent.Message.TableCardCell
	45, // 55: google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.open_uri_action:type_name -> google.cloud.dialogflow.v2.Intent.Message.BasicCard.Button.OpenUriAction
	36, // 56: google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.info:type_name -> google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
	25, // 57: google.cloud.dialogflow.v2.Intent.Message.ListSelect.Item.image:type_name -> google.cloud.dialogflow.v2.Intent.Message.Image
	36, // 58: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.info:type_name -> google.cloud.dialogflow.v2.Intent.Message.SelectItemInfo
	25, // 59: google.cloud.dialogflow.v2.Intent.Message.CarouselSelect.Item.image:type_name -> google.cloud.dialogflow.v2.Intent.Message.Image
	25, // 60: google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject.large_image:type_name -> google.cloud.dialogflow.v2.Intent.Message.Image
	25, // 61: google.cloud.dialogflow.v2.Intent.Message.MediaContent.ResponseMediaObject.icon:type_name -> google.cloud.dialogflow.v2.Intent.Message.Image
	50, // 62: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.open_uri_action:type_name -> google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction
	25, // 63: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.image:type_name -> google.cloud.dialogflow.v2.Intent.Message.Image
	6,  // 64: google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction.url_type_hint:type_name -> google.cloud.dialogflow.v2.Intent.Message.BrowseCarouselCard.BrowseCarouselCardItem.OpenUrlAction.UrlTypeHint
	9,  // 65: google.cloud.dialogflow.v2.Intents.ListIntents:input_type -> google.cloud.dialogflow.v2.ListIntentsRequest
	11, // 66: google.cloud.dialogflow.v2.Intents.GetIntent:input_type -> google.cloud.dialogflow.v2.GetIntentRequest
	12, // 67: google.cloud.dialogflow.v2.Intents.CreateIntent:input_type -> google.cloud.dialogflow.v2.CreateIntentRequest
	13, // 68: google.cloud.dialogflow.v2.Intents.UpdateIntent:input_type -> google.cloud.dialogflow.v2.UpdateIntentRequest
	14, // 69: google.cloud.dialogflow.v2.Intents.DeleteIntent:input_type -> google.cloud.dialogflow.v2.DeleteIntentRequest
	15, // 70: google.cloud.dialogflow.v2.Intents.BatchUpdateIntents:input_type -> google.cloud.dialogflow.v2.BatchUpdateIntentsRequest
	17, // 71: google.cloud.dialogflow.v2.Intents.BatchDeleteIntents:input_type -> google.cloud.dialogflow.v2.BatchDeleteIntentsRequest
	10, // 72: google.cloud.dialogflow.v2.Intents.ListIntents:output_type -> google.cloud.dialogflow.v2.ListIntentsResponse
	8,  // 73: google.cloud.dialogflow.v2.Intents.GetIntent:output_type -> google.cloud.dialogflow.v2.Intent
	8,  // 74: google.cloud.dialogflow.v2.Intents.CreateIntent:output_type -> google.cloud.dialogflow.v2.Intent
	8,  // 75: google.cloud.dialogflow.v2.Intents.UpdateIntent:output_type -> google.cloud.dialogflow.v2.Intent
	54, // 76: google.cloud.dialogflow.v2.Intents.DeleteIntent:output_type -> google.protobuf.Empty
	55, // 77: google.cloud.dialogflow.v2.Intents.BatchUpdateIntents:output_type -> google.longrunning.Operation
	55, // 78: google.cloud.dialogflow.v2.Intents.BatchDeleteIntents:output_type -> google.longrunning.Operation
	72, // [72:79] is the sub-list for method output_type
	65, // [65:72] is the sub-list for method input_type
	65, // [65:65] is the sub-list for extension type_name
	65, // [65:65] is the sub-list for extension extendee
	0,  // [0:65] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2_intent_proto_init() }
func file_google_cloud_dialogflow_v2_intent_proto_init() {
	if File_google_cloud_dialogflow_v2_intent_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2_context_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIntentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIntentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateIntentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUpdateIntentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteIntentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentBatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_TrainingPhrase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Parameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_FollowupIntentInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_TrainingPhrase_Part); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_Text); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_Image); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_QuickReplies); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_Card); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_SimpleResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_SimpleResponses); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_BasicCard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_Suggestion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_Suggestions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_LinkOutSuggestion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_ListSelect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_CarouselSelect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_SelectItemInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_MediaContent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_BrowseCarouselCard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_TableCard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_ColumnProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_TableCardRow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_TableCardCell); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_Card_Button); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_BasicCard_Button); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_BasicCard_Button_OpenUriAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_ListSelect_Item); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_CarouselSelect_Item); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_MediaContent_ResponseMediaObject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_intent_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Message_BrowseCarouselCard_BrowseCarouselCardItem_OpenUrlAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_v2_intent_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*BatchUpdateIntentsRequest_IntentBatchUri)(nil),
		(*BatchUpdateIntentsRequest_IntentBatchInline)(nil),
	}
	file_google_cloud_dialogflow_v2_intent_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*Intent_Message_Text_)(nil),
		(*Intent_Message_Image_)(nil),
		(*Intent_Message_QuickReplies_)(nil),
		(*Intent_Message_Card_)(nil),
		(*Intent_Message_Payload)(nil),
		(*Intent_Message_SimpleResponses_)(nil),
		(*Intent_Message_BasicCard_)(nil),
		(*Intent_Message_Suggestions_)(nil),
		(*Intent_Message_LinkOutSuggestion_)(nil),
		(*Intent_Message_ListSelect_)(nil),
		(*Intent_Message_CarouselSelect_)(nil),
		(*Intent_Message_BrowseCarouselCard_)(nil),
		(*Intent_Message_TableCard_)(nil),
		(*Intent_Message_MediaContent_)(nil),
	}
	file_google_cloud_dialogflow_v2_intent_proto_msgTypes[40].OneofWrappers = []interface{}{
		(*Intent_Message_MediaContent_ResponseMediaObject_LargeImage)(nil),
		(*Intent_Message_MediaContent_ResponseMediaObject_Icon)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2_intent_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   43,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2_intent_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2_intent_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2_intent_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2_intent_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2_intent_proto = out.File
	file_google_cloud_dialogflow_v2_intent_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2_intent_proto_goTypes = nil
	file_google_cloud_dialogflow_v2_intent_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IntentsClient is the client API for Intents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IntentsClient interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Creates an intent in the specified agent.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Updates the specified intent.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Deletes the specified intent and its direct or indirect followup intents.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates/Creates multiple intents in the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`: An empty [Struct
	//   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	// - `response`:
	// [BatchUpdateIntentsResponse][google.cloud.dialogflow.v2.BatchUpdateIntentsResponse]
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchUpdateIntents(ctx context.Context, in *BatchUpdateIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes intents in the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`: An empty [Struct
	//   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	// - `response`: An [Empty
	//   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchDeleteIntents(ctx context.Context, in *BatchDeleteIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type intentsClient struct {
	cc grpc.ClientConnInterface
}

func NewIntentsClient(cc grpc.ClientConnInterface) IntentsClient {
	return &intentsClient{cc}
}

func (c *intentsClient) ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error) {
	out := new(ListIntentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Intents/ListIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Intents/GetIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Intents/CreateIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Intents/UpdateIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Intents/DeleteIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) BatchUpdateIntents(ctx context.Context, in *BatchUpdateIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Intents/BatchUpdateIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) BatchDeleteIntents(ctx context.Context, in *BatchDeleteIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Intents/BatchDeleteIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IntentsServer is the server API for Intents service.
type IntentsServer interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(context.Context, *ListIntentsRequest) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(context.Context, *GetIntentRequest) (*Intent, error)
	// Creates an intent in the specified agent.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	CreateIntent(context.Context, *CreateIntentRequest) (*Intent, error)
	// Updates the specified intent.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	UpdateIntent(context.Context, *UpdateIntentRequest) (*Intent, error)
	// Deletes the specified intent and its direct or indirect followup intents.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	DeleteIntent(context.Context, *DeleteIntentRequest) (*emptypb.Empty, error)
	// Updates/Creates multiple intents in the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`: An empty [Struct
	//   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	// - `response`:
	// [BatchUpdateIntentsResponse][google.cloud.dialogflow.v2.BatchUpdateIntentsResponse]
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchUpdateIntents(context.Context, *BatchUpdateIntentsRequest) (*longrunningpb.Operation, error)
	// Deletes intents in the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`: An empty [Struct
	//   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	// - `response`: An [Empty
	//   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchDeleteIntents(context.Context, *BatchDeleteIntentsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedIntentsServer can be embedded to have forward compatible implementations.
type UnimplementedIntentsServer struct {
}

func (*UnimplementedIntentsServer) ListIntents(context.Context, *ListIntentsRequest) (*ListIntentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIntents not implemented")
}
func (*UnimplementedIntentsServer) GetIntent(context.Context, *GetIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIntent not implemented")
}
func (*UnimplementedIntentsServer) CreateIntent(context.Context, *CreateIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIntent not implemented")
}
func (*UnimplementedIntentsServer) UpdateIntent(context.Context, *UpdateIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIntent not implemented")
}
func (*UnimplementedIntentsServer) DeleteIntent(context.Context, *DeleteIntentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIntent not implemented")
}
func (*UnimplementedIntentsServer) BatchUpdateIntents(context.Context, *BatchUpdateIntentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateIntents not implemented")
}
func (*UnimplementedIntentsServer) BatchDeleteIntents(context.Context, *BatchDeleteIntentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteIntents not implemented")
}

func RegisterIntentsServer(s *grpc.Server, srv IntentsServer) {
	s.RegisterService(&_Intents_serviceDesc, srv)
}

func _Intents_ListIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ListIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Intents/ListIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ListIntents(ctx, req.(*ListIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_GetIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).GetIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Intents/GetIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).GetIntent(ctx, req.(*GetIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_CreateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).CreateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Intents/CreateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).CreateIntent(ctx, req.(*CreateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_UpdateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).UpdateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Intents/UpdateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).UpdateIntent(ctx, req.(*UpdateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_DeleteIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).DeleteIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Intents/DeleteIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).DeleteIntent(ctx, req.(*DeleteIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_BatchUpdateIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).BatchUpdateIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Intents/BatchUpdateIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).BatchUpdateIntents(ctx, req.(*BatchUpdateIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_BatchDeleteIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).BatchDeleteIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Intents/BatchDeleteIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).BatchDeleteIntents(ctx, req.(*BatchDeleteIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Intents_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Intents",
	HandlerType: (*IntentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListIntents",
			Handler:    _Intents_ListIntents_Handler,
		},
		{
			MethodName: "GetIntent",
			Handler:    _Intents_GetIntent_Handler,
		},
		{
			MethodName: "CreateIntent",
			Handler:    _Intents_CreateIntent_Handler,
		},
		{
			MethodName: "UpdateIntent",
			Handler:    _Intents_UpdateIntent_Handler,
		},
		{
			MethodName: "DeleteIntent",
			Handler:    _Intents_DeleteIntent_Handler,
		},
		{
			MethodName: "BatchUpdateIntents",
			Handler:    _Intents_BatchUpdateIntents_Handler,
		},
		{
			MethodName: "BatchDeleteIntents",
			Handler:    _Intents_BatchDeleteIntents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/intent.proto",
}
