// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/resourcesettings/v1/resource_settings.proto

package resourcesettingspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// View options for Settings.
type SettingView int32

const (
	// The default / unset value.
	// The API will default to the SETTING_VIEW_BASIC view.
	SettingView_SETTING_VIEW_UNSPECIFIED SettingView = 0
	// Include [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata], but nothing else.
	// This is the default value (for both ListSettings and GetSetting).
	SettingView_SETTING_VIEW_BASIC SettingView = 1
	// Include [Setting.effective_value][google.cloud.resourcesettings.v1.Setting.effective_value], but nothing else.
	SettingView_SETTING_VIEW_EFFECTIVE_VALUE SettingView = 2
	// Include [Setting.local_value][google.cloud.resourcesettings.v1.Setting.local_value], but nothing else.
	SettingView_SETTING_VIEW_LOCAL_VALUE SettingView = 3
)

// Enum value maps for SettingView.
var (
	SettingView_name = map[int32]string{
		0: "SETTING_VIEW_UNSPECIFIED",
		1: "SETTING_VIEW_BASIC",
		2: "SETTING_VIEW_EFFECTIVE_VALUE",
		3: "SETTING_VIEW_LOCAL_VALUE",
	}
	SettingView_value = map[string]int32{
		"SETTING_VIEW_UNSPECIFIED":     0,
		"SETTING_VIEW_BASIC":           1,
		"SETTING_VIEW_EFFECTIVE_VALUE": 2,
		"SETTING_VIEW_LOCAL_VALUE":     3,
	}
)

func (x SettingView) Enum() *SettingView {
	p := new(SettingView)
	*p = x
	return p
}

func (x SettingView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SettingView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes[0].Descriptor()
}

func (SettingView) Type() protoreflect.EnumType {
	return &file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes[0]
}

func (x SettingView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SettingView.Descriptor instead.
func (SettingView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{0}
}

// The data type for setting values of this setting. See [Value][google.cloud.resourcesettings.v1.Value] for more
// details on the available data types.
type SettingMetadata_DataType int32

const (
	// Unspecified data type.
	SettingMetadata_DATA_TYPE_UNSPECIFIED SettingMetadata_DataType = 0
	// A boolean setting.
	SettingMetadata_BOOLEAN SettingMetadata_DataType = 1
	// A string setting.
	SettingMetadata_STRING SettingMetadata_DataType = 2
	// A string set setting.
	SettingMetadata_STRING_SET SettingMetadata_DataType = 3
	// A Enum setting
	SettingMetadata_ENUM_VALUE SettingMetadata_DataType = 4
)

// Enum value maps for SettingMetadata_DataType.
var (
	SettingMetadata_DataType_name = map[int32]string{
		0: "DATA_TYPE_UNSPECIFIED",
		1: "BOOLEAN",
		2: "STRING",
		3: "STRING_SET",
		4: "ENUM_VALUE",
	}
	SettingMetadata_DataType_value = map[string]int32{
		"DATA_TYPE_UNSPECIFIED": 0,
		"BOOLEAN":               1,
		"STRING":                2,
		"STRING_SET":            3,
		"ENUM_VALUE":            4,
	}
)

func (x SettingMetadata_DataType) Enum() *SettingMetadata_DataType {
	p := new(SettingMetadata_DataType)
	*p = x
	return p
}

func (x SettingMetadata_DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SettingMetadata_DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes[1].Descriptor()
}

func (SettingMetadata_DataType) Type() protoreflect.EnumType {
	return &file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes[1]
}

func (x SettingMetadata_DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SettingMetadata_DataType.Descriptor instead.
func (SettingMetadata_DataType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{1, 0}
}

// The schema for settings.
type Setting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the setting. Must be in one of the following forms:
	//
	// * `projects/{project_number}/settings/{setting_name}`
	// * `folders/{folder_id}/settings/{setting_name}`
	// * `organizations/{organization_id}/settings/{setting_name}`
	//
	// For example, "/projects/123/settings/gcp-enableMyFeature"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Metadata about a setting which is not editable by the end user.
	Metadata *SettingMetadata `protobuf:"bytes,7,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// The configured value of the setting at the given parent resource (ignoring
	// the resource hierarchy). The data type of [Value][google.cloud.resourcesettings.v1.Value] must always be
	// consistent with the data type defined in [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
	LocalValue *Value `protobuf:"bytes,8,opt,name=local_value,json=localValue,proto3" json:"local_value,omitempty"`
	// Output only. The computed effective value of the setting at the given parent resource
	// (based on the resource hierarchy).
	//
	// The effective value evaluates to one of the following options in the given
	// order (the next option is used if the previous one does not exist):
	//
	//  1. the local setting value on the given resource: [Setting.local_value][google.cloud.resourcesettings.v1.Setting.local_value]
	//  2. if one of the given resource's ancestors have a local setting value,
	//     the local value at the nearest such ancestor
	//  3. the setting's default value: [SettingMetadata.default_value][google.cloud.resourcesettings.v1.SettingMetadata.default_value]
	//  4. an empty value (defined as a `Value` with all fields unset)
	//
	// The data type of [Value][google.cloud.resourcesettings.v1.Value] must always be
	// consistent with the data type defined in [Setting.metadata][google.cloud.resourcesettings.v1.Setting.metadata].
	EffectiveValue *Value `protobuf:"bytes,9,opt,name=effective_value,json=effectiveValue,proto3" json:"effective_value,omitempty"`
	// A fingerprint used for optimistic concurrency. See
	// [UpdateSetting][google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSetting] for more
	// details.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Setting) Reset() {
	*x = Setting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Setting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Setting) ProtoMessage() {}

func (x *Setting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Setting.ProtoReflect.Descriptor instead.
func (*Setting) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{0}
}

func (x *Setting) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Setting) GetMetadata() *SettingMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Setting) GetLocalValue() *Value {
	if x != nil {
		return x.LocalValue
	}
	return nil
}

func (x *Setting) GetEffectiveValue() *Value {
	if x != nil {
		return x.EffectiveValue
	}
	return nil
}

func (x *Setting) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Metadata about a setting which is not editable by the end user.
type SettingMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The human readable name for this setting.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A detailed description of what this setting does.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// A flag indicating that values of this setting cannot be modified (see
	// documentation of the specific setting for updates and reasons).
	ReadOnly bool `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	// The data type for this setting.
	DataType SettingMetadata_DataType `protobuf:"varint,4,opt,name=data_type,json=dataType,proto3,enum=google.cloud.resourcesettings.v1.SettingMetadata_DataType" json:"data_type,omitempty"`
	// The value provided by [Setting.effective_value][google.cloud.resourcesettings.v1.Setting.effective_value] if no setting value is
	// explicitly set.
	//
	// Note: not all settings have a default value.
	DefaultValue *Value `protobuf:"bytes,5,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
}

func (x *SettingMetadata) Reset() {
	*x = SettingMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SettingMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SettingMetadata) ProtoMessage() {}

func (x *SettingMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SettingMetadata.ProtoReflect.Descriptor instead.
func (*SettingMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{1}
}

func (x *SettingMetadata) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SettingMetadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SettingMetadata) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

func (x *SettingMetadata) GetDataType() SettingMetadata_DataType {
	if x != nil {
		return x.DataType
	}
	return SettingMetadata_DATA_TYPE_UNSPECIFIED
}

func (x *SettingMetadata) GetDefaultValue() *Value {
	if x != nil {
		return x.DefaultValue
	}
	return nil
}

// The data in a setting value.
type Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selects the data type and associated value.
	//
	// Types that are assignable to Value:
	//
	//	*Value_BooleanValue
	//	*Value_StringValue
	//	*Value_StringSetValue
	//	*Value_EnumValue_
	Value isValue_Value `protobuf_oneof:"value"`
}

func (x *Value) Reset() {
	*x = Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value.ProtoReflect.Descriptor instead.
func (*Value) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{2}
}

func (m *Value) GetValue() isValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Value) GetBooleanValue() bool {
	if x, ok := x.GetValue().(*Value_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

func (x *Value) GetStringValue() string {
	if x, ok := x.GetValue().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *Value) GetStringSetValue() *Value_StringSet {
	if x, ok := x.GetValue().(*Value_StringSetValue); ok {
		return x.StringSetValue
	}
	return nil
}

func (x *Value) GetEnumValue() *Value_EnumValue {
	if x, ok := x.GetValue().(*Value_EnumValue_); ok {
		return x.EnumValue
	}
	return nil
}

type isValue_Value interface {
	isValue_Value()
}

type Value_BooleanValue struct {
	// Defines this value as being a boolean value.
	BooleanValue bool `protobuf:"varint,1,opt,name=boolean_value,json=booleanValue,proto3,oneof"`
}

type Value_StringValue struct {
	// Defines this value as being a string value.
	StringValue string `protobuf:"bytes,2,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Value_StringSetValue struct {
	// Defines this value as being a StringSet.
	StringSetValue *Value_StringSet `protobuf:"bytes,3,opt,name=string_set_value,json=stringSetValue,proto3,oneof"`
}

type Value_EnumValue_ struct {
	// Defines this value as being a Enum.
	EnumValue *Value_EnumValue `protobuf:"bytes,4,opt,name=enum_value,json=enumValue,proto3,oneof"`
}

func (*Value_BooleanValue) isValue_Value() {}

func (*Value_StringValue) isValue_Value() {}

func (*Value_StringSetValue) isValue_Value() {}

func (*Value_EnumValue_) isValue_Value() {}

// The request for ListSettings.
type ListSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cloud resource that parents the setting. Must be in one of the
	// following forms:
	//
	// * `projects/{project_number}`
	// * `projects/{project_id}`
	// * `folders/{folder_id}`
	// * `organizations/{organization_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Unused. The size of the page to be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Unused. A page token used to retrieve the next page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The SettingView for this request.
	View SettingView `protobuf:"varint,4,opt,name=view,proto3,enum=google.cloud.resourcesettings.v1.SettingView" json:"view,omitempty"`
}

func (x *ListSettingsRequest) Reset() {
	*x = ListSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSettingsRequest) ProtoMessage() {}

func (x *ListSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSettingsRequest.ProtoReflect.Descriptor instead.
func (*ListSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{3}
}

func (x *ListSettingsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSettingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSettingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSettingsRequest) GetView() SettingView {
	if x != nil {
		return x.View
	}
	return SettingView_SETTING_VIEW_UNSPECIFIED
}

// The response from ListSettings.
type ListSettingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of settings that are available at the specified Cloud resource.
	Settings []*Setting `protobuf:"bytes,1,rep,name=settings,proto3" json:"settings,omitempty"`
	// Unused. A page token used to retrieve the next page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSettingsResponse) Reset() {
	*x = ListSettingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSettingsResponse) ProtoMessage() {}

func (x *ListSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSettingsResponse.ProtoReflect.Descriptor instead.
func (*ListSettingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{4}
}

func (x *ListSettingsResponse) GetSettings() []*Setting {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *ListSettingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for GetSetting.
type GetSettingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the setting to get. See [Setting][google.cloud.resourcesettings.v1.Setting] for naming
	// requirements.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The SettingView for this request.
	View SettingView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.resourcesettings.v1.SettingView" json:"view,omitempty"`
}

func (x *GetSettingRequest) Reset() {
	*x = GetSettingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSettingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSettingRequest) ProtoMessage() {}

func (x *GetSettingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSettingRequest.ProtoReflect.Descriptor instead.
func (*GetSettingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{5}
}

func (x *GetSettingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetSettingRequest) GetView() SettingView {
	if x != nil {
		return x.View
	}
	return SettingView_SETTING_VIEW_UNSPECIFIED
}

// The request for UpdateSetting.
type UpdateSettingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The setting to update. See [Setting][google.cloud.resourcesettings.v1.Setting] for field requirements.
	Setting *Setting `protobuf:"bytes,1,opt,name=setting,proto3" json:"setting,omitempty"`
}

func (x *UpdateSettingRequest) Reset() {
	*x = UpdateSettingRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSettingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSettingRequest) ProtoMessage() {}

func (x *UpdateSettingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSettingRequest.ProtoReflect.Descriptor instead.
func (*UpdateSettingRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateSettingRequest) GetSetting() *Setting {
	if x != nil {
		return x.Setting
	}
	return nil
}

// A string set value that can hold a set of strings. The maximum length of
// each string is 200 characters and there can be a maximum of 50 strings in
// the string set.
type Value_StringSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The strings in the set
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Value_StringSet) Reset() {
	*x = Value_StringSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_StringSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_StringSet) ProtoMessage() {}

func (x *Value_StringSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_StringSet.ProtoReflect.Descriptor instead.
func (*Value_StringSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Value_StringSet) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// A enum value that can hold any enum type setting values.
// Each enum type is represented by a number, this representation
// is stored in the definitions.
type Value_EnumValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of this enum
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Value_EnumValue) Reset() {
	*x = Value_EnumValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Value_EnumValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value_EnumValue) ProtoMessage() {}

func (x *Value_EnumValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Value_EnumValue.ProtoReflect.Descriptor instead.
func (*Value_EnumValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP(), []int{2, 1}
}

func (x *Value_EnumValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_cloud_resourcesettings_v1_resource_settings_proto protoreflect.FileDescriptor

var file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xe9, 0x03, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x52, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x48, 0x0a, 0x0b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x55, 0x0a,
	0x0f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x3a, 0xc0, 0x01, 0xea, 0x41, 0xbc, 0x01, 0x0a,
	0x27, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x31, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0x28, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x12, 0x34, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x7d, 0x22, 0xfa, 0x02, 0x0a, 0x0f,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c,
	0x79, 0x12, 0x57, 0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4c, 0x0a, 0x0d, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x5e, 0x0a, 0x08, 0x44, 0x61, 0x74, 0x61,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x54, 0x52, 0x49,
	0x4e, 0x47, 0x5f, 0x53, 0x45, 0x54, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x4e, 0x55, 0x4d,
	0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x04, 0x22, 0xd7, 0x02, 0x0a, 0x05, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x6f, 0x6f,
	0x6c, 0x65, 0x61, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x5d,
	0x0a, 0x10, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x52, 0x0a,
	0x0a, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x09, 0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x1a, 0x23, 0x0a, 0x09, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x21, 0x0a, 0x09, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0xb7, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x41, 0x0a, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x85, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9b, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x41, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69,
	0x65, 0x77, 0x22, 0x60, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x07, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x2a, 0x83, 0x01, 0x0a, 0x0b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f,
	0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x56, 0x49,
	0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x45,
	0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x45, 0x46, 0x46, 0x45, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18,
	0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x4c, 0x4f, 0x43,
	0x41, 0x4c, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x03, 0x32, 0xf9, 0x06, 0x0a, 0x17, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xfc, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6e, 0x12, 0x25,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x21, 0x12, 0x1f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5a, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xe9, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x22, 0x7b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6e, 0x12, 0x25, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x5a, 0x21, 0x12, 0x1f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x9d, 0x02, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x22, 0xa8, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xa1, 0x01,
	0x32, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x07, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5a, 0x32, 0x32, 0x27, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5a, 0x33, 0x32, 0x28,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x1a, 0x53, 0xca, 0x41, 0x1f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x80, 0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x76, 0x31, 0x42,
	0x15, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x20,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescOnce sync.Once
	file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescData = file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDesc
)

func file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescGZIP() []byte {
	file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescOnce.Do(func() {
		file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescData)
	})
	return file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDescData
}

var file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_resourcesettings_v1_resource_settings_proto_goTypes = []interface{}{
	(SettingView)(0),              // 0: google.cloud.resourcesettings.v1.SettingView
	(SettingMetadata_DataType)(0), // 1: google.cloud.resourcesettings.v1.SettingMetadata.DataType
	(*Setting)(nil),               // 2: google.cloud.resourcesettings.v1.Setting
	(*SettingMetadata)(nil),       // 3: google.cloud.resourcesettings.v1.SettingMetadata
	(*Value)(nil),                 // 4: google.cloud.resourcesettings.v1.Value
	(*ListSettingsRequest)(nil),   // 5: google.cloud.resourcesettings.v1.ListSettingsRequest
	(*ListSettingsResponse)(nil),  // 6: google.cloud.resourcesettings.v1.ListSettingsResponse
	(*GetSettingRequest)(nil),     // 7: google.cloud.resourcesettings.v1.GetSettingRequest
	(*UpdateSettingRequest)(nil),  // 8: google.cloud.resourcesettings.v1.UpdateSettingRequest
	(*Value_StringSet)(nil),       // 9: google.cloud.resourcesettings.v1.Value.StringSet
	(*Value_EnumValue)(nil),       // 10: google.cloud.resourcesettings.v1.Value.EnumValue
}
var file_google_cloud_resourcesettings_v1_resource_settings_proto_depIdxs = []int32{
	3,  // 0: google.cloud.resourcesettings.v1.Setting.metadata:type_name -> google.cloud.resourcesettings.v1.SettingMetadata
	4,  // 1: google.cloud.resourcesettings.v1.Setting.local_value:type_name -> google.cloud.resourcesettings.v1.Value
	4,  // 2: google.cloud.resourcesettings.v1.Setting.effective_value:type_name -> google.cloud.resourcesettings.v1.Value
	1,  // 3: google.cloud.resourcesettings.v1.SettingMetadata.data_type:type_name -> google.cloud.resourcesettings.v1.SettingMetadata.DataType
	4,  // 4: google.cloud.resourcesettings.v1.SettingMetadata.default_value:type_name -> google.cloud.resourcesettings.v1.Value
	9,  // 5: google.cloud.resourcesettings.v1.Value.string_set_value:type_name -> google.cloud.resourcesettings.v1.Value.StringSet
	10, // 6: google.cloud.resourcesettings.v1.Value.enum_value:type_name -> google.cloud.resourcesettings.v1.Value.EnumValue
	0,  // 7: google.cloud.resourcesettings.v1.ListSettingsRequest.view:type_name -> google.cloud.resourcesettings.v1.SettingView
	2,  // 8: google.cloud.resourcesettings.v1.ListSettingsResponse.settings:type_name -> google.cloud.resourcesettings.v1.Setting
	0,  // 9: google.cloud.resourcesettings.v1.GetSettingRequest.view:type_name -> google.cloud.resourcesettings.v1.SettingView
	2,  // 10: google.cloud.resourcesettings.v1.UpdateSettingRequest.setting:type_name -> google.cloud.resourcesettings.v1.Setting
	5,  // 11: google.cloud.resourcesettings.v1.ResourceSettingsService.ListSettings:input_type -> google.cloud.resourcesettings.v1.ListSettingsRequest
	7,  // 12: google.cloud.resourcesettings.v1.ResourceSettingsService.GetSetting:input_type -> google.cloud.resourcesettings.v1.GetSettingRequest
	8,  // 13: google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSetting:input_type -> google.cloud.resourcesettings.v1.UpdateSettingRequest
	6,  // 14: google.cloud.resourcesettings.v1.ResourceSettingsService.ListSettings:output_type -> google.cloud.resourcesettings.v1.ListSettingsResponse
	2,  // 15: google.cloud.resourcesettings.v1.ResourceSettingsService.GetSetting:output_type -> google.cloud.resourcesettings.v1.Setting
	2,  // 16: google.cloud.resourcesettings.v1.ResourceSettingsService.UpdateSetting:output_type -> google.cloud.resourcesettings.v1.Setting
	14, // [14:17] is the sub-list for method output_type
	11, // [11:14] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_resourcesettings_v1_resource_settings_proto_init() }
func file_google_cloud_resourcesettings_v1_resource_settings_proto_init() {
	if File_google_cloud_resourcesettings_v1_resource_settings_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Setting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SettingMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSettingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSettingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSettingRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_StringSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Value_EnumValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Value_BooleanValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_StringSetValue)(nil),
		(*Value_EnumValue_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_resourcesettings_v1_resource_settings_proto_goTypes,
		DependencyIndexes: file_google_cloud_resourcesettings_v1_resource_settings_proto_depIdxs,
		EnumInfos:         file_google_cloud_resourcesettings_v1_resource_settings_proto_enumTypes,
		MessageInfos:      file_google_cloud_resourcesettings_v1_resource_settings_proto_msgTypes,
	}.Build()
	File_google_cloud_resourcesettings_v1_resource_settings_proto = out.File
	file_google_cloud_resourcesettings_v1_resource_settings_proto_rawDesc = nil
	file_google_cloud_resourcesettings_v1_resource_settings_proto_goTypes = nil
	file_google_cloud_resourcesettings_v1_resource_settings_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ResourceSettingsServiceClient is the client API for ResourceSettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResourceSettingsServiceClient interface {
	// Lists all the settings that are available on the Cloud resource `parent`.
	ListSettings(ctx context.Context, in *ListSettingsRequest, opts ...grpc.CallOption) (*ListSettingsResponse, error)
	// Gets a setting.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting does not exist.
	GetSetting(ctx context.Context, in *GetSettingRequest, opts ...grpc.CallOption) (*Setting, error)
	// Updates a setting.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if
	// the setting is flagged as read only.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
	// supplied in the request does not match the persisted etag of the setting
	// value.
	//
	// On success, the response will contain only `name`, `local_value` and
	// `etag`.  The `metadata` and `effective_value` cannot be updated through
	// this API.
	//
	// Note: the supplied setting will perform a full overwrite of the
	// `local_value` field.
	UpdateSetting(ctx context.Context, in *UpdateSettingRequest, opts ...grpc.CallOption) (*Setting, error)
}

type resourceSettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewResourceSettingsServiceClient(cc grpc.ClientConnInterface) ResourceSettingsServiceClient {
	return &resourceSettingsServiceClient{cc}
}

func (c *resourceSettingsServiceClient) ListSettings(ctx context.Context, in *ListSettingsRequest, opts ...grpc.CallOption) (*ListSettingsResponse, error) {
	out := new(ListSettingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/ListSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceSettingsServiceClient) GetSetting(ctx context.Context, in *GetSettingRequest, opts ...grpc.CallOption) (*Setting, error) {
	out := new(Setting)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/GetSetting", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *resourceSettingsServiceClient) UpdateSetting(ctx context.Context, in *UpdateSettingRequest, opts ...grpc.CallOption) (*Setting, error) {
	out := new(Setting)
	err := c.cc.Invoke(ctx, "/google.cloud.resourcesettings.v1.ResourceSettingsService/UpdateSetting", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResourceSettingsServiceServer is the server API for ResourceSettingsService service.
type ResourceSettingsServiceServer interface {
	// Lists all the settings that are available on the Cloud resource `parent`.
	ListSettings(context.Context, *ListSettingsRequest) (*ListSettingsResponse, error)
	// Gets a setting.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting does not exist.
	GetSetting(context.Context, *GetSettingRequest) (*Setting, error)
	// Updates a setting.
	//
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// setting does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if
	// the setting is flagged as read only.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
	// supplied in the request does not match the persisted etag of the setting
	// value.
	//
	// On success, the response will contain only `name`, `local_value` and
	// `etag`.  The `metadata` and `effective_value` cannot be updated through
	// this API.
	//
	// Note: the supplied setting will perform a full overwrite of the
	// `local_value` field.
	UpdateSetting(context.Context, *UpdateSettingRequest) (*Setting, error)
}

// UnimplementedResourceSettingsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedResourceSettingsServiceServer struct {
}

func (*UnimplementedResourceSettingsServiceServer) ListSettings(context.Context, *ListSettingsRequest) (*ListSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSettings not implemented")
}
func (*UnimplementedResourceSettingsServiceServer) GetSetting(context.Context, *GetSettingRequest) (*Setting, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSetting not implemented")
}
func (*UnimplementedResourceSettingsServiceServer) UpdateSetting(context.Context, *UpdateSettingRequest) (*Setting, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSetting not implemented")
}

func RegisterResourceSettingsServiceServer(s *grpc.Server, srv ResourceSettingsServiceServer) {
	s.RegisterService(&_ResourceSettingsService_serviceDesc, srv)
}

func _ResourceSettingsService_ListSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).ListSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/ListSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).ListSettings(ctx, req.(*ListSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceSettingsService_GetSetting_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSettingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).GetSetting(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/GetSetting",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).GetSetting(ctx, req.(*GetSettingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ResourceSettingsService_UpdateSetting_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSettingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResourceSettingsServiceServer).UpdateSetting(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.resourcesettings.v1.ResourceSettingsService/UpdateSetting",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResourceSettingsServiceServer).UpdateSetting(ctx, req.(*UpdateSettingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResourceSettingsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcesettings.v1.ResourceSettingsService",
	HandlerType: (*ResourceSettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSettings",
			Handler:    _ResourceSettingsService_ListSettings_Handler,
		},
		{
			MethodName: "GetSetting",
			Handler:    _ResourceSettingsService_GetSetting_Handler,
		},
		{
			MethodName: "UpdateSetting",
			Handler:    _ResourceSettingsService_UpdateSetting_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcesettings/v1/resource_settings.proto",
}
