#!/bin/sh

# Setup env
set -xe
. /environ

# Clone git repository at branch / tag / commit.
REPO='https://aomedia.googlesource.com/aom'; TAG='v3.12.0'
git clone "$REPO" --depth=1 --branch="${TAG}" /av1

# Create build output dir
# (aom doesn't like building
# from within its own tree)
mkdir -p /aom_build
cd /aom_build

# Configure build.
cmake ../av1 \
      -D CMAKE_INSTALL_PREFIX=/vendor \
      -D BUILD_SHARED_LIBS=OFF \
      -D CONFIG_MULTITHREAD=0 \
      -D AOM_TARGET_CPU=generic \
      -D ENABLE_DOCS=0 \
      -D ENABLE_TESTS=0 \
      -D ENABLE_EXAMPLES=0 \
      -D ENABLE_TOOLS=0 \
      -D CONFIG_RUNTIME_CPU_DETECT=0 \
      -D CONFIG_WEBM_IO=0 \
      -D AOM_EXTRA_C_FLAGS="${CFLAGS}" \
      -D AOM_EXTRA_CXX_FLAGS="${CXXFLAGS}"

# Perform build + install.
make -j $(nproc) install
