#!/bin/sh

# Setup env
set -xe
. /environ

# Enter build dir
mkdir /mp3; cd /mp3

# Download latest
VERSION='3.100'
URL="https://sourceforge.net/projects/lame/files/lame-${VERSION}.tar.gz/download"
curl -fL "$URL" -o 'mp3.tgz'

# Unpack mp3 tar
tar -xvf 'mp3.tgz'
cd lame-*

# Make modifications to flags.
export CFLAGS=$(trim_spaces ${CFLAGS} \
                            -D_WASI_EMULATED_SIGNAL)
export LDFLAGS=$(trim_spaces ${LDFLAGS} \
                             -lwasi-emulated-signal)

# Configure build parameters.
./configure --host=none \
            --prefix=/vendor \
            --exec-prefix=/vendor \
            --disable-shared \
            --enable-static \
            --disable-frontend \
            --disable-gtktest \
            --disable-analyzer-hooks \
|| { cat config.log; exit 1; }

# Get rid of their additional prefixed CFLAGS
sed -i Makefile -e "s|CFLAGS = .*|CFLAGS = ${CFLAGS}|"

# Perform library build.
make -j $(nproc) install
