package io

import (
	"io"

	"github.com/philandstuff/dhall-golang/v6"
)

func init() {
	registerInputHandler("dhall", func() InputHandler { return &DhallInputHandler{} })
}

// Declare conformance with InputHandler interface.
var _ InputHandler = &DhallInputHandler{}

// DhallInputHandler handles parsing Dhall data.
type DhallInputHandler struct{}

// Name implements InputHandler.Name().
func (d *DhallInputHandler) Name() string {
	return "dhall"
}

// Parse implements InputHandler.Parse().
func (d *DhallInputHandler) Parse(reader io.Reader) (interface{}, error) {
	inputBytes, err := io.ReadAll(reader)
	if err != nil {
		return nil, err
	}

	if len(inputBytes) == 0 {
		inputBytes = []byte("{}")
	}

	var parsed interface{}
	err = dhall.Unmarshal(inputBytes, &parsed)
	if err != nil {
		return nil, err
	}

	return parsed, nil
}

// SetOption implements InputHandler.SetOption().
func (d *DhallInputHandler) SetOption(name string, value string) error {
	// The Dhall handler does not have any options.
	return nil
}
